
/* 
 * main.js - This file is compiled and contains code from the following scripts, concatenated together in order:
 * js/jquery.min.js, js/jquery.mixitup.min.js, js/jquery-ui.custom.min.js, js/vanwatech_init.js, js/catalog.js, js/captcha.js, js/jquery.tablesorter.min.js, js/options.js, js/style-select.js, js/options/general.js, js/post-hover.js, js/update_boards.js, js/favorites.js, js/show-op.js, js/smartphone-spoiler.js, js/inline-expanding.js, js/show-backlinks.js, js/webm-settings.js, js/expand-video.js, js/treeview.js, js/expand-too-long.js, js/settings.js, js/hide-images.js, js/expand-all-images.js, js/local-time.js, js/expand.js, js/auto-reload.js, js/options/user-css.js, js/options/user-js.js, js/options/fav.js, js/forced-anon.js, js/toggle-locked-threads.js, js/toggle-images.js, js/mobile-style.js, js/id_highlighter.js, js/id_colors.js, js/inline.js, js/infinite-scroll.js, js/download-original.js, js/download-hash-unix.js, js/thread-watcher.js, js/ajax.js, js/quick-reply.js, js/quick-post-controls.js, js/show-own-posts.js, js/youtube.js, js/comment-toolbar.js, js/catalog-search.js, js/thread-stats.js, js/quote-selection.js, js/flag-previews.js, js/post-menu.js, js/post-filter.js, js/filter_hidden_images.js, js/fix-report-delete-submit.js, js/image-hover.js, js/auto-scroll.js, js/file-selector.js, js/gallery-view.js, js/board-directory.js, js/disclaimer-toggle.js, js/disclaimer-check-auto-reload.js, js/post-capture.js, js/show-recommended-boards.js, js/catalog-create-thread.js, js/pepe-colored-quotes.js, js/save-original-filename.js, js/post-captcha-box.js, js/recent-post-time.js, js/preview_annoucement.js, js/auto_clear_postfields_options.js, js/embed_api.js, js/stub-options.js, js/jquery-ui.custom.min.js, js/wPaint/8ch.js, js/wpaint.js, js/code_tags/run_prettify.js, js/webtoolkit.sha1.js, js/user_unique_identity.js, js/fileboard.js, js/remove_rel_nofollow.js
 * Please see those files for licensing and authorship information.
 * Compiled on Tue Dec 24 02:07:13 2019
 */

/* gettext-compatible _ function, example of usage:
 *
 * > // Loading pl_PL.json here (containing polish translation strings generated by tools/i18n_compile.php)
 * > alert(_("Hello!"));
 * Witaj!
 */
function _(s) {
	return (typeof l10n != 'undefined' && typeof l10n[s] != 'undefined') ? l10n[s] : s;
}

/* printf-like formatting function, example of usage:
 *
 * > alert(fmt("There are {0} birds on {1} trees", [3,4]));
 * There are 3 birds on 4 trees
 * > // Loading pl_PL.json here (containing polish translation strings generated by tools/locale_compile.php)
 * > alert(fmt(_("{0} users"), [3]));
 * 3 uzytkownikow
 */
function fmt(s,a) {
	return s.replace(/\{([0-9]+)\}/g, function(x) { return a[x[1]]; });
}

function until($timestamp) {
		var $difference = $timestamp - Date.now()/1000|0, $num;
		switch(true){
		case ($difference < 60):
				return "" + $difference + ' ' + _('second(s)');
		case ($difference < 3600): //60*60 = 3600
				return "" + ($num = Math.round($difference/(60))) + ' ' + _('minute(s)');
		case ($difference < 86400): //60*60*24 = 86400
				return "" + ($num = Math.round($difference/(3600))) + ' ' + _('hour(s)');
		case ($difference < 604800): //60*60*24*7 = 604800
				return "" + ($num = Math.round($difference/(86400))) + ' ' + _('day(s)');
		case ($difference < 31536000): //60*60*24*365 = 31536000
				return "" + ($num = Math.round($difference/(604800))) + ' ' + _('week(s)');
		default:
				return "" + ($num = Math.round($difference/(31536000))) + ' ' + _('year(s)');
		}
}

function ago($timestamp) {
		var $difference = (Date.now()/1000|0) - $timestamp, $num;
		switch(true){
		case ($difference < 60) :
				return "" + $difference + ' ' + _('second(s)');
		case ($difference < 3600): //60*60 = 3600 
				return "" + ($num = Math.round($difference/(60))) + ' ' + _('minute(s)');
		case ($difference <  86400): //60*60*24 = 86400
				return "" + ($num = Math.round($difference/(3600))) + ' ' + _('hour(s)');
		case ($difference < 604800): //60*60*24*7 = 604800
				return "" + ($num = Math.round($difference/(86400))) + ' ' + _('day(s)');
		case ($difference < 31536000): //60*60*24*365 = 31536000
				return "" + ($num = Math.round($difference/(604800))) + ' ' + _('week(s)');
		default:
				return "" + ($num = Math.round($difference/(31536000))) + ' ' + _('year(s)');
		}
}

var datelocale =
		{ days: [_('Sunday'), _('Monday'), _('Tuesday'), _('Wednesday'), _('Thursday'), _('Friday'), _('Saturday')]
		, shortDays: [_("Sun"), _("Mon"), _("Tue"), _("Wed"), _("Thu"), _("Fri"), _("Sat")]
		, months: [_('January'), _('February'), _('March'), _('April'), _('May'), _('June'), _('July'), _('August'), _('September'), _('October'), _('November'), _('December')]
		, shortMonths: [_('Jan'), _('Feb'), _('Mar'), _('Apr'), _('May'), _('Jun'), _('Jul'), _('Aug'), _('Sep'), _('Oct'), _('Nov'), _('Dec')]
		, AM: _('AM')
		, PM: _('PM')
		, am: _('am')
		, pm: _('pm')
		};


function alert(a, do_confirm, confirm_ok_action, confirm_cancel_action) {
	var handler, div, bg, closebtn, okbtn;
	var close = function() {
		handler.fadeOut(400, function() { handler.remove(); });
		return false;
	};

	handler = $("<div id='alert_handler'></div>").hide().appendTo('body');

	bg = $("<div id='alert_background'></div>").appendTo(handler);

	div = $("<div id='alert_div'></div>").appendTo(handler);
	closebtn = $("<a id='alert_close' href='javascript:void(0)'><i class='fa fa-times'></i></div>")
		.appendTo(div);

	$("<div id='alert_message'></div>").html(a).appendTo(div);

	okbtn = $("<button class='button alert_button'>"+_("OK")+"</button>").appendTo(div);

	if (do_confirm) {
		confirm_ok_action = (typeof confirm_ok_action !== "function") ? function(){} : confirm_ok_action;
		confirm_cancel_action = (typeof confirm_cancel_action !== "function") ? function(){} : confirm_cancel_action;
		okbtn.click(confirm_ok_action);
		$("<button class='button alert_button'>"+_("Cancel")+"</button>").click(confirm_cancel_action).click(close).appendTo(div);
		bg.click(confirm_cancel_action);
		okbtn.click(confirm_cancel_action);
		closebtn.click(confirm_cancel_action);
	} 
	
	bg.click(close);
	okbtn.click(close);
	closebtn.click(close);

	handler.fadeIn(400);
}

/*function captchabox(a, do_confirm, confirm_ok_action, confirm_cancel_action) {
        var handler, div, bg, closebtn, okbtn;
        var close = function() {
                handler.fadeOut(400, function() { handler.remove(); });
                return false;
        };

        handler = $("<div id='alert_handler'></div>").hide().appendTo('body');

        bg = $("<div id='alert_background'></div>").appendTo(handler);

        div = $("<div id='alert_div'></div>").appendTo(handler);
        closebtn = $("<a id='alert_close' href='javascript:void(0)'><i class='fa fa-times'></i></div>")
                .appendTo(div);

	$("<div id='captcha_main_box' style='margin:15px'>"+_("Loading captcha...")+"<br><a href='https://8kun.top/dnsbls_bypass.php' target='_blank'>Click here if captcha doesnt load</a></div>").appendTo(div);
        
	if (window.document.location.protocol == 'https:') {
		$.get( "https://8kun.top/dnsbls_bypass_popup.php", function( datas ) {
                	$("#captcha_main_box").html(datas);
        	});
	} else {
                $.get( "http://8kun.top/dnsbls_bypass_popup.php", function( datas ) {
                        $("#captcha_main_box").html(datas);
                }); 
	}


        if (do_confirm) {
                confirm_ok_action = (typeof confirm_ok_action !== "function") ? function(){} : confirm_ok_action;
                confirm_cancel_action = (typeof confirm_cancel_action !== "function") ? function(){} : confirm_cancel_action;
                $("<button class='button alert_button'>"+_("Cancel")+"</button>").click(confirm_cancel_action).click(close).appendTo(div);
                bg.click(confirm_cancel_action);
                closebtn.click(confirm_cancel_action);
        }

        bg.click(close);
        closebtn.click(close);

        handler.fadeIn(400);
}
*/

function captchabox(a, do_confirm, confirm_ok_action, confirm_cancel_action) {
        var handler, div, bg, closebtn, okbtn;
        var close = function() {
                handler.fadeOut(400, function() { handler.remove(); });
                return false;
        };

        handler = $("<div id='alert_handler'></div>").hide().appendTo('body');

        bg = $("<div id='alert_background'></div>").appendTo(handler);

        div = $("<div id='alert_div'></div>").appendTo(handler);
        closebtn = $("<a id='alert_close' href='javascript:void(0)'><i class='fa fa-times'></i></div>")
                .appendTo(div);

        $("<div id='captcha_main_box' style='margin:15px'>"+_("Loading captcha...")+"<br><a href='https://sys.8kun.top/dnsbls_bypass.php' target='_blank'>Click here if captcha doesnt load</a></div>").appendTo(div);

        /*if (window.document.location.protocol == 'https:') {
                $.get( "https://8kun.top/dnsbls_bypass_popup.php", function( datas ) {
                        $("#captcha_main_box").html(datas);
                });
        } else {
                $.get( "http://8kun.top/dnsbls_bypass_popup.php", function( datas ) {
                        $("#captcha_main_box").html(datas);
                });
        }*/

	var durl = 'http://sys.8kun.top/dnsbls_bypass_popup.php';
        if (window.document.location.protocol == 'https:') {
		durl = '//sys.8kun.top/dnsbls_bypass_popup.php';
        } 

      $.ajax({
        type: 'GET',
        url: durl,
        cache: false,
	xhrFields: {withCredentials: true},
        success: function(datas) {
                $("#captcha_main_box").html(datas);

                if (do_confirm) {
                    confirm_ok_action = (typeof confirm_ok_action !== "function") ? function(){} : confirm_ok_action;
                    confirm_cancel_action = (typeof confirm_cancel_action !== "function") ? function(){} : confirm_cancel_action;
                    var captcha_main_box = $('#captcha_main_box');
                    var actionclick = function(){
                            if(captcha_main_box.text().toLowerCase().indexOf('fill out the captcha below')>0){
                                confirm_cancel_action()
                            }else{
                                confirm_ok_action()
                            }
                            close()
                    }
                    if(div.find('.alert_button').length>0)
                        div.find('.alert_button').remove();
                    $("<button class='button alert_button'>"+_("Cancel")+"</button>").off('click').click(actionclick).appendTo(div);
                        bg.off('click').click(actionclick);
                    closebtn.off('click').click(actionclick);

                }
        },
        error: function (request, status, error) {
          concole.log(request.responseText);
        }
      });

	/*
        $.get( durl, function( datas ) {
            $("#captcha_main_box").html(datas);

	        if (do_confirm) {
	            confirm_ok_action = (typeof confirm_ok_action !== "function") ? function(){} : confirm_ok_action;
	            confirm_cancel_action = (typeof confirm_cancel_action !== "function") ? function(){} : confirm_cancel_action;
	            var captcha_main_box = $('#captcha_main_box');
	            var actionclick = function(){
		            if(captcha_main_box.text().toLowerCase().indexOf('fill out the captcha below')>0){
		            	confirm_cancel_action()
		            }else{
		            	confirm_ok_action()
		            }
		            close()
	            }
	            if(div.find('.alert_button').length>0)
	            	div.find('.alert_button').remove();
	            $("<button class='button alert_button'>"+_("Cancel")+"</button>").off('click').click(actionclick).appendTo(div);
	        	bg.off('click').click(actionclick);
	            closebtn.off('click').click(actionclick); 

	        }
        });
	*/

        if (do_confirm) {
                confirm_ok_action = (typeof confirm_ok_action !== "function") ? function(){} : confirm_ok_action;
                confirm_cancel_action = (typeof confirm_cancel_action !== "function") ? function(){} : confirm_cancel_action;
                $("<button class='button alert_button'>"+_("Cancel")+"</button>").click(confirm_cancel_action).click(close).appendTo(div);
                bg.click(confirm_cancel_action);
                closebtn.click(confirm_cancel_action);
        }

        bg.click(close);
        closebtn.click(close);

        handler.fadeIn(400);
}

var saved = {};

if (typeof board_name === "undefined") {
	var matches = document.URL.match(/\/([0-9a-zA-Z\+$_\u0080-\uFFFF]{1,58})\/($|res\/\d+\.html|index\.html|res\/\d+\+50\.html|\d+\.html|catalog\.html)/);
	var board_name = (matches ? matches[1] : false);
}

function get_cookie(cookie_name) {
	var results = document.cookie.match ( '(^|;) ?' + cookie_name + '=([^;]*)(;|$)');
	
	if (results) {
		return (unescape(results[2]));
	}
	else {
		return null;
	}
}

function highlightReply(id, event) {
	// check if external post
	var post_list, arr, i;
	id = id.toString();

	post_list = document.querySelectorAll('a.post_no');
	for (i = 0, arr = []; i<post_list.length; i++) {
		arr.push(post_list[i]);
	}
	arr = arr.filter(function (ele) {
		if (ele.hasAttribute('id') || ((' '+ ele.parentElement.parentElement.className +' ').indexOf(' hidden ') > -1)) {
			return false;
		} else {
			return true;
		}
	});
	for (i = 0, post_list = []; i < arr.length; i++) {
		post_list.push(arr[i].innerHTML);
	}

	if (post_list.indexOf(id) == -1)
		return true;
	
	// don't highlight on middle click
	var e = event || window.event;
	if (typeof e != "undefined") {
		if (e.which == 2) return true;
		if (active_page == 'thread' && typeof e.preventDefault != "undefined") e.preventDefault();
	}
	
	var divs = document.getElementsByTagName('div');
	for (var i = 0; i < divs.length; i++)
	{
		if (divs[i].className.indexOf('post') != -1)
			divs[i].className = divs[i].className.replace(/highlighted/, '');
	}
	if (id) {
		var post = document.getElementById('reply_'+id);
		// No reply? Try OP.
		if (!post) {
			var post = document.getElementById('op_'+id);
		}

		if (post) {
			post.className += ' highlighted';

			if (history.pushState) {
				history.pushState(null, null, window.document.location.protocol + "//" + window.document.location.host + window.document.location.pathname + window.document.location.search + '#' + id); 
			} else {
				window.location.hash = id;
			}			

			// Better offset to keep in mind new hovering boardlist
			var post_top = post.getBoundingClientRect().top;
			var body_top = document.body.getBoundingClientRect().top;
			var boardlist_height = document.getElementsByClassName('boardlist')[0].getBoundingClientRect().height;
			var offset = (post_top - body_top) - boardlist_height;

			window.scrollTo(0, offset);
		}
	}
	return true;
}

function generatePassword() {
	var pass = '';
	var chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ123456789!@#$%^&*()_+';
	for (var i = 0; i < 8; i++) {
		var rnd = Math.floor(Math.random() * chars.length);
		pass += chars.substring(rnd, rnd + 1);
	}
	return pass;
}

function dopost(form) {
	if (form.elements['name']) {
		localStorage.name = form.elements['name'].value.replace(/( |^)## .+$/, '');
	}
	if (form.elements['password']) {
		localStorage.password = form.elements['password'].value;
	}
	if (form.elements['user_flag']) {
		if (localStorage.userflags) {
			var userflags = JSON.parse(localStorage.userflags);
		} else {
			localStorage.userflags = '{}';
			userflags = {};
		}
		userflags[board_name] = form.elements['user_flag'].value;
		localStorage.userflags = JSON.stringify(userflags);
	}
	if (form.elements['email'] && form.elements['email'].value != 'sage') {
		localStorage.email = form.elements['email'].value;
	}
	
	saved[document.location] = form.elements['body'].value;
	sessionStorage.body = JSON.stringify(saved);
	
	return form.elements['body'].value != "" || form.elements['file'].value != "" || (form.elements.file_url && form.elements['file_url'].value != "");
}

function citeReply(id, with_link) {
	var textarea = document.getElementById('body');

	if (!textarea) return false;
	
	if (document.selection) {
		// IE
		textarea.focus();
		var sel = document.selection.createRange();
		sel.text = '>>' + id + '\n';
	} else if (textarea.selectionStart || textarea.selectionStart == '0') {
		var start = textarea.selectionStart;
		var end = textarea.selectionEnd;
		textarea.value = textarea.value.substring(0, start) + '>>' + id + '\n' + textarea.value.substring(end, textarea.value.length);
		
		textarea.selectionStart += ('>>' + id).length + 1;
		textarea.selectionEnd = textarea.selectionStart;
	} else {
		// ???
		textarea.value += '>>' + id + '\n';
	}

	// multiline quotes
	var select = sessionStorage.quoteClipboard;
	if (select) {
		select = select.split('\n');
		select.forEach(function (str) {
			if (str !== '') {
				str = '>' + str + '\n';
			} else {
				str = '\n';
			}
			textarea.value += str;
		});
		delete sessionStorage.quoteClipboard;
	}

	if (typeof $ != 'undefined') {
		$(window).trigger('cite', [id, with_link]);
		$(textarea).change();
	}
	return false;
}

function rememberStuff() {
	if (document.forms.post) {
		if (document.forms.post.password) {
			if (!localStorage.password)
				localStorage.password = generatePassword();
			document.forms.post.password.value = localStorage.password;
		}
		
		if (localStorage.name && document.forms.post.elements['name'])
			document.forms.post.elements['name'].value = localStorage.name;
		if (localStorage.email && document.forms.post.elements['email'])
			document.forms.post.elements['email'].value = localStorage.email;
		if (localStorage.userflags && document.forms.post.elements['user_flag']) {
			var userflags = JSON.parse(localStorage.userflags);
			document.forms.post.elements['user_flag'].value = userflags[board_name];
		}
		
		if (window.location.hash.indexOf('q') == 1)
			citeReply(window.location.hash.substring(2), true);
		
		if (sessionStorage.body) {
			var saved = JSON.parse(sessionStorage.body);
			if (get_cookie('serv')) {
				// Remove successful posts
				var successful = JSON.parse(get_cookie('serv'));
				for (var url in successful) {
					saved[url] = null;
				}
				sessionStorage.body = JSON.stringify(saved);
				
				document.cookie = 'serv={};expires=0;path=/;';
			}
			if (saved[document.location]) {
				document.forms.post.body.value = saved[document.location];
			}
		}
		
		if (localStorage.body) {
			document.forms.post.body.value = '';
			localStorage.body = '';
		}
	}
}

var script_settings = function(script_name) {
	this.script_name = script_name;
	this.get = function(var_name, default_val) {
		if (typeof tb_settings == 'undefined' ||
			typeof tb_settings[this.script_name] == 'undefined' ||
			typeof tb_settings[this.script_name][var_name] == 'undefined')
			return default_val;
		return tb_settings[this.script_name][var_name];
	}
};

function init() {
	//	store highlighted text for citeReply()
	if (document.querySelector('form[name="postcontrols"]') !== null) {
		document.querySelector('form[name="postcontrols"]').addEventListener('mouseup', function (e) {
			sessionStorage.quoteClipboard = window.getSelection().toString();
		});
	}

	// just enable jquery, almost every script requires it by now. more and more main.js functions are going to start requiring it
	$('.post-table-options').css('display', 'none');
	window.optionsShowing = false;
	$(document).on('click', '.show-post-table-options', function(e) {
		if (!window.optionsShowing) { 
			$('.show-post-table-options').html('[&#9660; '+_('Hide post options &amp; limits')+']'); 
			$('.post-table-options').css('display', 'table');
			window.optionsShowing = true;
		} else { 
			$('.show-post-table-options').html('[&#9654; '+_('Show post options &amp; limits')+']'); 
			$('.post-table-options').css('display', 'none');
			window.optionsShowing = false;
		}; 
	
		return false;
	});

		
		if (document.forms.postcontrols && document.forms.postcontrols.password) {
		document.forms.postcontrols.password.value = localStorage.password;
	}
		
	
	if (window.location.hash.indexOf('q') != 1 && window.location.hash.substring(1))
		highlightReply(window.location.hash.substring(1));
}

var RecaptchaOptions = {
	theme : 'clean'
};

onready_callbacks = [];
function onready(fnc) {
	onready_callbacks.push(fnc);
}

function ready() {
	for (var i = 0; i < onready_callbacks.length; i++) {
		onready_callbacks[i]();
	}
}



var post_date = "%m/%d/%y (%a) %H:%M:%S";
if (typeof active_page === "undefined") {
	active_page = "page";
}



/*! jQuery v2.1.1 | (c) 2005, 2014 jQuery Foundation, Inc. | jquery.org/license */
!function(a,b){"object"==typeof module&&"object"==typeof module.exports?module.exports=a.document?b(a,!0):function(a){if(!a.document)throw new Error("jQuery requires a window with a document");return b(a)}:b(a)}("undefined"!=typeof window?window:this,function(a,b){var c=[],d=c.slice,e=c.concat,f=c.push,g=c.indexOf,h={},i=h.toString,j=h.hasOwnProperty,k={},l=a.document,m="2.1.1",n=function(a,b){return new n.fn.init(a,b)},o=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,p=/^-ms-/,q=/-([\da-z])/gi,r=function(a,b){return b.toUpperCase()};n.fn=n.prototype={jquery:m,constructor:n,selector:"",length:0,toArray:function(){return d.call(this)},get:function(a){return null!=a?0>a?this[a+this.length]:this[a]:d.call(this)},pushStack:function(a){var b=n.merge(this.constructor(),a);return b.prevObject=this,b.context=this.context,b},each:function(a,b){return n.each(this,a,b)},map:function(a){return this.pushStack(n.map(this,function(b,c){return a.call(b,c,b)}))},slice:function(){return this.pushStack(d.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(a){var b=this.length,c=+a+(0>a?b:0);return this.pushStack(c>=0&&b>c?[this[c]]:[])},end:function(){return this.prevObject||this.constructor(null)},push:f,sort:c.sort,splice:c.splice},n.extend=n.fn.extend=function(){var a,b,c,d,e,f,g=arguments[0]||{},h=1,i=arguments.length,j=!1;for("boolean"==typeof g&&(j=g,g=arguments[h]||{},h++),"object"==typeof g||n.isFunction(g)||(g={}),h===i&&(g=this,h--);i>h;h++)if(null!=(a=arguments[h]))for(b in a)c=g[b],d=a[b],g!==d&&(j&&d&&(n.isPlainObject(d)||(e=n.isArray(d)))?(e?(e=!1,f=c&&n.isArray(c)?c:[]):f=c&&n.isPlainObject(c)?c:{},g[b]=n.extend(j,f,d)):void 0!==d&&(g[b]=d));return g},n.extend({expando:"jQuery"+(m+Math.random()).replace(/\D/g,""),isReady:!0,error:function(a){throw new Error(a)},noop:function(){},isFunction:function(a){return"function"===n.type(a)},isArray:Array.isArray,isWindow:function(a){return null!=a&&a===a.window},isNumeric:function(a){return!n.isArray(a)&&a-parseFloat(a)>=0},isPlainObject:function(a){return"object"!==n.type(a)||a.nodeType||n.isWindow(a)?!1:a.constructor&&!j.call(a.constructor.prototype,"isPrototypeOf")?!1:!0},isEmptyObject:function(a){var b;for(b in a)return!1;return!0},type:function(a){return null==a?a+"":"object"==typeof a||"function"==typeof a?h[i.call(a)]||"object":typeof a},globalEval:function(a){var b,c=eval;a=n.trim(a),a&&(1===a.indexOf("use strict")?(b=l.createElement("script"),b.text=a,l.head.appendChild(b).parentNode.removeChild(b)):c(a))},camelCase:function(a){return a.replace(p,"ms-").replace(q,r)},nodeName:function(a,b){return a.nodeName&&a.nodeName.toLowerCase()===b.toLowerCase()},each:function(a,b,c){var d,e=0,f=a.length,g=s(a);if(c){if(g){for(;f>e;e++)if(d=b.apply(a[e],c),d===!1)break}else for(e in a)if(d=b.apply(a[e],c),d===!1)break}else if(g){for(;f>e;e++)if(d=b.call(a[e],e,a[e]),d===!1)break}else for(e in a)if(d=b.call(a[e],e,a[e]),d===!1)break;return a},trim:function(a){return null==a?"":(a+"").replace(o,"")},makeArray:function(a,b){var c=b||[];return null!=a&&(s(Object(a))?n.merge(c,"string"==typeof a?[a]:a):f.call(c,a)),c},inArray:function(a,b,c){return null==b?-1:g.call(b,a,c)},merge:function(a,b){for(var c=+b.length,d=0,e=a.length;c>d;d++)a[e++]=b[d];return a.length=e,a},grep:function(a,b,c){for(var d,e=[],f=0,g=a.length,h=!c;g>f;f++)d=!b(a[f],f),d!==h&&e.push(a[f]);return e},map:function(a,b,c){var d,f=0,g=a.length,h=s(a),i=[];if(h)for(;g>f;f++)d=b(a[f],f,c),null!=d&&i.push(d);else for(f in a)d=b(a[f],f,c),null!=d&&i.push(d);return e.apply([],i)},guid:1,proxy:function(a,b){var c,e,f;return"string"==typeof b&&(c=a[b],b=a,a=c),n.isFunction(a)?(e=d.call(arguments,2),f=function(){return a.apply(b||this,e.concat(d.call(arguments)))},f.guid=a.guid=a.guid||n.guid++,f):void 0},now:Date.now,support:k}),n.each("Boolean Number String Function Array Date RegExp Object Error".split(" "),function(a,b){h["[object "+b+"]"]=b.toLowerCase()});function s(a){var b=a.length,c=n.type(a);return"function"===c||n.isWindow(a)?!1:1===a.nodeType&&b?!0:"array"===c||0===b||"number"==typeof b&&b>0&&b-1 in a}var t=function(a){var b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u="sizzle"+-new Date,v=a.document,w=0,x=0,y=gb(),z=gb(),A=gb(),B=function(a,b){return a===b&&(l=!0),0},C="undefined",D=1<<31,E={}.hasOwnProperty,F=[],G=F.pop,H=F.push,I=F.push,J=F.slice,K=F.indexOf||function(a){for(var b=0,c=this.length;c>b;b++)if(this[b]===a)return b;return-1},L="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",M="[\\x20\\t\\r\\n\\f]",N="(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+",O=N.replace("w","w#"),P="\\["+M+"*("+N+")(?:"+M+"*([*^$|!~]?=)"+M+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+O+"))|)"+M+"*\\]",Q=":("+N+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+P+")*)|.*)\\)|)",R=new RegExp("^"+M+"+|((?:^|[^\\\\])(?:\\\\.)*)"+M+"+$","g"),S=new RegExp("^"+M+"*,"+M+"*"),T=new RegExp("^"+M+"*([>+~]|"+M+")"+M+"*"),U=new RegExp("="+M+"*([^\\]'\"]*?)"+M+"*\\]","g"),V=new RegExp(Q),W=new RegExp("^"+O+"$"),X={ID:new RegExp("^#("+N+")"),CLASS:new RegExp("^\\.("+N+")"),TAG:new RegExp("^("+N.replace("w","w*")+")"),ATTR:new RegExp("^"+P),PSEUDO:new RegExp("^"+Q),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+M+"*(even|odd|(([+-]|)(\\d*)n|)"+M+"*(?:([+-]|)"+M+"*(\\d+)|))"+M+"*\\)|)","i"),bool:new RegExp("^(?:"+L+")$","i"),needsContext:new RegExp("^"+M+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+M+"*((?:-\\d)?\\d*)"+M+"*\\)|)(?=[^-]|$)","i")},Y=/^(?:input|select|textarea|button)$/i,Z=/^h\d$/i,$=/^[^{]+\{\s*\[native \w/,_=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ab=/[+~]/,bb=/'|\\/g,cb=new RegExp("\\\\([\\da-f]{1,6}"+M+"?|("+M+")|.)","ig"),db=function(a,b,c){var d="0x"+b-65536;return d!==d||c?b:0>d?String.fromCharCode(d+65536):String.fromCharCode(d>>10|55296,1023&d|56320)};try{I.apply(F=J.call(v.childNodes),v.childNodes),F[v.childNodes.length].nodeType}catch(eb){I={apply:F.length?function(a,b){H.apply(a,J.call(b))}:function(a,b){var c=a.length,d=0;while(a[c++]=b[d++]);a.length=c-1}}}function fb(a,b,d,e){var f,h,j,k,l,o,r,s,w,x;if((b?b.ownerDocument||b:v)!==n&&m(b),b=b||n,d=d||[],!a||"string"!=typeof a)return d;if(1!==(k=b.nodeType)&&9!==k)return[];if(p&&!e){if(f=_.exec(a))if(j=f[1]){if(9===k){if(h=b.getElementById(j),!h||!h.parentNode)return d;if(h.id===j)return d.push(h),d}else if(b.ownerDocument&&(h=b.ownerDocument.getElementById(j))&&t(b,h)&&h.id===j)return d.push(h),d}else{if(f[2])return I.apply(d,b.getElementsByTagName(a)),d;if((j=f[3])&&c.getElementsByClassName&&b.getElementsByClassName)return I.apply(d,b.getElementsByClassName(j)),d}if(c.qsa&&(!q||!q.test(a))){if(s=r=u,w=b,x=9===k&&a,1===k&&"object"!==b.nodeName.toLowerCase()){o=g(a),(r=b.getAttribute("id"))?s=r.replace(bb,"\\$&"):b.setAttribute("id",s),s="[id='"+s+"'] ",l=o.length;while(l--)o[l]=s+qb(o[l]);w=ab.test(a)&&ob(b.parentNode)||b,x=o.join(",")}if(x)try{return I.apply(d,w.querySelectorAll(x)),d}catch(y){}finally{r||b.removeAttribute("id")}}}return i(a.replace(R,"$1"),b,d,e)}function gb(){var a=[];function b(c,e){return a.push(c+" ")>d.cacheLength&&delete b[a.shift()],b[c+" "]=e}return b}function hb(a){return a[u]=!0,a}function ib(a){var b=n.createElement("div");try{return!!a(b)}catch(c){return!1}finally{b.parentNode&&b.parentNode.removeChild(b),b=null}}function jb(a,b){var c=a.split("|"),e=a.length;while(e--)d.attrHandle[c[e]]=b}function kb(a,b){var c=b&&a,d=c&&1===a.nodeType&&1===b.nodeType&&(~b.sourceIndex||D)-(~a.sourceIndex||D);if(d)return d;if(c)while(c=c.nextSibling)if(c===b)return-1;return a?1:-1}function lb(a){return function(b){var c=b.nodeName.toLowerCase();return"input"===c&&b.type===a}}function mb(a){return function(b){var c=b.nodeName.toLowerCase();return("input"===c||"button"===c)&&b.type===a}}function nb(a){return hb(function(b){return b=+b,hb(function(c,d){var e,f=a([],c.length,b),g=f.length;while(g--)c[e=f[g]]&&(c[e]=!(d[e]=c[e]))})})}function ob(a){return a&&typeof a.getElementsByTagName!==C&&a}c=fb.support={},f=fb.isXML=function(a){var b=a&&(a.ownerDocument||a).documentElement;return b?"HTML"!==b.nodeName:!1},m=fb.setDocument=function(a){var b,e=a?a.ownerDocument||a:v,g=e.defaultView;return e!==n&&9===e.nodeType&&e.documentElement?(n=e,o=e.documentElement,p=!f(e),g&&g!==g.top&&(g.addEventListener?g.addEventListener("unload",function(){m()},!1):g.attachEvent&&g.attachEvent("onunload",function(){m()})),c.attributes=ib(function(a){return a.className="i",!a.getAttribute("className")}),c.getElementsByTagName=ib(function(a){return a.appendChild(e.createComment("")),!a.getElementsByTagName("*").length}),c.getElementsByClassName=$.test(e.getElementsByClassName)&&ib(function(a){return a.innerHTML="<div class='a'></div><div class='a i'></div>",a.firstChild.className="i",2===a.getElementsByClassName("i").length}),c.getById=ib(function(a){return o.appendChild(a).id=u,!e.getElementsByName||!e.getElementsByName(u).length}),c.getById?(d.find.ID=function(a,b){if(typeof b.getElementById!==C&&p){var c=b.getElementById(a);return c&&c.parentNode?[c]:[]}},d.filter.ID=function(a){var b=a.replace(cb,db);return function(a){return a.getAttribute("id")===b}}):(delete d.find.ID,d.filter.ID=function(a){var b=a.replace(cb,db);return function(a){var c=typeof a.getAttributeNode!==C&&a.getAttributeNode("id");return c&&c.value===b}}),d.find.TAG=c.getElementsByTagName?function(a,b){return typeof b.getElementsByTagName!==C?b.getElementsByTagName(a):void 0}:function(a,b){var c,d=[],e=0,f=b.getElementsByTagName(a);if("*"===a){while(c=f[e++])1===c.nodeType&&d.push(c);return d}return f},d.find.CLASS=c.getElementsByClassName&&function(a,b){return typeof b.getElementsByClassName!==C&&p?b.getElementsByClassName(a):void 0},r=[],q=[],(c.qsa=$.test(e.querySelectorAll))&&(ib(function(a){a.innerHTML="<select msallowclip=''><option selected=''></option></select>",a.querySelectorAll("[msallowclip^='']").length&&q.push("[*^$]="+M+"*(?:''|\"\")"),a.querySelectorAll("[selected]").length||q.push("\\["+M+"*(?:value|"+L+")"),a.querySelectorAll(":checked").length||q.push(":checked")}),ib(function(a){var b=e.createElement("input");b.setAttribute("type","hidden"),a.appendChild(b).setAttribute("name","D"),a.querySelectorAll("[name=d]").length&&q.push("name"+M+"*[*^$|!~]?="),a.querySelectorAll(":enabled").length||q.push(":enabled",":disabled"),a.querySelectorAll("*,:x"),q.push(",.*:")})),(c.matchesSelector=$.test(s=o.matches||o.webkitMatchesSelector||o.mozMatchesSelector||o.oMatchesSelector||o.msMatchesSelector))&&ib(function(a){c.disconnectedMatch=s.call(a,"div"),s.call(a,"[s!='']:x"),r.push("!=",Q)}),q=q.length&&new RegExp(q.join("|")),r=r.length&&new RegExp(r.join("|")),b=$.test(o.compareDocumentPosition),t=b||$.test(o.contains)?function(a,b){var c=9===a.nodeType?a.documentElement:a,d=b&&b.parentNode;return a===d||!(!d||1!==d.nodeType||!(c.contains?c.contains(d):a.compareDocumentPosition&&16&a.compareDocumentPosition(d)))}:function(a,b){if(b)while(b=b.parentNode)if(b===a)return!0;return!1},B=b?function(a,b){if(a===b)return l=!0,0;var d=!a.compareDocumentPosition-!b.compareDocumentPosition;return d?d:(d=(a.ownerDocument||a)===(b.ownerDocument||b)?a.compareDocumentPosition(b):1,1&d||!c.sortDetached&&b.compareDocumentPosition(a)===d?a===e||a.ownerDocument===v&&t(v,a)?-1:b===e||b.ownerDocument===v&&t(v,b)?1:k?K.call(k,a)-K.call(k,b):0:4&d?-1:1)}:function(a,b){if(a===b)return l=!0,0;var c,d=0,f=a.parentNode,g=b.parentNode,h=[a],i=[b];if(!f||!g)return a===e?-1:b===e?1:f?-1:g?1:k?K.call(k,a)-K.call(k,b):0;if(f===g)return kb(a,b);c=a;while(c=c.parentNode)h.unshift(c);c=b;while(c=c.parentNode)i.unshift(c);while(h[d]===i[d])d++;return d?kb(h[d],i[d]):h[d]===v?-1:i[d]===v?1:0},e):n},fb.matches=function(a,b){return fb(a,null,null,b)},fb.matchesSelector=function(a,b){if((a.ownerDocument||a)!==n&&m(a),b=b.replace(U,"='$1']"),!(!c.matchesSelector||!p||r&&r.test(b)||q&&q.test(b)))try{var d=s.call(a,b);if(d||c.disconnectedMatch||a.document&&11!==a.document.nodeType)return d}catch(e){}return fb(b,n,null,[a]).length>0},fb.contains=function(a,b){return(a.ownerDocument||a)!==n&&m(a),t(a,b)},fb.attr=function(a,b){(a.ownerDocument||a)!==n&&m(a);var e=d.attrHandle[b.toLowerCase()],f=e&&E.call(d.attrHandle,b.toLowerCase())?e(a,b,!p):void 0;return void 0!==f?f:c.attributes||!p?a.getAttribute(b):(f=a.getAttributeNode(b))&&f.specified?f.value:null},fb.error=function(a){throw new Error("Syntax error, unrecognized expression: "+a)},fb.uniqueSort=function(a){var b,d=[],e=0,f=0;if(l=!c.detectDuplicates,k=!c.sortStable&&a.slice(0),a.sort(B),l){while(b=a[f++])b===a[f]&&(e=d.push(f));while(e--)a.splice(d[e],1)}return k=null,a},e=fb.getText=function(a){var b,c="",d=0,f=a.nodeType;if(f){if(1===f||9===f||11===f){if("string"==typeof a.textContent)return a.textContent;for(a=a.firstChild;a;a=a.nextSibling)c+=e(a)}else if(3===f||4===f)return a.nodeValue}else while(b=a[d++])c+=e(b);return c},d=fb.selectors={cacheLength:50,createPseudo:hb,match:X,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(a){return a[1]=a[1].replace(cb,db),a[3]=(a[3]||a[4]||a[5]||"").replace(cb,db),"~="===a[2]&&(a[3]=" "+a[3]+" "),a.slice(0,4)},CHILD:function(a){return a[1]=a[1].toLowerCase(),"nth"===a[1].slice(0,3)?(a[3]||fb.error(a[0]),a[4]=+(a[4]?a[5]+(a[6]||1):2*("even"===a[3]||"odd"===a[3])),a[5]=+(a[7]+a[8]||"odd"===a[3])):a[3]&&fb.error(a[0]),a},PSEUDO:function(a){var b,c=!a[6]&&a[2];return X.CHILD.test(a[0])?null:(a[3]?a[2]=a[4]||a[5]||"":c&&V.test(c)&&(b=g(c,!0))&&(b=c.indexOf(")",c.length-b)-c.length)&&(a[0]=a[0].slice(0,b),a[2]=c.slice(0,b)),a.slice(0,3))}},filter:{TAG:function(a){var b=a.replace(cb,db).toLowerCase();return"*"===a?function(){return!0}:function(a){return a.nodeName&&a.nodeName.toLowerCase()===b}},CLASS:function(a){var b=y[a+" "];return b||(b=new RegExp("(^|"+M+")"+a+"("+M+"|$)"))&&y(a,function(a){return b.test("string"==typeof a.className&&a.className||typeof a.getAttribute!==C&&a.getAttribute("class")||"")})},ATTR:function(a,b,c){return function(d){var e=fb.attr(d,a);return null==e?"!="===b:b?(e+="","="===b?e===c:"!="===b?e!==c:"^="===b?c&&0===e.indexOf(c):"*="===b?c&&e.indexOf(c)>-1:"$="===b?c&&e.slice(-c.length)===c:"~="===b?(" "+e+" ").indexOf(c)>-1:"|="===b?e===c||e.slice(0,c.length+1)===c+"-":!1):!0}},CHILD:function(a,b,c,d,e){var f="nth"!==a.slice(0,3),g="last"!==a.slice(-4),h="of-type"===b;return 1===d&&0===e?function(a){return!!a.parentNode}:function(b,c,i){var j,k,l,m,n,o,p=f!==g?"nextSibling":"previousSibling",q=b.parentNode,r=h&&b.nodeName.toLowerCase(),s=!i&&!h;if(q){if(f){while(p){l=b;while(l=l[p])if(h?l.nodeName.toLowerCase()===r:1===l.nodeType)return!1;o=p="only"===a&&!o&&"nextSibling"}return!0}if(o=[g?q.firstChild:q.lastChild],g&&s){k=q[u]||(q[u]={}),j=k[a]||[],n=j[0]===w&&j[1],m=j[0]===w&&j[2],l=n&&q.childNodes[n];while(l=++n&&l&&l[p]||(m=n=0)||o.pop())if(1===l.nodeType&&++m&&l===b){k[a]=[w,n,m];break}}else if(s&&(j=(b[u]||(b[u]={}))[a])&&j[0]===w)m=j[1];else while(l=++n&&l&&l[p]||(m=n=0)||o.pop())if((h?l.nodeName.toLowerCase()===r:1===l.nodeType)&&++m&&(s&&((l[u]||(l[u]={}))[a]=[w,m]),l===b))break;return m-=e,m===d||m%d===0&&m/d>=0}}},PSEUDO:function(a,b){var c,e=d.pseudos[a]||d.setFilters[a.toLowerCase()]||fb.error("unsupported pseudo: "+a);return e[u]?e(b):e.length>1?(c=[a,a,"",b],d.setFilters.hasOwnProperty(a.toLowerCase())?hb(function(a,c){var d,f=e(a,b),g=f.length;while(g--)d=K.call(a,f[g]),a[d]=!(c[d]=f[g])}):function(a){return e(a,0,c)}):e}},pseudos:{not:hb(function(a){var b=[],c=[],d=h(a.replace(R,"$1"));return d[u]?hb(function(a,b,c,e){var f,g=d(a,null,e,[]),h=a.length;while(h--)(f=g[h])&&(a[h]=!(b[h]=f))}):function(a,e,f){return b[0]=a,d(b,null,f,c),!c.pop()}}),has:hb(function(a){return function(b){return fb(a,b).length>0}}),contains:hb(function(a){return function(b){return(b.textContent||b.innerText||e(b)).indexOf(a)>-1}}),lang:hb(function(a){return W.test(a||"")||fb.error("unsupported lang: "+a),a=a.replace(cb,db).toLowerCase(),function(b){var c;do if(c=p?b.lang:b.getAttribute("xml:lang")||b.getAttribute("lang"))return c=c.toLowerCase(),c===a||0===c.indexOf(a+"-");while((b=b.parentNode)&&1===b.nodeType);return!1}}),target:function(b){var c=a.location&&a.location.hash;return c&&c.slice(1)===b.id},root:function(a){return a===o},focus:function(a){return a===n.activeElement&&(!n.hasFocus||n.hasFocus())&&!!(a.type||a.href||~a.tabIndex)},enabled:function(a){return a.disabled===!1},disabled:function(a){return a.disabled===!0},checked:function(a){var b=a.nodeName.toLowerCase();return"input"===b&&!!a.checked||"option"===b&&!!a.selected},selected:function(a){return a.parentNode&&a.parentNode.selectedIndex,a.selected===!0},empty:function(a){for(a=a.firstChild;a;a=a.nextSibling)if(a.nodeType<6)return!1;return!0},parent:function(a){return!d.pseudos.empty(a)},header:function(a){return Z.test(a.nodeName)},input:function(a){return Y.test(a.nodeName)},button:function(a){var b=a.nodeName.toLowerCase();return"input"===b&&"button"===a.type||"button"===b},text:function(a){var b;return"input"===a.nodeName.toLowerCase()&&"text"===a.type&&(null==(b=a.getAttribute("type"))||"text"===b.toLowerCase())},first:nb(function(){return[0]}),last:nb(function(a,b){return[b-1]}),eq:nb(function(a,b,c){return[0>c?c+b:c]}),even:nb(function(a,b){for(var c=0;b>c;c+=2)a.push(c);return a}),odd:nb(function(a,b){for(var c=1;b>c;c+=2)a.push(c);return a}),lt:nb(function(a,b,c){for(var d=0>c?c+b:c;--d>=0;)a.push(d);return a}),gt:nb(function(a,b,c){for(var d=0>c?c+b:c;++d<b;)a.push(d);return a})}},d.pseudos.nth=d.pseudos.eq;for(b in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})d.pseudos[b]=lb(b);for(b in{submit:!0,reset:!0})d.pseudos[b]=mb(b);function pb(){}pb.prototype=d.filters=d.pseudos,d.setFilters=new pb,g=fb.tokenize=function(a,b){var c,e,f,g,h,i,j,k=z[a+" "];if(k)return b?0:k.slice(0);h=a,i=[],j=d.preFilter;while(h){(!c||(e=S.exec(h)))&&(e&&(h=h.slice(e[0].length)||h),i.push(f=[])),c=!1,(e=T.exec(h))&&(c=e.shift(),f.push({value:c,type:e[0].replace(R," ")}),h=h.slice(c.length));for(g in d.filter)!(e=X[g].exec(h))||j[g]&&!(e=j[g](e))||(c=e.shift(),f.push({value:c,type:g,matches:e}),h=h.slice(c.length));if(!c)break}return b?h.length:h?fb.error(a):z(a,i).slice(0)};function qb(a){for(var b=0,c=a.length,d="";c>b;b++)d+=a[b].value;return d}function rb(a,b,c){var d=b.dir,e=c&&"parentNode"===d,f=x++;return b.first?function(b,c,f){while(b=b[d])if(1===b.nodeType||e)return a(b,c,f)}:function(b,c,g){var h,i,j=[w,f];if(g){while(b=b[d])if((1===b.nodeType||e)&&a(b,c,g))return!0}else while(b=b[d])if(1===b.nodeType||e){if(i=b[u]||(b[u]={}),(h=i[d])&&h[0]===w&&h[1]===f)return j[2]=h[2];if(i[d]=j,j[2]=a(b,c,g))return!0}}}function sb(a){return a.length>1?function(b,c,d){var e=a.length;while(e--)if(!a[e](b,c,d))return!1;return!0}:a[0]}function tb(a,b,c){for(var d=0,e=b.length;e>d;d++)fb(a,b[d],c);return c}function ub(a,b,c,d,e){for(var f,g=[],h=0,i=a.length,j=null!=b;i>h;h++)(f=a[h])&&(!c||c(f,d,e))&&(g.push(f),j&&b.push(h));return g}function vb(a,b,c,d,e,f){return d&&!d[u]&&(d=vb(d)),e&&!e[u]&&(e=vb(e,f)),hb(function(f,g,h,i){var j,k,l,m=[],n=[],o=g.length,p=f||tb(b||"*",h.nodeType?[h]:h,[]),q=!a||!f&&b?p:ub(p,m,a,h,i),r=c?e||(f?a:o||d)?[]:g:q;if(c&&c(q,r,h,i),d){j=ub(r,n),d(j,[],h,i),k=j.length;while(k--)(l=j[k])&&(r[n[k]]=!(q[n[k]]=l))}if(f){if(e||a){if(e){j=[],k=r.length;while(k--)(l=r[k])&&j.push(q[k]=l);e(null,r=[],j,i)}k=r.length;while(k--)(l=r[k])&&(j=e?K.call(f,l):m[k])>-1&&(f[j]=!(g[j]=l))}}else r=ub(r===g?r.splice(o,r.length):r),e?e(null,g,r,i):I.apply(g,r)})}function wb(a){for(var b,c,e,f=a.length,g=d.relative[a[0].type],h=g||d.relative[" "],i=g?1:0,k=rb(function(a){return a===b},h,!0),l=rb(function(a){return K.call(b,a)>-1},h,!0),m=[function(a,c,d){return!g&&(d||c!==j)||((b=c).nodeType?k(a,c,d):l(a,c,d))}];f>i;i++)if(c=d.relative[a[i].type])m=[rb(sb(m),c)];else{if(c=d.filter[a[i].type].apply(null,a[i].matches),c[u]){for(e=++i;f>e;e++)if(d.relative[a[e].type])break;return vb(i>1&&sb(m),i>1&&qb(a.slice(0,i-1).concat({value:" "===a[i-2].type?"*":""})).replace(R,"$1"),c,e>i&&wb(a.slice(i,e)),f>e&&wb(a=a.slice(e)),f>e&&qb(a))}m.push(c)}return sb(m)}function xb(a,b){var c=b.length>0,e=a.length>0,f=function(f,g,h,i,k){var l,m,o,p=0,q="0",r=f&&[],s=[],t=j,u=f||e&&d.find.TAG("*",k),v=w+=null==t?1:Math.random()||.1,x=u.length;for(k&&(j=g!==n&&g);q!==x&&null!=(l=u[q]);q++){if(e&&l){m=0;while(o=a[m++])if(o(l,g,h)){i.push(l);break}k&&(w=v)}c&&((l=!o&&l)&&p--,f&&r.push(l))}if(p+=q,c&&q!==p){m=0;while(o=b[m++])o(r,s,g,h);if(f){if(p>0)while(q--)r[q]||s[q]||(s[q]=G.call(i));s=ub(s)}I.apply(i,s),k&&!f&&s.length>0&&p+b.length>1&&fb.uniqueSort(i)}return k&&(w=v,j=t),r};return c?hb(f):f}return h=fb.compile=function(a,b){var c,d=[],e=[],f=A[a+" "];if(!f){b||(b=g(a)),c=b.length;while(c--)f=wb(b[c]),f[u]?d.push(f):e.push(f);f=A(a,xb(e,d)),f.selector=a}return f},i=fb.select=function(a,b,e,f){var i,j,k,l,m,n="function"==typeof a&&a,o=!f&&g(a=n.selector||a);if(e=e||[],1===o.length){if(j=o[0]=o[0].slice(0),j.length>2&&"ID"===(k=j[0]).type&&c.getById&&9===b.nodeType&&p&&d.relative[j[1].type]){if(b=(d.find.ID(k.matches[0].replace(cb,db),b)||[])[0],!b)return e;n&&(b=b.parentNode),a=a.slice(j.shift().value.length)}i=X.needsContext.test(a)?0:j.length;while(i--){if(k=j[i],d.relative[l=k.type])break;if((m=d.find[l])&&(f=m(k.matches[0].replace(cb,db),ab.test(j[0].type)&&ob(b.parentNode)||b))){if(j.splice(i,1),a=f.length&&qb(j),!a)return I.apply(e,f),e;break}}}return(n||h(a,o))(f,b,!p,e,ab.test(a)&&ob(b.parentNode)||b),e},c.sortStable=u.split("").sort(B).join("")===u,c.detectDuplicates=!!l,m(),c.sortDetached=ib(function(a){return 1&a.compareDocumentPosition(n.createElement("div"))}),ib(function(a){return a.innerHTML="<a href='#'></a>","#"===a.firstChild.getAttribute("href")})||jb("type|href|height|width",function(a,b,c){return c?void 0:a.getAttribute(b,"type"===b.toLowerCase()?1:2)}),c.attributes&&ib(function(a){return a.innerHTML="<input/>",a.firstChild.setAttribute("value",""),""===a.firstChild.getAttribute("value")})||jb("value",function(a,b,c){return c||"input"!==a.nodeName.toLowerCase()?void 0:a.defaultValue}),ib(function(a){return null==a.getAttribute("disabled")})||jb(L,function(a,b,c){var d;return c?void 0:a[b]===!0?b.toLowerCase():(d=a.getAttributeNode(b))&&d.specified?d.value:null}),fb}(a);n.find=t,n.expr=t.selectors,n.expr[":"]=n.expr.pseudos,n.unique=t.uniqueSort,n.text=t.getText,n.isXMLDoc=t.isXML,n.contains=t.contains;var u=n.expr.match.needsContext,v=/^<(\w+)\s*\/?>(?:<\/\1>|)$/,w=/^.[^:#\[\.,]*$/;function x(a,b,c){if(n.isFunction(b))return n.grep(a,function(a,d){return!!b.call(a,d,a)!==c});if(b.nodeType)return n.grep(a,function(a){return a===b!==c});if("string"==typeof b){if(w.test(b))return n.filter(b,a,c);b=n.filter(b,a)}return n.grep(a,function(a){return g.call(b,a)>=0!==c})}n.filter=function(a,b,c){var d=b[0];return c&&(a=":not("+a+")"),1===b.length&&1===d.nodeType?n.find.matchesSelector(d,a)?[d]:[]:n.find.matches(a,n.grep(b,function(a){return 1===a.nodeType}))},n.fn.extend({find:function(a){var b,c=this.length,d=[],e=this;if("string"!=typeof a)return this.pushStack(n(a).filter(function(){for(b=0;c>b;b++)if(n.contains(e[b],this))return!0}));for(b=0;c>b;b++)n.find(a,e[b],d);return d=this.pushStack(c>1?n.unique(d):d),d.selector=this.selector?this.selector+" "+a:a,d},filter:function(a){return this.pushStack(x(this,a||[],!1))},not:function(a){return this.pushStack(x(this,a||[],!0))},is:function(a){return!!x(this,"string"==typeof a&&u.test(a)?n(a):a||[],!1).length}});var y,z=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/,A=n.fn.init=function(a,b){var c,d;if(!a)return this;if("string"==typeof a){if(c="<"===a[0]&&">"===a[a.length-1]&&a.length>=3?[null,a,null]:z.exec(a),!c||!c[1]&&b)return!b||b.jquery?(b||y).find(a):this.constructor(b).find(a);if(c[1]){if(b=b instanceof n?b[0]:b,n.merge(this,n.parseHTML(c[1],b&&b.nodeType?b.ownerDocument||b:l,!0)),v.test(c[1])&&n.isPlainObject(b))for(c in b)n.isFunction(this[c])?this[c](b[c]):this.attr(c,b[c]);return this}return d=l.getElementById(c[2]),d&&d.parentNode&&(this.length=1,this[0]=d),this.context=l,this.selector=a,this}return a.nodeType?(this.context=this[0]=a,this.length=1,this):n.isFunction(a)?"undefined"!=typeof y.ready?y.ready(a):a(n):(void 0!==a.selector&&(this.selector=a.selector,this.context=a.context),n.makeArray(a,this))};A.prototype=n.fn,y=n(l);var B=/^(?:parents|prev(?:Until|All))/,C={children:!0,contents:!0,next:!0,prev:!0};n.extend({dir:function(a,b,c){var d=[],e=void 0!==c;while((a=a[b])&&9!==a.nodeType)if(1===a.nodeType){if(e&&n(a).is(c))break;d.push(a)}return d},sibling:function(a,b){for(var c=[];a;a=a.nextSibling)1===a.nodeType&&a!==b&&c.push(a);return c}}),n.fn.extend({has:function(a){var b=n(a,this),c=b.length;return this.filter(function(){for(var a=0;c>a;a++)if(n.contains(this,b[a]))return!0})},closest:function(a,b){for(var c,d=0,e=this.length,f=[],g=u.test(a)||"string"!=typeof a?n(a,b||this.context):0;e>d;d++)for(c=this[d];c&&c!==b;c=c.parentNode)if(c.nodeType<11&&(g?g.index(c)>-1:1===c.nodeType&&n.find.matchesSelector(c,a))){f.push(c);break}return this.pushStack(f.length>1?n.unique(f):f)},index:function(a){return a?"string"==typeof a?g.call(n(a),this[0]):g.call(this,a.jquery?a[0]:a):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(a,b){return this.pushStack(n.unique(n.merge(this.get(),n(a,b))))},addBack:function(a){return this.add(null==a?this.prevObject:this.prevObject.filter(a))}});function D(a,b){while((a=a[b])&&1!==a.nodeType);return a}n.each({parent:function(a){var b=a.parentNode;return b&&11!==b.nodeType?b:null},parents:function(a){return n.dir(a,"parentNode")},parentsUntil:function(a,b,c){return n.dir(a,"parentNode",c)},next:function(a){return D(a,"nextSibling")},prev:function(a){return D(a,"previousSibling")},nextAll:function(a){return n.dir(a,"nextSibling")},prevAll:function(a){return n.dir(a,"previousSibling")},nextUntil:function(a,b,c){return n.dir(a,"nextSibling",c)},prevUntil:function(a,b,c){return n.dir(a,"previousSibling",c)},siblings:function(a){return n.sibling((a.parentNode||{}).firstChild,a)},children:function(a){return n.sibling(a.firstChild)},contents:function(a){return a.contentDocument||n.merge([],a.childNodes)}},function(a,b){n.fn[a]=function(c,d){var e=n.map(this,b,c);return"Until"!==a.slice(-5)&&(d=c),d&&"string"==typeof d&&(e=n.filter(d,e)),this.length>1&&(C[a]||n.unique(e),B.test(a)&&e.reverse()),this.pushStack(e)}});var E=/\S+/g,F={};function G(a){var b=F[a]={};return n.each(a.match(E)||[],function(a,c){b[c]=!0}),b}n.Callbacks=function(a){a="string"==typeof a?F[a]||G(a):n.extend({},a);var b,c,d,e,f,g,h=[],i=!a.once&&[],j=function(l){for(b=a.memory&&l,c=!0,g=e||0,e=0,f=h.length,d=!0;h&&f>g;g++)if(h[g].apply(l[0],l[1])===!1&&a.stopOnFalse){b=!1;break}d=!1,h&&(i?i.length&&j(i.shift()):b?h=[]:k.disable())},k={add:function(){if(h){var c=h.length;!function g(b){n.each(b,function(b,c){var d=n.type(c);"function"===d?a.unique&&k.has(c)||h.push(c):c&&c.length&&"string"!==d&&g(c)})}(arguments),d?f=h.length:b&&(e=c,j(b))}return this},remove:function(){return h&&n.each(arguments,function(a,b){var c;while((c=n.inArray(b,h,c))>-1)h.splice(c,1),d&&(f>=c&&f--,g>=c&&g--)}),this},has:function(a){return a?n.inArray(a,h)>-1:!(!h||!h.length)},empty:function(){return h=[],f=0,this},disable:function(){return h=i=b=void 0,this},disabled:function(){return!h},lock:function(){return i=void 0,b||k.disable(),this},locked:function(){return!i},fireWith:function(a,b){return!h||c&&!i||(b=b||[],b=[a,b.slice?b.slice():b],d?i.push(b):j(b)),this},fire:function(){return k.fireWith(this,arguments),this},fired:function(){return!!c}};return k},n.extend({Deferred:function(a){var b=[["resolve","done",n.Callbacks("once memory"),"resolved"],["reject","fail",n.Callbacks("once memory"),"rejected"],["notify","progress",n.Callbacks("memory")]],c="pending",d={state:function(){return c},always:function(){return e.done(arguments).fail(arguments),this},then:function(){var a=arguments;return n.Deferred(function(c){n.each(b,function(b,f){var g=n.isFunction(a[b])&&a[b];e[f[1]](function(){var a=g&&g.apply(this,arguments);a&&n.isFunction(a.promise)?a.promise().done(c.resolve).fail(c.reject).progress(c.notify):c[f[0]+"With"](this===d?c.promise():this,g?[a]:arguments)})}),a=null}).promise()},promise:function(a){return null!=a?n.extend(a,d):d}},e={};return d.pipe=d.then,n.each(b,function(a,f){var g=f[2],h=f[3];d[f[1]]=g.add,h&&g.add(function(){c=h},b[1^a][2].disable,b[2][2].lock),e[f[0]]=function(){return e[f[0]+"With"](this===e?d:this,arguments),this},e[f[0]+"With"]=g.fireWith}),d.promise(e),a&&a.call(e,e),e},when:function(a){var b=0,c=d.call(arguments),e=c.length,f=1!==e||a&&n.isFunction(a.promise)?e:0,g=1===f?a:n.Deferred(),h=function(a,b,c){return function(e){b[a]=this,c[a]=arguments.length>1?d.call(arguments):e,c===i?g.notifyWith(b,c):--f||g.resolveWith(b,c)}},i,j,k;if(e>1)for(i=new Array(e),j=new Array(e),k=new Array(e);e>b;b++)c[b]&&n.isFunction(c[b].promise)?c[b].promise().done(h(b,k,c)).fail(g.reject).progress(h(b,j,i)):--f;return f||g.resolveWith(k,c),g.promise()}});var H;n.fn.ready=function(a){return n.ready.promise().done(a),this},n.extend({isReady:!1,readyWait:1,holdReady:function(a){a?n.readyWait++:n.ready(!0)},ready:function(a){(a===!0?--n.readyWait:n.isReady)||(n.isReady=!0,a!==!0&&--n.readyWait>0||(H.resolveWith(l,[n]),n.fn.triggerHandler&&(n(l).triggerHandler("ready"),n(l).off("ready"))))}});function I(){l.removeEventListener("DOMContentLoaded",I,!1),a.removeEventListener("load",I,!1),n.ready()}n.ready.promise=function(b){return H||(H=n.Deferred(),"complete"===l.readyState?setTimeout(n.ready):(l.addEventListener("DOMContentLoaded",I,!1),a.addEventListener("load",I,!1))),H.promise(b)},n.ready.promise();var J=n.access=function(a,b,c,d,e,f,g){var h=0,i=a.length,j=null==c;if("object"===n.type(c)){e=!0;for(h in c)n.access(a,b,h,c[h],!0,f,g)}else if(void 0!==d&&(e=!0,n.isFunction(d)||(g=!0),j&&(g?(b.call(a,d),b=null):(j=b,b=function(a,b,c){return j.call(n(a),c)})),b))for(;i>h;h++)b(a[h],c,g?d:d.call(a[h],h,b(a[h],c)));return e?a:j?b.call(a):i?b(a[0],c):f};n.acceptData=function(a){return 1===a.nodeType||9===a.nodeType||!+a.nodeType};function K(){Object.defineProperty(this.cache={},0,{get:function(){return{}}}),this.expando=n.expando+Math.random()}K.uid=1,K.accepts=n.acceptData,K.prototype={key:function(a){if(!K.accepts(a))return 0;var b={},c=a[this.expando];if(!c){c=K.uid++;try{b[this.expando]={value:c},Object.defineProperties(a,b)}catch(d){b[this.expando]=c,n.extend(a,b)}}return this.cache[c]||(this.cache[c]={}),c},set:function(a,b,c){var d,e=this.key(a),f=this.cache[e];if("string"==typeof b)f[b]=c;else if(n.isEmptyObject(f))n.extend(this.cache[e],b);else for(d in b)f[d]=b[d];return f},get:function(a,b){var c=this.cache[this.key(a)];return void 0===b?c:c[b]},access:function(a,b,c){var d;return void 0===b||b&&"string"==typeof b&&void 0===c?(d=this.get(a,b),void 0!==d?d:this.get(a,n.camelCase(b))):(this.set(a,b,c),void 0!==c?c:b)},remove:function(a,b){var c,d,e,f=this.key(a),g=this.cache[f];if(void 0===b)this.cache[f]={};else{n.isArray(b)?d=b.concat(b.map(n.camelCase)):(e=n.camelCase(b),b in g?d=[b,e]:(d=e,d=d in g?[d]:d.match(E)||[])),c=d.length;while(c--)delete g[d[c]]}},hasData:function(a){return!n.isEmptyObject(this.cache[a[this.expando]]||{})},discard:function(a){a[this.expando]&&delete this.cache[a[this.expando]]}};var L=new K,M=new K,N=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,O=/([A-Z])/g;function P(a,b,c){var d;if(void 0===c&&1===a.nodeType)if(d="data-"+b.replace(O,"-$1").toLowerCase(),c=a.getAttribute(d),"string"==typeof c){try{c="true"===c?!0:"false"===c?!1:"null"===c?null:+c+""===c?+c:N.test(c)?n.parseJSON(c):c}catch(e){}M.set(a,b,c)}else c=void 0;return c}n.extend({hasData:function(a){return M.hasData(a)||L.hasData(a)},data:function(a,b,c){return M.access(a,b,c)},removeData:function(a,b){M.remove(a,b)
},_data:function(a,b,c){return L.access(a,b,c)},_removeData:function(a,b){L.remove(a,b)}}),n.fn.extend({data:function(a,b){var c,d,e,f=this[0],g=f&&f.attributes;if(void 0===a){if(this.length&&(e=M.get(f),1===f.nodeType&&!L.get(f,"hasDataAttrs"))){c=g.length;while(c--)g[c]&&(d=g[c].name,0===d.indexOf("data-")&&(d=n.camelCase(d.slice(5)),P(f,d,e[d])));L.set(f,"hasDataAttrs",!0)}return e}return"object"==typeof a?this.each(function(){M.set(this,a)}):J(this,function(b){var c,d=n.camelCase(a);if(f&&void 0===b){if(c=M.get(f,a),void 0!==c)return c;if(c=M.get(f,d),void 0!==c)return c;if(c=P(f,d,void 0),void 0!==c)return c}else this.each(function(){var c=M.get(this,d);M.set(this,d,b),-1!==a.indexOf("-")&&void 0!==c&&M.set(this,a,b)})},null,b,arguments.length>1,null,!0)},removeData:function(a){return this.each(function(){M.remove(this,a)})}}),n.extend({queue:function(a,b,c){var d;return a?(b=(b||"fx")+"queue",d=L.get(a,b),c&&(!d||n.isArray(c)?d=L.access(a,b,n.makeArray(c)):d.push(c)),d||[]):void 0},dequeue:function(a,b){b=b||"fx";var c=n.queue(a,b),d=c.length,e=c.shift(),f=n._queueHooks(a,b),g=function(){n.dequeue(a,b)};"inprogress"===e&&(e=c.shift(),d--),e&&("fx"===b&&c.unshift("inprogress"),delete f.stop,e.call(a,g,f)),!d&&f&&f.empty.fire()},_queueHooks:function(a,b){var c=b+"queueHooks";return L.get(a,c)||L.access(a,c,{empty:n.Callbacks("once memory").add(function(){L.remove(a,[b+"queue",c])})})}}),n.fn.extend({queue:function(a,b){var c=2;return"string"!=typeof a&&(b=a,a="fx",c--),arguments.length<c?n.queue(this[0],a):void 0===b?this:this.each(function(){var c=n.queue(this,a,b);n._queueHooks(this,a),"fx"===a&&"inprogress"!==c[0]&&n.dequeue(this,a)})},dequeue:function(a){return this.each(function(){n.dequeue(this,a)})},clearQueue:function(a){return this.queue(a||"fx",[])},promise:function(a,b){var c,d=1,e=n.Deferred(),f=this,g=this.length,h=function(){--d||e.resolveWith(f,[f])};"string"!=typeof a&&(b=a,a=void 0),a=a||"fx";while(g--)c=L.get(f[g],a+"queueHooks"),c&&c.empty&&(d++,c.empty.add(h));return h(),e.promise(b)}});var Q=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,R=["Top","Right","Bottom","Left"],S=function(a,b){return a=b||a,"none"===n.css(a,"display")||!n.contains(a.ownerDocument,a)},T=/^(?:checkbox|radio)$/i;!function(){var a=l.createDocumentFragment(),b=a.appendChild(l.createElement("div")),c=l.createElement("input");c.setAttribute("type","radio"),c.setAttribute("checked","checked"),c.setAttribute("name","t"),b.appendChild(c),k.checkClone=b.cloneNode(!0).cloneNode(!0).lastChild.checked,b.innerHTML="<textarea>x</textarea>",k.noCloneChecked=!!b.cloneNode(!0).lastChild.defaultValue}();var U="undefined";k.focusinBubbles="onfocusin"in a;var V=/^key/,W=/^(?:mouse|pointer|contextmenu)|click/,X=/^(?:focusinfocus|focusoutblur)$/,Y=/^([^.]*)(?:\.(.+)|)$/;function Z(){return!0}function $(){return!1}function _(){try{return l.activeElement}catch(a){}}n.event={global:{},add:function(a,b,c,d,e){var f,g,h,i,j,k,l,m,o,p,q,r=L.get(a);if(r){c.handler&&(f=c,c=f.handler,e=f.selector),c.guid||(c.guid=n.guid++),(i=r.events)||(i=r.events={}),(g=r.handle)||(g=r.handle=function(b){return typeof n!==U&&n.event.triggered!==b.type?n.event.dispatch.apply(a,arguments):void 0}),b=(b||"").match(E)||[""],j=b.length;while(j--)h=Y.exec(b[j])||[],o=q=h[1],p=(h[2]||"").split(".").sort(),o&&(l=n.event.special[o]||{},o=(e?l.delegateType:l.bindType)||o,l=n.event.special[o]||{},k=n.extend({type:o,origType:q,data:d,handler:c,guid:c.guid,selector:e,needsContext:e&&n.expr.match.needsContext.test(e),namespace:p.join(".")},f),(m=i[o])||(m=i[o]=[],m.delegateCount=0,l.setup&&l.setup.call(a,d,p,g)!==!1||a.addEventListener&&a.addEventListener(o,g,!1)),l.add&&(l.add.call(a,k),k.handler.guid||(k.handler.guid=c.guid)),e?m.splice(m.delegateCount++,0,k):m.push(k),n.event.global[o]=!0)}},remove:function(a,b,c,d,e){var f,g,h,i,j,k,l,m,o,p,q,r=L.hasData(a)&&L.get(a);if(r&&(i=r.events)){b=(b||"").match(E)||[""],j=b.length;while(j--)if(h=Y.exec(b[j])||[],o=q=h[1],p=(h[2]||"").split(".").sort(),o){l=n.event.special[o]||{},o=(d?l.delegateType:l.bindType)||o,m=i[o]||[],h=h[2]&&new RegExp("(^|\\.)"+p.join("\\.(?:.*\\.|)")+"(\\.|$)"),g=f=m.length;while(f--)k=m[f],!e&&q!==k.origType||c&&c.guid!==k.guid||h&&!h.test(k.namespace)||d&&d!==k.selector&&("**"!==d||!k.selector)||(m.splice(f,1),k.selector&&m.delegateCount--,l.remove&&l.remove.call(a,k));g&&!m.length&&(l.teardown&&l.teardown.call(a,p,r.handle)!==!1||n.removeEvent(a,o,r.handle),delete i[o])}else for(o in i)n.event.remove(a,o+b[j],c,d,!0);n.isEmptyObject(i)&&(delete r.handle,L.remove(a,"events"))}},trigger:function(b,c,d,e){var f,g,h,i,k,m,o,p=[d||l],q=j.call(b,"type")?b.type:b,r=j.call(b,"namespace")?b.namespace.split("."):[];if(g=h=d=d||l,3!==d.nodeType&&8!==d.nodeType&&!X.test(q+n.event.triggered)&&(q.indexOf(".")>=0&&(r=q.split("."),q=r.shift(),r.sort()),k=q.indexOf(":")<0&&"on"+q,b=b[n.expando]?b:new n.Event(q,"object"==typeof b&&b),b.isTrigger=e?2:3,b.namespace=r.join("."),b.namespace_re=b.namespace?new RegExp("(^|\\.)"+r.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,b.result=void 0,b.target||(b.target=d),c=null==c?[b]:n.makeArray(c,[b]),o=n.event.special[q]||{},e||!o.trigger||o.trigger.apply(d,c)!==!1)){if(!e&&!o.noBubble&&!n.isWindow(d)){for(i=o.delegateType||q,X.test(i+q)||(g=g.parentNode);g;g=g.parentNode)p.push(g),h=g;h===(d.ownerDocument||l)&&p.push(h.defaultView||h.parentWindow||a)}f=0;while((g=p[f++])&&!b.isPropagationStopped())b.type=f>1?i:o.bindType||q,m=(L.get(g,"events")||{})[b.type]&&L.get(g,"handle"),m&&m.apply(g,c),m=k&&g[k],m&&m.apply&&n.acceptData(g)&&(b.result=m.apply(g,c),b.result===!1&&b.preventDefault());return b.type=q,e||b.isDefaultPrevented()||o._default&&o._default.apply(p.pop(),c)!==!1||!n.acceptData(d)||k&&n.isFunction(d[q])&&!n.isWindow(d)&&(h=d[k],h&&(d[k]=null),n.event.triggered=q,d[q](),n.event.triggered=void 0,h&&(d[k]=h)),b.result}},dispatch:function(a){a=n.event.fix(a);var b,c,e,f,g,h=[],i=d.call(arguments),j=(L.get(this,"events")||{})[a.type]||[],k=n.event.special[a.type]||{};if(i[0]=a,a.delegateTarget=this,!k.preDispatch||k.preDispatch.call(this,a)!==!1){h=n.event.handlers.call(this,a,j),b=0;while((f=h[b++])&&!a.isPropagationStopped()){a.currentTarget=f.elem,c=0;while((g=f.handlers[c++])&&!a.isImmediatePropagationStopped())(!a.namespace_re||a.namespace_re.test(g.namespace))&&(a.handleObj=g,a.data=g.data,e=((n.event.special[g.origType]||{}).handle||g.handler).apply(f.elem,i),void 0!==e&&(a.result=e)===!1&&(a.preventDefault(),a.stopPropagation()))}return k.postDispatch&&k.postDispatch.call(this,a),a.result}},handlers:function(a,b){var c,d,e,f,g=[],h=b.delegateCount,i=a.target;if(h&&i.nodeType&&(!a.button||"click"!==a.type))for(;i!==this;i=i.parentNode||this)if(i.disabled!==!0||"click"!==a.type){for(d=[],c=0;h>c;c++)f=b[c],e=f.selector+" ",void 0===d[e]&&(d[e]=f.needsContext?n(e,this).index(i)>=0:n.find(e,this,null,[i]).length),d[e]&&d.push(f);d.length&&g.push({elem:i,handlers:d})}return h<b.length&&g.push({elem:this,handlers:b.slice(h)}),g},props:"altKey bubbles cancelable ctrlKey currentTarget eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "),fixHooks:{},keyHooks:{props:"char charCode key keyCode".split(" "),filter:function(a,b){return null==a.which&&(a.which=null!=b.charCode?b.charCode:b.keyCode),a}},mouseHooks:{props:"button buttons clientX clientY offsetX offsetY pageX pageY screenX screenY toElement".split(" "),filter:function(a,b){var c,d,e,f=b.button;return null==a.pageX&&null!=b.clientX&&(c=a.target.ownerDocument||l,d=c.documentElement,e=c.body,a.pageX=b.clientX+(d&&d.scrollLeft||e&&e.scrollLeft||0)-(d&&d.clientLeft||e&&e.clientLeft||0),a.pageY=b.clientY+(d&&d.scrollTop||e&&e.scrollTop||0)-(d&&d.clientTop||e&&e.clientTop||0)),a.which||void 0===f||(a.which=1&f?1:2&f?3:4&f?2:0),a}},fix:function(a){if(a[n.expando])return a;var b,c,d,e=a.type,f=a,g=this.fixHooks[e];g||(this.fixHooks[e]=g=W.test(e)?this.mouseHooks:V.test(e)?this.keyHooks:{}),d=g.props?this.props.concat(g.props):this.props,a=new n.Event(f),b=d.length;while(b--)c=d[b],a[c]=f[c];return a.target||(a.target=l),3===a.target.nodeType&&(a.target=a.target.parentNode),g.filter?g.filter(a,f):a},special:{load:{noBubble:!0},focus:{trigger:function(){return this!==_()&&this.focus?(this.focus(),!1):void 0},delegateType:"focusin"},blur:{trigger:function(){return this===_()&&this.blur?(this.blur(),!1):void 0},delegateType:"focusout"},click:{trigger:function(){return"checkbox"===this.type&&this.click&&n.nodeName(this,"input")?(this.click(),!1):void 0},_default:function(a){return n.nodeName(a.target,"a")}},beforeunload:{postDispatch:function(a){void 0!==a.result&&a.originalEvent&&(a.originalEvent.returnValue=a.result)}}},simulate:function(a,b,c,d){var e=n.extend(new n.Event,c,{type:a,isSimulated:!0,originalEvent:{}});d?n.event.trigger(e,null,b):n.event.dispatch.call(b,e),e.isDefaultPrevented()&&c.preventDefault()}},n.removeEvent=function(a,b,c){a.removeEventListener&&a.removeEventListener(b,c,!1)},n.Event=function(a,b){return this instanceof n.Event?(a&&a.type?(this.originalEvent=a,this.type=a.type,this.isDefaultPrevented=a.defaultPrevented||void 0===a.defaultPrevented&&a.returnValue===!1?Z:$):this.type=a,b&&n.extend(this,b),this.timeStamp=a&&a.timeStamp||n.now(),void(this[n.expando]=!0)):new n.Event(a,b)},n.Event.prototype={isDefaultPrevented:$,isPropagationStopped:$,isImmediatePropagationStopped:$,preventDefault:function(){var a=this.originalEvent;this.isDefaultPrevented=Z,a&&a.preventDefault&&a.preventDefault()},stopPropagation:function(){var a=this.originalEvent;this.isPropagationStopped=Z,a&&a.stopPropagation&&a.stopPropagation()},stopImmediatePropagation:function(){var a=this.originalEvent;this.isImmediatePropagationStopped=Z,a&&a.stopImmediatePropagation&&a.stopImmediatePropagation(),this.stopPropagation()}},n.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(a,b){n.event.special[a]={delegateType:b,bindType:b,handle:function(a){var c,d=this,e=a.relatedTarget,f=a.handleObj;return(!e||e!==d&&!n.contains(d,e))&&(a.type=f.origType,c=f.handler.apply(this,arguments),a.type=b),c}}}),k.focusinBubbles||n.each({focus:"focusin",blur:"focusout"},function(a,b){var c=function(a){n.event.simulate(b,a.target,n.event.fix(a),!0)};n.event.special[b]={setup:function(){var d=this.ownerDocument||this,e=L.access(d,b);e||d.addEventListener(a,c,!0),L.access(d,b,(e||0)+1)},teardown:function(){var d=this.ownerDocument||this,e=L.access(d,b)-1;e?L.access(d,b,e):(d.removeEventListener(a,c,!0),L.remove(d,b))}}}),n.fn.extend({on:function(a,b,c,d,e){var f,g;if("object"==typeof a){"string"!=typeof b&&(c=c||b,b=void 0);for(g in a)this.on(g,b,c,a[g],e);return this}if(null==c&&null==d?(d=b,c=b=void 0):null==d&&("string"==typeof b?(d=c,c=void 0):(d=c,c=b,b=void 0)),d===!1)d=$;else if(!d)return this;return 1===e&&(f=d,d=function(a){return n().off(a),f.apply(this,arguments)},d.guid=f.guid||(f.guid=n.guid++)),this.each(function(){n.event.add(this,a,d,c,b)})},one:function(a,b,c,d){return this.on(a,b,c,d,1)},off:function(a,b,c){var d,e;if(a&&a.preventDefault&&a.handleObj)return d=a.handleObj,n(a.delegateTarget).off(d.namespace?d.origType+"."+d.namespace:d.origType,d.selector,d.handler),this;if("object"==typeof a){for(e in a)this.off(e,b,a[e]);return this}return(b===!1||"function"==typeof b)&&(c=b,b=void 0),c===!1&&(c=$),this.each(function(){n.event.remove(this,a,c,b)})},trigger:function(a,b){return this.each(function(){n.event.trigger(a,b,this)})},triggerHandler:function(a,b){var c=this[0];return c?n.event.trigger(a,b,c,!0):void 0}});var ab=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi,bb=/<([\w:]+)/,cb=/<|&#?\w+;/,db=/<(?:script|style|link)/i,eb=/checked\s*(?:[^=]|=\s*.checked.)/i,fb=/^$|\/(?:java|ecma)script/i,gb=/^true\/(.*)/,hb=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g,ib={option:[1,"<select multiple='multiple'>","</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};ib.optgroup=ib.option,ib.tbody=ib.tfoot=ib.colgroup=ib.caption=ib.thead,ib.th=ib.td;function jb(a,b){return n.nodeName(a,"table")&&n.nodeName(11!==b.nodeType?b:b.firstChild,"tr")?a.getElementsByTagName("tbody")[0]||a.appendChild(a.ownerDocument.createElement("tbody")):a}function kb(a){return a.type=(null!==a.getAttribute("type"))+"/"+a.type,a}function lb(a){var b=gb.exec(a.type);return b?a.type=b[1]:a.removeAttribute("type"),a}function mb(a,b){for(var c=0,d=a.length;d>c;c++)L.set(a[c],"globalEval",!b||L.get(b[c],"globalEval"))}function nb(a,b){var c,d,e,f,g,h,i,j;if(1===b.nodeType){if(L.hasData(a)&&(f=L.access(a),g=L.set(b,f),j=f.events)){delete g.handle,g.events={};for(e in j)for(c=0,d=j[e].length;d>c;c++)n.event.add(b,e,j[e][c])}M.hasData(a)&&(h=M.access(a),i=n.extend({},h),M.set(b,i))}}function ob(a,b){var c=a.getElementsByTagName?a.getElementsByTagName(b||"*"):a.querySelectorAll?a.querySelectorAll(b||"*"):[];return void 0===b||b&&n.nodeName(a,b)?n.merge([a],c):c}function pb(a,b){var c=b.nodeName.toLowerCase();"input"===c&&T.test(a.type)?b.checked=a.checked:("input"===c||"textarea"===c)&&(b.defaultValue=a.defaultValue)}n.extend({clone:function(a,b,c){var d,e,f,g,h=a.cloneNode(!0),i=n.contains(a.ownerDocument,a);if(!(k.noCloneChecked||1!==a.nodeType&&11!==a.nodeType||n.isXMLDoc(a)))for(g=ob(h),f=ob(a),d=0,e=f.length;e>d;d++)pb(f[d],g[d]);if(b)if(c)for(f=f||ob(a),g=g||ob(h),d=0,e=f.length;e>d;d++)nb(f[d],g[d]);else nb(a,h);return g=ob(h,"script"),g.length>0&&mb(g,!i&&ob(a,"script")),h},buildFragment:function(a,b,c,d){for(var e,f,g,h,i,j,k=b.createDocumentFragment(),l=[],m=0,o=a.length;o>m;m++)if(e=a[m],e||0===e)if("object"===n.type(e))n.merge(l,e.nodeType?[e]:e);else if(cb.test(e)){f=f||k.appendChild(b.createElement("div")),g=(bb.exec(e)||["",""])[1].toLowerCase(),h=ib[g]||ib._default,f.innerHTML=h[1]+e.replace(ab,"<$1></$2>")+h[2],j=h[0];while(j--)f=f.lastChild;n.merge(l,f.childNodes),f=k.firstChild,f.textContent=""}else l.push(b.createTextNode(e));k.textContent="",m=0;while(e=l[m++])if((!d||-1===n.inArray(e,d))&&(i=n.contains(e.ownerDocument,e),f=ob(k.appendChild(e),"script"),i&&mb(f),c)){j=0;while(e=f[j++])fb.test(e.type||"")&&c.push(e)}return k},cleanData:function(a){for(var b,c,d,e,f=n.event.special,g=0;void 0!==(c=a[g]);g++){if(n.acceptData(c)&&(e=c[L.expando],e&&(b=L.cache[e]))){if(b.events)for(d in b.events)f[d]?n.event.remove(c,d):n.removeEvent(c,d,b.handle);L.cache[e]&&delete L.cache[e]}delete M.cache[c[M.expando]]}}}),n.fn.extend({text:function(a){return J(this,function(a){return void 0===a?n.text(this):this.empty().each(function(){(1===this.nodeType||11===this.nodeType||9===this.nodeType)&&(this.textContent=a)})},null,a,arguments.length)},append:function(){return this.domManip(arguments,function(a){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var b=jb(this,a);b.appendChild(a)}})},prepend:function(){return this.domManip(arguments,function(a){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var b=jb(this,a);b.insertBefore(a,b.firstChild)}})},before:function(){return this.domManip(arguments,function(a){this.parentNode&&this.parentNode.insertBefore(a,this)})},after:function(){return this.domManip(arguments,function(a){this.parentNode&&this.parentNode.insertBefore(a,this.nextSibling)})},remove:function(a,b){for(var c,d=a?n.filter(a,this):this,e=0;null!=(c=d[e]);e++)b||1!==c.nodeType||n.cleanData(ob(c)),c.parentNode&&(b&&n.contains(c.ownerDocument,c)&&mb(ob(c,"script")),c.parentNode.removeChild(c));return this},empty:function(){for(var a,b=0;null!=(a=this[b]);b++)1===a.nodeType&&(n.cleanData(ob(a,!1)),a.textContent="");return this},clone:function(a,b){return a=null==a?!1:a,b=null==b?a:b,this.map(function(){return n.clone(this,a,b)})},html:function(a){return J(this,function(a){var b=this[0]||{},c=0,d=this.length;if(void 0===a&&1===b.nodeType)return b.innerHTML;if("string"==typeof a&&!db.test(a)&&!ib[(bb.exec(a)||["",""])[1].toLowerCase()]){a=a.replace(ab,"<$1></$2>");try{for(;d>c;c++)b=this[c]||{},1===b.nodeType&&(n.cleanData(ob(b,!1)),b.innerHTML=a);b=0}catch(e){}}b&&this.empty().append(a)},null,a,arguments.length)},replaceWith:function(){var a=arguments[0];return this.domManip(arguments,function(b){a=this.parentNode,n.cleanData(ob(this)),a&&a.replaceChild(b,this)}),a&&(a.length||a.nodeType)?this:this.remove()},detach:function(a){return this.remove(a,!0)},domManip:function(a,b){a=e.apply([],a);var c,d,f,g,h,i,j=0,l=this.length,m=this,o=l-1,p=a[0],q=n.isFunction(p);if(q||l>1&&"string"==typeof p&&!k.checkClone&&eb.test(p))return this.each(function(c){var d=m.eq(c);q&&(a[0]=p.call(this,c,d.html())),d.domManip(a,b)});if(l&&(c=n.buildFragment(a,this[0].ownerDocument,!1,this),d=c.firstChild,1===c.childNodes.length&&(c=d),d)){for(f=n.map(ob(c,"script"),kb),g=f.length;l>j;j++)h=c,j!==o&&(h=n.clone(h,!0,!0),g&&n.merge(f,ob(h,"script"))),b.call(this[j],h,j);if(g)for(i=f[f.length-1].ownerDocument,n.map(f,lb),j=0;g>j;j++)h=f[j],fb.test(h.type||"")&&!L.access(h,"globalEval")&&n.contains(i,h)&&(h.src?n._evalUrl&&n._evalUrl(h.src):n.globalEval(h.textContent.replace(hb,"")))}return this}}),n.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(a,b){n.fn[a]=function(a){for(var c,d=[],e=n(a),g=e.length-1,h=0;g>=h;h++)c=h===g?this:this.clone(!0),n(e[h])[b](c),f.apply(d,c.get());return this.pushStack(d)}});var qb,rb={};function sb(b,c){var d,e=n(c.createElement(b)).appendTo(c.body),f=a.getDefaultComputedStyle&&(d=a.getDefaultComputedStyle(e[0]))?d.display:n.css(e[0],"display");return e.detach(),f}function tb(a){var b=l,c=rb[a];return c||(c=sb(a,b),"none"!==c&&c||(qb=(qb||n("<iframe frameborder='0' width='0' height='0'/>")).appendTo(b.documentElement),b=qb[0].contentDocument,b.write(),b.close(),c=sb(a,b),qb.detach()),rb[a]=c),c}var ub=/^margin/,vb=new RegExp("^("+Q+")(?!px)[a-z%]+$","i"),wb=function(a){return a.ownerDocument.defaultView.getComputedStyle(a,null)};function xb(a,b,c){var d,e,f,g,h=a.style;return c=c||wb(a),c&&(g=c.getPropertyValue(b)||c[b]),c&&(""!==g||n.contains(a.ownerDocument,a)||(g=n.style(a,b)),vb.test(g)&&ub.test(b)&&(d=h.width,e=h.minWidth,f=h.maxWidth,h.minWidth=h.maxWidth=h.width=g,g=c.width,h.width=d,h.minWidth=e,h.maxWidth=f)),void 0!==g?g+"":g}function yb(a,b){return{get:function(){return a()?void delete this.get:(this.get=b).apply(this,arguments)}}}!function(){var b,c,d=l.documentElement,e=l.createElement("div"),f=l.createElement("div");if(f.style){f.style.backgroundClip="content-box",f.cloneNode(!0).style.backgroundClip="",k.clearCloneStyle="content-box"===f.style.backgroundClip,e.style.cssText="border:0;width:0;height:0;top:0;left:-9999px;margin-top:1px;position:absolute",e.appendChild(f);function g(){f.style.cssText="-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box;display:block;margin-top:1%;top:1%;border:1px;padding:1px;width:4px;position:absolute",f.innerHTML="",d.appendChild(e);var g=a.getComputedStyle(f,null);b="1%"!==g.top,c="4px"===g.width,d.removeChild(e)}a.getComputedStyle&&n.extend(k,{pixelPosition:function(){return g(),b},boxSizingReliable:function(){return null==c&&g(),c},reliableMarginRight:function(){var b,c=f.appendChild(l.createElement("div"));return c.style.cssText=f.style.cssText="-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;display:block;margin:0;border:0;padding:0",c.style.marginRight=c.style.width="0",f.style.width="1px",d.appendChild(e),b=!parseFloat(a.getComputedStyle(c,null).marginRight),d.removeChild(e),b}})}}(),n.swap=function(a,b,c,d){var e,f,g={};for(f in b)g[f]=a.style[f],a.style[f]=b[f];e=c.apply(a,d||[]);for(f in b)a.style[f]=g[f];return e};var zb=/^(none|table(?!-c[ea]).+)/,Ab=new RegExp("^("+Q+")(.*)$","i"),Bb=new RegExp("^([+-])=("+Q+")","i"),Cb={position:"absolute",visibility:"hidden",display:"block"},Db={letterSpacing:"0",fontWeight:"400"},Eb=["Webkit","O","Moz","ms"];function Fb(a,b){if(b in a)return b;var c=b[0].toUpperCase()+b.slice(1),d=b,e=Eb.length;while(e--)if(b=Eb[e]+c,b in a)return b;return d}function Gb(a,b,c){var d=Ab.exec(b);return d?Math.max(0,d[1]-(c||0))+(d[2]||"px"):b}function Hb(a,b,c,d,e){for(var f=c===(d?"border":"content")?4:"width"===b?1:0,g=0;4>f;f+=2)"margin"===c&&(g+=n.css(a,c+R[f],!0,e)),d?("content"===c&&(g-=n.css(a,"padding"+R[f],!0,e)),"margin"!==c&&(g-=n.css(a,"border"+R[f]+"Width",!0,e))):(g+=n.css(a,"padding"+R[f],!0,e),"padding"!==c&&(g+=n.css(a,"border"+R[f]+"Width",!0,e)));return g}function Ib(a,b,c){var d=!0,e="width"===b?a.offsetWidth:a.offsetHeight,f=wb(a),g="border-box"===n.css(a,"boxSizing",!1,f);if(0>=e||null==e){if(e=xb(a,b,f),(0>e||null==e)&&(e=a.style[b]),vb.test(e))return e;d=g&&(k.boxSizingReliable()||e===a.style[b]),e=parseFloat(e)||0}return e+Hb(a,b,c||(g?"border":"content"),d,f)+"px"}function Jb(a,b){for(var c,d,e,f=[],g=0,h=a.length;h>g;g++)d=a[g],d.style&&(f[g]=L.get(d,"olddisplay"),c=d.style.display,b?(f[g]||"none"!==c||(d.style.display=""),""===d.style.display&&S(d)&&(f[g]=L.access(d,"olddisplay",tb(d.nodeName)))):(e=S(d),"none"===c&&e||L.set(d,"olddisplay",e?c:n.css(d,"display"))));for(g=0;h>g;g++)d=a[g],d.style&&(b&&"none"!==d.style.display&&""!==d.style.display||(d.style.display=b?f[g]||"":"none"));return a}n.extend({cssHooks:{opacity:{get:function(a,b){if(b){var c=xb(a,"opacity");return""===c?"1":c}}}},cssNumber:{columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{"float":"cssFloat"},style:function(a,b,c,d){if(a&&3!==a.nodeType&&8!==a.nodeType&&a.style){var e,f,g,h=n.camelCase(b),i=a.style;return b=n.cssProps[h]||(n.cssProps[h]=Fb(i,h)),g=n.cssHooks[b]||n.cssHooks[h],void 0===c?g&&"get"in g&&void 0!==(e=g.get(a,!1,d))?e:i[b]:(f=typeof c,"string"===f&&(e=Bb.exec(c))&&(c=(e[1]+1)*e[2]+parseFloat(n.css(a,b)),f="number"),null!=c&&c===c&&("number"!==f||n.cssNumber[h]||(c+="px"),k.clearCloneStyle||""!==c||0!==b.indexOf("background")||(i[b]="inherit"),g&&"set"in g&&void 0===(c=g.set(a,c,d))||(i[b]=c)),void 0)}},css:function(a,b,c,d){var e,f,g,h=n.camelCase(b);return b=n.cssProps[h]||(n.cssProps[h]=Fb(a.style,h)),g=n.cssHooks[b]||n.cssHooks[h],g&&"get"in g&&(e=g.get(a,!0,c)),void 0===e&&(e=xb(a,b,d)),"normal"===e&&b in Db&&(e=Db[b]),""===c||c?(f=parseFloat(e),c===!0||n.isNumeric(f)?f||0:e):e}}),n.each(["height","width"],function(a,b){n.cssHooks[b]={get:function(a,c,d){return c?zb.test(n.css(a,"display"))&&0===a.offsetWidth?n.swap(a,Cb,function(){return Ib(a,b,d)}):Ib(a,b,d):void 0},set:function(a,c,d){var e=d&&wb(a);return Gb(a,c,d?Hb(a,b,d,"border-box"===n.css(a,"boxSizing",!1,e),e):0)}}}),n.cssHooks.marginRight=yb(k.reliableMarginRight,function(a,b){return b?n.swap(a,{display:"inline-block"},xb,[a,"marginRight"]):void 0}),n.each({margin:"",padding:"",border:"Width"},function(a,b){n.cssHooks[a+b]={expand:function(c){for(var d=0,e={},f="string"==typeof c?c.split(" "):[c];4>d;d++)e[a+R[d]+b]=f[d]||f[d-2]||f[0];return e}},ub.test(a)||(n.cssHooks[a+b].set=Gb)}),n.fn.extend({css:function(a,b){return J(this,function(a,b,c){var d,e,f={},g=0;if(n.isArray(b)){for(d=wb(a),e=b.length;e>g;g++)f[b[g]]=n.css(a,b[g],!1,d);return f}return void 0!==c?n.style(a,b,c):n.css(a,b)},a,b,arguments.length>1)},show:function(){return Jb(this,!0)},hide:function(){return Jb(this)},toggle:function(a){return"boolean"==typeof a?a?this.show():this.hide():this.each(function(){S(this)?n(this).show():n(this).hide()})}});function Kb(a,b,c,d,e){return new Kb.prototype.init(a,b,c,d,e)}n.Tween=Kb,Kb.prototype={constructor:Kb,init:function(a,b,c,d,e,f){this.elem=a,this.prop=c,this.easing=e||"swing",this.options=b,this.start=this.now=this.cur(),this.end=d,this.unit=f||(n.cssNumber[c]?"":"px")},cur:function(){var a=Kb.propHooks[this.prop];return a&&a.get?a.get(this):Kb.propHooks._default.get(this)},run:function(a){var b,c=Kb.propHooks[this.prop];return this.pos=b=this.options.duration?n.easing[this.easing](a,this.options.duration*a,0,1,this.options.duration):a,this.now=(this.end-this.start)*b+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),c&&c.set?c.set(this):Kb.propHooks._default.set(this),this}},Kb.prototype.init.prototype=Kb.prototype,Kb.propHooks={_default:{get:function(a){var b;return null==a.elem[a.prop]||a.elem.style&&null!=a.elem.style[a.prop]?(b=n.css(a.elem,a.prop,""),b&&"auto"!==b?b:0):a.elem[a.prop]},set:function(a){n.fx.step[a.prop]?n.fx.step[a.prop](a):a.elem.style&&(null!=a.elem.style[n.cssProps[a.prop]]||n.cssHooks[a.prop])?n.style(a.elem,a.prop,a.now+a.unit):a.elem[a.prop]=a.now}}},Kb.propHooks.scrollTop=Kb.propHooks.scrollLeft={set:function(a){a.elem.nodeType&&a.elem.parentNode&&(a.elem[a.prop]=a.now)}},n.easing={linear:function(a){return a},swing:function(a){return.5-Math.cos(a*Math.PI)/2}},n.fx=Kb.prototype.init,n.fx.step={};var Lb,Mb,Nb=/^(?:toggle|show|hide)$/,Ob=new RegExp("^(?:([+-])=|)("+Q+")([a-z%]*)$","i"),Pb=/queueHooks$/,Qb=[Vb],Rb={"*":[function(a,b){var c=this.createTween(a,b),d=c.cur(),e=Ob.exec(b),f=e&&e[3]||(n.cssNumber[a]?"":"px"),g=(n.cssNumber[a]||"px"!==f&&+d)&&Ob.exec(n.css(c.elem,a)),h=1,i=20;if(g&&g[3]!==f){f=f||g[3],e=e||[],g=+d||1;do h=h||".5",g/=h,n.style(c.elem,a,g+f);while(h!==(h=c.cur()/d)&&1!==h&&--i)}return e&&(g=c.start=+g||+d||0,c.unit=f,c.end=e[1]?g+(e[1]+1)*e[2]:+e[2]),c}]};function Sb(){return setTimeout(function(){Lb=void 0}),Lb=n.now()}function Tb(a,b){var c,d=0,e={height:a};for(b=b?1:0;4>d;d+=2-b)c=R[d],e["margin"+c]=e["padding"+c]=a;return b&&(e.opacity=e.width=a),e}function Ub(a,b,c){for(var d,e=(Rb[b]||[]).concat(Rb["*"]),f=0,g=e.length;g>f;f++)if(d=e[f].call(c,b,a))return d}function Vb(a,b,c){var d,e,f,g,h,i,j,k,l=this,m={},o=a.style,p=a.nodeType&&S(a),q=L.get(a,"fxshow");c.queue||(h=n._queueHooks(a,"fx"),null==h.unqueued&&(h.unqueued=0,i=h.empty.fire,h.empty.fire=function(){h.unqueued||i()}),h.unqueued++,l.always(function(){l.always(function(){h.unqueued--,n.queue(a,"fx").length||h.empty.fire()})})),1===a.nodeType&&("height"in b||"width"in b)&&(c.overflow=[o.overflow,o.overflowX,o.overflowY],j=n.css(a,"display"),k="none"===j?L.get(a,"olddisplay")||tb(a.nodeName):j,"inline"===k&&"none"===n.css(a,"float")&&(o.display="inline-block")),c.overflow&&(o.overflow="hidden",l.always(function(){o.overflow=c.overflow[0],o.overflowX=c.overflow[1],o.overflowY=c.overflow[2]}));for(d in b)if(e=b[d],Nb.exec(e)){if(delete b[d],f=f||"toggle"===e,e===(p?"hide":"show")){if("show"!==e||!q||void 0===q[d])continue;p=!0}m[d]=q&&q[d]||n.style(a,d)}else j=void 0;if(n.isEmptyObject(m))"inline"===("none"===j?tb(a.nodeName):j)&&(o.display=j);else{q?"hidden"in q&&(p=q.hidden):q=L.access(a,"fxshow",{}),f&&(q.hidden=!p),p?n(a).show():l.done(function(){n(a).hide()}),l.done(function(){var b;L.remove(a,"fxshow");for(b in m)n.style(a,b,m[b])});for(d in m)g=Ub(p?q[d]:0,d,l),d in q||(q[d]=g.start,p&&(g.end=g.start,g.start="width"===d||"height"===d?1:0))}}function Wb(a,b){var c,d,e,f,g;for(c in a)if(d=n.camelCase(c),e=b[d],f=a[c],n.isArray(f)&&(e=f[1],f=a[c]=f[0]),c!==d&&(a[d]=f,delete a[c]),g=n.cssHooks[d],g&&"expand"in g){f=g.expand(f),delete a[d];for(c in f)c in a||(a[c]=f[c],b[c]=e)}else b[d]=e}function Xb(a,b,c){var d,e,f=0,g=Qb.length,h=n.Deferred().always(function(){delete i.elem}),i=function(){if(e)return!1;for(var b=Lb||Sb(),c=Math.max(0,j.startTime+j.duration-b),d=c/j.duration||0,f=1-d,g=0,i=j.tweens.length;i>g;g++)j.tweens[g].run(f);return h.notifyWith(a,[j,f,c]),1>f&&i?c:(h.resolveWith(a,[j]),!1)},j=h.promise({elem:a,props:n.extend({},b),opts:n.extend(!0,{specialEasing:{}},c),originalProperties:b,originalOptions:c,startTime:Lb||Sb(),duration:c.duration,tweens:[],createTween:function(b,c){var d=n.Tween(a,j.opts,b,c,j.opts.specialEasing[b]||j.opts.easing);return j.tweens.push(d),d},stop:function(b){var c=0,d=b?j.tweens.length:0;if(e)return this;for(e=!0;d>c;c++)j.tweens[c].run(1);return b?h.resolveWith(a,[j,b]):h.rejectWith(a,[j,b]),this}}),k=j.props;for(Wb(k,j.opts.specialEasing);g>f;f++)if(d=Qb[f].call(j,a,k,j.opts))return d;return n.map(k,Ub,j),n.isFunction(j.opts.start)&&j.opts.start.call(a,j),n.fx.timer(n.extend(i,{elem:a,anim:j,queue:j.opts.queue})),j.progress(j.opts.progress).done(j.opts.done,j.opts.complete).fail(j.opts.fail).always(j.opts.always)}n.Animation=n.extend(Xb,{tweener:function(a,b){n.isFunction(a)?(b=a,a=["*"]):a=a.split(" ");for(var c,d=0,e=a.length;e>d;d++)c=a[d],Rb[c]=Rb[c]||[],Rb[c].unshift(b)},prefilter:function(a,b){b?Qb.unshift(a):Qb.push(a)}}),n.speed=function(a,b,c){var d=a&&"object"==typeof a?n.extend({},a):{complete:c||!c&&b||n.isFunction(a)&&a,duration:a,easing:c&&b||b&&!n.isFunction(b)&&b};return d.duration=n.fx.off?0:"number"==typeof d.duration?d.duration:d.duration in n.fx.speeds?n.fx.speeds[d.duration]:n.fx.speeds._default,(null==d.queue||d.queue===!0)&&(d.queue="fx"),d.old=d.complete,d.complete=function(){n.isFunction(d.old)&&d.old.call(this),d.queue&&n.dequeue(this,d.queue)},d},n.fn.extend({fadeTo:function(a,b,c,d){return this.filter(S).css("opacity",0).show().end().animate({opacity:b},a,c,d)},animate:function(a,b,c,d){var e=n.isEmptyObject(a),f=n.speed(b,c,d),g=function(){var b=Xb(this,n.extend({},a),f);(e||L.get(this,"finish"))&&b.stop(!0)};return g.finish=g,e||f.queue===!1?this.each(g):this.queue(f.queue,g)},stop:function(a,b,c){var d=function(a){var b=a.stop;delete a.stop,b(c)};return"string"!=typeof a&&(c=b,b=a,a=void 0),b&&a!==!1&&this.queue(a||"fx",[]),this.each(function(){var b=!0,e=null!=a&&a+"queueHooks",f=n.timers,g=L.get(this);if(e)g[e]&&g[e].stop&&d(g[e]);else for(e in g)g[e]&&g[e].stop&&Pb.test(e)&&d(g[e]);for(e=f.length;e--;)f[e].elem!==this||null!=a&&f[e].queue!==a||(f[e].anim.stop(c),b=!1,f.splice(e,1));(b||!c)&&n.dequeue(this,a)})},finish:function(a){return a!==!1&&(a=a||"fx"),this.each(function(){var b,c=L.get(this),d=c[a+"queue"],e=c[a+"queueHooks"],f=n.timers,g=d?d.length:0;for(c.finish=!0,n.queue(this,a,[]),e&&e.stop&&e.stop.call(this,!0),b=f.length;b--;)f[b].elem===this&&f[b].queue===a&&(f[b].anim.stop(!0),f.splice(b,1));for(b=0;g>b;b++)d[b]&&d[b].finish&&d[b].finish.call(this);delete c.finish})}}),n.each(["toggle","show","hide"],function(a,b){var c=n.fn[b];n.fn[b]=function(a,d,e){return null==a||"boolean"==typeof a?c.apply(this,arguments):this.animate(Tb(b,!0),a,d,e)}}),n.each({slideDown:Tb("show"),slideUp:Tb("hide"),slideToggle:Tb("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(a,b){n.fn[a]=function(a,c,d){return this.animate(b,a,c,d)}}),n.timers=[],n.fx.tick=function(){var a,b=0,c=n.timers;for(Lb=n.now();b<c.length;b++)a=c[b],a()||c[b]!==a||c.splice(b--,1);c.length||n.fx.stop(),Lb=void 0},n.fx.timer=function(a){n.timers.push(a),a()?n.fx.start():n.timers.pop()},n.fx.interval=13,n.fx.start=function(){Mb||(Mb=setInterval(n.fx.tick,n.fx.interval))},n.fx.stop=function(){clearInterval(Mb),Mb=null},n.fx.speeds={slow:600,fast:200,_default:400},n.fn.delay=function(a,b){return a=n.fx?n.fx.speeds[a]||a:a,b=b||"fx",this.queue(b,function(b,c){var d=setTimeout(b,a);c.stop=function(){clearTimeout(d)}})},function(){var a=l.createElement("input"),b=l.createElement("select"),c=b.appendChild(l.createElement("option"));a.type="checkbox",k.checkOn=""!==a.value,k.optSelected=c.selected,b.disabled=!0,k.optDisabled=!c.disabled,a=l.createElement("input"),a.value="t",a.type="radio",k.radioValue="t"===a.value}();var Yb,Zb,$b=n.expr.attrHandle;n.fn.extend({attr:function(a,b){return J(this,n.attr,a,b,arguments.length>1)},removeAttr:function(a){return this.each(function(){n.removeAttr(this,a)})}}),n.extend({attr:function(a,b,c){var d,e,f=a.nodeType;if(a&&3!==f&&8!==f&&2!==f)return typeof a.getAttribute===U?n.prop(a,b,c):(1===f&&n.isXMLDoc(a)||(b=b.toLowerCase(),d=n.attrHooks[b]||(n.expr.match.bool.test(b)?Zb:Yb)),void 0===c?d&&"get"in d&&null!==(e=d.get(a,b))?e:(e=n.find.attr(a,b),null==e?void 0:e):null!==c?d&&"set"in d&&void 0!==(e=d.set(a,c,b))?e:(a.setAttribute(b,c+""),c):void n.removeAttr(a,b))
},removeAttr:function(a,b){var c,d,e=0,f=b&&b.match(E);if(f&&1===a.nodeType)while(c=f[e++])d=n.propFix[c]||c,n.expr.match.bool.test(c)&&(a[d]=!1),a.removeAttribute(c)},attrHooks:{type:{set:function(a,b){if(!k.radioValue&&"radio"===b&&n.nodeName(a,"input")){var c=a.value;return a.setAttribute("type",b),c&&(a.value=c),b}}}}}),Zb={set:function(a,b,c){return b===!1?n.removeAttr(a,c):a.setAttribute(c,c),c}},n.each(n.expr.match.bool.source.match(/\w+/g),function(a,b){var c=$b[b]||n.find.attr;$b[b]=function(a,b,d){var e,f;return d||(f=$b[b],$b[b]=e,e=null!=c(a,b,d)?b.toLowerCase():null,$b[b]=f),e}});var _b=/^(?:input|select|textarea|button)$/i;n.fn.extend({prop:function(a,b){return J(this,n.prop,a,b,arguments.length>1)},removeProp:function(a){return this.each(function(){delete this[n.propFix[a]||a]})}}),n.extend({propFix:{"for":"htmlFor","class":"className"},prop:function(a,b,c){var d,e,f,g=a.nodeType;if(a&&3!==g&&8!==g&&2!==g)return f=1!==g||!n.isXMLDoc(a),f&&(b=n.propFix[b]||b,e=n.propHooks[b]),void 0!==c?e&&"set"in e&&void 0!==(d=e.set(a,c,b))?d:a[b]=c:e&&"get"in e&&null!==(d=e.get(a,b))?d:a[b]},propHooks:{tabIndex:{get:function(a){return a.hasAttribute("tabindex")||_b.test(a.nodeName)||a.href?a.tabIndex:-1}}}}),k.optSelected||(n.propHooks.selected={get:function(a){var b=a.parentNode;return b&&b.parentNode&&b.parentNode.selectedIndex,null}}),n.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){n.propFix[this.toLowerCase()]=this});var ac=/[\t\r\n\f]/g;n.fn.extend({addClass:function(a){var b,c,d,e,f,g,h="string"==typeof a&&a,i=0,j=this.length;if(n.isFunction(a))return this.each(function(b){n(this).addClass(a.call(this,b,this.className))});if(h)for(b=(a||"").match(E)||[];j>i;i++)if(c=this[i],d=1===c.nodeType&&(c.className?(" "+c.className+" ").replace(ac," "):" ")){f=0;while(e=b[f++])d.indexOf(" "+e+" ")<0&&(d+=e+" ");g=n.trim(d),c.className!==g&&(c.className=g)}return this},removeClass:function(a){var b,c,d,e,f,g,h=0===arguments.length||"string"==typeof a&&a,i=0,j=this.length;if(n.isFunction(a))return this.each(function(b){n(this).removeClass(a.call(this,b,this.className))});if(h)for(b=(a||"").match(E)||[];j>i;i++)if(c=this[i],d=1===c.nodeType&&(c.className?(" "+c.className+" ").replace(ac," "):"")){f=0;while(e=b[f++])while(d.indexOf(" "+e+" ")>=0)d=d.replace(" "+e+" "," ");g=a?n.trim(d):"",c.className!==g&&(c.className=g)}return this},toggleClass:function(a,b){var c=typeof a;return"boolean"==typeof b&&"string"===c?b?this.addClass(a):this.removeClass(a):this.each(n.isFunction(a)?function(c){n(this).toggleClass(a.call(this,c,this.className,b),b)}:function(){if("string"===c){var b,d=0,e=n(this),f=a.match(E)||[];while(b=f[d++])e.hasClass(b)?e.removeClass(b):e.addClass(b)}else(c===U||"boolean"===c)&&(this.className&&L.set(this,"__className__",this.className),this.className=this.className||a===!1?"":L.get(this,"__className__")||"")})},hasClass:function(a){for(var b=" "+a+" ",c=0,d=this.length;d>c;c++)if(1===this[c].nodeType&&(" "+this[c].className+" ").replace(ac," ").indexOf(b)>=0)return!0;return!1}});var bc=/\r/g;n.fn.extend({val:function(a){var b,c,d,e=this[0];{if(arguments.length)return d=n.isFunction(a),this.each(function(c){var e;1===this.nodeType&&(e=d?a.call(this,c,n(this).val()):a,null==e?e="":"number"==typeof e?e+="":n.isArray(e)&&(e=n.map(e,function(a){return null==a?"":a+""})),b=n.valHooks[this.type]||n.valHooks[this.nodeName.toLowerCase()],b&&"set"in b&&void 0!==b.set(this,e,"value")||(this.value=e))});if(e)return b=n.valHooks[e.type]||n.valHooks[e.nodeName.toLowerCase()],b&&"get"in b&&void 0!==(c=b.get(e,"value"))?c:(c=e.value,"string"==typeof c?c.replace(bc,""):null==c?"":c)}}}),n.extend({valHooks:{option:{get:function(a){var b=n.find.attr(a,"value");return null!=b?b:n.trim(n.text(a))}},select:{get:function(a){for(var b,c,d=a.options,e=a.selectedIndex,f="select-one"===a.type||0>e,g=f?null:[],h=f?e+1:d.length,i=0>e?h:f?e:0;h>i;i++)if(c=d[i],!(!c.selected&&i!==e||(k.optDisabled?c.disabled:null!==c.getAttribute("disabled"))||c.parentNode.disabled&&n.nodeName(c.parentNode,"optgroup"))){if(b=n(c).val(),f)return b;g.push(b)}return g},set:function(a,b){var c,d,e=a.options,f=n.makeArray(b),g=e.length;while(g--)d=e[g],(d.selected=n.inArray(d.value,f)>=0)&&(c=!0);return c||(a.selectedIndex=-1),f}}}}),n.each(["radio","checkbox"],function(){n.valHooks[this]={set:function(a,b){return n.isArray(b)?a.checked=n.inArray(n(a).val(),b)>=0:void 0}},k.checkOn||(n.valHooks[this].get=function(a){return null===a.getAttribute("value")?"on":a.value})}),n.each("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu".split(" "),function(a,b){n.fn[b]=function(a,c){return arguments.length>0?this.on(b,null,a,c):this.trigger(b)}}),n.fn.extend({hover:function(a,b){return this.mouseenter(a).mouseleave(b||a)},bind:function(a,b,c){return this.on(a,null,b,c)},unbind:function(a,b){return this.off(a,null,b)},delegate:function(a,b,c,d){return this.on(b,a,c,d)},undelegate:function(a,b,c){return 1===arguments.length?this.off(a,"**"):this.off(b,a||"**",c)}});var cc=n.now(),dc=/\?/;n.parseJSON=function(a){return JSON.parse(a+"")},n.parseXML=function(a){var b,c;if(!a||"string"!=typeof a)return null;try{c=new DOMParser,b=c.parseFromString(a,"text/xml")}catch(d){b=void 0}return(!b||b.getElementsByTagName("parsererror").length)&&n.error("Invalid XML: "+a),b};var ec,fc,gc=/#.*$/,hc=/([?&])_=[^&]*/,ic=/^(.*?):[ \t]*([^\r\n]*)$/gm,jc=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,kc=/^(?:GET|HEAD)$/,lc=/^\/\//,mc=/^([\w.+-]+:)(?:\/\/(?:[^\/?#]*@|)([^\/?#:]*)(?::(\d+)|)|)/,nc={},oc={},pc="*/".concat("*");try{fc=location.href}catch(qc){fc=l.createElement("a"),fc.href="",fc=fc.href}ec=mc.exec(fc.toLowerCase())||[];function rc(a){return function(b,c){"string"!=typeof b&&(c=b,b="*");var d,e=0,f=b.toLowerCase().match(E)||[];if(n.isFunction(c))while(d=f[e++])"+"===d[0]?(d=d.slice(1)||"*",(a[d]=a[d]||[]).unshift(c)):(a[d]=a[d]||[]).push(c)}}function sc(a,b,c,d){var e={},f=a===oc;function g(h){var i;return e[h]=!0,n.each(a[h]||[],function(a,h){var j=h(b,c,d);return"string"!=typeof j||f||e[j]?f?!(i=j):void 0:(b.dataTypes.unshift(j),g(j),!1)}),i}return g(b.dataTypes[0])||!e["*"]&&g("*")}function tc(a,b){var c,d,e=n.ajaxSettings.flatOptions||{};for(c in b)void 0!==b[c]&&((e[c]?a:d||(d={}))[c]=b[c]);return d&&n.extend(!0,a,d),a}function uc(a,b,c){var d,e,f,g,h=a.contents,i=a.dataTypes;while("*"===i[0])i.shift(),void 0===d&&(d=a.mimeType||b.getResponseHeader("Content-Type"));if(d)for(e in h)if(h[e]&&h[e].test(d)){i.unshift(e);break}if(i[0]in c)f=i[0];else{for(e in c){if(!i[0]||a.converters[e+" "+i[0]]){f=e;break}g||(g=e)}f=f||g}return f?(f!==i[0]&&i.unshift(f),c[f]):void 0}function vc(a,b,c,d){var e,f,g,h,i,j={},k=a.dataTypes.slice();if(k[1])for(g in a.converters)j[g.toLowerCase()]=a.converters[g];f=k.shift();while(f)if(a.responseFields[f]&&(c[a.responseFields[f]]=b),!i&&d&&a.dataFilter&&(b=a.dataFilter(b,a.dataType)),i=f,f=k.shift())if("*"===f)f=i;else if("*"!==i&&i!==f){if(g=j[i+" "+f]||j["* "+f],!g)for(e in j)if(h=e.split(" "),h[1]===f&&(g=j[i+" "+h[0]]||j["* "+h[0]])){g===!0?g=j[e]:j[e]!==!0&&(f=h[0],k.unshift(h[1]));break}if(g!==!0)if(g&&a["throws"])b=g(b);else try{b=g(b)}catch(l){return{state:"parsererror",error:g?l:"No conversion from "+i+" to "+f}}}return{state:"success",data:b}}n.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:fc,type:"GET",isLocal:jc.test(ec[1]),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":pc,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/xml/,html:/html/,json:/json/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":n.parseJSON,"text xml":n.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(a,b){return b?tc(tc(a,n.ajaxSettings),b):tc(n.ajaxSettings,a)},ajaxPrefilter:rc(nc),ajaxTransport:rc(oc),ajax:function(a,b){"object"==typeof a&&(b=a,a=void 0),b=b||{};var c,d,e,f,g,h,i,j,k=n.ajaxSetup({},b),l=k.context||k,m=k.context&&(l.nodeType||l.jquery)?n(l):n.event,o=n.Deferred(),p=n.Callbacks("once memory"),q=k.statusCode||{},r={},s={},t=0,u="canceled",v={readyState:0,getResponseHeader:function(a){var b;if(2===t){if(!f){f={};while(b=ic.exec(e))f[b[1].toLowerCase()]=b[2]}b=f[a.toLowerCase()]}return null==b?null:b},getAllResponseHeaders:function(){return 2===t?e:null},setRequestHeader:function(a,b){var c=a.toLowerCase();return t||(a=s[c]=s[c]||a,r[a]=b),this},overrideMimeType:function(a){return t||(k.mimeType=a),this},statusCode:function(a){var b;if(a)if(2>t)for(b in a)q[b]=[q[b],a[b]];else v.always(a[v.status]);return this},abort:function(a){var b=a||u;return c&&c.abort(b),x(0,b),this}};if(o.promise(v).complete=p.add,v.success=v.done,v.error=v.fail,k.url=((a||k.url||fc)+"").replace(gc,"").replace(lc,ec[1]+"//"),k.type=b.method||b.type||k.method||k.type,k.dataTypes=n.trim(k.dataType||"*").toLowerCase().match(E)||[""],null==k.crossDomain&&(h=mc.exec(k.url.toLowerCase()),k.crossDomain=!(!h||h[1]===ec[1]&&h[2]===ec[2]&&(h[3]||("http:"===h[1]?"80":"443"))===(ec[3]||("http:"===ec[1]?"80":"443")))),k.data&&k.processData&&"string"!=typeof k.data&&(k.data=n.param(k.data,k.traditional)),sc(nc,k,b,v),2===t)return v;i=k.global,i&&0===n.active++&&n.event.trigger("ajaxStart"),k.type=k.type.toUpperCase(),k.hasContent=!kc.test(k.type),d=k.url,k.hasContent||(k.data&&(d=k.url+=(dc.test(d)?"&":"?")+k.data,delete k.data),k.cache===!1&&(k.url=hc.test(d)?d.replace(hc,"$1_="+cc++):d+(dc.test(d)?"&":"?")+"_="+cc++)),k.ifModified&&(n.lastModified[d]&&v.setRequestHeader("If-Modified-Since",n.lastModified[d]),n.etag[d]&&v.setRequestHeader("If-None-Match",n.etag[d])),(k.data&&k.hasContent&&k.contentType!==!1||b.contentType)&&v.setRequestHeader("Content-Type",k.contentType),v.setRequestHeader("Accept",k.dataTypes[0]&&k.accepts[k.dataTypes[0]]?k.accepts[k.dataTypes[0]]+("*"!==k.dataTypes[0]?", "+pc+"; q=0.01":""):k.accepts["*"]);for(j in k.headers)v.setRequestHeader(j,k.headers[j]);if(k.beforeSend&&(k.beforeSend.call(l,v,k)===!1||2===t))return v.abort();u="abort";for(j in{success:1,error:1,complete:1})v[j](k[j]);if(c=sc(oc,k,b,v)){v.readyState=1,i&&m.trigger("ajaxSend",[v,k]),k.async&&k.timeout>0&&(g=setTimeout(function(){v.abort("timeout")},k.timeout));try{t=1,c.send(r,x)}catch(w){if(!(2>t))throw w;x(-1,w)}}else x(-1,"No Transport");function x(a,b,f,h){var j,r,s,u,w,x=b;2!==t&&(t=2,g&&clearTimeout(g),c=void 0,e=h||"",v.readyState=a>0?4:0,j=a>=200&&300>a||304===a,f&&(u=uc(k,v,f)),u=vc(k,u,v,j),j?(k.ifModified&&(w=v.getResponseHeader("Last-Modified"),w&&(n.lastModified[d]=w),w=v.getResponseHeader("etag"),w&&(n.etag[d]=w)),204===a||"HEAD"===k.type?x="nocontent":304===a?x="notmodified":(x=u.state,r=u.data,s=u.error,j=!s)):(s=x,(a||!x)&&(x="error",0>a&&(a=0))),v.status=a,v.statusText=(b||x)+"",j?o.resolveWith(l,[r,x,v]):o.rejectWith(l,[v,x,s]),v.statusCode(q),q=void 0,i&&m.trigger(j?"ajaxSuccess":"ajaxError",[v,k,j?r:s]),p.fireWith(l,[v,x]),i&&(m.trigger("ajaxComplete",[v,k]),--n.active||n.event.trigger("ajaxStop")))}return v},getJSON:function(a,b,c){return n.get(a,b,c,"json")},getScript:function(a,b){return n.get(a,void 0,b,"script")}}),n.each(["get","post"],function(a,b){n[b]=function(a,c,d,e){return n.isFunction(c)&&(e=e||d,d=c,c=void 0),n.ajax({url:a,type:b,dataType:e,data:c,success:d})}}),n.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(a,b){n.fn[b]=function(a){return this.on(b,a)}}),n._evalUrl=function(a){return n.ajax({url:a,type:"GET",dataType:"script",async:!1,global:!1,"throws":!0})},n.fn.extend({wrapAll:function(a){var b;return n.isFunction(a)?this.each(function(b){n(this).wrapAll(a.call(this,b))}):(this[0]&&(b=n(a,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&b.insertBefore(this[0]),b.map(function(){var a=this;while(a.firstElementChild)a=a.firstElementChild;return a}).append(this)),this)},wrapInner:function(a){return this.each(n.isFunction(a)?function(b){n(this).wrapInner(a.call(this,b))}:function(){var b=n(this),c=b.contents();c.length?c.wrapAll(a):b.append(a)})},wrap:function(a){var b=n.isFunction(a);return this.each(function(c){n(this).wrapAll(b?a.call(this,c):a)})},unwrap:function(){return this.parent().each(function(){n.nodeName(this,"body")||n(this).replaceWith(this.childNodes)}).end()}}),n.expr.filters.hidden=function(a){return a.offsetWidth<=0&&a.offsetHeight<=0},n.expr.filters.visible=function(a){return!n.expr.filters.hidden(a)};var wc=/%20/g,xc=/\[\]$/,yc=/\r?\n/g,zc=/^(?:submit|button|image|reset|file)$/i,Ac=/^(?:input|select|textarea|keygen)/i;function Bc(a,b,c,d){var e;if(n.isArray(b))n.each(b,function(b,e){c||xc.test(a)?d(a,e):Bc(a+"["+("object"==typeof e?b:"")+"]",e,c,d)});else if(c||"object"!==n.type(b))d(a,b);else for(e in b)Bc(a+"["+e+"]",b[e],c,d)}n.param=function(a,b){var c,d=[],e=function(a,b){b=n.isFunction(b)?b():null==b?"":b,d[d.length]=encodeURIComponent(a)+"="+encodeURIComponent(b)};if(void 0===b&&(b=n.ajaxSettings&&n.ajaxSettings.traditional),n.isArray(a)||a.jquery&&!n.isPlainObject(a))n.each(a,function(){e(this.name,this.value)});else for(c in a)Bc(c,a[c],b,e);return d.join("&").replace(wc,"+")},n.fn.extend({serialize:function(){return n.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var a=n.prop(this,"elements");return a?n.makeArray(a):this}).filter(function(){var a=this.type;return this.name&&!n(this).is(":disabled")&&Ac.test(this.nodeName)&&!zc.test(a)&&(this.checked||!T.test(a))}).map(function(a,b){var c=n(this).val();return null==c?null:n.isArray(c)?n.map(c,function(a){return{name:b.name,value:a.replace(yc,"\r\n")}}):{name:b.name,value:c.replace(yc,"\r\n")}}).get()}}),n.ajaxSettings.xhr=function(){try{return new XMLHttpRequest}catch(a){}};var Cc=0,Dc={},Ec={0:200,1223:204},Fc=n.ajaxSettings.xhr();a.ActiveXObject&&n(a).on("unload",function(){for(var a in Dc)Dc[a]()}),k.cors=!!Fc&&"withCredentials"in Fc,k.ajax=Fc=!!Fc,n.ajaxTransport(function(a){var b;return k.cors||Fc&&!a.crossDomain?{send:function(c,d){var e,f=a.xhr(),g=++Cc;if(f.open(a.type,a.url,a.async,a.username,a.password),a.xhrFields)for(e in a.xhrFields)f[e]=a.xhrFields[e];a.mimeType&&f.overrideMimeType&&f.overrideMimeType(a.mimeType),a.crossDomain||c["X-Requested-With"]||(c["X-Requested-With"]="XMLHttpRequest");for(e in c)f.setRequestHeader(e,c[e]);b=function(a){return function(){b&&(delete Dc[g],b=f.onload=f.onerror=null,"abort"===a?f.abort():"error"===a?d(f.status,f.statusText):d(Ec[f.status]||f.status,f.statusText,"string"==typeof f.responseText?{text:f.responseText}:void 0,f.getAllResponseHeaders()))}},f.onload=b(),f.onerror=b("error"),b=Dc[g]=b("abort");try{f.send(a.hasContent&&a.data||null)}catch(h){if(b)throw h}},abort:function(){b&&b()}}:void 0}),n.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/(?:java|ecma)script/},converters:{"text script":function(a){return n.globalEval(a),a}}}),n.ajaxPrefilter("script",function(a){void 0===a.cache&&(a.cache=!1),a.crossDomain&&(a.type="GET")}),n.ajaxTransport("script",function(a){if(a.crossDomain){var b,c;return{send:function(d,e){b=n("<script>").prop({async:!0,charset:a.scriptCharset,src:a.url}).on("load error",c=function(a){b.remove(),c=null,a&&e("error"===a.type?404:200,a.type)}),l.head.appendChild(b[0])},abort:function(){c&&c()}}}});var Gc=[],Hc=/(=)\?(?=&|$)|\?\?/;n.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var a=Gc.pop()||n.expando+"_"+cc++;return this[a]=!0,a}}),n.ajaxPrefilter("json jsonp",function(b,c,d){var e,f,g,h=b.jsonp!==!1&&(Hc.test(b.url)?"url":"string"==typeof b.data&&!(b.contentType||"").indexOf("application/x-www-form-urlencoded")&&Hc.test(b.data)&&"data");return h||"jsonp"===b.dataTypes[0]?(e=b.jsonpCallback=n.isFunction(b.jsonpCallback)?b.jsonpCallback():b.jsonpCallback,h?b[h]=b[h].replace(Hc,"$1"+e):b.jsonp!==!1&&(b.url+=(dc.test(b.url)?"&":"?")+b.jsonp+"="+e),b.converters["script json"]=function(){return g||n.error(e+" was not called"),g[0]},b.dataTypes[0]="json",f=a[e],a[e]=function(){g=arguments},d.always(function(){a[e]=f,b[e]&&(b.jsonpCallback=c.jsonpCallback,Gc.push(e)),g&&n.isFunction(f)&&f(g[0]),g=f=void 0}),"script"):void 0}),n.parseHTML=function(a,b,c){if(!a||"string"!=typeof a)return null;"boolean"==typeof b&&(c=b,b=!1),b=b||l;var d=v.exec(a),e=!c&&[];return d?[b.createElement(d[1])]:(d=n.buildFragment([a],b,e),e&&e.length&&n(e).remove(),n.merge([],d.childNodes))};var Ic=n.fn.load;n.fn.load=function(a,b,c){if("string"!=typeof a&&Ic)return Ic.apply(this,arguments);var d,e,f,g=this,h=a.indexOf(" ");return h>=0&&(d=n.trim(a.slice(h)),a=a.slice(0,h)),n.isFunction(b)?(c=b,b=void 0):b&&"object"==typeof b&&(e="POST"),g.length>0&&n.ajax({url:a,type:e,dataType:"html",data:b}).done(function(a){f=arguments,g.html(d?n("<div>").append(n.parseHTML(a)).find(d):a)}).complete(c&&function(a,b){g.each(c,f||[a.responseText,b,a])}),this},n.expr.filters.animated=function(a){return n.grep(n.timers,function(b){return a===b.elem}).length};var Jc=a.document.documentElement;function Kc(a){return n.isWindow(a)?a:9===a.nodeType&&a.defaultView}n.offset={setOffset:function(a,b,c){var d,e,f,g,h,i,j,k=n.css(a,"position"),l=n(a),m={};"static"===k&&(a.style.position="relative"),h=l.offset(),f=n.css(a,"top"),i=n.css(a,"left"),j=("absolute"===k||"fixed"===k)&&(f+i).indexOf("auto")>-1,j?(d=l.position(),g=d.top,e=d.left):(g=parseFloat(f)||0,e=parseFloat(i)||0),n.isFunction(b)&&(b=b.call(a,c,h)),null!=b.top&&(m.top=b.top-h.top+g),null!=b.left&&(m.left=b.left-h.left+e),"using"in b?b.using.call(a,m):l.css(m)}},n.fn.extend({offset:function(a){if(arguments.length)return void 0===a?this:this.each(function(b){n.offset.setOffset(this,a,b)});var b,c,d=this[0],e={top:0,left:0},f=d&&d.ownerDocument;if(f)return b=f.documentElement,n.contains(b,d)?(typeof d.getBoundingClientRect!==U&&(e=d.getBoundingClientRect()),c=Kc(f),{top:e.top+c.pageYOffset-b.clientTop,left:e.left+c.pageXOffset-b.clientLeft}):e},position:function(){if(this[0]){var a,b,c=this[0],d={top:0,left:0};return"fixed"===n.css(c,"position")?b=c.getBoundingClientRect():(a=this.offsetParent(),b=this.offset(),n.nodeName(a[0],"html")||(d=a.offset()),d.top+=n.css(a[0],"borderTopWidth",!0),d.left+=n.css(a[0],"borderLeftWidth",!0)),{top:b.top-d.top-n.css(c,"marginTop",!0),left:b.left-d.left-n.css(c,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){var a=this.offsetParent||Jc;while(a&&!n.nodeName(a,"html")&&"static"===n.css(a,"position"))a=a.offsetParent;return a||Jc})}}),n.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(b,c){var d="pageYOffset"===c;n.fn[b]=function(e){return J(this,function(b,e,f){var g=Kc(b);return void 0===f?g?g[c]:b[e]:void(g?g.scrollTo(d?a.pageXOffset:f,d?f:a.pageYOffset):b[e]=f)},b,e,arguments.length,null)}}),n.each(["top","left"],function(a,b){n.cssHooks[b]=yb(k.pixelPosition,function(a,c){return c?(c=xb(a,b),vb.test(c)?n(a).position()[b]+"px":c):void 0})}),n.each({Height:"height",Width:"width"},function(a,b){n.each({padding:"inner"+a,content:b,"":"outer"+a},function(c,d){n.fn[d]=function(d,e){var f=arguments.length&&(c||"boolean"!=typeof d),g=c||(d===!0||e===!0?"margin":"border");return J(this,function(b,c,d){var e;return n.isWindow(b)?b.document.documentElement["client"+a]:9===b.nodeType?(e=b.documentElement,Math.max(b.body["scroll"+a],e["scroll"+a],b.body["offset"+a],e["offset"+a],e["client"+a])):void 0===d?n.css(b,c,g):n.style(b,c,d,g)},b,f?d:void 0,f,null)}})}),n.fn.size=function(){return this.length},n.fn.andSelf=n.fn.addBack,"function"==typeof define&&define.amd&&define("jquery",[],function(){return n});var Lc=a.jQuery,Mc=a.$;return n.noConflict=function(b){return a.$===n&&(a.$=Mc),b&&a.jQuery===n&&(a.jQuery=Lc),n},typeof b===U&&(a.jQuery=a.$=n),n});
/*
 Copyright 2014 KunkaLabs Limited.
 @author    KunkaLabs Limited.
 @link      https://mixitup.kunkalabs.com

 @license   Commercial use requires a commercial license.
            https://mixitup.kunkalabs.com/licenses/

            Non-commercial use permitted under terms of CC-BY-NC license.
            http://creativecommons.org/licenses/by-nc/3.0/
*/
(function(f,l){f.MixItUp=function(){this._execAction("_constructor",0);f.extend(this,{selectors:{target:".mix",filter:".filter",sort:".sort"},animation:{enable:!0,effects:"fade scale",duration:600,easing:"ease",perspectiveDistance:"3000",perspectiveOrigin:"50% 50%",queue:!0,queueLimit:1,animateChangeLayout:!1,animateResizeContainer:!0,animateResizeTargets:!1,staggerSequence:!1,reverseOut:!1},callbacks:{onMixLoad:!1,onMixStart:!1,onMixBusy:!1,onMixEnd:!1,onMixFail:!1,_user:!1},controls:{enable:!0,
live:!1,toggleFilterButtons:!1,toggleLogic:"or",activeClass:"active"},layout:{display:"inline-block",containerClass:"",containerClassFail:"fail"},load:{filter:"all",sort:!1},_$body:null,_$container:null,_$targets:null,_$parent:null,_$sortButtons:null,_$filterButtons:null,_suckMode:!1,_mixing:!1,_sorting:!1,_clicking:!1,_loading:!0,_changingLayout:!1,_changingClass:!1,_changingDisplay:!1,_origOrder:[],_startOrder:[],_newOrder:[],_activeFilter:null,_toggleArray:[],_toggleString:"",_activeSort:"default:asc",
_newSort:null,_startHeight:null,_newHeight:null,_incPadding:!0,_newDisplay:null,_newClass:null,_targetsBound:0,_targetsDone:0,_queue:[],_$show:f(),_$hide:f()});this._execAction("_constructor",1)};f.MixItUp.prototype={constructor:f.MixItUp,_instances:{},_handled:{_filter:{},_sort:{}},_bound:{_filter:{},_sort:{}},_actions:{},_filters:{},extend:function(a){for(var c in a)f.MixItUp.prototype[c]=a[c]},addAction:function(a,c,b,d){f.MixItUp.prototype._addHook("_actions",a,c,b,d)},addFilter:function(a,c,
b,d){f.MixItUp.prototype._addHook("_filters",a,c,b,d)},_addHook:function(a,c,b,d,e){a=f.MixItUp.prototype[a];var g={};e=1===e||"post"===e?"post":"pre";g[c]={};g[c][e]={};g[c][e][b]=d;f.extend(!0,a,g)},_init:function(a,c){this._execAction("_init",0,arguments);c&&f.extend(!0,this,c);this._$body=f("body");this._domNode=a;this._$container=f(a);this._$container.addClass(this.layout.containerClass);this._id=a.id;this._platformDetect();this._brake=this._getPrefixedCSS("transition","none");this._refresh(!0);
this._$parent=this._$targets.parent().length?this._$targets.parent():this._$container;this.load.sort&&(this._newSort=this._parseSort(this.load.sort),this._activeSort=this._newSortString=this.load.sort,this._sort(),this._printSort());this._activeFilter="all"===this.load.filter?this.selectors.target:"none"===this.load.filter?"":this.load.filter;this.controls.enable&&this._bindHandlers();if(this.controls.toggleFilterButtons){this._buildToggleArray();for(var b=0;b<this._toggleArray.length;b++)this._updateControls({filter:this._toggleArray[b],
sort:this._activeSort},!0)}else this.controls.enable&&this._updateControls({filter:this._activeFilter,sort:this._activeSort});this._filter();this._init=!0;this._$container.data("mixItUp",this);this._execAction("_init",1,arguments);this._buildState();this._$targets.css(this._brake);this._goMix(this.animation.enable)},_platformDetect:function(){var a=["Webkit","Moz","O","ms"],c=["webkit","moz"],b=window.navigator.appVersion.match(/Chrome\/(\d+)\./)||!1,d="undefined"!==typeof InstallTrigger,e=function(b){for(var c=
0;c<a.length;c++)if(a[c]+"Transition"in b.style)return{prefix:"-"+a[c].toLowerCase()+"-",vendor:a[c]};return"transition"in b.style?"":!1}(this._domNode);this._execAction("_platformDetect",0);this._chrome=b?parseInt(b[1],10):!1;this._ff=d?parseInt(window.navigator.userAgent.match(/rv:([^)]+)\)/)[1]):!1;this._prefix=e.prefix;this._vendor=e.vendor;(this._suckMode=window.atob&&this._prefix?!1:!0)&&(this.animation.enable=!1);this._ff&&4>=this._ff&&(this.animation.enable=!1);for(b=0;b<c.length&&!window.requestAnimationFrame;b++)window.requestAnimationFrame=
window[c[b]+"RequestAnimationFrame"];"function"!==typeof Object.getPrototypeOf&&(Object.getPrototypeOf="object"===typeof"test".__proto__?function(a){return a.__proto__}:function(a){return a.constructor.prototype});this._domNode.nextElementSibling===l&&Object.defineProperty(Element.prototype,"nextElementSibling",{get:function(){for(var a=this.nextSibling;a;){if(1===a.nodeType)return a;a=a.nextSibling}return null}});this._execAction("_platformDetect",1)},_refresh:function(a,c){this._execAction("_refresh",
0,arguments);this._$targets=this._$container.find(this.selectors.target);for(var b=0;b<this._$targets.length;b++){var d=this._$targets[b];if(d.dataset===l||c){d.dataset={};for(var e=0;e<d.attributes.length;e++){var g=d.attributes[e],k=g.name,g=g.value;-1<k.indexOf("data-")&&(k=this._helpers._camelCase(k.substring(5,k.length)),d.dataset[k]=g)}}d.mixParent===l&&(d.mixParent=this._id)}if(this._$targets.length&&a||!this._origOrder.length&&this._$targets.length)for(this._origOrder=[],b=0;b<this._$targets.length;b++)d=
this._$targets[b],this._origOrder.push(d);this._execAction("_refresh",1,arguments)},_bindHandlers:function(){var a=this,c=f.MixItUp.prototype._bound._filter,b=f.MixItUp.prototype._bound._sort;a._execAction("_bindHandlers",0);if(a.controls.live)a._$body.on("click.mixItUp."+a._id,a.selectors.sort,function(){a._processClick(f(this),"sort")}).on("click.mixItUp."+a._id,a.selectors.filter,function(){a._processClick(f(this),"filter")});else a._$sortButtons=f(a.selectors.sort),a._$filterButtons=f(a.selectors.filter),
a._$sortButtons.on("click.mixItUp."+a._id,function(){a._processClick(f(this),"sort")}),a._$filterButtons.on("click.mixItUp."+a._id,function(){a._processClick(f(this),"filter")});c[a.selectors.filter]=c[a.selectors.filter]===l?1:c[a.selectors.filter]+1;b[a.selectors.sort]=b[a.selectors.sort]===l?1:b[a.selectors.sort]+1;a._execAction("_bindHandlers",1)},_processClick:function(a,c){var b=this,d=function(a,c,d){var e=f.MixItUp.prototype;e._handled["_"+c][b.selectors[c]]=e._handled["_"+c][b.selectors[c]]===
l?1:e._handled["_"+c][b.selectors[c]]+1;e._handled["_"+c][b.selectors[c]]===e._bound["_"+c][b.selectors[c]]&&(a[(d?"remove":"add")+"Class"](b.controls.activeClass),delete e._handled["_"+c][b.selectors[c]])};b._execAction("_processClick",0,arguments);if(!b._mixing||b.animation.queue&&b._queue.length<b.animation.queueLimit){b._clicking=!0;if("sort"===c){var e=a.attr("data-sort");if(!a.hasClass(b.controls.activeClass)||-1<e.indexOf("random"))f(b.selectors.sort).removeClass(b.controls.activeClass),d(a,
c),b.sort(e)}if("filter"===c){var g=a.attr("data-filter"),e="or"===b.controls.toggleLogic?",":"";b.controls.toggleFilterButtons?(b._buildToggleArray(),a.hasClass(b.controls.activeClass)?(d(a,c,!0),d=b._toggleArray.indexOf(g),b._toggleArray.splice(d,1)):(d(a,c),b._toggleArray.push(g)),b._toggleArray=f.grep(b._toggleArray,function(a){return a}),b._toggleString=b._toggleArray.join(e),b.filter(b._toggleString)):a.hasClass(b.controls.activeClass)||(f(b.selectors.filter).removeClass(b.controls.activeClass),
d(a,c),b.filter(g))}b._execAction("_processClick",1,arguments)}else"function"===typeof b.callbacks.onMixBusy&&b.callbacks.onMixBusy.call(b._domNode,b._state,b),b._execAction("_processClickBusy",1,arguments)},_buildToggleArray:function(){var a=this._activeFilter.replace(/\s/g,"");this._execAction("_buildToggleArray",0,arguments);if("or"===this.controls.toggleLogic)this._toggleArray=a.split(",");else{this._toggleArray=a.split(".");!this._toggleArray[0]&&this._toggleArray.shift();for(var a=0,c;c=this._toggleArray[a];a++)this._toggleArray[a]=
"."+c}this._execAction("_buildToggleArray",1,arguments)},_updateControls:function(a,c){var b={filter:a.filter,sort:a.sort},d="filter",e=null;this._execAction("_updateControls",0,arguments);a.filter===l&&(b.filter=this._activeFilter);a.sort===l&&(b.sort=this._activeSort);b.filter===this.selectors.target&&(b.filter="all");for(var g=0;2>g;g++){if(e=this.controls.live?f(this.selectors[d]):this["_$"+d+"Buttons"]){var k="[data-"+d+'="'+b[d]+'"]';c&&"filter"===d&&"none"!==b.filter&&""!==b.filter?e.filter(k).addClass(this.controls.activeClass):
e.removeClass(this.controls.activeClass).filter(k).addClass(this.controls.activeClass)}d="sort"}this._execAction("_updateControls",1,arguments)},_filter:function(){this._execAction("_filter",0);for(var a=0;a<this._$targets.length;a++){var c=f(this._$targets[a]);c.is(this._activeFilter)?this._$show=this._$show.add(c):this._$hide=this._$hide.add(c)}this._execAction("_filter",1)},_sort:function(){var a=this,c=function(a){a=a.slice();for(var b=a.length,c=b;c--;){var f=parseInt(Math.random()*b),h=a[c];
a[c]=a[f];a[f]=h}return a};a._execAction("_sort",0);a._startOrder=[];for(var b=0;b<a._$targets.length;b++)a._startOrder.push(a._$targets[b]);switch(a._newSort[0].sortBy){case "default":a._newOrder=a._origOrder;break;case "random":a._newOrder=c(a._startOrder);break;case "custom":a._newOrder=a._newSort[0].order;break;default:a._newOrder=a._startOrder.concat().sort(function(b,c){return a._compare(b,c)})}a._execAction("_sort",1)},_compare:function(a,c,b){b=b?b:0;var d=this,e=d._newSort[b].order,g=function(a){return a.dataset[d._newSort[b].sortBy]||
0},f=isNaN(1*g(a))?g(a).toLowerCase():1*g(a),g=isNaN(1*g(c))?g(c).toLowerCase():1*g(c);return f<g?"asc"===e?-1:1:f>g?"asc"===e?1:-1:f===g&&d._newSort.length>b+1?d._compare(a,c,b+1):0},_printSort:function(a){var c=a?this._startOrder:this._newOrder,b=this._$parent[0].querySelectorAll(this.selectors.target),d=b.length?b[b.length-1].nextElementSibling:null,e=document.createDocumentFragment();this._execAction("_printSort",0,arguments);for(var g=0;g<b.length;g++){var f=b[g],h=f.nextSibling;"absolute"!==
f.style.position&&(h&&"#text"===h.nodeName&&this._$parent[0].removeChild(h),this._$parent[0].removeChild(f))}for(g=0;g<c.length;g++)b=c[g],"default"!==this._newSort[0].sortBy||"desc"!==this._newSort[0].order||a?(e.appendChild(b),e.appendChild(document.createTextNode(" "))):(e.insertBefore(b,e.firstChild),e.insertBefore(document.createTextNode(" "),b));d?this._$parent[0].insertBefore(e,d):this._$parent[0].appendChild(e);this._execAction("_printSort",1,arguments)},_parseSort:function(a){for(var c="string"===
typeof a?a.split(" "):[a],b=[],d=0;d<c.length;d++){var e="string"===typeof a?c[d].split(":"):["custom",c[d]],e={sortBy:this._helpers._camelCase(e[0]),order:e[1]||"asc"};b.push(e);if("default"===e.sortBy||"random"===e.sortBy)break}return this._execFilter("_parseSort",b,arguments)},_parseEffects:function(){var a=this,c={opacity:"",transformIn:"",transformOut:"",filter:""},b=function(b,c,d){return-1<a.animation.effects.indexOf(b)?c&&(b=a.animation.effects.indexOf(b+"("),-1<b)?(b=a.animation.effects.substring(b),
{val:/\(([^)]+)\)/.exec(b)[1]}):!0:!1},d=function(a,d){for(var f=[["scale",".01"],["translateX","20px"],["translateY","20px"],["translateZ","20px"],["rotateX","90deg"],["rotateY","90deg"],["rotateZ","180deg"]],h=0;h<f.length;h++){var m=f[h][0],l=f[h][1],p=d&&"scale"!==m,q=c[a],n;b(m)?(n=m+"(",m=b(m,!0).val||l,p=p?"-"===m.charAt(0)?m.substr(1,m.length):"-"+m:m,n=n+p+") "):n="";c[a]=q+n}};c.opacity=b("fade")?b("fade",!0).val||"0":"1";d("transformIn");a.animation.reverseOut?d("transformOut",!0):c.transformOut=
c.transformIn;c.transition={};c.transition=a._getPrefixedCSS("transition","all "+a.animation.duration+"ms "+a.animation.easing+", opacity "+a.animation.duration+"ms linear");a.animation.stagger=b("stagger")?!0:!1;a.animation.staggerDuration=parseInt(b("stagger")?b("stagger",!0).val?b("stagger",!0).val:100:100);return a._execFilter("_parseEffects",c)},_buildState:function(a){var c={};this._execAction("_buildState",0);c={activeFilter:""===this._activeFilter?"none":this._activeFilter,activeSort:a&&this._newSortString?
this._newSortString:this._activeSort,fail:!this._$show.length&&""!==this._activeFilter,$targets:this._$targets,$show:this._$show,$hide:this._$hide,totalTargets:this._$targets.length,totalShow:this._$show.length,totalHide:this._$hide.length,display:a&&this._newDisplay?this._newDisplay:this.layout.display};if(a)return this._execFilter("_buildState",c);this._state=c;this._execAction("_buildState",1)},_goMix:function(a){var c=this,b=function(){if(c._chrome&&31===c._chrome){var a=c._$parent[0],b=a.parentElement,
e=document.createElement("div"),f=document.createDocumentFragment();b.insertBefore(e,a);f.appendChild(a);b.replaceChild(a,e)}c._setInter();d()},d=function(){var a=window.pageYOffset,b=window.pageXOffset;c._getInterMixData();c._setFinal();c._getFinalMixData();window.pageYOffset!==a&&window.scrollTo(b,a);c._prepTargets();window.requestAnimationFrame?requestAnimationFrame(e):setTimeout(function(){e()},20)},e=function(){c._animateTargets();0===c._targetsBound&&c._cleanUp()},f=c._buildState(!0);c._execAction("_goMix",
0,arguments);!c.animation.duration&&(a=!1);c._mixing=!0;c._$container.removeClass(c.layout.containerClassFail);"function"===typeof c.callbacks.onMixStart&&c.callbacks.onMixStart.call(c._domNode,c._state,f,c);c._$container.trigger("mixStart",[c._state,f,c]);c._getOrigMixData();a&&!c._suckMode?window.requestAnimationFrame?requestAnimationFrame(b):b():c._cleanUp();c._execAction("_goMix",1,arguments)},_getTargetData:function(a,c){var b;a.dataset[c+"PosX"]=a.offsetLeft;a.dataset[c+"PosY"]=a.offsetTop;
this.animation.animateResizeTargets&&(b=window.getComputedStyle(a),a.dataset[c+"MarginBottom"]=parseInt(b.marginBottom),a.dataset[c+"MarginRight"]=parseInt(b.marginRight),a.dataset[c+"Width"]=a.offsetWidth,a.dataset[c+"Height"]=a.offsetHeight)},_getOrigMixData:function(){var a=this._suckMode?{boxSizing:""}:window.getComputedStyle(this._$parent[0]);this._incPadding="border-box"===(a.boxSizing||a[this._vendor+"BoxSizing"]);this._execAction("_getOrigMixData",0);!this._suckMode&&(this.effects=this._parseEffects());
this._$toHide=this._$hide.filter(":visible");this._$toShow=this._$show.filter(":hidden");this._$pre=this._$targets.filter(":visible");this._startHeight=this._incPadding?this._$parent.outerHeight():this._$parent.height();for(a=0;a<this._$pre.length;a++)this._getTargetData(this._$pre[a],"orig");this._execAction("_getOrigMixData",1)},_setInter:function(){this._execAction("_setInter",0);this._changingLayout&&this.animation.animateChangeLayout?(this._$toShow.css("display",this._newDisplay),this._changingClass&&
this._$container.removeClass(this.layout.containerClass).addClass(this._newClass)):this._$toShow.css("display",this.layout.display);this._execAction("_setInter",1)},_getInterMixData:function(){this._execAction("_getInterMixData",0);for(var a=0;a<this._$toShow.length;a++){var c=this._$toShow[a];this._getTargetData(c,"inter")}for(a=0;a<this._$pre.length;a++)c=this._$pre[a],this._getTargetData(c,"inter");this._execAction("_getInterMixData",1)},_setFinal:function(){this._execAction("_setFinal",0);this._sorting&&
this._printSort();this._$toHide.removeStyle("display");this._changingLayout&&this.animation.animateChangeLayout&&this._$pre.css("display",this._newDisplay);this._execAction("_setFinal",1)},_getFinalMixData:function(){this._execAction("_getFinalMixData",0);for(var a=0;a<this._$toShow.length;a++){var c=this._$toShow[a];this._getTargetData(c,"final")}for(a=0;a<this._$pre.length;a++)c=this._$pre[a],this._getTargetData(c,"final");this._newHeight=this._incPadding?this._$parent.outerHeight():this._$parent.height();
this._sorting&&this._printSort(!0);this._$toShow.removeStyle("display");this._$pre.css("display",this.layout.display);this._changingClass&&this.animation.animateChangeLayout&&this._$container.removeClass(this._newClass).addClass(this.layout.containerClass);this._execAction("_getFinalMixData",1)},_prepTargets:function(){var a={_in:this._getPrefixedCSS("transform",this.effects.transformIn),_out:this._getPrefixedCSS("transform",this.effects.transformOut)};this._execAction("_prepTargets",0);this.animation.animateResizeContainer&&
this._$parent.css("height",this._startHeight+"px");for(var c=0;c<this._$toShow.length;c++){var b=this._$toShow[c],d=f(b);b.style.opacity=this.effects.opacity;b.style.display=this._changingLayout&&this.animation.animateChangeLayout?this._newDisplay:this.layout.display;d.css(a._in);this.animation.animateResizeTargets&&(b.style.width=b.dataset.finalWidth+"px",b.style.height=b.dataset.finalHeight+"px",b.style.marginRight=-(b.dataset.finalWidth-b.dataset.interWidth)+1*b.dataset.finalMarginRight+"px",b.style.marginBottom=
-(b.dataset.finalHeight-b.dataset.interHeight)+1*b.dataset.finalMarginBottom+"px")}for(c=0;c<this._$pre.length;c++)b=this._$pre[c],d=f(b),a=this._getPrefixedCSS("transform","translate("+(b.dataset.origPosX-b.dataset.interPosX)+"px,"+(b.dataset.origPosY-b.dataset.interPosY)+"px)"),d.css(a),this.animation.animateResizeTargets&&(b.style.width=b.dataset.origWidth+"px",b.style.height=b.dataset.origHeight+"px",b.dataset.origWidth-b.dataset.finalWidth&&(b.style.marginRight=-(b.dataset.origWidth-b.dataset.interWidth)+
1*b.dataset.origMarginRight+"px"),b.dataset.origHeight-b.dataset.finalHeight&&(b.style.marginBottom=-(b.dataset.origHeight-b.dataset.interHeight)+1*b.dataset.origMarginBottom+"px"));this._execAction("_prepTargets",1)},_animateTargets:function(){var a,c;this._execAction("_animateTargets",0);this._targetsBound=this._targetsDone=0;this._$parent.css(this._getPrefixedCSS("perspective",this.animation.perspectiveDistance+"px")).css(this._getPrefixedCSS("perspective-origin",this.animation.perspectiveOrigin));
this.animation.animateResizeContainer&&this._$parent.css(this._getPrefixedCSS("transition","height "+this.animation.duration+"ms ease")).css("height",this._newHeight+"px");for(var b=0;b<this._$toShow.length;b++){var d=this._$toShow[b],e=f(d);a=d.dataset.finalPosX-d.dataset.interPosX;c=d.dataset.finalPosY-d.dataset.interPosY;var g=this._getDelay(b),k={};d.style.opacity="";for(d=0;2>d;d++){var h=0===d?h=this._prefix:"";this._ff&&20>=this._ff&&(k[h+"transition-property"]="all",k[h+"transition-timing-function"]=
this.animation.easing+"ms",k[h+"transition-duration"]=this.animation.duration+"ms");k[h+"transition-delay"]=g+"ms";k[h+"transform"]="translate("+a+"px,"+c+"px)"}(this.effects.transform||this.effects.opacity)&&this._bindTargetDone(e);this._ff&&20>=this._ff?e.css(k):e.css(this.effects.transition).css(k)}for(b=0;b<this._$pre.length;b++)d=this._$pre[b],e=f(d),a=d.dataset.finalPosX-d.dataset.interPosX,c=d.dataset.finalPosY-d.dataset.interPosY,g=this._getDelay(b),d.dataset.finalPosX===d.dataset.origPosX&&
d.dataset.finalPosY===d.dataset.origPosY||this._bindTargetDone(e),e.css(this._getPrefixedCSS("transition","all "+this.animation.duration+"ms "+this.animation.easing+" "+g+"ms")),e.css(this._getPrefixedCSS("transform","translate("+a+"px,"+c+"px)")),this.animation.animateResizeTargets&&(d.dataset.origWidth-d.dataset.finalWidth&&1*d.dataset.finalWidth&&(d.style.width=d.dataset.finalWidth+"px",d.style.marginRight=-(d.dataset.finalWidth-d.dataset.interWidth)+1*d.dataset.finalMarginRight+"px"),d.dataset.origHeight-
d.dataset.finalHeight&&1*d.dataset.finalHeight&&(d.style.height=d.dataset.finalHeight+"px",d.style.marginBottom=-(d.dataset.finalHeight-d.dataset.interHeight)+1*d.dataset.finalMarginBottom+"px"));this._changingClass&&this._$container.removeClass(this.layout.containerClass).addClass(this._newClass);for(b=0;b<this._$toHide.length;b++){d=this._$toHide[b];e=f(d);g=this._getDelay(b);a={};for(d=0;2>d;d++)h=0===d?h=this._prefix:"",a[h+"transition-delay"]=g+"ms",a[h+"transform"]=this.effects.transformOut,
a.opacity=this.effects.opacity;e.css(this.effects.transition).css(a);(this.effects.transform||this.effects.opacity)&&this._bindTargetDone(e)}this._execAction("_animateTargets",1)},_bindTargetDone:function(a){var c=this,b=a[0];c._execAction("_bindTargetDone",0,arguments);b.dataset.bound||(b.dataset.bound=!0,c._targetsBound++,a.on("webkitTransitionEnd.mixItUp transitionend.mixItUp",function(d){(-1<d.originalEvent.propertyName.indexOf("transform")||-1<d.originalEvent.propertyName.indexOf("opacity"))&&
f(d.originalEvent.target).is(c.selectors.target)&&(a.off(".mixItUp"),delete b.dataset.bound,c._targetDone())}));c._execAction("_bindTargetDone",1,arguments)},_targetDone:function(){this._execAction("_targetDone",0);this._targetsDone++;this._targetsDone===this._targetsBound&&this._cleanUp();this._execAction("_targetDone",1)},_cleanUp:function(){var a=this,c=a.animation.animateResizeTargets?"transform opacity width height margin-bottom margin-right":"transform opacity";unBrake=function(){a._$targets.removeStyle("transition",
a._prefix)};a._execAction("_cleanUp",0);a._changingLayout?a._$show.css("display",a._newDisplay):a._$show.css("display",a.layout.display);a._$targets.css(a._brake);a._$targets.removeStyle(c,a._prefix).removeAttr("data-inter-pos-x data-inter-pos-y data-final-pos-x data-final-pos-y data-orig-pos-x data-orig-pos-y data-orig-height data-orig-width data-final-height data-final-width data-inter-width data-inter-height data-orig-margin-right data-orig-margin-bottom data-inter-margin-right data-inter-margin-bottom data-final-margin-right data-final-margin-bottom");
a._$hide.removeStyle("display");a._$parent.removeStyle("height transition perspective-distance perspective perspective-origin-x perspective-origin-y perspective-origin perspectiveOrigin",a._prefix);a._sorting&&(a._printSort(),a._activeSort=a._newSortString,a._sorting=!1);a._changingLayout&&(a._changingDisplay&&(a.layout.display=a._newDisplay,a._changingDisplay=!1),a._changingClass&&(a._$parent.removeClass(a.layout.containerClass).addClass(a._newClass),a.layout.containerClass=a._newClass,a._changingClass=
!1),a._changingLayout=!1);a._refresh();a._buildState();a._state.fail&&a._$container.addClass(a.layout.containerClassFail);a._$show=f();a._$hide=f();window.requestAnimationFrame&&requestAnimationFrame(unBrake);a._mixing=!1;"function"===typeof a.callbacks._user&&a.callbacks._user.call(a._domNode,a._state,a);"function"===typeof a.callbacks.onMixEnd&&a.callbacks.onMixEnd.call(a._domNode,a._state,a);a._$container.trigger("mixEnd",[a._state,a]);a._state.fail&&("function"===typeof a.callbacks.onMixFail&&
a.callbacks.onMixFail.call(a._domNode,a._state,a),a._$container.trigger("mixFail",[a._state,a]));a._loading&&("function"===typeof a.callbacks.onMixLoad&&a.callbacks.onMixLoad.call(a._domNode,a._state,a),a._$container.trigger("mixLoad",[a._state,a]));a._queue.length&&(a._execAction("_queue",0),a.multiMix(a._queue[0][0],a._queue[0][1],a._queue[0][2]),a._queue.splice(0,1));a._execAction("_cleanUp",1);a._loading=!1},_getPrefixedCSS:function(a,c,b){var d={};for(i=0;2>i;i++){var e=0===i?this._prefix:"";
b?d[e+a]=e+c:d[e+a]=c}return this._execFilter("_getPrefixedCSS",d,arguments)},_getDelay:function(a){var c="function"===typeof this.animation.staggerSequence?this.animation.staggerSequence.call(this._domNode,a,this._state):a;return this._execFilter("_getDelay",this.animation.stagger?c*this.animation.staggerDuration:0,arguments)},_parseMultiMixArgs:function(a){for(var c={command:null,animate:this.animation.enable,callback:null},b=0;b<a.length;b++){var d=a[b];null!==d&&("object"===typeof d||"string"===
typeof d?c.command=d:"boolean"===typeof d?c.animate=d:"function"===typeof d&&(c.callback=d))}return this._execFilter("_parseMultiMixArgs",c,arguments)},_parseInsertArgs:function(a){for(var c={index:0,$object:f(),multiMix:{filter:this._state.activeFilter},callback:null},b=0;b<a.length;b++){var d=a[b];"number"===typeof d?c.index=d:"object"===typeof d&&d instanceof f?c.$object=d:"object"===typeof d&&this._helpers._isElement(d)?c.$object=f(d):"object"===typeof d&&null!==d?c.multiMix=d:"boolean"!==typeof d||
d?"function"===typeof d&&(c.callback=d):c.multiMix=!1}return this._execFilter("_parseInsertArgs",c,arguments)},_execAction:function(a,c,b){c=c?"post":"pre";if(!this._actions.isEmptyObject&&this._actions.hasOwnProperty(a))for(var d in this._actions[a][c])this._actions[a][c][d].call(this,b)},_execFilter:function(a,c,b){if(!this._filters.isEmptyObject&&this._filters.hasOwnProperty(a))for(var d in this._filters[a])return this._filters[a][d].call(this,b);else return c},_helpers:{_camelCase:function(a){return a.replace(/-([a-z])/g,
function(a){return a[1].toUpperCase()})},_isElement:function(a){return window.HTMLElement?a instanceof HTMLElement:null!==a&&1===a.nodeType&&"string"===a.nodeName}},isMixing:function(){return this._execFilter("isMixing",this._mixing)},filter:function(){var a=this._parseMultiMixArgs(arguments);this._clicking&&(this._toggleString="");this.multiMix({filter:a.command},a.animate,a.callback)},sort:function(){var a=this._parseMultiMixArgs(arguments);this.multiMix({sort:a.command},a.animate,a.callback)},
changeLayout:function(){var a=this._parseMultiMixArgs(arguments);this.multiMix({changeLayout:a.command},a.animate,a.callback)},multiMix:function(){var a=this._parseMultiMixArgs(arguments);this._execAction("multiMix",0,arguments);if(this._mixing)this.animation.queue&&this._queue.length<this.animation.queueLimit?(this._queue.push(arguments),this.controls.enable&&!this._clicking&&this._updateControls(a.command),this._execAction("multiMixQueue",1,arguments)):("function"===typeof this.callbacks.onMixBusy&&
this.callbacks.onMixBusy.call(this._domNode,this._state,this),this._$container.trigger("mixBusy",[this._state,this]),this._execAction("multiMixBusy",1,arguments));else{this.controls.enable&&!this._clicking&&(this.controls.toggleFilterButtons&&this._buildToggleArray(),this._updateControls(a.command,this.controls.toggleFilterButtons));2>this._queue.length&&(this._clicking=!1);delete this.callbacks._user;a.callback&&(this.callbacks._user=a.callback);var c=a.command.sort,b=a.command.filter,d=a.command.changeLayout;
this._refresh();c&&(this._newSort=this._parseSort(c),this._newSortString=c,this._sorting=!0,this._sort());b!==l&&(this._activeFilter=b="all"===b?this.selectors.target:b);this._filter();d&&(this._newDisplay="string"===typeof d?d:d.display||this.layout.display,this._newClass=d.containerClass||"",this._newDisplay!==this.layout.display||this._newClass!==this.layout.containerClass)&&(this._changingLayout=!0,this._changingClass=this._newClass!==this.layout.containerClass,this._changingDisplay=this._newDisplay!==
this.layout.display);this._$targets.css(this._brake);this._goMix(a.animate^this.animation.enable?a.animate:this.animation.enable);this._execAction("multiMix",1,arguments)}},insert:function(){var a=this._parseInsertArgs(arguments),c="function"===typeof a.callback?a.callback:null,b=document.createDocumentFragment(),d;this._refresh();d=this._$targets.length?a.index<this._$targets.length||!this._$targets.length?this._$targets[a.index]:this._$targets[this._$targets.length-1].nextElementSibling:this._$parent[0].children[0];
this._execAction("insert",0,arguments);if(a.$object){for(var e=0;e<a.$object.length;e++)b.appendChild(a.$object[e]),b.appendChild(document.createTextNode(" "));this._$parent[0].insertBefore(b,d)}this._execAction("insert",1,arguments);"object"===typeof a.multiMix&&this.multiMix(a.multiMix,c)},prepend:function(){var a=this._parseInsertArgs(arguments);this.insert(0,a.$object,a.multiMix,a.callback)},append:function(){var a=this._parseInsertArgs(arguments);this.insert(this._state.totalTargets,a.$object,
a.multiMix,a.callback)},getOption:function(a){var c=function(a,c){for(var e=c.split("."),f=e.pop(),k=e.length,h=1,m=e[0]||c;(a=a[m])&&h<k;)m=e[h],h++;if(a!==l)return a[f]!==l?a[f]:a};return a?this._execFilter("getOption",c(this,a),arguments):this},setOptions:function(a){this._execAction("setOptions",0,arguments);"object"===typeof a&&f.extend(!0,this,a);this._execAction("setOptions",1,arguments)},getState:function(){return this._execFilter("getState",this._state,this)},forceRefresh:function(){this._refresh(!1,
!0)},destroy:function(a){this._execAction("destroy",0,arguments);this._$body.add(f(this.selectors.sort)).add(f(this.selectors.filter)).off(".mixItUp");for(var c=0;c<this._$targets.length;c++){var b=this._$targets[c];a&&(b.style.display="");delete b.mixParent}this._execAction("destroy",1,arguments);delete f.MixItUp.prototype._instances[this._id]}};f.fn.mixItUp=function(){var a=arguments,c=[],b,d=function(a,b){var c=new f.MixItUp;c._execAction("_instantiate",0,arguments);a.id=a.id?a.id:"MixItUp"+("00000"+
(16777216*Math.random()<<0).toString(16)).substr(-6).toUpperCase();c._instances[a.id]||(c._instances[a.id]=c,c._init(a,b));c._execAction("_instantiate",1,arguments)};b=this.each(function(){if(a&&"string"===typeof a[0]){var b=f.MixItUp.prototype._instances[this.id];"isLoaded"===a[0]?c.push(b?!0:!1):(b=b[a[0]](a[1],a[2],a[3]),b!==l&&c.push(b))}else d(this,a[0])});return c.length?1<c.length?c:c[0]:b};f.fn.removeStyle=function(a,c){c=c?c:"";return this.each(function(){for(var b=a.split(" "),d=0;d<b.length;d++)for(var e=
0;4>e;e++){switch(e){case 0:var g=b[d];break;case 1:g=f.MixItUp.prototype._helpers._camelCase(g);break;case 2:g=c+b[d];break;case 3:g=f.MixItUp.prototype._helpers._camelCase(c+b[d])}this.style[g]!==l&&"unknown"!==typeof this.style[g]&&0<this.style[g].length&&(this.style[g]="");if(!c&&1===e)break}this.attributes&&this.attributes.style&&this.attributes.style!==l&&""===this.attributes.style.value&&this.attributes.removeNamedItem("style")})}})(jQuery);
/*! jQuery UI - v1.10.4 - 2014-02-11
* http://jqueryui.com
* Includes: jquery.ui.core.js, jquery.ui.widget.js, jquery.ui.mouse.js, jquery.ui.draggable.js, jquery.ui.droppable.js, jquery.ui.resizable.js, jquery.ui.selectable.js, jquery.ui.sortable.js
* Copyright 2014 jQuery Foundation and other contributors; Licensed MIT */

(function(e,t){function i(t,i){var s,a,o,r=t.nodeName.toLowerCase();return"area"===r?(s=t.parentNode,a=s.name,t.href&&a&&"map"===s.nodeName.toLowerCase()?(o=e("img[usemap=#"+a+"]")[0],!!o&&n(o)):!1):(/input|select|textarea|button|object/.test(r)?!t.disabled:"a"===r?t.href||i:i)&&n(t)}function n(t){return e.expr.filters.visible(t)&&!e(t).parents().addBack().filter(function(){return"hidden"===e.css(this,"visibility")}).length}var s=0,a=/^ui-id-\d+$/;e.ui=e.ui||{},e.extend(e.ui,{version:"1.10.4",keyCode:{BACKSPACE:8,COMMA:188,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,NUMPAD_ADD:107,NUMPAD_DECIMAL:110,NUMPAD_DIVIDE:111,NUMPAD_ENTER:108,NUMPAD_MULTIPLY:106,NUMPAD_SUBTRACT:109,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SPACE:32,TAB:9,UP:38}}),e.fn.extend({focus:function(t){return function(i,n){return"number"==typeof i?this.each(function(){var t=this;setTimeout(function(){e(t).focus(),n&&n.call(t)},i)}):t.apply(this,arguments)}}(e.fn.focus),scrollParent:function(){var t;return t=e.ui.ie&&/(static|relative)/.test(this.css("position"))||/absolute/.test(this.css("position"))?this.parents().filter(function(){return/(relative|absolute|fixed)/.test(e.css(this,"position"))&&/(auto|scroll)/.test(e.css(this,"overflow")+e.css(this,"overflow-y")+e.css(this,"overflow-x"))}).eq(0):this.parents().filter(function(){return/(auto|scroll)/.test(e.css(this,"overflow")+e.css(this,"overflow-y")+e.css(this,"overflow-x"))}).eq(0),/fixed/.test(this.css("position"))||!t.length?e(document):t},zIndex:function(i){if(i!==t)return this.css("zIndex",i);if(this.length)for(var n,s,a=e(this[0]);a.length&&a[0]!==document;){if(n=a.css("position"),("absolute"===n||"relative"===n||"fixed"===n)&&(s=parseInt(a.css("zIndex"),10),!isNaN(s)&&0!==s))return s;a=a.parent()}return 0},uniqueId:function(){return this.each(function(){this.id||(this.id="ui-id-"+ ++s)})},removeUniqueId:function(){return this.each(function(){a.test(this.id)&&e(this).removeAttr("id")})}}),e.extend(e.expr[":"],{data:e.expr.createPseudo?e.expr.createPseudo(function(t){return function(i){return!!e.data(i,t)}}):function(t,i,n){return!!e.data(t,n[3])},focusable:function(t){return i(t,!isNaN(e.attr(t,"tabindex")))},tabbable:function(t){var n=e.attr(t,"tabindex"),s=isNaN(n);return(s||n>=0)&&i(t,!s)}}),e("<a>").outerWidth(1).jquery||e.each(["Width","Height"],function(i,n){function s(t,i,n,s){return e.each(a,function(){i-=parseFloat(e.css(t,"padding"+this))||0,n&&(i-=parseFloat(e.css(t,"border"+this+"Width"))||0),s&&(i-=parseFloat(e.css(t,"margin"+this))||0)}),i}var a="Width"===n?["Left","Right"]:["Top","Bottom"],o=n.toLowerCase(),r={innerWidth:e.fn.innerWidth,innerHeight:e.fn.innerHeight,outerWidth:e.fn.outerWidth,outerHeight:e.fn.outerHeight};e.fn["inner"+n]=function(i){return i===t?r["inner"+n].call(this):this.each(function(){e(this).css(o,s(this,i)+"px")})},e.fn["outer"+n]=function(t,i){return"number"!=typeof t?r["outer"+n].call(this,t):this.each(function(){e(this).css(o,s(this,t,!0,i)+"px")})}}),e.fn.addBack||(e.fn.addBack=function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}),e("<a>").data("a-b","a").removeData("a-b").data("a-b")&&(e.fn.removeData=function(t){return function(i){return arguments.length?t.call(this,e.camelCase(i)):t.call(this)}}(e.fn.removeData)),e.ui.ie=!!/msie [\w.]+/.exec(navigator.userAgent.toLowerCase()),e.support.selectstart="onselectstart"in document.createElement("div"),e.fn.extend({disableSelection:function(){return this.bind((e.support.selectstart?"selectstart":"mousedown")+".ui-disableSelection",function(e){e.preventDefault()})},enableSelection:function(){return this.unbind(".ui-disableSelection")}}),e.extend(e.ui,{plugin:{add:function(t,i,n){var s,a=e.ui[t].prototype;for(s in n)a.plugins[s]=a.plugins[s]||[],a.plugins[s].push([i,n[s]])},call:function(e,t,i){var n,s=e.plugins[t];if(s&&e.element[0].parentNode&&11!==e.element[0].parentNode.nodeType)for(n=0;s.length>n;n++)e.options[s[n][0]]&&s[n][1].apply(e.element,i)}},hasScroll:function(t,i){if("hidden"===e(t).css("overflow"))return!1;var n=i&&"left"===i?"scrollLeft":"scrollTop",s=!1;return t[n]>0?!0:(t[n]=1,s=t[n]>0,t[n]=0,s)}})})(jQuery);(function(t,e){var i=0,s=Array.prototype.slice,n=t.cleanData;t.cleanData=function(e){for(var i,s=0;null!=(i=e[s]);s++)try{t(i).triggerHandler("remove")}catch(o){}n(e)},t.widget=function(i,s,n){var o,a,r,h,l={},c=i.split(".")[0];i=i.split(".")[1],o=c+"-"+i,n||(n=s,s=t.Widget),t.expr[":"][o.toLowerCase()]=function(e){return!!t.data(e,o)},t[c]=t[c]||{},a=t[c][i],r=t[c][i]=function(t,i){return this._createWidget?(arguments.length&&this._createWidget(t,i),e):new r(t,i)},t.extend(r,a,{version:n.version,_proto:t.extend({},n),_childConstructors:[]}),h=new s,h.options=t.widget.extend({},h.options),t.each(n,function(i,n){return t.isFunction(n)?(l[i]=function(){var t=function(){return s.prototype[i].apply(this,arguments)},e=function(t){return s.prototype[i].apply(this,t)};return function(){var i,s=this._super,o=this._superApply;return this._super=t,this._superApply=e,i=n.apply(this,arguments),this._super=s,this._superApply=o,i}}(),e):(l[i]=n,e)}),r.prototype=t.widget.extend(h,{widgetEventPrefix:a?h.widgetEventPrefix||i:i},l,{constructor:r,namespace:c,widgetName:i,widgetFullName:o}),a?(t.each(a._childConstructors,function(e,i){var s=i.prototype;t.widget(s.namespace+"."+s.widgetName,r,i._proto)}),delete a._childConstructors):s._childConstructors.push(r),t.widget.bridge(i,r)},t.widget.extend=function(i){for(var n,o,a=s.call(arguments,1),r=0,h=a.length;h>r;r++)for(n in a[r])o=a[r][n],a[r].hasOwnProperty(n)&&o!==e&&(i[n]=t.isPlainObject(o)?t.isPlainObject(i[n])?t.widget.extend({},i[n],o):t.widget.extend({},o):o);return i},t.widget.bridge=function(i,n){var o=n.prototype.widgetFullName||i;t.fn[i]=function(a){var r="string"==typeof a,h=s.call(arguments,1),l=this;return a=!r&&h.length?t.widget.extend.apply(null,[a].concat(h)):a,r?this.each(function(){var s,n=t.data(this,o);return n?t.isFunction(n[a])&&"_"!==a.charAt(0)?(s=n[a].apply(n,h),s!==n&&s!==e?(l=s&&s.jquery?l.pushStack(s.get()):s,!1):e):t.error("no such method '"+a+"' for "+i+" widget instance"):t.error("cannot call methods on "+i+" prior to initialization; "+"attempted to call method '"+a+"'")}):this.each(function(){var e=t.data(this,o);e?e.option(a||{})._init():t.data(this,o,new n(a,this))}),l}},t.Widget=function(){},t.Widget._childConstructors=[],t.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",defaultElement:"<div>",options:{disabled:!1,create:null},_createWidget:function(e,s){s=t(s||this.defaultElement||this)[0],this.element=t(s),this.uuid=i++,this.eventNamespace="."+this.widgetName+this.uuid,this.options=t.widget.extend({},this.options,this._getCreateOptions(),e),this.bindings=t(),this.hoverable=t(),this.focusable=t(),s!==this&&(t.data(s,this.widgetFullName,this),this._on(!0,this.element,{remove:function(t){t.target===s&&this.destroy()}}),this.document=t(s.style?s.ownerDocument:s.document||s),this.window=t(this.document[0].defaultView||this.document[0].parentWindow)),this._create(),this._trigger("create",null,this._getCreateEventData()),this._init()},_getCreateOptions:t.noop,_getCreateEventData:t.noop,_create:t.noop,_init:t.noop,destroy:function(){this._destroy(),this.element.unbind(this.eventNamespace).removeData(this.widgetName).removeData(this.widgetFullName).removeData(t.camelCase(this.widgetFullName)),this.widget().unbind(this.eventNamespace).removeAttr("aria-disabled").removeClass(this.widgetFullName+"-disabled "+"ui-state-disabled"),this.bindings.unbind(this.eventNamespace),this.hoverable.removeClass("ui-state-hover"),this.focusable.removeClass("ui-state-focus")},_destroy:t.noop,widget:function(){return this.element},option:function(i,s){var n,o,a,r=i;if(0===arguments.length)return t.widget.extend({},this.options);if("string"==typeof i)if(r={},n=i.split("."),i=n.shift(),n.length){for(o=r[i]=t.widget.extend({},this.options[i]),a=0;n.length-1>a;a++)o[n[a]]=o[n[a]]||{},o=o[n[a]];if(i=n.pop(),1===arguments.length)return o[i]===e?null:o[i];o[i]=s}else{if(1===arguments.length)return this.options[i]===e?null:this.options[i];r[i]=s}return this._setOptions(r),this},_setOptions:function(t){var e;for(e in t)this._setOption(e,t[e]);return this},_setOption:function(t,e){return this.options[t]=e,"disabled"===t&&(this.widget().toggleClass(this.widgetFullName+"-disabled ui-state-disabled",!!e).attr("aria-disabled",e),this.hoverable.removeClass("ui-state-hover"),this.focusable.removeClass("ui-state-focus")),this},enable:function(){return this._setOption("disabled",!1)},disable:function(){return this._setOption("disabled",!0)},_on:function(i,s,n){var o,a=this;"boolean"!=typeof i&&(n=s,s=i,i=!1),n?(s=o=t(s),this.bindings=this.bindings.add(s)):(n=s,s=this.element,o=this.widget()),t.each(n,function(n,r){function h(){return i||a.options.disabled!==!0&&!t(this).hasClass("ui-state-disabled")?("string"==typeof r?a[r]:r).apply(a,arguments):e}"string"!=typeof r&&(h.guid=r.guid=r.guid||h.guid||t.guid++);var l=n.match(/^(\w+)\s*(.*)$/),c=l[1]+a.eventNamespace,u=l[2];u?o.delegate(u,c,h):s.bind(c,h)})},_off:function(t,e){e=(e||"").split(" ").join(this.eventNamespace+" ")+this.eventNamespace,t.unbind(e).undelegate(e)},_delay:function(t,e){function i(){return("string"==typeof t?s[t]:t).apply(s,arguments)}var s=this;return setTimeout(i,e||0)},_hoverable:function(e){this.hoverable=this.hoverable.add(e),this._on(e,{mouseenter:function(e){t(e.currentTarget).addClass("ui-state-hover")},mouseleave:function(e){t(e.currentTarget).removeClass("ui-state-hover")}})},_focusable:function(e){this.focusable=this.focusable.add(e),this._on(e,{focusin:function(e){t(e.currentTarget).addClass("ui-state-focus")},focusout:function(e){t(e.currentTarget).removeClass("ui-state-focus")}})},_trigger:function(e,i,s){var n,o,a=this.options[e];if(s=s||{},i=t.Event(i),i.type=(e===this.widgetEventPrefix?e:this.widgetEventPrefix+e).toLowerCase(),i.target=this.element[0],o=i.originalEvent)for(n in o)n in i||(i[n]=o[n]);return this.element.trigger(i,s),!(t.isFunction(a)&&a.apply(this.element[0],[i].concat(s))===!1||i.isDefaultPrevented())}},t.each({show:"fadeIn",hide:"fadeOut"},function(e,i){t.Widget.prototype["_"+e]=function(s,n,o){"string"==typeof n&&(n={effect:n});var a,r=n?n===!0||"number"==typeof n?i:n.effect||i:e;n=n||{},"number"==typeof n&&(n={duration:n}),a=!t.isEmptyObject(n),n.complete=o,n.delay&&s.delay(n.delay),a&&t.effects&&t.effects.effect[r]?s[e](n):r!==e&&s[r]?s[r](n.duration,n.easing,o):s.queue(function(i){t(this)[e](),o&&o.call(s[0]),i()})}})})(jQuery);(function(t){var e=!1;t(document).mouseup(function(){e=!1}),t.widget("ui.mouse",{version:"1.10.4",options:{cancel:"input,textarea,button,select,option",distance:1,delay:0},_mouseInit:function(){var e=this;this.element.bind("mousedown."+this.widgetName,function(t){return e._mouseDown(t)}).bind("click."+this.widgetName,function(i){return!0===t.data(i.target,e.widgetName+".preventClickEvent")?(t.removeData(i.target,e.widgetName+".preventClickEvent"),i.stopImmediatePropagation(),!1):undefined}),this.started=!1},_mouseDestroy:function(){this.element.unbind("."+this.widgetName),this._mouseMoveDelegate&&t(document).unbind("mousemove."+this.widgetName,this._mouseMoveDelegate).unbind("mouseup."+this.widgetName,this._mouseUpDelegate)},_mouseDown:function(i){if(!e){this._mouseStarted&&this._mouseUp(i),this._mouseDownEvent=i;var s=this,n=1===i.which,a="string"==typeof this.options.cancel&&i.target.nodeName?t(i.target).closest(this.options.cancel).length:!1;return n&&!a&&this._mouseCapture(i)?(this.mouseDelayMet=!this.options.delay,this.mouseDelayMet||(this._mouseDelayTimer=setTimeout(function(){s.mouseDelayMet=!0},this.options.delay)),this._mouseDistanceMet(i)&&this._mouseDelayMet(i)&&(this._mouseStarted=this._mouseStart(i)!==!1,!this._mouseStarted)?(i.preventDefault(),!0):(!0===t.data(i.target,this.widgetName+".preventClickEvent")&&t.removeData(i.target,this.widgetName+".preventClickEvent"),this._mouseMoveDelegate=function(t){return s._mouseMove(t)},this._mouseUpDelegate=function(t){return s._mouseUp(t)},t(document).bind("mousemove."+this.widgetName,this._mouseMoveDelegate).bind("mouseup."+this.widgetName,this._mouseUpDelegate),i.preventDefault(),e=!0,!0)):!0}},_mouseMove:function(e){return t.ui.ie&&(!document.documentMode||9>document.documentMode)&&!e.button?this._mouseUp(e):this._mouseStarted?(this._mouseDrag(e),e.preventDefault()):(this._mouseDistanceMet(e)&&this._mouseDelayMet(e)&&(this._mouseStarted=this._mouseStart(this._mouseDownEvent,e)!==!1,this._mouseStarted?this._mouseDrag(e):this._mouseUp(e)),!this._mouseStarted)},_mouseUp:function(e){return t(document).unbind("mousemove."+this.widgetName,this._mouseMoveDelegate).unbind("mouseup."+this.widgetName,this._mouseUpDelegate),this._mouseStarted&&(this._mouseStarted=!1,e.target===this._mouseDownEvent.target&&t.data(e.target,this.widgetName+".preventClickEvent",!0),this._mouseStop(e)),!1},_mouseDistanceMet:function(t){return Math.max(Math.abs(this._mouseDownEvent.pageX-t.pageX),Math.abs(this._mouseDownEvent.pageY-t.pageY))>=this.options.distance},_mouseDelayMet:function(){return this.mouseDelayMet},_mouseStart:function(){},_mouseDrag:function(){},_mouseStop:function(){},_mouseCapture:function(){return!0}})})(jQuery);(function(t){t.widget("ui.draggable",t.ui.mouse,{version:"1.10.4",widgetEventPrefix:"drag",options:{addClasses:!0,appendTo:"parent",axis:!1,connectToSortable:!1,containment:!1,cursor:"auto",cursorAt:!1,grid:!1,handle:!1,helper:"original",iframeFix:!1,opacity:!1,refreshPositions:!1,revert:!1,revertDuration:500,scope:"default",scroll:!0,scrollSensitivity:20,scrollSpeed:20,snap:!1,snapMode:"both",snapTolerance:20,stack:!1,zIndex:!1,drag:null,start:null,stop:null},_create:function(){"original"!==this.options.helper||/^(?:r|a|f)/.test(this.element.css("position"))||(this.element[0].style.position="relative"),this.options.addClasses&&this.element.addClass("ui-draggable"),this.options.disabled&&this.element.addClass("ui-draggable-disabled"),this._mouseInit()},_destroy:function(){this.element.removeClass("ui-draggable ui-draggable-dragging ui-draggable-disabled"),this._mouseDestroy()},_mouseCapture:function(e){var i=this.options;return this.helper||i.disabled||t(e.target).closest(".ui-resizable-handle").length>0?!1:(this.handle=this._getHandle(e),this.handle?(t(i.iframeFix===!0?"iframe":i.iframeFix).each(function(){t("<div class='ui-draggable-iframeFix' style='background: #fff;'></div>").css({width:this.offsetWidth+"px",height:this.offsetHeight+"px",position:"absolute",opacity:"0.001",zIndex:1e3}).css(t(this).offset()).appendTo("body")}),!0):!1)},_mouseStart:function(e){var i=this.options;return this.helper=this._createHelper(e),this.helper.addClass("ui-draggable-dragging"),this._cacheHelperProportions(),t.ui.ddmanager&&(t.ui.ddmanager.current=this),this._cacheMargins(),this.cssPosition=this.helper.css("position"),this.scrollParent=this.helper.scrollParent(),this.offsetParent=this.helper.offsetParent(),this.offsetParentCssPosition=this.offsetParent.css("position"),this.offset=this.positionAbs=this.element.offset(),this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left},this.offset.scroll=!1,t.extend(this.offset,{click:{left:e.pageX-this.offset.left,top:e.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()}),this.originalPosition=this.position=this._generatePosition(e),this.originalPageX=e.pageX,this.originalPageY=e.pageY,i.cursorAt&&this._adjustOffsetFromHelper(i.cursorAt),this._setContainment(),this._trigger("start",e)===!1?(this._clear(),!1):(this._cacheHelperProportions(),t.ui.ddmanager&&!i.dropBehaviour&&t.ui.ddmanager.prepareOffsets(this,e),this._mouseDrag(e,!0),t.ui.ddmanager&&t.ui.ddmanager.dragStart(this,e),!0)},_mouseDrag:function(e,i){if("fixed"===this.offsetParentCssPosition&&(this.offset.parent=this._getParentOffset()),this.position=this._generatePosition(e),this.positionAbs=this._convertPositionTo("absolute"),!i){var s=this._uiHash();if(this._trigger("drag",e,s)===!1)return this._mouseUp({}),!1;this.position=s.position}return this.options.axis&&"y"===this.options.axis||(this.helper[0].style.left=this.position.left+"px"),this.options.axis&&"x"===this.options.axis||(this.helper[0].style.top=this.position.top+"px"),t.ui.ddmanager&&t.ui.ddmanager.drag(this,e),!1},_mouseStop:function(e){var i=this,s=!1;return t.ui.ddmanager&&!this.options.dropBehaviour&&(s=t.ui.ddmanager.drop(this,e)),this.dropped&&(s=this.dropped,this.dropped=!1),"original"!==this.options.helper||t.contains(this.element[0].ownerDocument,this.element[0])?("invalid"===this.options.revert&&!s||"valid"===this.options.revert&&s||this.options.revert===!0||t.isFunction(this.options.revert)&&this.options.revert.call(this.element,s)?t(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){i._trigger("stop",e)!==!1&&i._clear()}):this._trigger("stop",e)!==!1&&this._clear(),!1):!1},_mouseUp:function(e){return t("div.ui-draggable-iframeFix").each(function(){this.parentNode.removeChild(this)}),t.ui.ddmanager&&t.ui.ddmanager.dragStop(this,e),t.ui.mouse.prototype._mouseUp.call(this,e)},cancel:function(){return this.helper.is(".ui-draggable-dragging")?this._mouseUp({}):this._clear(),this},_getHandle:function(e){return this.options.handle?!!t(e.target).closest(this.element.find(this.options.handle)).length:!0},_createHelper:function(e){var i=this.options,s=t.isFunction(i.helper)?t(i.helper.apply(this.element[0],[e])):"clone"===i.helper?this.element.clone().removeAttr("id"):this.element;return s.parents("body").length||s.appendTo("parent"===i.appendTo?this.element[0].parentNode:i.appendTo),s[0]===this.element[0]||/(fixed|absolute)/.test(s.css("position"))||s.css("position","absolute"),s},_adjustOffsetFromHelper:function(e){"string"==typeof e&&(e=e.split(" ")),t.isArray(e)&&(e={left:+e[0],top:+e[1]||0}),"left"in e&&(this.offset.click.left=e.left+this.margins.left),"right"in e&&(this.offset.click.left=this.helperProportions.width-e.right+this.margins.left),"top"in e&&(this.offset.click.top=e.top+this.margins.top),"bottom"in e&&(this.offset.click.top=this.helperProportions.height-e.bottom+this.margins.top)},_getParentOffset:function(){var e=this.offsetParent.offset();return"absolute"===this.cssPosition&&this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])&&(e.left+=this.scrollParent.scrollLeft(),e.top+=this.scrollParent.scrollTop()),(this.offsetParent[0]===document.body||this.offsetParent[0].tagName&&"html"===this.offsetParent[0].tagName.toLowerCase()&&t.ui.ie)&&(e={top:0,left:0}),{top:e.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:e.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if("relative"===this.cssPosition){var t=this.element.position();return{top:t.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:t.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}}return{top:0,left:0}},_cacheMargins:function(){this.margins={left:parseInt(this.element.css("marginLeft"),10)||0,top:parseInt(this.element.css("marginTop"),10)||0,right:parseInt(this.element.css("marginRight"),10)||0,bottom:parseInt(this.element.css("marginBottom"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var e,i,s,n=this.options;return n.containment?"window"===n.containment?(this.containment=[t(window).scrollLeft()-this.offset.relative.left-this.offset.parent.left,t(window).scrollTop()-this.offset.relative.top-this.offset.parent.top,t(window).scrollLeft()+t(window).width()-this.helperProportions.width-this.margins.left,t(window).scrollTop()+(t(window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top],undefined):"document"===n.containment?(this.containment=[0,0,t(document).width()-this.helperProportions.width-this.margins.left,(t(document).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top],undefined):n.containment.constructor===Array?(this.containment=n.containment,undefined):("parent"===n.containment&&(n.containment=this.helper[0].parentNode),i=t(n.containment),s=i[0],s&&(e="hidden"!==i.css("overflow"),this.containment=[(parseInt(i.css("borderLeftWidth"),10)||0)+(parseInt(i.css("paddingLeft"),10)||0),(parseInt(i.css("borderTopWidth"),10)||0)+(parseInt(i.css("paddingTop"),10)||0),(e?Math.max(s.scrollWidth,s.offsetWidth):s.offsetWidth)-(parseInt(i.css("borderRightWidth"),10)||0)-(parseInt(i.css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left-this.margins.right,(e?Math.max(s.scrollHeight,s.offsetHeight):s.offsetHeight)-(parseInt(i.css("borderBottomWidth"),10)||0)-(parseInt(i.css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top-this.margins.bottom],this.relative_container=i),undefined):(this.containment=null,undefined)},_convertPositionTo:function(e,i){i||(i=this.position);var s="absolute"===e?1:-1,n="absolute"!==this.cssPosition||this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent;return this.offset.scroll||(this.offset.scroll={top:n.scrollTop(),left:n.scrollLeft()}),{top:i.top+this.offset.relative.top*s+this.offset.parent.top*s-("fixed"===this.cssPosition?-this.scrollParent.scrollTop():this.offset.scroll.top)*s,left:i.left+this.offset.relative.left*s+this.offset.parent.left*s-("fixed"===this.cssPosition?-this.scrollParent.scrollLeft():this.offset.scroll.left)*s}},_generatePosition:function(e){var i,s,n,a,o=this.options,r="absolute"!==this.cssPosition||this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,l=e.pageX,h=e.pageY;return this.offset.scroll||(this.offset.scroll={top:r.scrollTop(),left:r.scrollLeft()}),this.originalPosition&&(this.containment&&(this.relative_container?(s=this.relative_container.offset(),i=[this.containment[0]+s.left,this.containment[1]+s.top,this.containment[2]+s.left,this.containment[3]+s.top]):i=this.containment,e.pageX-this.offset.click.left<i[0]&&(l=i[0]+this.offset.click.left),e.pageY-this.offset.click.top<i[1]&&(h=i[1]+this.offset.click.top),e.pageX-this.offset.click.left>i[2]&&(l=i[2]+this.offset.click.left),e.pageY-this.offset.click.top>i[3]&&(h=i[3]+this.offset.click.top)),o.grid&&(n=o.grid[1]?this.originalPageY+Math.round((h-this.originalPageY)/o.grid[1])*o.grid[1]:this.originalPageY,h=i?n-this.offset.click.top>=i[1]||n-this.offset.click.top>i[3]?n:n-this.offset.click.top>=i[1]?n-o.grid[1]:n+o.grid[1]:n,a=o.grid[0]?this.originalPageX+Math.round((l-this.originalPageX)/o.grid[0])*o.grid[0]:this.originalPageX,l=i?a-this.offset.click.left>=i[0]||a-this.offset.click.left>i[2]?a:a-this.offset.click.left>=i[0]?a-o.grid[0]:a+o.grid[0]:a)),{top:h-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+("fixed"===this.cssPosition?-this.scrollParent.scrollTop():this.offset.scroll.top),left:l-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+("fixed"===this.cssPosition?-this.scrollParent.scrollLeft():this.offset.scroll.left)}},_clear:function(){this.helper.removeClass("ui-draggable-dragging"),this.helper[0]===this.element[0]||this.cancelHelperRemoval||this.helper.remove(),this.helper=null,this.cancelHelperRemoval=!1},_trigger:function(e,i,s){return s=s||this._uiHash(),t.ui.plugin.call(this,e,[i,s]),"drag"===e&&(this.positionAbs=this._convertPositionTo("absolute")),t.Widget.prototype._trigger.call(this,e,i,s)},plugins:{},_uiHash:function(){return{helper:this.helper,position:this.position,originalPosition:this.originalPosition,offset:this.positionAbs}}}),t.ui.plugin.add("draggable","connectToSortable",{start:function(e,i){var s=t(this).data("ui-draggable"),n=s.options,a=t.extend({},i,{item:s.element});s.sortables=[],t(n.connectToSortable).each(function(){var i=t.data(this,"ui-sortable");i&&!i.options.disabled&&(s.sortables.push({instance:i,shouldRevert:i.options.revert}),i.refreshPositions(),i._trigger("activate",e,a))})},stop:function(e,i){var s=t(this).data("ui-draggable"),n=t.extend({},i,{item:s.element});t.each(s.sortables,function(){this.instance.isOver?(this.instance.isOver=0,s.cancelHelperRemoval=!0,this.instance.cancelHelperRemoval=!1,this.shouldRevert&&(this.instance.options.revert=this.shouldRevert),this.instance._mouseStop(e),this.instance.options.helper=this.instance.options._helper,"original"===s.options.helper&&this.instance.currentItem.css({top:"auto",left:"auto"})):(this.instance.cancelHelperRemoval=!1,this.instance._trigger("deactivate",e,n))})},drag:function(e,i){var s=t(this).data("ui-draggable"),n=this;t.each(s.sortables,function(){var a=!1,o=this;this.instance.positionAbs=s.positionAbs,this.instance.helperProportions=s.helperProportions,this.instance.offset.click=s.offset.click,this.instance._intersectsWith(this.instance.containerCache)&&(a=!0,t.each(s.sortables,function(){return this.instance.positionAbs=s.positionAbs,this.instance.helperProportions=s.helperProportions,this.instance.offset.click=s.offset.click,this!==o&&this.instance._intersectsWith(this.instance.containerCache)&&t.contains(o.instance.element[0],this.instance.element[0])&&(a=!1),a})),a?(this.instance.isOver||(this.instance.isOver=1,this.instance.currentItem=t(n).clone().removeAttr("id").appendTo(this.instance.element).data("ui-sortable-item",!0),this.instance.options._helper=this.instance.options.helper,this.instance.options.helper=function(){return i.helper[0]},e.target=this.instance.currentItem[0],this.instance._mouseCapture(e,!0),this.instance._mouseStart(e,!0,!0),this.instance.offset.click.top=s.offset.click.top,this.instance.offset.click.left=s.offset.click.left,this.instance.offset.parent.left-=s.offset.parent.left-this.instance.offset.parent.left,this.instance.offset.parent.top-=s.offset.parent.top-this.instance.offset.parent.top,s._trigger("toSortable",e),s.dropped=this.instance.element,s.currentItem=s.element,this.instance.fromOutside=s),this.instance.currentItem&&this.instance._mouseDrag(e)):this.instance.isOver&&(this.instance.isOver=0,this.instance.cancelHelperRemoval=!0,this.instance.options.revert=!1,this.instance._trigger("out",e,this.instance._uiHash(this.instance)),this.instance._mouseStop(e,!0),this.instance.options.helper=this.instance.options._helper,this.instance.currentItem.remove(),this.instance.placeholder&&this.instance.placeholder.remove(),s._trigger("fromSortable",e),s.dropped=!1)})}}),t.ui.plugin.add("draggable","cursor",{start:function(){var e=t("body"),i=t(this).data("ui-draggable").options;e.css("cursor")&&(i._cursor=e.css("cursor")),e.css("cursor",i.cursor)},stop:function(){var e=t(this).data("ui-draggable").options;e._cursor&&t("body").css("cursor",e._cursor)}}),t.ui.plugin.add("draggable","opacity",{start:function(e,i){var s=t(i.helper),n=t(this).data("ui-draggable").options;s.css("opacity")&&(n._opacity=s.css("opacity")),s.css("opacity",n.opacity)},stop:function(e,i){var s=t(this).data("ui-draggable").options;s._opacity&&t(i.helper).css("opacity",s._opacity)}}),t.ui.plugin.add("draggable","scroll",{start:function(){var e=t(this).data("ui-draggable");e.scrollParent[0]!==document&&"HTML"!==e.scrollParent[0].tagName&&(e.overflowOffset=e.scrollParent.offset())},drag:function(e){var i=t(this).data("ui-draggable"),s=i.options,n=!1;i.scrollParent[0]!==document&&"HTML"!==i.scrollParent[0].tagName?(s.axis&&"x"===s.axis||(i.overflowOffset.top+i.scrollParent[0].offsetHeight-e.pageY<s.scrollSensitivity?i.scrollParent[0].scrollTop=n=i.scrollParent[0].scrollTop+s.scrollSpeed:e.pageY-i.overflowOffset.top<s.scrollSensitivity&&(i.scrollParent[0].scrollTop=n=i.scrollParent[0].scrollTop-s.scrollSpeed)),s.axis&&"y"===s.axis||(i.overflowOffset.left+i.scrollParent[0].offsetWidth-e.pageX<s.scrollSensitivity?i.scrollParent[0].scrollLeft=n=i.scrollParent[0].scrollLeft+s.scrollSpeed:e.pageX-i.overflowOffset.left<s.scrollSensitivity&&(i.scrollParent[0].scrollLeft=n=i.scrollParent[0].scrollLeft-s.scrollSpeed))):(s.axis&&"x"===s.axis||(e.pageY-t(document).scrollTop()<s.scrollSensitivity?n=t(document).scrollTop(t(document).scrollTop()-s.scrollSpeed):t(window).height()-(e.pageY-t(document).scrollTop())<s.scrollSensitivity&&(n=t(document).scrollTop(t(document).scrollTop()+s.scrollSpeed))),s.axis&&"y"===s.axis||(e.pageX-t(document).scrollLeft()<s.scrollSensitivity?n=t(document).scrollLeft(t(document).scrollLeft()-s.scrollSpeed):t(window).width()-(e.pageX-t(document).scrollLeft())<s.scrollSensitivity&&(n=t(document).scrollLeft(t(document).scrollLeft()+s.scrollSpeed)))),n!==!1&&t.ui.ddmanager&&!s.dropBehaviour&&t.ui.ddmanager.prepareOffsets(i,e)}}),t.ui.plugin.add("draggable","snap",{start:function(){var e=t(this).data("ui-draggable"),i=e.options;e.snapElements=[],t(i.snap.constructor!==String?i.snap.items||":data(ui-draggable)":i.snap).each(function(){var i=t(this),s=i.offset();this!==e.element[0]&&e.snapElements.push({item:this,width:i.outerWidth(),height:i.outerHeight(),top:s.top,left:s.left})})},drag:function(e,i){var s,n,a,o,r,l,h,c,u,d,p=t(this).data("ui-draggable"),g=p.options,f=g.snapTolerance,m=i.offset.left,_=m+p.helperProportions.width,v=i.offset.top,b=v+p.helperProportions.height;for(u=p.snapElements.length-1;u>=0;u--)r=p.snapElements[u].left,l=r+p.snapElements[u].width,h=p.snapElements[u].top,c=h+p.snapElements[u].height,r-f>_||m>l+f||h-f>b||v>c+f||!t.contains(p.snapElements[u].item.ownerDocument,p.snapElements[u].item)?(p.snapElements[u].snapping&&p.options.snap.release&&p.options.snap.release.call(p.element,e,t.extend(p._uiHash(),{snapItem:p.snapElements[u].item})),p.snapElements[u].snapping=!1):("inner"!==g.snapMode&&(s=f>=Math.abs(h-b),n=f>=Math.abs(c-v),a=f>=Math.abs(r-_),o=f>=Math.abs(l-m),s&&(i.position.top=p._convertPositionTo("relative",{top:h-p.helperProportions.height,left:0}).top-p.margins.top),n&&(i.position.top=p._convertPositionTo("relative",{top:c,left:0}).top-p.margins.top),a&&(i.position.left=p._convertPositionTo("relative",{top:0,left:r-p.helperProportions.width}).left-p.margins.left),o&&(i.position.left=p._convertPositionTo("relative",{top:0,left:l}).left-p.margins.left)),d=s||n||a||o,"outer"!==g.snapMode&&(s=f>=Math.abs(h-v),n=f>=Math.abs(c-b),a=f>=Math.abs(r-m),o=f>=Math.abs(l-_),s&&(i.position.top=p._convertPositionTo("relative",{top:h,left:0}).top-p.margins.top),n&&(i.position.top=p._convertPositionTo("relative",{top:c-p.helperProportions.height,left:0}).top-p.margins.top),a&&(i.position.left=p._convertPositionTo("relative",{top:0,left:r}).left-p.margins.left),o&&(i.position.left=p._convertPositionTo("relative",{top:0,left:l-p.helperProportions.width}).left-p.margins.left)),!p.snapElements[u].snapping&&(s||n||a||o||d)&&p.options.snap.snap&&p.options.snap.snap.call(p.element,e,t.extend(p._uiHash(),{snapItem:p.snapElements[u].item})),p.snapElements[u].snapping=s||n||a||o||d)}}),t.ui.plugin.add("draggable","stack",{start:function(){var e,i=this.data("ui-draggable").options,s=t.makeArray(t(i.stack)).sort(function(e,i){return(parseInt(t(e).css("zIndex"),10)||0)-(parseInt(t(i).css("zIndex"),10)||0)});s.length&&(e=parseInt(t(s[0]).css("zIndex"),10)||0,t(s).each(function(i){t(this).css("zIndex",e+i)}),this.css("zIndex",e+s.length))}}),t.ui.plugin.add("draggable","zIndex",{start:function(e,i){var s=t(i.helper),n=t(this).data("ui-draggable").options;s.css("zIndex")&&(n._zIndex=s.css("zIndex")),s.css("zIndex",n.zIndex)},stop:function(e,i){var s=t(this).data("ui-draggable").options;s._zIndex&&t(i.helper).css("zIndex",s._zIndex)}})})(jQuery);(function(t){function e(t,e,i){return t>e&&e+i>t}t.widget("ui.droppable",{version:"1.10.4",widgetEventPrefix:"drop",options:{accept:"*",activeClass:!1,addClasses:!0,greedy:!1,hoverClass:!1,scope:"default",tolerance:"intersect",activate:null,deactivate:null,drop:null,out:null,over:null},_create:function(){var e,i=this.options,s=i.accept;this.isover=!1,this.isout=!0,this.accept=t.isFunction(s)?s:function(t){return t.is(s)},this.proportions=function(){return arguments.length?(e=arguments[0],undefined):e?e:e={width:this.element[0].offsetWidth,height:this.element[0].offsetHeight}},t.ui.ddmanager.droppables[i.scope]=t.ui.ddmanager.droppables[i.scope]||[],t.ui.ddmanager.droppables[i.scope].push(this),i.addClasses&&this.element.addClass("ui-droppable")},_destroy:function(){for(var e=0,i=t.ui.ddmanager.droppables[this.options.scope];i.length>e;e++)i[e]===this&&i.splice(e,1);this.element.removeClass("ui-droppable ui-droppable-disabled")},_setOption:function(e,i){"accept"===e&&(this.accept=t.isFunction(i)?i:function(t){return t.is(i)}),t.Widget.prototype._setOption.apply(this,arguments)},_activate:function(e){var i=t.ui.ddmanager.current;this.options.activeClass&&this.element.addClass(this.options.activeClass),i&&this._trigger("activate",e,this.ui(i))},_deactivate:function(e){var i=t.ui.ddmanager.current;this.options.activeClass&&this.element.removeClass(this.options.activeClass),i&&this._trigger("deactivate",e,this.ui(i))},_over:function(e){var i=t.ui.ddmanager.current;i&&(i.currentItem||i.element)[0]!==this.element[0]&&this.accept.call(this.element[0],i.currentItem||i.element)&&(this.options.hoverClass&&this.element.addClass(this.options.hoverClass),this._trigger("over",e,this.ui(i)))},_out:function(e){var i=t.ui.ddmanager.current;i&&(i.currentItem||i.element)[0]!==this.element[0]&&this.accept.call(this.element[0],i.currentItem||i.element)&&(this.options.hoverClass&&this.element.removeClass(this.options.hoverClass),this._trigger("out",e,this.ui(i)))},_drop:function(e,i){var s=i||t.ui.ddmanager.current,n=!1;return s&&(s.currentItem||s.element)[0]!==this.element[0]?(this.element.find(":data(ui-droppable)").not(".ui-draggable-dragging").each(function(){var e=t.data(this,"ui-droppable");return e.options.greedy&&!e.options.disabled&&e.options.scope===s.options.scope&&e.accept.call(e.element[0],s.currentItem||s.element)&&t.ui.intersect(s,t.extend(e,{offset:e.element.offset()}),e.options.tolerance)?(n=!0,!1):undefined}),n?!1:this.accept.call(this.element[0],s.currentItem||s.element)?(this.options.activeClass&&this.element.removeClass(this.options.activeClass),this.options.hoverClass&&this.element.removeClass(this.options.hoverClass),this._trigger("drop",e,this.ui(s)),this.element):!1):!1},ui:function(t){return{draggable:t.currentItem||t.element,helper:t.helper,position:t.position,offset:t.positionAbs}}}),t.ui.intersect=function(t,i,s){if(!i.offset)return!1;var n,a,o=(t.positionAbs||t.position.absolute).left,r=(t.positionAbs||t.position.absolute).top,l=o+t.helperProportions.width,h=r+t.helperProportions.height,c=i.offset.left,u=i.offset.top,d=c+i.proportions().width,p=u+i.proportions().height;switch(s){case"fit":return o>=c&&d>=l&&r>=u&&p>=h;case"intersect":return o+t.helperProportions.width/2>c&&d>l-t.helperProportions.width/2&&r+t.helperProportions.height/2>u&&p>h-t.helperProportions.height/2;case"pointer":return n=(t.positionAbs||t.position.absolute).left+(t.clickOffset||t.offset.click).left,a=(t.positionAbs||t.position.absolute).top+(t.clickOffset||t.offset.click).top,e(a,u,i.proportions().height)&&e(n,c,i.proportions().width);case"touch":return(r>=u&&p>=r||h>=u&&p>=h||u>r&&h>p)&&(o>=c&&d>=o||l>=c&&d>=l||c>o&&l>d);default:return!1}},t.ui.ddmanager={current:null,droppables:{"default":[]},prepareOffsets:function(e,i){var s,n,a=t.ui.ddmanager.droppables[e.options.scope]||[],o=i?i.type:null,r=(e.currentItem||e.element).find(":data(ui-droppable)").addBack();t:for(s=0;a.length>s;s++)if(!(a[s].options.disabled||e&&!a[s].accept.call(a[s].element[0],e.currentItem||e.element))){for(n=0;r.length>n;n++)if(r[n]===a[s].element[0]){a[s].proportions().height=0;continue t}a[s].visible="none"!==a[s].element.css("display"),a[s].visible&&("mousedown"===o&&a[s]._activate.call(a[s],i),a[s].offset=a[s].element.offset(),a[s].proportions({width:a[s].element[0].offsetWidth,height:a[s].element[0].offsetHeight}))}},drop:function(e,i){var s=!1;return t.each((t.ui.ddmanager.droppables[e.options.scope]||[]).slice(),function(){this.options&&(!this.options.disabled&&this.visible&&t.ui.intersect(e,this,this.options.tolerance)&&(s=this._drop.call(this,i)||s),!this.options.disabled&&this.visible&&this.accept.call(this.element[0],e.currentItem||e.element)&&(this.isout=!0,this.isover=!1,this._deactivate.call(this,i)))}),s},dragStart:function(e,i){e.element.parentsUntil("body").bind("scroll.droppable",function(){e.options.refreshPositions||t.ui.ddmanager.prepareOffsets(e,i)})},drag:function(e,i){e.options.refreshPositions&&t.ui.ddmanager.prepareOffsets(e,i),t.each(t.ui.ddmanager.droppables[e.options.scope]||[],function(){if(!this.options.disabled&&!this.greedyChild&&this.visible){var s,n,a,o=t.ui.intersect(e,this,this.options.tolerance),r=!o&&this.isover?"isout":o&&!this.isover?"isover":null;r&&(this.options.greedy&&(n=this.options.scope,a=this.element.parents(":data(ui-droppable)").filter(function(){return t.data(this,"ui-droppable").options.scope===n}),a.length&&(s=t.data(a[0],"ui-droppable"),s.greedyChild="isover"===r)),s&&"isover"===r&&(s.isover=!1,s.isout=!0,s._out.call(s,i)),this[r]=!0,this["isout"===r?"isover":"isout"]=!1,this["isover"===r?"_over":"_out"].call(this,i),s&&"isout"===r&&(s.isout=!1,s.isover=!0,s._over.call(s,i)))}})},dragStop:function(e,i){e.element.parentsUntil("body").unbind("scroll.droppable"),e.options.refreshPositions||t.ui.ddmanager.prepareOffsets(e,i)}}})(jQuery);(function(t){function e(t){return parseInt(t,10)||0}function i(t){return!isNaN(parseInt(t,10))}t.widget("ui.resizable",t.ui.mouse,{version:"1.10.4",widgetEventPrefix:"resize",options:{alsoResize:!1,animate:!1,animateDuration:"slow",animateEasing:"swing",aspectRatio:!1,autoHide:!1,containment:!1,ghost:!1,grid:!1,handles:"e,s,se",helper:!1,maxHeight:null,maxWidth:null,minHeight:10,minWidth:10,zIndex:90,resize:null,start:null,stop:null},_create:function(){var e,i,s,n,a,o=this,r=this.options;if(this.element.addClass("ui-resizable"),t.extend(this,{_aspectRatio:!!r.aspectRatio,aspectRatio:r.aspectRatio,originalElement:this.element,_proportionallyResizeElements:[],_helper:r.helper||r.ghost||r.animate?r.helper||"ui-resizable-helper":null}),this.element[0].nodeName.match(/canvas|textarea|input|select|button|img/i)&&(this.element.wrap(t("<div class='ui-wrapper' style='overflow: hidden;'></div>").css({position:this.element.css("position"),width:this.element.outerWidth(),height:this.element.outerHeight(),top:this.element.css("top"),left:this.element.css("left")})),this.element=this.element.parent().data("ui-resizable",this.element.data("ui-resizable")),this.elementIsWrapper=!0,this.element.css({marginLeft:this.originalElement.css("marginLeft"),marginTop:this.originalElement.css("marginTop"),marginRight:this.originalElement.css("marginRight"),marginBottom:this.originalElement.css("marginBottom")}),this.originalElement.css({marginLeft:0,marginTop:0,marginRight:0,marginBottom:0}),this.originalResizeStyle=this.originalElement.css("resize"),this.originalElement.css("resize","none"),this._proportionallyResizeElements.push(this.originalElement.css({position:"static",zoom:1,display:"block"})),this.originalElement.css({margin:this.originalElement.css("margin")}),this._proportionallyResize()),this.handles=r.handles||(t(".ui-resizable-handle",this.element).length?{n:".ui-resizable-n",e:".ui-resizable-e",s:".ui-resizable-s",w:".ui-resizable-w",se:".ui-resizable-se",sw:".ui-resizable-sw",ne:".ui-resizable-ne",nw:".ui-resizable-nw"}:"e,s,se"),this.handles.constructor===String)for("all"===this.handles&&(this.handles="n,e,s,w,se,sw,ne,nw"),e=this.handles.split(","),this.handles={},i=0;e.length>i;i++)s=t.trim(e[i]),a="ui-resizable-"+s,n=t("<div class='ui-resizable-handle "+a+"'></div>"),n.css({zIndex:r.zIndex}),"se"===s&&n.addClass("ui-icon ui-icon-gripsmall-diagonal-se"),this.handles[s]=".ui-resizable-"+s,this.element.append(n);this._renderAxis=function(e){var i,s,n,a;e=e||this.element;for(i in this.handles)this.handles[i].constructor===String&&(this.handles[i]=t(this.handles[i],this.element).show()),this.elementIsWrapper&&this.originalElement[0].nodeName.match(/textarea|input|select|button/i)&&(s=t(this.handles[i],this.element),a=/sw|ne|nw|se|n|s/.test(i)?s.outerHeight():s.outerWidth(),n=["padding",/ne|nw|n/.test(i)?"Top":/se|sw|s/.test(i)?"Bottom":/^e$/.test(i)?"Right":"Left"].join(""),e.css(n,a),this._proportionallyResize()),t(this.handles[i]).length},this._renderAxis(this.element),this._handles=t(".ui-resizable-handle",this.element).disableSelection(),this._handles.mouseover(function(){o.resizing||(this.className&&(n=this.className.match(/ui-resizable-(se|sw|ne|nw|n|e|s|w)/i)),o.axis=n&&n[1]?n[1]:"se")}),r.autoHide&&(this._handles.hide(),t(this.element).addClass("ui-resizable-autohide").mouseenter(function(){r.disabled||(t(this).removeClass("ui-resizable-autohide"),o._handles.show())}).mouseleave(function(){r.disabled||o.resizing||(t(this).addClass("ui-resizable-autohide"),o._handles.hide())})),this._mouseInit()},_destroy:function(){this._mouseDestroy();var e,i=function(e){t(e).removeClass("ui-resizable ui-resizable-disabled ui-resizable-resizing").removeData("resizable").removeData("ui-resizable").unbind(".resizable").find(".ui-resizable-handle").remove()};return this.elementIsWrapper&&(i(this.element),e=this.element,this.originalElement.css({position:e.css("position"),width:e.outerWidth(),height:e.outerHeight(),top:e.css("top"),left:e.css("left")}).insertAfter(e),e.remove()),this.originalElement.css("resize",this.originalResizeStyle),i(this.originalElement),this},_mouseCapture:function(e){var i,s,n=!1;for(i in this.handles)s=t(this.handles[i])[0],(s===e.target||t.contains(s,e.target))&&(n=!0);return!this.options.disabled&&n},_mouseStart:function(i){var s,n,a,o=this.options,r=this.element.position(),h=this.element;return this.resizing=!0,/absolute/.test(h.css("position"))?h.css({position:"absolute",top:h.css("top"),left:h.css("left")}):h.is(".ui-draggable")&&h.css({position:"absolute",top:r.top,left:r.left}),this._renderProxy(),s=e(this.helper.css("left")),n=e(this.helper.css("top")),o.containment&&(s+=t(o.containment).scrollLeft()||0,n+=t(o.containment).scrollTop()||0),this.offset=this.helper.offset(),this.position={left:s,top:n},this.size=this._helper?{width:this.helper.width(),height:this.helper.height()}:{width:h.width(),height:h.height()},this.originalSize=this._helper?{width:h.outerWidth(),height:h.outerHeight()}:{width:h.width(),height:h.height()},this.originalPosition={left:s,top:n},this.sizeDiff={width:h.outerWidth()-h.width(),height:h.outerHeight()-h.height()},this.originalMousePosition={left:i.pageX,top:i.pageY},this.aspectRatio="number"==typeof o.aspectRatio?o.aspectRatio:this.originalSize.width/this.originalSize.height||1,a=t(".ui-resizable-"+this.axis).css("cursor"),t("body").css("cursor","auto"===a?this.axis+"-resize":a),h.addClass("ui-resizable-resizing"),this._propagate("start",i),!0},_mouseDrag:function(e){var i,s=this.helper,n={},a=this.originalMousePosition,o=this.axis,r=this.position.top,h=this.position.left,l=this.size.width,c=this.size.height,u=e.pageX-a.left||0,d=e.pageY-a.top||0,p=this._change[o];return p?(i=p.apply(this,[e,u,d]),this._updateVirtualBoundaries(e.shiftKey),(this._aspectRatio||e.shiftKey)&&(i=this._updateRatio(i,e)),i=this._respectSize(i,e),this._updateCache(i),this._propagate("resize",e),this.position.top!==r&&(n.top=this.position.top+"px"),this.position.left!==h&&(n.left=this.position.left+"px"),this.size.width!==l&&(n.width=this.size.width+"px"),this.size.height!==c&&(n.height=this.size.height+"px"),s.css(n),!this._helper&&this._proportionallyResizeElements.length&&this._proportionallyResize(),t.isEmptyObject(n)||this._trigger("resize",e,this.ui()),!1):!1},_mouseStop:function(e){this.resizing=!1;var i,s,n,a,o,r,h,l=this.options,c=this;return this._helper&&(i=this._proportionallyResizeElements,s=i.length&&/textarea/i.test(i[0].nodeName),n=s&&t.ui.hasScroll(i[0],"left")?0:c.sizeDiff.height,a=s?0:c.sizeDiff.width,o={width:c.helper.width()-a,height:c.helper.height()-n},r=parseInt(c.element.css("left"),10)+(c.position.left-c.originalPosition.left)||null,h=parseInt(c.element.css("top"),10)+(c.position.top-c.originalPosition.top)||null,l.animate||this.element.css(t.extend(o,{top:h,left:r})),c.helper.height(c.size.height),c.helper.width(c.size.width),this._helper&&!l.animate&&this._proportionallyResize()),t("body").css("cursor","auto"),this.element.removeClass("ui-resizable-resizing"),this._propagate("stop",e),this._helper&&this.helper.remove(),!1},_updateVirtualBoundaries:function(t){var e,s,n,a,o,r=this.options;o={minWidth:i(r.minWidth)?r.minWidth:0,maxWidth:i(r.maxWidth)?r.maxWidth:1/0,minHeight:i(r.minHeight)?r.minHeight:0,maxHeight:i(r.maxHeight)?r.maxHeight:1/0},(this._aspectRatio||t)&&(e=o.minHeight*this.aspectRatio,n=o.minWidth/this.aspectRatio,s=o.maxHeight*this.aspectRatio,a=o.maxWidth/this.aspectRatio,e>o.minWidth&&(o.minWidth=e),n>o.minHeight&&(o.minHeight=n),o.maxWidth>s&&(o.maxWidth=s),o.maxHeight>a&&(o.maxHeight=a)),this._vBoundaries=o},_updateCache:function(t){this.offset=this.helper.offset(),i(t.left)&&(this.position.left=t.left),i(t.top)&&(this.position.top=t.top),i(t.height)&&(this.size.height=t.height),i(t.width)&&(this.size.width=t.width)},_updateRatio:function(t){var e=this.position,s=this.size,n=this.axis;return i(t.height)?t.width=t.height*this.aspectRatio:i(t.width)&&(t.height=t.width/this.aspectRatio),"sw"===n&&(t.left=e.left+(s.width-t.width),t.top=null),"nw"===n&&(t.top=e.top+(s.height-t.height),t.left=e.left+(s.width-t.width)),t},_respectSize:function(t){var e=this._vBoundaries,s=this.axis,n=i(t.width)&&e.maxWidth&&e.maxWidth<t.width,a=i(t.height)&&e.maxHeight&&e.maxHeight<t.height,o=i(t.width)&&e.minWidth&&e.minWidth>t.width,r=i(t.height)&&e.minHeight&&e.minHeight>t.height,h=this.originalPosition.left+this.originalSize.width,l=this.position.top+this.size.height,c=/sw|nw|w/.test(s),u=/nw|ne|n/.test(s);return o&&(t.width=e.minWidth),r&&(t.height=e.minHeight),n&&(t.width=e.maxWidth),a&&(t.height=e.maxHeight),o&&c&&(t.left=h-e.minWidth),n&&c&&(t.left=h-e.maxWidth),r&&u&&(t.top=l-e.minHeight),a&&u&&(t.top=l-e.maxHeight),t.width||t.height||t.left||!t.top?t.width||t.height||t.top||!t.left||(t.left=null):t.top=null,t},_proportionallyResize:function(){if(this._proportionallyResizeElements.length){var t,e,i,s,n,a=this.helper||this.element;for(t=0;this._proportionallyResizeElements.length>t;t++){if(n=this._proportionallyResizeElements[t],!this.borderDif)for(this.borderDif=[],i=[n.css("borderTopWidth"),n.css("borderRightWidth"),n.css("borderBottomWidth"),n.css("borderLeftWidth")],s=[n.css("paddingTop"),n.css("paddingRight"),n.css("paddingBottom"),n.css("paddingLeft")],e=0;i.length>e;e++)this.borderDif[e]=(parseInt(i[e],10)||0)+(parseInt(s[e],10)||0);n.css({height:a.height()-this.borderDif[0]-this.borderDif[2]||0,width:a.width()-this.borderDif[1]-this.borderDif[3]||0})}}},_renderProxy:function(){var e=this.element,i=this.options;this.elementOffset=e.offset(),this._helper?(this.helper=this.helper||t("<div style='overflow:hidden;'></div>"),this.helper.addClass(this._helper).css({width:this.element.outerWidth()-1,height:this.element.outerHeight()-1,position:"absolute",left:this.elementOffset.left+"px",top:this.elementOffset.top+"px",zIndex:++i.zIndex}),this.helper.appendTo("body").disableSelection()):this.helper=this.element},_change:{e:function(t,e){return{width:this.originalSize.width+e}},w:function(t,e){var i=this.originalSize,s=this.originalPosition;return{left:s.left+e,width:i.width-e}},n:function(t,e,i){var s=this.originalSize,n=this.originalPosition;return{top:n.top+i,height:s.height-i}},s:function(t,e,i){return{height:this.originalSize.height+i}},se:function(e,i,s){return t.extend(this._change.s.apply(this,arguments),this._change.e.apply(this,[e,i,s]))},sw:function(e,i,s){return t.extend(this._change.s.apply(this,arguments),this._change.w.apply(this,[e,i,s]))},ne:function(e,i,s){return t.extend(this._change.n.apply(this,arguments),this._change.e.apply(this,[e,i,s]))},nw:function(e,i,s){return t.extend(this._change.n.apply(this,arguments),this._change.w.apply(this,[e,i,s]))}},_propagate:function(e,i){t.ui.plugin.call(this,e,[i,this.ui()]),"resize"!==e&&this._trigger(e,i,this.ui())},plugins:{},ui:function(){return{originalElement:this.originalElement,element:this.element,helper:this.helper,position:this.position,size:this.size,originalSize:this.originalSize,originalPosition:this.originalPosition}}}),t.ui.plugin.add("resizable","animate",{stop:function(e){var i=t(this).data("ui-resizable"),s=i.options,n=i._proportionallyResizeElements,a=n.length&&/textarea/i.test(n[0].nodeName),o=a&&t.ui.hasScroll(n[0],"left")?0:i.sizeDiff.height,r=a?0:i.sizeDiff.width,h={width:i.size.width-r,height:i.size.height-o},l=parseInt(i.element.css("left"),10)+(i.position.left-i.originalPosition.left)||null,c=parseInt(i.element.css("top"),10)+(i.position.top-i.originalPosition.top)||null;i.element.animate(t.extend(h,c&&l?{top:c,left:l}:{}),{duration:s.animateDuration,easing:s.animateEasing,step:function(){var s={width:parseInt(i.element.css("width"),10),height:parseInt(i.element.css("height"),10),top:parseInt(i.element.css("top"),10),left:parseInt(i.element.css("left"),10)};n&&n.length&&t(n[0]).css({width:s.width,height:s.height}),i._updateCache(s),i._propagate("resize",e)}})}}),t.ui.plugin.add("resizable","containment",{start:function(){var i,s,n,a,o,r,h,l=t(this).data("ui-resizable"),c=l.options,u=l.element,d=c.containment,p=d instanceof t?d.get(0):/parent/.test(d)?u.parent().get(0):d;p&&(l.containerElement=t(p),/document/.test(d)||d===document?(l.containerOffset={left:0,top:0},l.containerPosition={left:0,top:0},l.parentData={element:t(document),left:0,top:0,width:t(document).width(),height:t(document).height()||document.body.parentNode.scrollHeight}):(i=t(p),s=[],t(["Top","Right","Left","Bottom"]).each(function(t,n){s[t]=e(i.css("padding"+n))}),l.containerOffset=i.offset(),l.containerPosition=i.position(),l.containerSize={height:i.innerHeight()-s[3],width:i.innerWidth()-s[1]},n=l.containerOffset,a=l.containerSize.height,o=l.containerSize.width,r=t.ui.hasScroll(p,"left")?p.scrollWidth:o,h=t.ui.hasScroll(p)?p.scrollHeight:a,l.parentData={element:p,left:n.left,top:n.top,width:r,height:h}))},resize:function(e){var i,s,n,a,o=t(this).data("ui-resizable"),r=o.options,h=o.containerOffset,l=o.position,c=o._aspectRatio||e.shiftKey,u={top:0,left:0},d=o.containerElement;d[0]!==document&&/static/.test(d.css("position"))&&(u=h),l.left<(o._helper?h.left:0)&&(o.size.width=o.size.width+(o._helper?o.position.left-h.left:o.position.left-u.left),c&&(o.size.height=o.size.width/o.aspectRatio),o.position.left=r.helper?h.left:0),l.top<(o._helper?h.top:0)&&(o.size.height=o.size.height+(o._helper?o.position.top-h.top:o.position.top),c&&(o.size.width=o.size.height*o.aspectRatio),o.position.top=o._helper?h.top:0),o.offset.left=o.parentData.left+o.position.left,o.offset.top=o.parentData.top+o.position.top,i=Math.abs((o._helper?o.offset.left-u.left:o.offset.left-u.left)+o.sizeDiff.width),s=Math.abs((o._helper?o.offset.top-u.top:o.offset.top-h.top)+o.sizeDiff.height),n=o.containerElement.get(0)===o.element.parent().get(0),a=/relative|absolute/.test(o.containerElement.css("position")),n&&a&&(i-=Math.abs(o.parentData.left)),i+o.size.width>=o.parentData.width&&(o.size.width=o.parentData.width-i,c&&(o.size.height=o.size.width/o.aspectRatio)),s+o.size.height>=o.parentData.height&&(o.size.height=o.parentData.height-s,c&&(o.size.width=o.size.height*o.aspectRatio))},stop:function(){var e=t(this).data("ui-resizable"),i=e.options,s=e.containerOffset,n=e.containerPosition,a=e.containerElement,o=t(e.helper),r=o.offset(),h=o.outerWidth()-e.sizeDiff.width,l=o.outerHeight()-e.sizeDiff.height;e._helper&&!i.animate&&/relative/.test(a.css("position"))&&t(this).css({left:r.left-n.left-s.left,width:h,height:l}),e._helper&&!i.animate&&/static/.test(a.css("position"))&&t(this).css({left:r.left-n.left-s.left,width:h,height:l})}}),t.ui.plugin.add("resizable","alsoResize",{start:function(){var e=t(this).data("ui-resizable"),i=e.options,s=function(e){t(e).each(function(){var e=t(this);e.data("ui-resizable-alsoresize",{width:parseInt(e.width(),10),height:parseInt(e.height(),10),left:parseInt(e.css("left"),10),top:parseInt(e.css("top"),10)})})};"object"!=typeof i.alsoResize||i.alsoResize.parentNode?s(i.alsoResize):i.alsoResize.length?(i.alsoResize=i.alsoResize[0],s(i.alsoResize)):t.each(i.alsoResize,function(t){s(t)})},resize:function(e,i){var s=t(this).data("ui-resizable"),n=s.options,a=s.originalSize,o=s.originalPosition,r={height:s.size.height-a.height||0,width:s.size.width-a.width||0,top:s.position.top-o.top||0,left:s.position.left-o.left||0},h=function(e,s){t(e).each(function(){var e=t(this),n=t(this).data("ui-resizable-alsoresize"),a={},o=s&&s.length?s:e.parents(i.originalElement[0]).length?["width","height"]:["width","height","top","left"];t.each(o,function(t,e){var i=(n[e]||0)+(r[e]||0);i&&i>=0&&(a[e]=i||null)}),e.css(a)})};"object"!=typeof n.alsoResize||n.alsoResize.nodeType?h(n.alsoResize):t.each(n.alsoResize,function(t,e){h(t,e)})},stop:function(){t(this).removeData("resizable-alsoresize")}}),t.ui.plugin.add("resizable","ghost",{start:function(){var e=t(this).data("ui-resizable"),i=e.options,s=e.size;e.ghost=e.originalElement.clone(),e.ghost.css({opacity:.25,display:"block",position:"relative",height:s.height,width:s.width,margin:0,left:0,top:0}).addClass("ui-resizable-ghost").addClass("string"==typeof i.ghost?i.ghost:""),e.ghost.appendTo(e.helper)},resize:function(){var e=t(this).data("ui-resizable");e.ghost&&e.ghost.css({position:"relative",height:e.size.height,width:e.size.width})},stop:function(){var e=t(this).data("ui-resizable");e.ghost&&e.helper&&e.helper.get(0).removeChild(e.ghost.get(0))}}),t.ui.plugin.add("resizable","grid",{resize:function(){var e=t(this).data("ui-resizable"),i=e.options,s=e.size,n=e.originalSize,a=e.originalPosition,o=e.axis,r="number"==typeof i.grid?[i.grid,i.grid]:i.grid,h=r[0]||1,l=r[1]||1,c=Math.round((s.width-n.width)/h)*h,u=Math.round((s.height-n.height)/l)*l,d=n.width+c,p=n.height+u,f=i.maxWidth&&d>i.maxWidth,g=i.maxHeight&&p>i.maxHeight,m=i.minWidth&&i.minWidth>d,v=i.minHeight&&i.minHeight>p;i.grid=r,m&&(d+=h),v&&(p+=l),f&&(d-=h),g&&(p-=l),/^(se|s|e)$/.test(o)?(e.size.width=d,e.size.height=p):/^(ne)$/.test(o)?(e.size.width=d,e.size.height=p,e.position.top=a.top-u):/^(sw)$/.test(o)?(e.size.width=d,e.size.height=p,e.position.left=a.left-c):(p-l>0?(e.size.height=p,e.position.top=a.top-u):(e.size.height=l,e.position.top=a.top+n.height-l),d-h>0?(e.size.width=d,e.position.left=a.left-c):(e.size.width=h,e.position.left=a.left+n.width-h))}})})(jQuery);(function(t){t.widget("ui.selectable",t.ui.mouse,{version:"1.10.4",options:{appendTo:"body",autoRefresh:!0,distance:0,filter:"*",tolerance:"touch",selected:null,selecting:null,start:null,stop:null,unselected:null,unselecting:null},_create:function(){var e,i=this;this.element.addClass("ui-selectable"),this.dragged=!1,this.refresh=function(){e=t(i.options.filter,i.element[0]),e.addClass("ui-selectee"),e.each(function(){var e=t(this),i=e.offset();t.data(this,"selectable-item",{element:this,$element:e,left:i.left,top:i.top,right:i.left+e.outerWidth(),bottom:i.top+e.outerHeight(),startselected:!1,selected:e.hasClass("ui-selected"),selecting:e.hasClass("ui-selecting"),unselecting:e.hasClass("ui-unselecting")})})},this.refresh(),this.selectees=e.addClass("ui-selectee"),this._mouseInit(),this.helper=t("<div class='ui-selectable-helper'></div>")},_destroy:function(){this.selectees.removeClass("ui-selectee").removeData("selectable-item"),this.element.removeClass("ui-selectable ui-selectable-disabled"),this._mouseDestroy()},_mouseStart:function(e){var i=this,s=this.options;this.opos=[e.pageX,e.pageY],this.options.disabled||(this.selectees=t(s.filter,this.element[0]),this._trigger("start",e),t(s.appendTo).append(this.helper),this.helper.css({left:e.pageX,top:e.pageY,width:0,height:0}),s.autoRefresh&&this.refresh(),this.selectees.filter(".ui-selected").each(function(){var s=t.data(this,"selectable-item");s.startselected=!0,e.metaKey||e.ctrlKey||(s.$element.removeClass("ui-selected"),s.selected=!1,s.$element.addClass("ui-unselecting"),s.unselecting=!0,i._trigger("unselecting",e,{unselecting:s.element}))}),t(e.target).parents().addBack().each(function(){var s,n=t.data(this,"selectable-item");return n?(s=!e.metaKey&&!e.ctrlKey||!n.$element.hasClass("ui-selected"),n.$element.removeClass(s?"ui-unselecting":"ui-selected").addClass(s?"ui-selecting":"ui-unselecting"),n.unselecting=!s,n.selecting=s,n.selected=s,s?i._trigger("selecting",e,{selecting:n.element}):i._trigger("unselecting",e,{unselecting:n.element}),!1):undefined}))},_mouseDrag:function(e){if(this.dragged=!0,!this.options.disabled){var i,s=this,n=this.options,a=this.opos[0],o=this.opos[1],r=e.pageX,l=e.pageY;return a>r&&(i=r,r=a,a=i),o>l&&(i=l,l=o,o=i),this.helper.css({left:a,top:o,width:r-a,height:l-o}),this.selectees.each(function(){var i=t.data(this,"selectable-item"),h=!1;i&&i.element!==s.element[0]&&("touch"===n.tolerance?h=!(i.left>r||a>i.right||i.top>l||o>i.bottom):"fit"===n.tolerance&&(h=i.left>a&&r>i.right&&i.top>o&&l>i.bottom),h?(i.selected&&(i.$element.removeClass("ui-selected"),i.selected=!1),i.unselecting&&(i.$element.removeClass("ui-unselecting"),i.unselecting=!1),i.selecting||(i.$element.addClass("ui-selecting"),i.selecting=!0,s._trigger("selecting",e,{selecting:i.element}))):(i.selecting&&((e.metaKey||e.ctrlKey)&&i.startselected?(i.$element.removeClass("ui-selecting"),i.selecting=!1,i.$element.addClass("ui-selected"),i.selected=!0):(i.$element.removeClass("ui-selecting"),i.selecting=!1,i.startselected&&(i.$element.addClass("ui-unselecting"),i.unselecting=!0),s._trigger("unselecting",e,{unselecting:i.element}))),i.selected&&(e.metaKey||e.ctrlKey||i.startselected||(i.$element.removeClass("ui-selected"),i.selected=!1,i.$element.addClass("ui-unselecting"),i.unselecting=!0,s._trigger("unselecting",e,{unselecting:i.element})))))}),!1}},_mouseStop:function(e){var i=this;return this.dragged=!1,t(".ui-unselecting",this.element[0]).each(function(){var s=t.data(this,"selectable-item");s.$element.removeClass("ui-unselecting"),s.unselecting=!1,s.startselected=!1,i._trigger("unselected",e,{unselected:s.element})}),t(".ui-selecting",this.element[0]).each(function(){var s=t.data(this,"selectable-item");s.$element.removeClass("ui-selecting").addClass("ui-selected"),s.selecting=!1,s.selected=!0,s.startselected=!0,i._trigger("selected",e,{selected:s.element})}),this._trigger("stop",e),this.helper.remove(),!1}})})(jQuery);(function(t){function e(t,e,i){return t>e&&e+i>t}function i(t){return/left|right/.test(t.css("float"))||/inline|table-cell/.test(t.css("display"))}t.widget("ui.sortable",t.ui.mouse,{version:"1.10.4",widgetEventPrefix:"sort",ready:!1,options:{appendTo:"parent",axis:!1,connectWith:!1,containment:!1,cursor:"auto",cursorAt:!1,dropOnEmpty:!0,forcePlaceholderSize:!1,forceHelperSize:!1,grid:!1,handle:!1,helper:"original",items:"> *",opacity:!1,placeholder:!1,revert:!1,scroll:!0,scrollSensitivity:20,scrollSpeed:20,scope:"default",tolerance:"intersect",zIndex:1e3,activate:null,beforeStop:null,change:null,deactivate:null,out:null,over:null,receive:null,remove:null,sort:null,start:null,stop:null,update:null},_create:function(){var t=this.options;this.containerCache={},this.element.addClass("ui-sortable"),this.refresh(),this.floating=this.items.length?"x"===t.axis||i(this.items[0].item):!1,this.offset=this.element.offset(),this._mouseInit(),this.ready=!0},_destroy:function(){this.element.removeClass("ui-sortable ui-sortable-disabled"),this._mouseDestroy();for(var t=this.items.length-1;t>=0;t--)this.items[t].item.removeData(this.widgetName+"-item");return this},_setOption:function(e,i){"disabled"===e?(this.options[e]=i,this.widget().toggleClass("ui-sortable-disabled",!!i)):t.Widget.prototype._setOption.apply(this,arguments)},_mouseCapture:function(e,i){var s=null,n=!1,o=this;return this.reverting?!1:this.options.disabled||"static"===this.options.type?!1:(this._refreshItems(e),t(e.target).parents().each(function(){return t.data(this,o.widgetName+"-item")===o?(s=t(this),!1):undefined}),t.data(e.target,o.widgetName+"-item")===o&&(s=t(e.target)),s?!this.options.handle||i||(t(this.options.handle,s).find("*").addBack().each(function(){this===e.target&&(n=!0)}),n)?(this.currentItem=s,this._removeCurrentsFromItems(),!0):!1:!1)},_mouseStart:function(e,i,s){var n,o,a=this.options;if(this.currentContainer=this,this.refreshPositions(),this.helper=this._createHelper(e),this._cacheHelperProportions(),this._cacheMargins(),this.scrollParent=this.helper.scrollParent(),this.offset=this.currentItem.offset(),this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left},t.extend(this.offset,{click:{left:e.pageX-this.offset.left,top:e.pageY-this.offset.top},parent:this._getParentOffset(),relative:this._getRelativeOffset()}),this.helper.css("position","absolute"),this.cssPosition=this.helper.css("position"),this.originalPosition=this._generatePosition(e),this.originalPageX=e.pageX,this.originalPageY=e.pageY,a.cursorAt&&this._adjustOffsetFromHelper(a.cursorAt),this.domPosition={prev:this.currentItem.prev()[0],parent:this.currentItem.parent()[0]},this.helper[0]!==this.currentItem[0]&&this.currentItem.hide(),this._createPlaceholder(),a.containment&&this._setContainment(),a.cursor&&"auto"!==a.cursor&&(o=this.document.find("body"),this.storedCursor=o.css("cursor"),o.css("cursor",a.cursor),this.storedStylesheet=t("<style>*{ cursor: "+a.cursor+" !important; }</style>").appendTo(o)),a.opacity&&(this.helper.css("opacity")&&(this._storedOpacity=this.helper.css("opacity")),this.helper.css("opacity",a.opacity)),a.zIndex&&(this.helper.css("zIndex")&&(this._storedZIndex=this.helper.css("zIndex")),this.helper.css("zIndex",a.zIndex)),this.scrollParent[0]!==document&&"HTML"!==this.scrollParent[0].tagName&&(this.overflowOffset=this.scrollParent.offset()),this._trigger("start",e,this._uiHash()),this._preserveHelperProportions||this._cacheHelperProportions(),!s)for(n=this.containers.length-1;n>=0;n--)this.containers[n]._trigger("activate",e,this._uiHash(this));return t.ui.ddmanager&&(t.ui.ddmanager.current=this),t.ui.ddmanager&&!a.dropBehaviour&&t.ui.ddmanager.prepareOffsets(this,e),this.dragging=!0,this.helper.addClass("ui-sortable-helper"),this._mouseDrag(e),!0},_mouseDrag:function(e){var i,s,n,o,a=this.options,r=!1;for(this.position=this._generatePosition(e),this.positionAbs=this._convertPositionTo("absolute"),this.lastPositionAbs||(this.lastPositionAbs=this.positionAbs),this.options.scroll&&(this.scrollParent[0]!==document&&"HTML"!==this.scrollParent[0].tagName?(this.overflowOffset.top+this.scrollParent[0].offsetHeight-e.pageY<a.scrollSensitivity?this.scrollParent[0].scrollTop=r=this.scrollParent[0].scrollTop+a.scrollSpeed:e.pageY-this.overflowOffset.top<a.scrollSensitivity&&(this.scrollParent[0].scrollTop=r=this.scrollParent[0].scrollTop-a.scrollSpeed),this.overflowOffset.left+this.scrollParent[0].offsetWidth-e.pageX<a.scrollSensitivity?this.scrollParent[0].scrollLeft=r=this.scrollParent[0].scrollLeft+a.scrollSpeed:e.pageX-this.overflowOffset.left<a.scrollSensitivity&&(this.scrollParent[0].scrollLeft=r=this.scrollParent[0].scrollLeft-a.scrollSpeed)):(e.pageY-t(document).scrollTop()<a.scrollSensitivity?r=t(document).scrollTop(t(document).scrollTop()-a.scrollSpeed):t(window).height()-(e.pageY-t(document).scrollTop())<a.scrollSensitivity&&(r=t(document).scrollTop(t(document).scrollTop()+a.scrollSpeed)),e.pageX-t(document).scrollLeft()<a.scrollSensitivity?r=t(document).scrollLeft(t(document).scrollLeft()-a.scrollSpeed):t(window).width()-(e.pageX-t(document).scrollLeft())<a.scrollSensitivity&&(r=t(document).scrollLeft(t(document).scrollLeft()+a.scrollSpeed))),r!==!1&&t.ui.ddmanager&&!a.dropBehaviour&&t.ui.ddmanager.prepareOffsets(this,e)),this.positionAbs=this._convertPositionTo("absolute"),this.options.axis&&"y"===this.options.axis||(this.helper[0].style.left=this.position.left+"px"),this.options.axis&&"x"===this.options.axis||(this.helper[0].style.top=this.position.top+"px"),i=this.items.length-1;i>=0;i--)if(s=this.items[i],n=s.item[0],o=this._intersectsWithPointer(s),o&&s.instance===this.currentContainer&&n!==this.currentItem[0]&&this.placeholder[1===o?"next":"prev"]()[0]!==n&&!t.contains(this.placeholder[0],n)&&("semi-dynamic"===this.options.type?!t.contains(this.element[0],n):!0)){if(this.direction=1===o?"down":"up","pointer"!==this.options.tolerance&&!this._intersectsWithSides(s))break;this._rearrange(e,s),this._trigger("change",e,this._uiHash());break}return this._contactContainers(e),t.ui.ddmanager&&t.ui.ddmanager.drag(this,e),this._trigger("sort",e,this._uiHash()),this.lastPositionAbs=this.positionAbs,!1},_mouseStop:function(e,i){if(e){if(t.ui.ddmanager&&!this.options.dropBehaviour&&t.ui.ddmanager.drop(this,e),this.options.revert){var s=this,n=this.placeholder.offset(),o=this.options.axis,a={};o&&"x"!==o||(a.left=n.left-this.offset.parent.left-this.margins.left+(this.offsetParent[0]===document.body?0:this.offsetParent[0].scrollLeft)),o&&"y"!==o||(a.top=n.top-this.offset.parent.top-this.margins.top+(this.offsetParent[0]===document.body?0:this.offsetParent[0].scrollTop)),this.reverting=!0,t(this.helper).animate(a,parseInt(this.options.revert,10)||500,function(){s._clear(e)})}else this._clear(e,i);return!1}},cancel:function(){if(this.dragging){this._mouseUp({target:null}),"original"===this.options.helper?this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper"):this.currentItem.show();for(var e=this.containers.length-1;e>=0;e--)this.containers[e]._trigger("deactivate",null,this._uiHash(this)),this.containers[e].containerCache.over&&(this.containers[e]._trigger("out",null,this._uiHash(this)),this.containers[e].containerCache.over=0)}return this.placeholder&&(this.placeholder[0].parentNode&&this.placeholder[0].parentNode.removeChild(this.placeholder[0]),"original"!==this.options.helper&&this.helper&&this.helper[0].parentNode&&this.helper.remove(),t.extend(this,{helper:null,dragging:!1,reverting:!1,_noFinalSort:null}),this.domPosition.prev?t(this.domPosition.prev).after(this.currentItem):t(this.domPosition.parent).prepend(this.currentItem)),this},serialize:function(e){var i=this._getItemsAsjQuery(e&&e.connected),s=[];return e=e||{},t(i).each(function(){var i=(t(e.item||this).attr(e.attribute||"id")||"").match(e.expression||/(.+)[\-=_](.+)/);i&&s.push((e.key||i[1]+"[]")+"="+(e.key&&e.expression?i[1]:i[2]))}),!s.length&&e.key&&s.push(e.key+"="),s.join("&")},toArray:function(e){var i=this._getItemsAsjQuery(e&&e.connected),s=[];return e=e||{},i.each(function(){s.push(t(e.item||this).attr(e.attribute||"id")||"")}),s},_intersectsWith:function(t){var e=this.positionAbs.left,i=e+this.helperProportions.width,s=this.positionAbs.top,n=s+this.helperProportions.height,o=t.left,a=o+t.width,r=t.top,h=r+t.height,l=this.offset.click.top,c=this.offset.click.left,u="x"===this.options.axis||s+l>r&&h>s+l,d="y"===this.options.axis||e+c>o&&a>e+c,p=u&&d;return"pointer"===this.options.tolerance||this.options.forcePointerForContainers||"pointer"!==this.options.tolerance&&this.helperProportions[this.floating?"width":"height"]>t[this.floating?"width":"height"]?p:e+this.helperProportions.width/2>o&&a>i-this.helperProportions.width/2&&s+this.helperProportions.height/2>r&&h>n-this.helperProportions.height/2},_intersectsWithPointer:function(t){var i="x"===this.options.axis||e(this.positionAbs.top+this.offset.click.top,t.top,t.height),s="y"===this.options.axis||e(this.positionAbs.left+this.offset.click.left,t.left,t.width),n=i&&s,o=this._getDragVerticalDirection(),a=this._getDragHorizontalDirection();return n?this.floating?a&&"right"===a||"down"===o?2:1:o&&("down"===o?2:1):!1},_intersectsWithSides:function(t){var i=e(this.positionAbs.top+this.offset.click.top,t.top+t.height/2,t.height),s=e(this.positionAbs.left+this.offset.click.left,t.left+t.width/2,t.width),n=this._getDragVerticalDirection(),o=this._getDragHorizontalDirection();return this.floating&&o?"right"===o&&s||"left"===o&&!s:n&&("down"===n&&i||"up"===n&&!i)},_getDragVerticalDirection:function(){var t=this.positionAbs.top-this.lastPositionAbs.top;return 0!==t&&(t>0?"down":"up")},_getDragHorizontalDirection:function(){var t=this.positionAbs.left-this.lastPositionAbs.left;return 0!==t&&(t>0?"right":"left")},refresh:function(t){return this._refreshItems(t),this.refreshPositions(),this},_connectWith:function(){var t=this.options;return t.connectWith.constructor===String?[t.connectWith]:t.connectWith},_getItemsAsjQuery:function(e){function i(){r.push(this)}var s,n,o,a,r=[],h=[],l=this._connectWith();if(l&&e)for(s=l.length-1;s>=0;s--)for(o=t(l[s]),n=o.length-1;n>=0;n--)a=t.data(o[n],this.widgetFullName),a&&a!==this&&!a.options.disabled&&h.push([t.isFunction(a.options.items)?a.options.items.call(a.element):t(a.options.items,a.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),a]);for(h.push([t.isFunction(this.options.items)?this.options.items.call(this.element,null,{options:this.options,item:this.currentItem}):t(this.options.items,this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"),this]),s=h.length-1;s>=0;s--)h[s][0].each(i);return t(r)},_removeCurrentsFromItems:function(){var e=this.currentItem.find(":data("+this.widgetName+"-item)");this.items=t.grep(this.items,function(t){for(var i=0;e.length>i;i++)if(e[i]===t.item[0])return!1;return!0})},_refreshItems:function(e){this.items=[],this.containers=[this];var i,s,n,o,a,r,h,l,c=this.items,u=[[t.isFunction(this.options.items)?this.options.items.call(this.element[0],e,{item:this.currentItem}):t(this.options.items,this.element),this]],d=this._connectWith();if(d&&this.ready)for(i=d.length-1;i>=0;i--)for(n=t(d[i]),s=n.length-1;s>=0;s--)o=t.data(n[s],this.widgetFullName),o&&o!==this&&!o.options.disabled&&(u.push([t.isFunction(o.options.items)?o.options.items.call(o.element[0],e,{item:this.currentItem}):t(o.options.items,o.element),o]),this.containers.push(o));for(i=u.length-1;i>=0;i--)for(a=u[i][1],r=u[i][0],s=0,l=r.length;l>s;s++)h=t(r[s]),h.data(this.widgetName+"-item",a),c.push({item:h,instance:a,width:0,height:0,left:0,top:0})},refreshPositions:function(e){this.offsetParent&&this.helper&&(this.offset.parent=this._getParentOffset());var i,s,n,o;for(i=this.items.length-1;i>=0;i--)s=this.items[i],s.instance!==this.currentContainer&&this.currentContainer&&s.item[0]!==this.currentItem[0]||(n=this.options.toleranceElement?t(this.options.toleranceElement,s.item):s.item,e||(s.width=n.outerWidth(),s.height=n.outerHeight()),o=n.offset(),s.left=o.left,s.top=o.top);if(this.options.custom&&this.options.custom.refreshContainers)this.options.custom.refreshContainers.call(this);else for(i=this.containers.length-1;i>=0;i--)o=this.containers[i].element.offset(),this.containers[i].containerCache.left=o.left,this.containers[i].containerCache.top=o.top,this.containers[i].containerCache.width=this.containers[i].element.outerWidth(),this.containers[i].containerCache.height=this.containers[i].element.outerHeight();return this},_createPlaceholder:function(e){e=e||this;var i,s=e.options;s.placeholder&&s.placeholder.constructor!==String||(i=s.placeholder,s.placeholder={element:function(){var s=e.currentItem[0].nodeName.toLowerCase(),n=t("<"+s+">",e.document[0]).addClass(i||e.currentItem[0].className+" ui-sortable-placeholder").removeClass("ui-sortable-helper");return"tr"===s?e.currentItem.children().each(function(){t("<td>&#160;</td>",e.document[0]).attr("colspan",t(this).attr("colspan")||1).appendTo(n)}):"img"===s&&n.attr("src",e.currentItem.attr("src")),i||n.css("visibility","hidden"),n},update:function(t,n){(!i||s.forcePlaceholderSize)&&(n.height()||n.height(e.currentItem.innerHeight()-parseInt(e.currentItem.css("paddingTop")||0,10)-parseInt(e.currentItem.css("paddingBottom")||0,10)),n.width()||n.width(e.currentItem.innerWidth()-parseInt(e.currentItem.css("paddingLeft")||0,10)-parseInt(e.currentItem.css("paddingRight")||0,10)))}}),e.placeholder=t(s.placeholder.element.call(e.element,e.currentItem)),e.currentItem.after(e.placeholder),s.placeholder.update(e,e.placeholder)},_contactContainers:function(s){var n,o,a,r,h,l,c,u,d,p,f=null,g=null;for(n=this.containers.length-1;n>=0;n--)if(!t.contains(this.currentItem[0],this.containers[n].element[0]))if(this._intersectsWith(this.containers[n].containerCache)){if(f&&t.contains(this.containers[n].element[0],f.element[0]))continue;f=this.containers[n],g=n}else this.containers[n].containerCache.over&&(this.containers[n]._trigger("out",s,this._uiHash(this)),this.containers[n].containerCache.over=0);if(f)if(1===this.containers.length)this.containers[g].containerCache.over||(this.containers[g]._trigger("over",s,this._uiHash(this)),this.containers[g].containerCache.over=1);else{for(a=1e4,r=null,p=f.floating||i(this.currentItem),h=p?"left":"top",l=p?"width":"height",c=this.positionAbs[h]+this.offset.click[h],o=this.items.length-1;o>=0;o--)t.contains(this.containers[g].element[0],this.items[o].item[0])&&this.items[o].item[0]!==this.currentItem[0]&&(!p||e(this.positionAbs.top+this.offset.click.top,this.items[o].top,this.items[o].height))&&(u=this.items[o].item.offset()[h],d=!1,Math.abs(u-c)>Math.abs(u+this.items[o][l]-c)&&(d=!0,u+=this.items[o][l]),a>Math.abs(u-c)&&(a=Math.abs(u-c),r=this.items[o],this.direction=d?"up":"down"));if(!r&&!this.options.dropOnEmpty)return;if(this.currentContainer===this.containers[g])return;r?this._rearrange(s,r,null,!0):this._rearrange(s,null,this.containers[g].element,!0),this._trigger("change",s,this._uiHash()),this.containers[g]._trigger("change",s,this._uiHash(this)),this.currentContainer=this.containers[g],this.options.placeholder.update(this.currentContainer,this.placeholder),this.containers[g]._trigger("over",s,this._uiHash(this)),this.containers[g].containerCache.over=1}},_createHelper:function(e){var i=this.options,s=t.isFunction(i.helper)?t(i.helper.apply(this.element[0],[e,this.currentItem])):"clone"===i.helper?this.currentItem.clone():this.currentItem;return s.parents("body").length||t("parent"!==i.appendTo?i.appendTo:this.currentItem[0].parentNode)[0].appendChild(s[0]),s[0]===this.currentItem[0]&&(this._storedCSS={width:this.currentItem[0].style.width,height:this.currentItem[0].style.height,position:this.currentItem.css("position"),top:this.currentItem.css("top"),left:this.currentItem.css("left")}),(!s[0].style.width||i.forceHelperSize)&&s.width(this.currentItem.width()),(!s[0].style.height||i.forceHelperSize)&&s.height(this.currentItem.height()),s},_adjustOffsetFromHelper:function(e){"string"==typeof e&&(e=e.split(" ")),t.isArray(e)&&(e={left:+e[0],top:+e[1]||0}),"left"in e&&(this.offset.click.left=e.left+this.margins.left),"right"in e&&(this.offset.click.left=this.helperProportions.width-e.right+this.margins.left),"top"in e&&(this.offset.click.top=e.top+this.margins.top),"bottom"in e&&(this.offset.click.top=this.helperProportions.height-e.bottom+this.margins.top)},_getParentOffset:function(){this.offsetParent=this.helper.offsetParent();var e=this.offsetParent.offset();return"absolute"===this.cssPosition&&this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])&&(e.left+=this.scrollParent.scrollLeft(),e.top+=this.scrollParent.scrollTop()),(this.offsetParent[0]===document.body||this.offsetParent[0].tagName&&"html"===this.offsetParent[0].tagName.toLowerCase()&&t.ui.ie)&&(e={top:0,left:0}),{top:e.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:e.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if("relative"===this.cssPosition){var t=this.currentItem.position();return{top:t.top-(parseInt(this.helper.css("top"),10)||0)+this.scrollParent.scrollTop(),left:t.left-(parseInt(this.helper.css("left"),10)||0)+this.scrollParent.scrollLeft()}}return{top:0,left:0}},_cacheMargins:function(){this.margins={left:parseInt(this.currentItem.css("marginLeft"),10)||0,top:parseInt(this.currentItem.css("marginTop"),10)||0}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var e,i,s,n=this.options;"parent"===n.containment&&(n.containment=this.helper[0].parentNode),("document"===n.containment||"window"===n.containment)&&(this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,t("document"===n.containment?document:window).width()-this.helperProportions.width-this.margins.left,(t("document"===n.containment?document:window).height()||document.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top]),/^(document|window|parent)$/.test(n.containment)||(e=t(n.containment)[0],i=t(n.containment).offset(),s="hidden"!==t(e).css("overflow"),this.containment=[i.left+(parseInt(t(e).css("borderLeftWidth"),10)||0)+(parseInt(t(e).css("paddingLeft"),10)||0)-this.margins.left,i.top+(parseInt(t(e).css("borderTopWidth"),10)||0)+(parseInt(t(e).css("paddingTop"),10)||0)-this.margins.top,i.left+(s?Math.max(e.scrollWidth,e.offsetWidth):e.offsetWidth)-(parseInt(t(e).css("borderLeftWidth"),10)||0)-(parseInt(t(e).css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left,i.top+(s?Math.max(e.scrollHeight,e.offsetHeight):e.offsetHeight)-(parseInt(t(e).css("borderTopWidth"),10)||0)-(parseInt(t(e).css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top])},_convertPositionTo:function(e,i){i||(i=this.position);var s="absolute"===e?1:-1,n="absolute"!==this.cssPosition||this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,o=/(html|body)/i.test(n[0].tagName);return{top:i.top+this.offset.relative.top*s+this.offset.parent.top*s-("fixed"===this.cssPosition?-this.scrollParent.scrollTop():o?0:n.scrollTop())*s,left:i.left+this.offset.relative.left*s+this.offset.parent.left*s-("fixed"===this.cssPosition?-this.scrollParent.scrollLeft():o?0:n.scrollLeft())*s}},_generatePosition:function(e){var i,s,n=this.options,o=e.pageX,a=e.pageY,r="absolute"!==this.cssPosition||this.scrollParent[0]!==document&&t.contains(this.scrollParent[0],this.offsetParent[0])?this.scrollParent:this.offsetParent,h=/(html|body)/i.test(r[0].tagName);return"relative"!==this.cssPosition||this.scrollParent[0]!==document&&this.scrollParent[0]!==this.offsetParent[0]||(this.offset.relative=this._getRelativeOffset()),this.originalPosition&&(this.containment&&(e.pageX-this.offset.click.left<this.containment[0]&&(o=this.containment[0]+this.offset.click.left),e.pageY-this.offset.click.top<this.containment[1]&&(a=this.containment[1]+this.offset.click.top),e.pageX-this.offset.click.left>this.containment[2]&&(o=this.containment[2]+this.offset.click.left),e.pageY-this.offset.click.top>this.containment[3]&&(a=this.containment[3]+this.offset.click.top)),n.grid&&(i=this.originalPageY+Math.round((a-this.originalPageY)/n.grid[1])*n.grid[1],a=this.containment?i-this.offset.click.top>=this.containment[1]&&i-this.offset.click.top<=this.containment[3]?i:i-this.offset.click.top>=this.containment[1]?i-n.grid[1]:i+n.grid[1]:i,s=this.originalPageX+Math.round((o-this.originalPageX)/n.grid[0])*n.grid[0],o=this.containment?s-this.offset.click.left>=this.containment[0]&&s-this.offset.click.left<=this.containment[2]?s:s-this.offset.click.left>=this.containment[0]?s-n.grid[0]:s+n.grid[0]:s)),{top:a-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+("fixed"===this.cssPosition?-this.scrollParent.scrollTop():h?0:r.scrollTop()),left:o-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+("fixed"===this.cssPosition?-this.scrollParent.scrollLeft():h?0:r.scrollLeft())}},_rearrange:function(t,e,i,s){i?i[0].appendChild(this.placeholder[0]):e.item[0].parentNode.insertBefore(this.placeholder[0],"down"===this.direction?e.item[0]:e.item[0].nextSibling),this.counter=this.counter?++this.counter:1;var n=this.counter;this._delay(function(){n===this.counter&&this.refreshPositions(!s)})},_clear:function(t,e){function i(t,e,i){return function(s){i._trigger(t,s,e._uiHash(e))}}this.reverting=!1;var s,n=[];if(!this._noFinalSort&&this.currentItem.parent().length&&this.placeholder.before(this.currentItem),this._noFinalSort=null,this.helper[0]===this.currentItem[0]){for(s in this._storedCSS)("auto"===this._storedCSS[s]||"static"===this._storedCSS[s])&&(this._storedCSS[s]="");this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper")}else this.currentItem.show();for(this.fromOutside&&!e&&n.push(function(t){this._trigger("receive",t,this._uiHash(this.fromOutside))}),!this.fromOutside&&this.domPosition.prev===this.currentItem.prev().not(".ui-sortable-helper")[0]&&this.domPosition.parent===this.currentItem.parent()[0]||e||n.push(function(t){this._trigger("update",t,this._uiHash())}),this!==this.currentContainer&&(e||(n.push(function(t){this._trigger("remove",t,this._uiHash())}),n.push(function(t){return function(e){t._trigger("receive",e,this._uiHash(this))}}.call(this,this.currentContainer)),n.push(function(t){return function(e){t._trigger("update",e,this._uiHash(this))}}.call(this,this.currentContainer)))),s=this.containers.length-1;s>=0;s--)e||n.push(i("deactivate",this,this.containers[s])),this.containers[s].containerCache.over&&(n.push(i("out",this,this.containers[s])),this.containers[s].containerCache.over=0);if(this.storedCursor&&(this.document.find("body").css("cursor",this.storedCursor),this.storedStylesheet.remove()),this._storedOpacity&&this.helper.css("opacity",this._storedOpacity),this._storedZIndex&&this.helper.css("zIndex","auto"===this._storedZIndex?"":this._storedZIndex),this.dragging=!1,this.cancelHelperRemoval){if(!e){for(this._trigger("beforeStop",t,this._uiHash()),s=0;n.length>s;s++)n[s].call(this,t);this._trigger("stop",t,this._uiHash())}return this.fromOutside=!1,!1}if(e||this._trigger("beforeStop",t,this._uiHash()),this.placeholder[0].parentNode.removeChild(this.placeholder[0]),this.helper[0]!==this.currentItem[0]&&this.helper.remove(),this.helper=null,!e){for(s=0;n.length>s;s++)n[s].call(this,t);this._trigger("stop",t,this._uiHash())}return this.fromOutside=!1,!0},_trigger:function(){t.Widget.prototype._trigger.apply(this,arguments)===!1&&this.cancel()},_uiHash:function(e){var i=e||this;return{helper:i.helper,placeholder:i.placeholder||t([]),position:i.position,originalPosition:i.originalPosition,offset:i.positionAbs,item:i.currentItem,sender:e?e.element:null}}})})(jQuery);//check if tor or not
var tor_browser = false;
if(location.hostname == "jthnx5wyvjvzsxtu.onion"){
	tor_browser = true;
}
if (active_page == 'catalog') $(function(){
	if (localStorage.catalog !== undefined) {
		var catalog = JSON.parse(localStorage.catalog);
	} else {
		var catalog = {};
		localStorage.catalog = JSON.stringify(catalog);
	}

	$("#sort_by").change(function(){
		var value = this.value;
		$('#Grid').mixItUp('sort', (value == "random" ? value : "sticky:desc " + value));
		catalog.sort_by = value;
		localStorage.catalog = JSON.stringify(catalog);
	});

	$("#image_size").change(function(){
		var value = this.value, old;
		$(".grid-li").removeClass("grid-size-vsmall");
		$(".grid-li").removeClass("grid-size-small");
		$(".grid-li").removeClass("grid-size-medium");
		$(".grid-li").removeClass("grid-size-large");
		$(".grid-li").addClass("grid-size-"+value);
		catalog.image_size = value;
		localStorage.catalog = JSON.stringify(catalog);
	});

	$('#Grid').mixItUp({
		animation: {
			enable: false
		}
	});

	if (catalog.sort_by !== undefined) {
		$('#sort_by').val(catalog.sort_by).trigger('change');
	}
	if (catalog.image_size !== undefined) {
		$('#image_size').val(catalog.image_size).trigger('change');
	}

	$('div.thread').on('click', function(e) {
		if ($(this).css('overflow-y') === 'hidden') {
			$(this).css('overflow-y', 'auto');
			$(this).css('width', '100%');
		} else {
			$(this).css('overflow-y', 'hidden');
			$(this).css('width', 'auto');
		}
	});
});
var tout;

function redo_events(provider, extra) {
  console.log("redo_events: " + provider);
  $('.captcha .captcha_text, textarea[id="body"]').off("focus").one("focus", function() { actually_load_captcha(provider, extra); });
}

function actually_load_captcha(provider, extra) {
 console.log("actually_load_captcha: " + provider);
  $('.captcha .captcha_text, textarea[id="body"]').off("focus");

  if (tout !== undefined) {
    clearTimeout(tout);
  }


  $.ajax({
    type: 'GET',
    url: provider,
    dataType: "json",
    cache: false,
    data: {mode: 'get', extra: extra},
    xhrFields: {withCredentials: true},
    success: function(json) {
            $(".captcha .captcha_cookie").val(json.cookie);
            $(".captcha .captcha_html").html(json.captchahtml);

    	    setTimeout(function() {
      		redo_events(provider, extra);
    	    }, json.expires_in * 1000);
    },
    error: function (xhr) {
      console.log(xhr);
    }
  });

}

function load_captcha(provider, extra) {
 console.log("load_captcha: " + provider);
  $(function() {
    $(".captcha>td").html("<input class='captcha_text' type='text' name='captcha_text' size='25' maxlength='8' autocomplete='off' autocorrect='off' autocapitalize='off' spellcheck='false'>"+
			  "<input class='captcha_cookie' name='captcha_cookie' type='hidden'>"+
			  "<div class='captcha_html'></div>");

    $("#quick-reply .captcha .captcha_text").prop("placeholder", _("Verification"));

    $(".captcha .captcha_html").on("click", function() { actually_load_captcha(provider, extra); });
    $(document).on("ajax_after_post",       function() { actually_load_captcha(provider, extra); });
    redo_events(provider, extra);

    $(window).on("quick-reply", function() {
      redo_events(provider, extra);
      $("#quick-reply .captcha .captcha_html").html($("form:not(#quick-reply) .captcha .captcha_html").html());
      $("#quick-reply .captcha .captcha_cookie").val($("form:not(#quick-reply) .captcha .captcha_cookie").html());
      $("#quick-reply .captcha .captcha_html").on("click", function() { actually_load_captcha(provider, extra); });
    });
  });
}


(function($){$.extend({tablesorter:new
function(){var parsers=[],widgets=[];this.defaults={cssHeader:"header",cssAsc:"headerSortUp",cssDesc:"headerSortDown",cssChildRow:"expand-child",sortInitialOrder:"asc",sortMultiSortKey:"shiftKey",sortForce:null,sortAppend:null,sortLocaleCompare:true,textExtraction:"simple",parsers:{},widgets:[],widgetZebra:{css:["even","odd"]},headers:{},widthFixed:false,cancelSelection:true,sortList:[],headerList:[],dateFormat:"us",decimal:'/\.|\,/g',onRenderHeader:null,selectorHeaders:'thead th',debug:false};function benchmark(s,d){log(s+","+(new Date().getTime()-d.getTime())+"ms");}this.benchmark=benchmark;function log(s){if(typeof console!="undefined"&&typeof console.debug!="undefined"){console.log(s);}else{alert(s);}}function buildParserCache(table,$headers){if(table.config.debug){var parsersDebug="";}if(table.tBodies.length==0)return;var rows=table.tBodies[0].rows;if(rows[0]){var list=[],cells=rows[0].cells,l=cells.length;for(var i=0;i<l;i++){var p=false;if($.metadata&&($($headers[i]).metadata()&&$($headers[i]).metadata().sorter)){p=getParserById($($headers[i]).metadata().sorter);}else if((table.config.headers[i]&&table.config.headers[i].sorter)){p=getParserById(table.config.headers[i].sorter);}if(!p){p=detectParserForColumn(table,rows,-1,i);}if(table.config.debug){parsersDebug+="column:"+i+" parser:"+p.id+"\n";}list.push(p);}}if(table.config.debug){log(parsersDebug);}return list;};function detectParserForColumn(table,rows,rowIndex,cellIndex){var l=parsers.length,node=false,nodeValue=false,keepLooking=true;while(nodeValue==''&&keepLooking){rowIndex++;if(rows[rowIndex]){node=getNodeFromRowAndCellIndex(rows,rowIndex,cellIndex);nodeValue=trimAndGetNodeText(table.config,node);if(table.config.debug){log('Checking if value was empty on row:'+rowIndex);}}else{keepLooking=false;}}for(var i=1;i<l;i++){if(parsers[i].is(nodeValue,table,node)){return parsers[i];}}return parsers[0];}function getNodeFromRowAndCellIndex(rows,rowIndex,cellIndex){return rows[rowIndex].cells[cellIndex];}function trimAndGetNodeText(config,node){return $.trim(getElementText(config,node));}function getParserById(name){var l=parsers.length;for(var i=0;i<l;i++){if(parsers[i].id.toLowerCase()==name.toLowerCase()){return parsers[i];}}return false;}function buildCache(table){if(table.config.debug){var cacheTime=new Date();}var totalRows=(table.tBodies[0]&&table.tBodies[0].rows.length)||0,totalCells=(table.tBodies[0].rows[0]&&table.tBodies[0].rows[0].cells.length)||0,parsers=table.config.parsers,cache={row:[],normalized:[]};for(var i=0;i<totalRows;++i){var c=$(table.tBodies[0].rows[i]),cols=[];if(c.hasClass(table.config.cssChildRow)){cache.row[cache.row.length-1]=cache.row[cache.row.length-1].add(c);continue;}cache.row.push(c);for(var j=0;j<totalCells;++j){cols.push(parsers[j].format(getElementText(table.config,c[0].cells[j]),table,c[0].cells[j]));}cols.push(cache.normalized.length);cache.normalized.push(cols);cols=null;};if(table.config.debug){benchmark("Building cache for "+totalRows+" rows:",cacheTime);}return cache;};function getElementText(config,node){var text="";if(!node)return"";if(!config.supportsTextContent)config.supportsTextContent=node.textContent||false;if(config.textExtraction=="simple"){if(config.supportsTextContent){text=node.textContent;}else{if(node.childNodes[0]&&node.childNodes[0].hasChildNodes()){text=node.childNodes[0].innerHTML;}else{text=node.innerHTML;}}}else{if(typeof(config.textExtraction)=="function"){text=config.textExtraction(node);}else{text=$(node).text();}}return text;}function appendToTable(table,cache){if(table.config.debug){var appendTime=new Date()}var c=cache,r=c.row,n=c.normalized,totalRows=n.length,checkCell=(n[0].length-1),tableBody=$(table.tBodies[0]),rows=[];for(var i=0;i<totalRows;i++){var pos=n[i][checkCell];rows.push(r[pos]);if(!table.config.appender){var l=r[pos].length;for(var j=0;j<l;j++){tableBody[0].appendChild(r[pos][j]);}}}if(table.config.appender){table.config.appender(table,rows);}rows=null;if(table.config.debug){benchmark("Rebuilt table:",appendTime);}applyWidget(table);setTimeout(function(){$(table).trigger("sortEnd");},0);};function buildHeaders(table){if(table.config.debug){var time=new Date();}var meta=($.metadata)?true:false;var header_index=computeTableHeaderCellIndexes(table);$tableHeaders=$(table.config.selectorHeaders,table).each(function(index){this.column=header_index[this.parentNode.rowIndex+"-"+this.cellIndex];this.order=formatSortingOrder(table.config.sortInitialOrder);this.count=this.order;if(checkHeaderMetadata(this)||checkHeaderOptions(table,index))this.sortDisabled=true;if(checkHeaderOptionsSortingLocked(table,index))this.order=this.lockedOrder=checkHeaderOptionsSortingLocked(table,index);if(!this.sortDisabled){var $th=$(this).addClass(table.config.cssHeader);if(table.config.onRenderHeader)table.config.onRenderHeader.apply($th);}table.config.headerList[index]=this;});if(table.config.debug){benchmark("Built headers:",time);log($tableHeaders);}return $tableHeaders;};function computeTableHeaderCellIndexes(t){var matrix=[];var lookup={};var thead=t.getElementsByTagName('THEAD')[0];var trs=thead.getElementsByTagName('TR');for(var i=0;i<trs.length;i++){var cells=trs[i].cells;for(var j=0;j<cells.length;j++){var c=cells[j];var rowIndex=c.parentNode.rowIndex;var cellId=rowIndex+"-"+c.cellIndex;var rowSpan=c.rowSpan||1;var colSpan=c.colSpan||1
var firstAvailCol;if(typeof(matrix[rowIndex])=="undefined"){matrix[rowIndex]=[];}for(var k=0;k<matrix[rowIndex].length+1;k++){if(typeof(matrix[rowIndex][k])=="undefined"){firstAvailCol=k;break;}}lookup[cellId]=firstAvailCol;for(var k=rowIndex;k<rowIndex+rowSpan;k++){if(typeof(matrix[k])=="undefined"){matrix[k]=[];}var matrixrow=matrix[k];for(var l=firstAvailCol;l<firstAvailCol+colSpan;l++){matrixrow[l]="x";}}}}return lookup;}function checkCellColSpan(table,rows,row){var arr=[],r=table.tHead.rows,c=r[row].cells;for(var i=0;i<c.length;i++){var cell=c[i];if(cell.colSpan>1){arr=arr.concat(checkCellColSpan(table,headerArr,row++));}else{if(table.tHead.length==1||(cell.rowSpan>1||!r[row+1])){arr.push(cell);}}}return arr;};function checkHeaderMetadata(cell){if(($.metadata)&&($(cell).metadata().sorter===false)){return true;};return false;}function checkHeaderOptions(table,i){if((table.config.headers[i])&&(table.config.headers[i].sorter===false)){return true;};return false;}function checkHeaderOptionsSortingLocked(table,i){if((table.config.headers[i])&&(table.config.headers[i].lockedOrder))return table.config.headers[i].lockedOrder;return false;}function applyWidget(table){var c=table.config.widgets;var l=c.length;for(var i=0;i<l;i++){getWidgetById(c[i]).format(table);}}function getWidgetById(name){var l=widgets.length;for(var i=0;i<l;i++){if(widgets[i].id.toLowerCase()==name.toLowerCase()){return widgets[i];}}};function formatSortingOrder(v){if(typeof(v)!="Number"){return(v.toLowerCase()=="desc")?1:0;}else{return(v==1)?1:0;}}function isValueInArray(v,a){var l=a.length;for(var i=0;i<l;i++){if(a[i][0]==v){return true;}}return false;}function setHeadersCss(table,$headers,list,css){$headers.removeClass(css[0]).removeClass(css[1]);var h=[];$headers.each(function(offset){if(!this.sortDisabled){h[this.column]=$(this);}});var l=list.length;for(var i=0;i<l;i++){h[list[i][0]].addClass(css[list[i][1]]);}}function fixColumnWidth(table,$headers){var c=table.config;if(c.widthFixed){var colgroup=$('<colgroup>');$("tr:first td",table.tBodies[0]).each(function(){colgroup.append($('<col>').css('width',$(this).width()));});$(table).prepend(colgroup);};}function updateHeaderSortCount(table,sortList){var c=table.config,l=sortList.length;for(var i=0;i<l;i++){var s=sortList[i],o=c.headerList[s[0]];o.count=s[1];o.count++;}}function multisort(table,sortList,cache){if(table.config.debug){var sortTime=new Date();}var dynamicExp="var sortWrapper = function(a,b) {",l=sortList.length;for(var i=0;i<l;i++){var c=sortList[i][0];var order=sortList[i][1];var s=(table.config.parsers[c].type=="text")?((order==0)?makeSortFunction("text","asc",c):makeSortFunction("text","desc",c)):((order==0)?makeSortFunction("numeric","asc",c):makeSortFunction("numeric","desc",c));var e="e"+i;dynamicExp+="var "+e+" = "+s;dynamicExp+="if("+e+") { return "+e+"; } ";dynamicExp+="else { ";}var orgOrderCol=cache.normalized[0].length-1;dynamicExp+="return a["+orgOrderCol+"]-b["+orgOrderCol+"];";for(var i=0;i<l;i++){dynamicExp+="}; ";}dynamicExp+="return 0; ";dynamicExp+="}; ";if(table.config.debug){benchmark("Evaling expression:"+dynamicExp,new Date());}eval(dynamicExp);cache.normalized.sort(sortWrapper);if(table.config.debug){benchmark("Sorting on "+sortList.toString()+" and dir "+order+" time:",sortTime);}return cache;};function makeSortFunction(type,direction,index){var a="a["+index+"]",b="b["+index+"]";if(type=='text'&&direction=='asc'){return"("+a+" == "+b+" ? 0 : ("+a+" === null ? Number.POSITIVE_INFINITY : ("+b+" === null ? Number.NEGATIVE_INFINITY : ("+a+" < "+b+") ? -1 : 1 )));";}else if(type=='text'&&direction=='desc'){return"("+a+" == "+b+" ? 0 : ("+a+" === null ? Number.POSITIVE_INFINITY : ("+b+" === null ? Number.NEGATIVE_INFINITY : ("+b+" < "+a+") ? -1 : 1 )));";}else if(type=='numeric'&&direction=='asc'){return"("+a+" === null && "+b+" === null) ? 0 :("+a+" === null ? Number.POSITIVE_INFINITY : ("+b+" === null ? Number.NEGATIVE_INFINITY : "+a+" - "+b+"));";}else if(type=='numeric'&&direction=='desc'){return"("+a+" === null && "+b+" === null) ? 0 :("+a+" === null ? Number.POSITIVE_INFINITY : ("+b+" === null ? Number.NEGATIVE_INFINITY : "+b+" - "+a+"));";}};function makeSortText(i){return"((a["+i+"] < b["+i+"]) ? -1 : ((a["+i+"] > b["+i+"]) ? 1 : 0));";};function makeSortTextDesc(i){return"((b["+i+"] < a["+i+"]) ? -1 : ((b["+i+"] > a["+i+"]) ? 1 : 0));";};function makeSortNumeric(i){return"a["+i+"]-b["+i+"];";};function makeSortNumericDesc(i){return"b["+i+"]-a["+i+"];";};function sortText(a,b){if(table.config.sortLocaleCompare)return a.localeCompare(b);return((a<b)?-1:((a>b)?1:0));};function sortTextDesc(a,b){if(table.config.sortLocaleCompare)return b.localeCompare(a);return((b<a)?-1:((b>a)?1:0));};function sortNumeric(a,b){return a-b;};function sortNumericDesc(a,b){return b-a;};function getCachedSortType(parsers,i){return parsers[i].type;};this.construct=function(settings){return this.each(function(){if(!this.tHead||!this.tBodies)return;var $this,$document,$headers,cache,config,shiftDown=0,sortOrder;this.config={};config=$.extend(this.config,$.tablesorter.defaults,settings);$this=$(this);$.data(this,"tablesorter",config);$headers=buildHeaders(this);this.config.parsers=buildParserCache(this,$headers);cache=buildCache(this);var sortCSS=[config.cssDesc,config.cssAsc];fixColumnWidth(this);$headers.click(function(e){var totalRows=($this[0].tBodies[0]&&$this[0].tBodies[0].rows.length)||0;if(!this.sortDisabled&&totalRows>0){$this.trigger("sortStart");var $cell=$(this);var i=this.column;this.order=this.count++%2;if(this.lockedOrder)this.order=this.lockedOrder;if(!e[config.sortMultiSortKey]){config.sortList=[];if(config.sortForce!=null){var a=config.sortForce;for(var j=0;j<a.length;j++){if(a[j][0]!=i){config.sortList.push(a[j]);}}}config.sortList.push([i,this.order]);}else{if(isValueInArray(i,config.sortList)){for(var j=0;j<config.sortList.length;j++){var s=config.sortList[j],o=config.headerList[s[0]];if(s[0]==i){o.count=s[1];o.count++;s[1]=o.count%2;}}}else{config.sortList.push([i,this.order]);}};setTimeout(function(){setHeadersCss($this[0],$headers,config.sortList,sortCSS);appendToTable($this[0],multisort($this[0],config.sortList,cache));},1);return false;}}).mousedown(function(){if(config.cancelSelection){this.onselectstart=function(){return false};return false;}});$this.bind("update",function(){var me=this;setTimeout(function(){me.config.parsers=buildParserCache(me,$headers);cache=buildCache(me);},1);}).bind("updateCell",function(e,cell){var config=this.config;var pos=[(cell.parentNode.rowIndex-1),cell.cellIndex];cache.normalized[pos[0]][pos[1]]=config.parsers[pos[1]].format(getElementText(config,cell),cell);}).bind("sorton",function(e,list){$(this).trigger("sortStart");config.sortList=list;var sortList=config.sortList;updateHeaderSortCount(this,sortList);setHeadersCss(this,$headers,sortList,sortCSS);appendToTable(this,multisort(this,sortList,cache));}).bind("appendCache",function(){appendToTable(this,cache);}).bind("applyWidgetId",function(e,id){getWidgetById(id).format(this);}).bind("applyWidgets",function(){applyWidget(this);});if($.metadata&&($(this).metadata()&&$(this).metadata().sortlist)){config.sortList=$(this).metadata().sortlist;}if(config.sortList.length>0){$this.trigger("sorton",[config.sortList]);}applyWidget(this);});};this.addParser=function(parser){var l=parsers.length,a=true;for(var i=0;i<l;i++){if(parsers[i].id.toLowerCase()==parser.id.toLowerCase()){a=false;}}if(a){parsers.push(parser);};};this.addWidget=function(widget){widgets.push(widget);};this.formatFloat=function(s){var i=parseFloat(s);return(isNaN(i))?0:i;};this.formatInt=function(s){var i=parseInt(s);return(isNaN(i))?0:i;};this.isDigit=function(s,config){return/^[-+]?\d*$/.test($.trim(s.replace(/[,.']/g,'')));};this.clearTableBody=function(table){if($.browser.msie){function empty(){while(this.firstChild)this.removeChild(this.firstChild);}empty.apply(table.tBodies[0]);}else{table.tBodies[0].innerHTML="";}};}});$.fn.extend({tablesorter:$.tablesorter.construct});var ts=$.tablesorter;ts.addParser({id:"text",is:function(s){return true;},format:function(s){return $.trim(s.toLocaleLowerCase());},type:"text"});ts.addParser({id:"digit",is:function(s,table){var c=table.config;return $.tablesorter.isDigit(s,c);},format:function(s){return $.tablesorter.formatFloat(s);},type:"numeric"});ts.addParser({id:"currency",is:function(s){return/^[£$€?.]/.test(s);},format:function(s){return $.tablesorter.formatFloat(s.replace(new RegExp(/[£$€]/g),""));},type:"numeric"});ts.addParser({id:"ipAddress",is:function(s){return/^\d{2,3}[\.]\d{2,3}[\.]\d{2,3}[\.]\d{2,3}$/.test(s);},format:function(s){var a=s.split("."),r="",l=a.length;for(var i=0;i<l;i++){var item=a[i];if(item.length==2){r+="0"+item;}else{r+=item;}}return $.tablesorter.formatFloat(r);},type:"numeric"});ts.addParser({id:"url",is:function(s){return/^(https?|ftp|file):\/\/$/.test(s);},format:function(s){return jQuery.trim(s.replace(new RegExp(/(https?|ftp|file):\/\//),''));},type:"text"});ts.addParser({id:"isoDate",is:function(s){return/^\d{4}[\/-]\d{1,2}[\/-]\d{1,2}$/.test(s);},format:function(s){return $.tablesorter.formatFloat((s!="")?new Date(s.replace(new RegExp(/-/g),"/")).getTime():"0");},type:"numeric"});ts.addParser({id:"percent",is:function(s){return/\%$/.test($.trim(s));},format:function(s){return $.tablesorter.formatFloat(s.replace(new RegExp(/%/g),""));},type:"numeric"});ts.addParser({id:"usLongDate",is:function(s){return s.match(new RegExp(/^[A-Za-z]{3,10}\.? [0-9]{1,2}, ([0-9]{4}|'?[0-9]{2}) (([0-2]?[0-9]:[0-5][0-9])|([0-1]?[0-9]:[0-5][0-9]\s(AM|PM)))$/));},format:function(s){return $.tablesorter.formatFloat(new Date(s).getTime());},type:"numeric"});ts.addParser({id:"shortDate",is:function(s){return/\d{1,2}[\/\-]\d{1,2}[\/\-]\d{2,4}/.test(s);},format:function(s,table){var c=table.config;s=s.replace(/\-/g,"/");if(c.dateFormat=="us"){s=s.replace(/(\d{1,2})[\/\-](\d{1,2})[\/\-](\d{4})/,"$3/$1/$2");}else if(c.dateFormat=="uk"){s=s.replace(/(\d{1,2})[\/\-](\d{1,2})[\/\-](\d{4})/,"$3/$2/$1");}else if(c.dateFormat=="dd/mm/yy"||c.dateFormat=="dd-mm-yy"){s=s.replace(/(\d{1,2})[\/\-](\d{1,2})[\/\-](\d{2})/,"$1/$2/$3");}return $.tablesorter.formatFloat(new Date(s).getTime());},type:"numeric"});ts.addParser({id:"time",is:function(s){return/^(([0-2]?[0-9]:[0-5][0-9])|([0-1]?[0-9]:[0-5][0-9]\s(am|pm)))$/.test(s);},format:function(s){return $.tablesorter.formatFloat(new Date("2000/01/01 "+s).getTime());},type:"numeric"});ts.addParser({id:"metadata",is:function(s){return false;},format:function(s,table,cell){var c=table.config,p=(!c.parserMetadataName)?'sortValue':c.parserMetadataName;return $(cell).metadata()[p];},type:"numeric"});ts.addWidget({id:"zebra",format:function(table){if(table.config.debug){var time=new Date();}var $tr,row=-1,odd;$("tr:visible",table.tBodies[0]).each(function(i){$tr=$(this);if(!$tr.hasClass(table.config.cssChildRow))row++;odd=(row%2==0);$tr.removeClass(table.config.widgetZebra.css[odd?0:1]).addClass(table.config.widgetZebra.css[odd?1:0])});if(table.config.debug){$.tablesorter.benchmark("Applying Zebra widget",time);}}});})(jQuery);/*
 * options.js - allow users choose board options as they wish
 *
 * Copyright (c) 2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/options.js';
 */

+function(){

var options_button, options_handler, options_background, options_div
  , options_close, options_tablist, options_tabs, options_current_tab;

var Options = {};
window.Options = Options;

var first_tab = function() {
  for (var i in options_tabs) {
    return i;
  }
  return false;
};

Options.show = function() {
  if (!options_current_tab) {
    Options.select_tab(first_tab(), true);
  }
  options_handler.fadeIn();
};
Options.hide = function() {
  options_handler.fadeOut();
};

options_tabs = {};

Options.add_tab = function(id, icon, name, content) {
  var tab = {};

  if (typeof content == "string") {
    content = $("<div>"+content+"</div>");
  }

  tab.id = id;
  tab.name = name;
  tab.icon = $("<div class='options_tab_icon'><i class='fa fa-"+icon+"'></i><div>"+name+"</div></div>");
  tab.content = $("<div class='options_tab'></div>").css("display", "none");

  tab.content.appendTo(options_div);

  tab.icon.on("click", function() {
    Options.select_tab(id);
  }).appendTo(options_tablist);

  $("<h2>"+name+"</h2>").appendTo(tab.content);

  if (content) {
    content.appendTo(tab.content);
  }
  
  options_tabs[id] = tab;

  return tab;
};

Options.get_tab = function(id) {
  return options_tabs[id];
};

Options.extend_tab = function(id, content) {
  if (typeof content == "string") {
    content = $("<div>"+content+"</div>");
  }

  content.appendTo(options_tabs[id].content);

  return options_tabs[id];
};

Options.select_tab = function(id, quick) {
  if (options_current_tab) {
    if (options_current_tab.id == id) {
      return false;
    }
    options_current_tab.content.fadeOut();
    options_current_tab.icon.removeClass("active");
  }
  var tab = options_tabs[id];
  options_current_tab = tab;
  options_current_tab.icon.addClass("active");
  tab.content[quick? "show" : "fadeIn"]();

  return tab;
};

options_handler = $("<div id='options_handler'></div>").css("display", "none");
options_background = $("<div id='options_background'></div>").on("click", Options.hide).appendTo(options_handler);
options_div = $("<div id='options_div'></div>").appendTo(options_handler);
options_close = $("<a id='options_close' href='javascript:void(0)'><i class='fa fa-times'></i></div>")
  .on("click", Options.hide).appendTo(options_div);
options_tablist = $("<div id='options_tablist'></div>").appendTo(options_div);


$(function(){
  options_button = $("<a href='javascript:void(0)' title='"+_("Options")+"'>["+_("Options")+"]</a>");

  if ($(".boardlist.compact-boardlist").length) {
    options_button.addClass("cb-item cb-fa").html("<i class='fa fa-gear'></i>");
  }

  if ($(".boardlist:first").length) {
    options_button.css('float', 'right').appendTo($(".boardlist:first"));
  }
  else {
    var optsdiv = $('<div style="text-align: right"></div>');
    options_button.appendTo(optsdiv);
    optsdiv.prependTo($(document.body));
  }

  options_button.on("click", Options.show);

  options_handler.appendTo($(document.body));
});



}();
/*
 * style-select.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/style-select.js
 *
 * Changes the stylesheet chooser links to a <select>
 *
 * Released under the MIT license
 * Copyright (c) 2013 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net> 
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/style-select.js';
 *
 */

onready(function(){
	var stylesDiv = $('div.styles');
	var stylesSelect = $('<select></select>');
	
	var i = 1;
	stylesDiv.children().each(function() {
		var opt = $('<option></option>')
			.html(this.innerHTML.replace(/(^\[|\]$)/g, ''))
			.val(i);
		if ($(this).hasClass('selected'))
			opt.attr('selected', true);
		stylesSelect.append(opt);
		$(this).attr('id', 'style-select-' + i);
		i++;
	});
	
	stylesSelect.change(function() {
		$('#style-select-' + $(this).val()).click();
	});
	
	stylesDiv.hide();
	
	stylesDiv.after(
		$('<div id="style-select" style="float:right;margin-bottom:10px"></div>')
			.text(_('Style: '))
			.append(stylesSelect)
	);
});

/*
 * options/general.js - general settings tab for options panel
 *
 * Copyright (c) 2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/options.js';
 *   $config['additional_javascript'][] = 'js/style-select.js';
 *   $config['additional_javascript'][] = 'js/options/general.js';
 */

+function(){

var tab = Options.add_tab("general", "home", _("General"));

$(function(){
  var help = $("<div><em>"+_("Note: Most option changes will only take effect on future page loads.")+"</em></div>");
  help.appendTo(tab.content);

  var stor = $("<div>"+_("Storage: ")+"</div>");
  stor.appendTo(tab.content);

  $("<button>"+_("Export")+"</button>").appendTo(stor).on("click", function() {
    var str = JSON.stringify(localStorage);

    $(".output").remove();
    $("<input type='text' class='output'>").appendTo(stor).val(str);
  });
  $("<button>"+_("Import")+"</button>").appendTo(stor).on("click", function() {
    var str = prompt(_("Paste your storage data"));
    if (!str) return false;
    var obj = JSON.parse(str);
    if (!obj) return false;

    localStorage.clear();
    for (var i in obj) {
      localStorage[i] = obj[i];
    }

    document.location.reload();
  });
  $("<button>"+_("Erase")+"</button>").appendTo(stor).on("click", function() {
    if (confirm(_("Are you sure you want to erase your storage? This involves your hidden threads, watched threads, post password and many more."))) {
      localStorage.clear();
      document.location.reload();
    }
  });


  $("#style-select").detach().css({float:"none","margin-bottom":0}).appendTo(tab.content);
});

}();
/*
 * post-hover.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/post-hover.js
 *
 * Released under the MIT license
 * Copyright (c) 2012 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 * Copyright (c) 2013 Macil Tech <maciltech@gmail.com>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/post-hover.js';
 *
 */

onready(function(){

	init_hover = function() {
		var link = $(this);

		var id;
		var matches;

		if (link.is('[data-thread]')) {
				id = link.attr('data-thread');
		}
		else if(matches = link.text().match(/^>>(?:>\/([^\/]+)\/)?(\d+)$/)) {
			id = matches[2];
		}
		else {
			return;
		}
		
		var board = $(this);
		while (board.data('board') === undefined) {
			board = board.parent();
		}
		var threadid;
		if (link.is('[data-thread]')) threadid = 0;
		else threadid = board.attr('id').replace("thread_", "");

		board = board.data('board');

		var parentboard = board;
		
		if (link.is('[data-thread]')) parentboard = $('form[name="post"] input[name="board"]').val();
		else if (matches[1] !== undefined) board = matches[1];

		var post = false;
		var hovering = false;
		link.hover(function(e) {
			hovering = true;
			var start_hover = function(link) {
				if(post.is(':visible') &&
						post.offset().top >= $(window).scrollTop() &&
						post.offset().top + post.height() <= $(window).scrollTop() + $(window).height()) {
					// post is in view
					post.addClass('highlighted');
				} else {
					var newPost = post.clone();
					newPost.find('>.reply, >br').remove();
					newPost.find('a.post_anchor').remove();

					newPost
						.attr('id', 'post-hover-' + id)
						.attr('data-board', board)
						.addClass('post-hover')
						.css('border-style', 'solid')
						.css('box-shadow', '1px 1px 1px #999')
						.css('display', 'block')
						.css('position', 'absolute')
						.css('font-style', 'normal')
						.css('z-index', '100')
						.css('left', '0')
						.css('margin-left', '')
						.addClass('reply').addClass('post')
						.appendTo(link.closest('div.post'));
						
					// shrink expanded images
					newPost.find('div.file img.post-image').css({'display': '', 'opacity': ''});
					newPost.find('div.file img.full-image').remove();
					
					// Highlight references to the current post
					if (link.hasClass('mentioned-'+id)) {
						var postLinks = newPost.find('div.body a:not([rel="nofollow"])');
						if (postLinks.length > 1) {
							var originalPost = link.closest('div.post').attr('id').replace("reply_", "").replace("inline_", "");
							postLinks.each(function() {
								if ($(this).text() == ">>"+originalPost) {
									$(this).addClass('dashed-underline');
								}
							});
						}
					}
					
					var previewWidth = newPost.outerWidth(true);
					var widthDiff = previewWidth - newPost.width();
					var linkLeft = link.offset().left;
					var left, top;
					
					if (linkLeft < $(document).width() * 0.7) {
						left = linkLeft + link.width();
						if (left + previewWidth > $(window).width()) {
							newPost.css('width', $(window).width() - left - widthDiff);
						}
					} else {
						if (previewWidth > linkLeft) {
							newPost.css('width', linkLeft - widthDiff);
							previewWidth = linkLeft;
						}
						left = linkLeft - previewWidth;
					}
					newPost.css('left', left);
					
					top = link.offset().top - 10;
					
					var scrollTop = $(window).scrollTop();
					if (link.is("[data-thread]")) {
						scrollTop = 0;
						top -= $(window).scrollTop();	
					}
					
					if(top < scrollTop + 15) {
						top = scrollTop;
					} else if(top > scrollTop + $(window).height() - newPost.height() - 15) {
						top = scrollTop + $(window).height() - newPost.height() - 15;
					}
					
					if (newPost.height() > $(window).height()) {
						top = scrollTop;
					}
					
					newPost.css('top', top);
				}
			};
			
			
			post = $('[data-board="' + board + '"] div.post#reply_' + id + ', [data-board="' + board + '"]div#thread_' + id);
			if(post.length > 0) {
				start_hover($(this));
			} else {
				var url = link.attr('href').replace(/#.*$/, '').replace('.html', '.json');
				var dataPromise = getPost(id, url);

				dataPromise.done(function (data) {
					//	reconstruct post from json response
					var file_array = [];
					var multifile = false;

					var add_info = function (data) {
						var file = {
							'thumb_h': data.tn_h,
							'thumb_w': data.tn_w,
							'fsize': data.fsize,
							'filename': data.filename,
							'ext': data.ext,
							'tim': data.tim
						};

						if ('h' in data) {
							file.isImage = true; //(or video)
							file.h = data.h;
							file.w = data.w;
						} else {
							file.isImage = false;
						}
						// since response doens't indicate spoilered files,
						// we'll just make do by assuming any image with 128*128px thumbnail is spoilered.
						// which is probably 99% of the cases anyway.
						file.isSpoiler = (data.tn_h == 128 && data.tn_w == 128);

						file_array.push(file);
					};

					var bytesToSize = function (bytes) {
						var sizes = ['Bytes', 'KB', 'MB'];
						var i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));

						return (i === 0) ? bytes +' '+ sizes[i] : (bytes / Math.pow(1024, i)).toFixed(2) +' ' +sizes[i];
					};

          				if(data.name === undefined){
            					data.name = "";
          				}

					var time = (!localStorage.show_relative_time || localStorage.show_relative_time === 'false') ? dateformat(new Date(data.time*1000)) : timeDifference(Date.now(), data.time*1000);
					var $post = $('<div class="post reply hidden" id="reply_'+ data.no +'">')
								.append($('<p class="intro"></p>')
									.append('<span class="name">'+ data.name +'</span> ')
									.append('<time datetime="'+ new Date(data.time*1000).toISOString() +'">'+ time +'</time>')
									.append('<a class="post_no"> No.'+ data.no +'</a>')
								)
								.append($('<div class="body"></div>')
									.html(data.com)
								)
								.css('display', 'none');

					//	other stuff
					if ('sub' in data) $post.find('.intro').prepend('<span class="subject">'+ data.sub +'</span> ');
					if ('trip' in data) $post.find('.name').after('<span class="trip">'+ data.trip +'</span>');
					if ('capcode' in data) $post.find('.post_no').before('<span class="capcode">## '+ data.capcode +'</span>');
					if ('id' in data) $post.find('.post_no').before('<span class="poster_id">'+ data.id +'</span>');
					if ('embed' in data) $post.find('p.intro').after(data.embed);

					if ('filename' in data) {
						var $files = $('<div class="files">');

						add_info(data);
						if ('extra_files' in data) {
							multifile = true;
							$.each(data.extra_files, function () {
								add_info(this);
							});
						}

						$.each(file_array, function () {
							var thumb_url;
							var file_ext = this.ext;

							if (this.isImage && !this.isSpoiler) {

								// at some point around 28/29th of Jan, 2015; all the newly  generated thumbnails switched to using jpg
								// this is a quick hack to ensure that external preview (mostly) works with old and new posts

									// Note: please update if a more accurate timestamp is known 
								if (data.last_modified > 1422489600) {
									if (this.ext == '.png' || this.ext == '.PNG') {
										this.ext = '.png';
									} else {
										this.ext = '.jpg';
									}
								} else {
									if (this.ext === '.webm' || this.ext === '.mp4' || this.ext === '.jpeg') {
										this.ext = '.jpg';
									}
									if (this.ext == '.png' || this.ext == '.PNG') {
                                                                                this.ext = '.png';
                                                                        }
								}
								if (this.tim.length > 16) {
									//thumb_url = '/file_store/thumb/' + this.tim + this.ext;
									thumb_url = 'https://media.8kun.top/file_store/thumb/' + this.tim + this.ext;
								} else {
									thumb_url = '/'+ board +'/thumb/' + this.tim + this.ext;
								}

							} else {
								thumb_url = (this.isSpoiler) ? '/static/spoiler.png' : '/static/file.png';
							}

							// truncate long filenames
							if (this.filename.length > 23) {
								this.filename = this.filename.substr(0, 22) + '…';
							}

							// file infos
							var $ele = $('<div class="file">')
										.append($('<p class="fileinfo">')
											.append('<span>File: </span>')
											.append('<a>'+ this.filename + file_ext +'</a>')
											.append('<span class="unimportant"> ('+ bytesToSize(this.fsize) +', '+ this.w +'x'+ this.h +')</span>')
										);
							if (multifile) $ele.addClass('multifile').css('width', this.thumb_w + 30);

							// image
							var $img = $('<img class="post-image">')
												.css('width', this.thumb_w)
												.css('height', this.thumb_h)
												.attr('src', thumb_url);

							$ele.append($img);
							$files.append($ele);
						});
						
						$post.children('p.intro').after($files);

					}

					var mythreadid = (data.resto !== 0) ? data.resto : data.no;

					if (mythreadid != threadid || parentboard != board) {
						// previewing post from external thread/board
						if ($('div#thread_'+ mythreadid +'[data-board="'+ board +'"]').length === 0) {
							$('form[name="postcontrols"]').prepend('<div class="thread" id="thread_'+ mythreadid +'" data-board="'+ board +'" style="display: none;"></div>');
						}
					}
					if ($('div#thread_'+ mythreadid +'[data-board="'+ board +'"]').children('#reply_'+ data.no).length === 0) {
						$('div#thread_'+ mythreadid +'[data-board="'+ board +'"]').prepend($post);
					}

					post = $('[data-board="' + board + '"] div.post#reply_' + id + ', [data-board="' + board + '"]div#thread_' + id);
					if (hovering && post.length > 0) {
						start_hover(link);
					}
				});
			}
		}, function() {
			hovering = false;
			if(!post)
				return;
			
			post.removeClass('highlighted');
			if(post.hasClass('hidden'))
				post.css('display', 'none');
			$('.post-hover').remove();
		});
	};

	var getPost = (function () {
		var cache = {};
		return function (targetId, url) {
			var deferred = $.Deferred();
			var data, post;

			var findPost = function (targetId, data) {
				var arr = data.posts;
				for (var i=0; i<arr.length; i++) {
					if (arr[i].no == targetId)
						return arr[i];
				}
				return false;
			};
			var get = function (targetId, url) {
				$.ajax({
					url: url,
					success: function (response) {
						cache[url] = response;
						var post = findPost(targetId, response);
						deferred.resolve(post);
					}
				});
			};

			//	check for cached response and check if it's stale
			if ((data = cache[url]) !== undefined && (post = findPost(targetId, data))) {
				deferred.resolve(post);
			} else {
				get(targetId, url);
			}
			return deferred.promise();
		};
	})();

	var zeropad = function(num, count) {
		return [Math.pow(10, count - num.toString().length), num].join('').substr(1);
	};

	var dateformat = (typeof strftime === 'undefined') ? function(t) {
		return zeropad(t.getMonth() + 1, 2) + "/" + zeropad(t.getDate(), 2) + "/" + t.getFullYear().toString().substring(2) +
				" (" + [_("Sun"), _("Mon"), _("Tue"), _("Wed"), _("Thu"), _("Fri"), _("Sat"), _("Sun")][t.getDay()]  + ") " +
				// time
				zeropad(t.getHours(), 2) + ":" + zeropad(t.getMinutes(), 2) + ":" + zeropad(t.getSeconds(), 2);

	} : function(t) {
		// post_date is defined in templates/main.js
		return strftime(window.post_date, t, datelocale);
	};

	function timeDifference(current, previous) {

		var msPerMinute = 60 * 1000;
		var msPerHour = msPerMinute * 60;
		var msPerDay = msPerHour * 24;
		var msPerMonth = msPerDay * 30;
		var msPerYear = msPerDay * 365;

		var elapsed = current - previous;

		if (elapsed < msPerMinute) {
			return 'Just now';
		} else if (elapsed < msPerHour) {
			return Math.round(elapsed/msPerMinute) + (Math.round(elapsed/msPerMinute)<=1 ? ' minute ago':' minutes ago');
		} else if (elapsed < msPerDay ) {
			return Math.round(elapsed/msPerHour ) + (Math.round(elapsed/msPerHour)<=1 ? ' hour ago':' hours ago');
		} else if (elapsed < msPerMonth) {
			return Math.round(elapsed/msPerDay) + (Math.round(elapsed/msPerDay)<=1 ? ' day ago':' days ago');
		} else if (elapsed < msPerYear) {
			return Math.round(elapsed/msPerMonth) + (Math.round(elapsed/msPerMonth)<=1 ? ' month ago':' months ago');
		} else {
			return Math.round(elapsed/msPerYear ) + (Math.round(elapsed/msPerYear)<=1 ? ' year ago':' years ago');
		}
	}
	
	$('div.body a:not([rel="nofollow"])').each(init_hover);
	
	// allow to work with auto-reload.js, etc.
	$(document).on('new_post', function(e, post) {
		$(post).find('div.body a:not([rel="nofollow"])').each(init_hover);
	});
});

$(document).ready(function(){

window.boards = new Array();

if (window.Options && Options.get_tab('general')) {
	Options.extend_tab("general", "<label id='show_top_boards'><input type='checkbox' /> "+_('Show top boards')+"</label>");

	if (typeof localStorage.show_top_boards === 'undefined') {
		localStorage.show_top_boards = 'false';
		var show_top = JSON.parse(localStorage.show_top_boards);
	}

	var show_top = JSON.parse(localStorage.show_top_boards);
	if (show_top) $('#show_top_boards>input').attr('checked', 'checked');


	$('#show_top_boards>input').on('change', function() {
		var show_top = ($(this).is(':checked'));
		localStorage.show_top_boards = JSON.stringify(show_top);

                if(show_top){
                        updateTopBoards(show_top);
                }else{
                        $('.sub[data-description="4"]').remove();
                }
	});
}

function updateTopBoards(show_top){
        if (!(typeof show_top !== "undefined" && !show_top)) {
                $.getJSON("//8kun.top/boards-top20.json", handle_boards);
        }
}

function handle_boards(data) {
	$.each(data, function(k, v) {
		boards.push('<a href="/'+v.uri+(window.active_page === 'catalog' ? '/catalog.html' : '/index.html')+'" title="'+v.title+'">'+v.uri+'</a>');
	})

	if (boards[0]) {
		$('.sub[data-description="1"]').after('<span class="sub" data-description="4"> [ '+boards.slice(0,25).join(" / ")+' ] </span>');
	}
}

if (!(window.location.pathname != '' && window.location.pathname != '/' && window.location.pathname != '/index.html' && typeof show_top !== "undefined" && !show_top)) {
	$.getJSON("//8kun.top/boards-top20.json", handle_boards)
}

});
/*
 * favorites.js - Allow user to favorite boards and put them in the bar
 *
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/favorites.js';
 *
 * XX: favorites.js may conflict with watch.js and compact-boardlist.js
 */

/*Uncomment these if you want to initialize operate and b board*/
if (!localStorage.favorites) {
	localStorage.favorites = '[]';
}

function favorite(board) {
	var favorites = JSON.parse(localStorage.favorites);
	favorites.push(board);
	localStorage.favorites = JSON.stringify(favorites);
};

function unfavorite(board) {
	var favorites = JSON.parse(localStorage.favorites);
	var index = $.inArray(board, favorites);
	if (~index) {
		favorites.splice(index, 1);
	}
	localStorage.favorites = JSON.stringify(favorites);
};

function handle_boards(data) {
	var boards = new Array();
	data = JSON.parse(data);

	$.each(data, function(k, v) {
    		var link_mod = "";
    		if(inMod){
      			link_mod = "?";
    		}

		boards.push('<a href="'+link_mod+'/'+v+(window.active_page === 'catalog' ? '/catalog.html' : '')+'">'+v+'</a>');
	})

	if (boards[0]) {
		return $('<span class="favorite-boards"></span>').append(' [ '+boards.join(" / ")+' ] ');
	} else {
		return $('<span class="favorite-boards"></span>');
	}	
}

function add_favorites() {
	$('.favorite-boards').remove();
	
	var boards = handle_boards(localStorage.favorites);

	$('.boardlist').append(boards);
};

if (active_page == 'thread' || active_page == 'index' || active_page == 'catalog') {
	$(document).ready(function(){
		var favorites = JSON.parse(localStorage.favorites);
		var is_board_favorite = ~$.inArray(board_name, favorites);

		$('header>h1').append('<a id="favorite-star" href="#" data-active="'+(is_board_favorite ? 'true' : 'false')+'" style="color: '+(is_board_favorite ? 'yellow' : 'grey')+'; text-decoration:none">\u2605</span>');
		add_favorites();

		$('#favorite-star').on('click', function(e) {
			e.preventDefault();
			if (!$(this).data('active')) {
				favorite(board_name);
				add_favorites();
				$(this).css('color', 'yellow');
				$(this).data('active', true);
			} else {
				unfavorite(board_name);
				add_favorites();
				$(this).css('color', 'grey');
				$(this).data('active', false);
			}
		});
	});
}
/*
 * show-op
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/show-op.js
 *
 * Adds "(OP)" to >>X links when the OP is quoted.
 *
 * Released under the MIT license
 * Copyright (c) 2012 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/show-op.js';
 *
 */

$(document).ready(function(){
	var showOPLinks = function() {
		var OP;
		
		if ($('div.banner').length == 0) {
			OP = parseInt($(this).parent().find('div.post.op a.post_no:eq(1)').text());
		} else {
			OP = parseInt($('div.post.op a.post_no:eq(1)').text());
		}
		
		$(this).find('div.body a:not([rel="nofollow"])').each(function() {
			var postID;
			
			if(postID = $(this).text().match(/^>>(\d+)$/))
				postID = postID[1];
			else
				return;
			
			if (postID == OP) {
				$(this).after(' <small>(OP)</small>');
			}
		});
	};
	
	$('div.post.reply').each(showOPLinks);
	
	// allow to work with auto-reload.js, etc.
	$(document).on('new_post', function(e, post) {
		if ($(post).is('div.post.reply')) {
			$(post).each(showOPLinks);
		}
		else {
			$(post).find('div.post.reply').each(showOPLinks);
		}
	});
});


/*
 * smartphone-spoiler.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/smartphone-spoiler.js
 *
 * Released under the MIT license
 * Copyright (c) 2012 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net> 
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/mobile-style.js';
 *   $config['additional_javascript'][] = 'js/smartphone-spoiler.js';
 *
 */

onready(function(){
	if(device_type == 'mobile') {
		var fix_spoilers = function(where) {
			var spoilers = where.getElementsByClassName('spoiler');
			for(var i = 0; i < spoilers.length; i++) {
				spoilers[i].onmousedown = function() {
					this.style.color = 'white';
				};
			}
		};
		fix_spoilers(document);

	        // allow to work with auto-reload.js, etc.
	        $(document).on('new_post', function(e, post) {
	                fix_spoilers(post);
        	});             
	
	}
});

/*
 * inline-expanding.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/inline-expanding.js
 *
 * Released under the MIT license
 * Copyright (c) 2012-2013 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/inline-expanding.js';
 *
 */

$(document).ready(function(){
	'use strict';

	var DEFAULT_MAX = 5;  // default maximum image loads
	var inline_expand_post = function() {
		var link = this.getElementsByTagName('a');

		var loadingQueue = (function () {
			var MAX_IMAGES = localStorage.inline_expand_max || DEFAULT_MAX;   // maximum number of images to load concurrently, 0 to disable
			var loading = 0;                                                  // number of images that is currently loading
			var waiting = [];                                                 // waiting queue

			var enqueue = function (ele) {
				waiting.push(ele);
			};
			var dequeue = function () {
				return waiting.shift();
			};
			var update = function() {
				var ele;
				while (loading < MAX_IMAGES || MAX_IMAGES === 0) {
					ele = dequeue();
					if (ele) {
						++loading;
						ele.deferred.resolve();
					} else {
						return;
					}
				}
			};
			return {
				remove: function (ele) {
					var i = waiting.indexOf(ele);
					if (i > -1) {
						waiting.splice(i, 1);
					}
					if ($(ele).data('imageLoading') === 'true') {
						$(ele).data('imageLoading', 'false');
						clearTimeout(ele.timeout);
						--loading;
					}
				},
				add: function (ele) {
					ele.deferred = $.Deferred();
					ele.deferred.done(function () {
						var $loadstart = $.Deferred();
						var thumb = ele.childNodes[0];
						var img = ele.childNodes[1];

						var onLoadStart = function (img) {
							if (img.naturalWidth) {
								$loadstart.resolve(img, thumb);
							} else {
								return (ele.timeout = setTimeout(onLoadStart, 30, img));
							}
						};

						$(img).one('load', function () {
							$.when($loadstart).done(function () {
								//  once fully loaded, update the waiting queue
								--loading;
								$(ele).data('imageLoading', 'false');
								update();
							});
						});
						$loadstart.done(function (img, thumb) {
							thumb.style.display = 'none';
							img.style.display = '';
						});

						img.setAttribute('src', ele.href);
						$(ele).data('imageLoading', 'true');
						ele.timeout = onLoadStart(img);
					});

					if (loading < MAX_IMAGES || MAX_IMAGES === 0) {
						++loading;
						ele.deferred.resolve();
					} else {
						enqueue(ele);
					}

				}
			};
		})();

		for (var i = 0; i < link.length; i++) {
			if (typeof link[i] == "object" && link[i].childNodes && typeof link[i].childNodes[0] !== 'undefined' &&
					link[i].childNodes[0].src && link[i].childNodes[0].className.match(/post-image/) && !link[i].className.match(/file/)) {
				link[i].onclick = function(e) {
					var img, post_body, still_open, canvas, scroll;
					var thumb = this.childNodes[0];
					var padding = 5;
					var boardlist = $('.boardlist')[0];
					

					if (thumb.className == 'hidden')
						return false;
					if (e.which == 2 || e.ctrlKey) //  open in new tab
						return true;
					if (!$(this).data('expanded')) {

						if (~this.parentNode.className.indexOf('multifile'))
							$(this).data('width', this.parentNode.style.width);

						this.parentNode.removeAttribute('style');
						$(this).data('expanded', 'true');

						if (thumb.tagName === 'CANVAS') {
							canvas = thumb;
							thumb = thumb.nextSibling;
							this.removeChild(canvas);
							canvas.style.display = 'block';
						}

						thumb.style.opacity = '0.4';
						thumb.style.filter = 'alpha(opacity=40)';

						img = document.createElement('img');
						img.className = 'full-image';
						img.style.display = 'none';
						img.setAttribute('alt', 'Fullsized image');
						this.appendChild(img);

						loadingQueue.add(this);
					} else {
						loadingQueue.remove(this);

						scroll = false;

						//  scroll to thumb if not triggered by 'shrink all image'
						if (e.target.className == 'full-image') {
							scroll = true;
						}

						if (~this.parentNode.className.indexOf('multifile'))
							this.parentNode.style.width = $(this).data('width');

						thumb.style.opacity = '';
						thumb.style.display = '';
						if (thumb.nextSibling) this.removeChild(thumb.nextSibling);  //full image loaded or loading
						$(this).removeData('expanded');
						delete thumb.style.filter;

						//  do the scrolling after page reflow
						if (scroll) {
							post_body = $(thumb).parentsUntil('form > div').last();

							//  on multifile posts, determin how many other images are still expanded
							still_open = post_body.find('.post-image').filter(function(){
								return $(this).parent().data('expanded') == 'true';
							}).length;

							//  deal with differnt boards' menu styles
							if ($(boardlist).css('position') == 'fixed')
								padding += boardlist.getBoundingClientRect().height;

							if (still_open > 0) {
								if (thumb.getBoundingClientRect().top - padding < 0)
									$(document).scrollTop($(thumb).parent().parent().offset().top - padding);
							} else {
								if (post_body[0].getBoundingClientRect().top - padding < 0)
									$(document).scrollTop(post_body.offset().top - padding);
							}
						}

						if (localStorage.no_animated_gif === 'true' && typeof unanimate_gif === 'function') {
							unanimate_gif(thumb);
						}
					}
					return false;
				};
			}
		}
	};

	//  setting up user option
	if (window.Options && Options.get_tab('general')) {
		Options.extend_tab('general', '<span id="inline-expand-max">'+ _('Number of simultaneous image downloads (0 to disable): ') + 
										'<input type="number" step="1" min="0" size="4"></span>');
		$('#inline-expand-max input')
			.css('width', '50px')
			.val(localStorage.inline_expand_max || DEFAULT_MAX)
			.on('change', function (e) {
				// validation in case some fucktard tries to enter a negative floating point number
				var n = parseInt(e.target.value);
				var val = (n<0) ? 0 : n;

				localStorage.inline_expand_max = val;
			});
	}

	if (window.jQuery) {
		$('div[id^="thread_"]').each(inline_expand_post);

		// allow to work with auto-reload.js, etc.
		$(document).on('new_post', function(e, post) {
			inline_expand_post.call(post);
		});
	} else {
		inline_expand_post.call(document);
	}
});
/*
 * show-backlinks.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/show-backlinks.js
 *
 * Released under the MIT license
 * Copyright (c) 2012 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net> 
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   // $config['additional_javascript'][] = 'js/post-hover'; (optional; must come first)
 *   $config['additional_javascript'][] = 'js/show-backlinks.js';
 *
 */

onready(function(){
	var showBackLinks = function() {
		var reply_id = $(this).attr('id').replace(/^(reply|op)_/, '');
		
		$(this).find('div.body a:not([rel="nofollow"])').each(function() {
			var id, post, $mentioned;
		
			if(id = $(this).text().match(/^>>(\d+)$/))
				id = id[1];
			else
				return;
		
			$post = $('#reply_' + id);
			if($post.length == 0)
				$post = $('#op_' + id);

			if($post.length == 0)
				return;
		
			$mentioned = $post.find('p.intro span.mentioned');
			if($mentioned.length == 0)
				$mentioned = $('<span class="mentioned unimportant"></span>').appendTo($post.find('p.intro'));
			
			if ($mentioned.find('a.mentioned-' + reply_id).length != 0)
				return;
			
			var $link = $('<a class="mentioned-' + reply_id + '" onclick="highlightReply(\'' + reply_id + '\', event);" href="#' + reply_id + '">&gt;&gt;' +
				reply_id + '</a>');
			$link.appendTo($mentioned);
			$link.after(" ");
			
			if (window.init_hover) {
				$link.each(init_hover);
			}
		});
	};
	
	$('div.post.reply').each(showBackLinks);

        $(document).on('new_post', function(e, post) {
		if ($(post).hasClass("reply")) {
			showBackLinks.call(post);
		}
		else {
			$(post).find('div.post.reply').each(showBackLinks);
		}
	});
});

/* This file is dedicated to the public domain; you may do as you wish with it. */

if (typeof _ == 'undefined') {
  var _ = function(a) { return a; };
}

// Default settings
var defaultSettings = {
    "videoexpand": true,
    "videohover": false,
    "videovolume": 1.0,
    "videoloop": true
};

// Non-persistent settings for when localStorage is absent/disabled
var tempSettings = {};

// Scripts obtain settings by calling this function
function setting(name) {
    if (localStorage) {
        if (localStorage[name] === undefined) return defaultSettings[name];
        return JSON.parse(localStorage[name]);
    } else {
        if (tempSettings[name] === undefined) return defaultSettings[name];
        return tempSettings[name];
    }
}

// Settings should be changed with this function
function changeSetting(name, value) {
    if (localStorage) {
        localStorage[name] = JSON.stringify(value);
    } else {
        tempSettings[name] = value;
    }
}

// Create settings menu
var settingsMenu = document.createElement("div");
var prefix = "", suffix = "", style = "";
if (window.Options) {
  var tab = Options.add_tab("webm", "video-camera", _("WebM"));
  $(settingsMenu).appendTo(tab.content);
}
else {
  prefix = '<a class="unimportant" href="javascript:void(0)">'+_('WebM Settings')+'</a>';
  settingsMenu.style.textAlign = "right";
  settingsMenu.style.background = "inherit";
  suffix = '</div>';
  style = 'display: none; text-align: left; position: absolute; right: 1em; margin-left: -999em; margin-top: -1px; padding-top: 1px; background: inherit;';
}

settingsMenu.innerHTML = prefix
    + '<div style="'+style+'">'
    + '<label><input type="checkbox" name="videoexpand">'+_('Expand videos inline')+'</label><br>'
    + '<label><input type="checkbox" name="videohover">'+_('Play videos on hover')+'</label><br>'
    + '<label><input type="checkbox" name="videoloop">'+_('Loop videos by default')+'</label><br>'
    + '<label><input type="range" name="videovolume" min="0" max="1" step="0.01" style="width: 4em; height: 1ex; vertical-align: middle; margin: 0px;">'+_('Default volume')+'</label><br>'
    + suffix;

function refreshSettings() {
    var settingsItems = settingsMenu.getElementsByTagName("input");
    for (var i = 0; i < settingsItems.length; i++) {
        var control = settingsItems[i];
        if (control.type == "checkbox") {
            control.checked = setting(control.name);
        } else if (control.type == "range") {
            control.value = setting(control.name);
        }
    }
}

function setupControl(control) {
    if (control.addEventListener) control.addEventListener("change", function(e) {
        if (control.type == "checkbox") {
            changeSetting(control.name, control.checked);
        } else if (control.type == "range") {
            changeSetting(control.name, control.value);
        }
    }, false);
}

refreshSettings();
var settingsItems = settingsMenu.getElementsByTagName("input");
for (var i = 0; i < settingsItems.length; i++) {
    setupControl(settingsItems[i]);
}

if (settingsMenu.addEventListener && !window.Options) {
    settingsMenu.addEventListener("mouseover", function(e) {
        refreshSettings();
        settingsMenu.getElementsByTagName("a")[0].style.fontWeight = "bold";
        settingsMenu.getElementsByTagName("div")[0].style.display = "block";
    }, false);
    settingsMenu.addEventListener("mouseout", function(e) {
        settingsMenu.getElementsByTagName("a")[0].style.fontWeight = "normal";
        settingsMenu.getElementsByTagName("div")[0].style.display = "none";
    }, false);
}
/* This file is dedicated to the public domain; you may do as you wish with it. */
/* Note: This code expects the global variable configRoot to be set. */

if (typeof _ == 'undefined') {
  var _ = function(a) { return a; };
}

function setupVideo(thumb, url) {
    if (thumb.videoAlreadySetUp) return;
    thumb.videoAlreadySetUp = true;

    var video = null;
    var videoContainer, videoHide;
    var expanded = false;
    var hovering = false;
    var loop = setting("videoloop");
    var loopControls = [document.createElement("span"), document.createElement("span")];
    var fileInfo = thumb.parentNode.querySelector(".fileinfo");
    var mouseDown = false;

    function unexpand() {
        if (expanded) {
            expanded = false;
            if (video.pause) video.pause();
            videoContainer.style.display = "none";
            thumb.style.display = "inline";
            video.style.maxWidth = "inherit";
            video.style.maxHeight = "inherit";
        }
    }

    function unhover() {
        if (hovering) {
            hovering = false;
            if (video.pause) video.pause();
            videoContainer.style.display = "none";
            video.style.maxWidth = "inherit";
            video.style.maxHeight = "inherit";
        }
    }

    // Create video element if does not exist yet
    function getVideo() {
        if (video == null) {
            video = document.createElement("video");
            video.src = url;
            video.loop = loop;
            video.innerText = _("Your browser does not support HTML5 video.");

            videoHide = document.createElement("img");
            videoHide.src = configRoot + "static/collapse.gif";
            videoHide.alt = "[ - ]";
            videoHide.title = "Collapse video";
            videoHide.style.marginLeft = "-15px";
            videoHide.style.cssFloat = "left";
            videoHide.addEventListener("click", unexpand, false);

            videoContainer = document.createElement("div");
            videoContainer.style.paddingLeft = "15px";
            videoContainer.style.display = "none";
            videoContainer.appendChild(videoHide);
            videoContainer.appendChild(video);
            thumb.parentNode.insertBefore(videoContainer, thumb.nextSibling);

            // Dragging to the left collapses the video
            video.addEventListener("mousedown", function(e) {
                if (e.button == 0) mouseDown = true;
            }, false);
            video.addEventListener("mouseup", function(e) {
                if (e.button == 0) mouseDown = false;
            }, false);
            video.addEventListener("mouseenter", function(e) {
                mouseDown = false;
            }, false);
            video.addEventListener("mouseout", function(e) {
                if (mouseDown && e.clientX - video.getBoundingClientRect().left <= 0) {
                    unexpand();
                }
                mouseDown = false;
            }, false);
        }
    }

    // Clicking on thumbnail expands video
    thumb.addEventListener("click", function(e) {
        if (setting("videoexpand") && !e.shiftKey && !e.ctrlKey && !e.altKey && !e.metaKey) {
            getVideo();
            expanded = true;
            hovering = false;

            video.style.position = "static";
            video.style.pointerEvents = "inherit";
            video.style.display = "inline";
            videoHide.style.display = "inline";
            videoContainer.style.display = "block";
            videoContainer.style.position = "static";
            video.parentNode.parentNode.removeAttribute('style');
            thumb.style.display = "none";

            video.muted = (setting("videovolume") == 0);
            video.volume = setting("videovolume");
            video.controls = true;
            if (video.readyState == 0) {
                video.addEventListener("loadedmetadata", expand2, false);
            } else {
                setTimeout(expand2, 0);
            }
            video.play();
            e.preventDefault();
        }
    }, false);

    function expand2() {
        video.style.maxWidth = "100%";
        video.style.maxHeight = window.innerHeight + "px";
        var bottom = video.getBoundingClientRect().bottom;
        if (bottom > window.innerHeight) {
            window.scrollBy(0, bottom - window.innerHeight);
        }
        // work around Firefox volume control bug
        video.volume = Math.max(setting("videovolume") - 0.001, 0);
        video.volume = setting("videovolume");
    }

    // Hovering over thumbnail displays video
    thumb.addEventListener("mouseover", function(e) {
        if (setting("videohover")) {
            getVideo();
            expanded = false;
            hovering = true;

            var docRight = document.documentElement.getBoundingClientRect().right;
            var thumbRight = thumb.querySelector("img, video").getBoundingClientRect().right;
            var maxWidth = docRight - thumbRight - 20;
            if (maxWidth < 250) maxWidth = 250;

            video.style.position = "fixed";
            video.style.right = "0px";
            video.style.top = "0px";
            var docRight = document.documentElement.getBoundingClientRect().right;
            var thumbRight = thumb.querySelector("img, video").getBoundingClientRect().right;
            video.style.maxWidth = maxWidth + "px";
            video.style.maxHeight = "100%";
            video.style.pointerEvents = "none";

            video.style.display = "inline";
            videoHide.style.display = "none";
            videoContainer.style.display = "inline";
            videoContainer.style.position = "fixed";

            video.muted = (setting("videovolume") == 0);
            video.volume = setting("videovolume");
            video.controls = false;
            video.play();
        }
    }, false);

    thumb.addEventListener("mouseout", unhover, false);

    // Scroll wheel on thumbnail adjusts default volume
    thumb.addEventListener("wheel", function(e) {
        if (setting("videohover")) {
            var volume = setting("videovolume");
            if (e.deltaY > 0) volume -= 0.1;
            if (e.deltaY < 0) volume += 0.1;
            if (volume < 0) volume = 0;
            if (volume > 1) volume = 1;
            if (video != null) {
                video.muted = (volume == 0);
                video.volume = volume;
            }
            changeSetting("videovolume", volume);
            e.preventDefault();
        }
    }, false);

    // [play once] vs [loop] controls
    function setupLoopControl(i) {
        loopControls[i].addEventListener("click", function(e) {
            loop = (i != 0);
            thumb.href = thumb.href.replace(/([\?&])loop=\d+/, "$1loop=" + i);
            if (video != null) {
                video.loop = loop;
                if (loop && video.currentTime >= video.duration) {
                    video.currentTime = 0;
                }
            }
            loopControls[i].style.fontWeight = "bold";
            loopControls[1-i].style.fontWeight = "inherit";
        }, false);
    }

    loopControls[0].textContent = _("[play once]");
    loopControls[1].textContent = _("[loop]");
    loopControls[(setting("videoloop") ? 1 : 0)].style.fontWeight = "bold";
    for (var i = 0; i < 2; i++) {
        setupLoopControl(i);
        loopControls[i].style.whiteSpace = "nowrap";
        fileInfo.appendChild(document.createTextNode(" "));
        fileInfo.appendChild(loopControls[i]);
    }
}

function setupVideosIn(element) {
    var thumbs = element.querySelectorAll("a.file");
    for (var i = 0; i < thumbs.length; i++) {
        if (/(\.webm)|(\.mp4)$/.test(thumbs[i].pathname)) {
            setupVideo(thumbs[i], thumbs[i].href);
        } else {
            var m = thumbs[i].search.match(/\bv=([^&]*)/);
            if (m != null) {
                var url = decodeURIComponent(m[1]);
                if (/(\.webm)|(\.mp4)$/.test(url)) setupVideo(thumbs[i], url);
            }
        }
    }
}

onready(function(){
    // Insert menu from settings.js
    if (typeof settingsMenu != "undefined" && typeof Options == "undefined")
      document.body.insertBefore(settingsMenu, document.getElementsByTagName("hr")[0]);

    // Setup Javascript events for videos in document now
    setupVideosIn(document);

    // Setup Javascript events for videos added by updater
    if (window.MutationObserver) {
        var observer = new MutationObserver(function(mutations) {
            for (var i = 0; i < mutations.length; i++) {
                var additions = mutations[i].addedNodes;
                if (additions == null) continue;
                for (var j = 0; j < additions.length; j++) {
                    var node = additions[j];
                    if (node.nodeType == 1) {
                        setupVideosIn(node);
                    }
                }
            }
        });
        observer.observe(document.body, {childList: true, subtree: true});
    }
});

/*
 * treeview.js
 * https://github.com/vichan-devel/vichan/blob/master/js/treeview.js
 *
 * Released under the MIT license
 * Copyright (c) 2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/treeview.js';
 *
 */

if (active_page == 'thread' || active_page == 'ukko' || active_page == 'index')
$(function() {
	if (window.Options && Options.get_tab('general')) {
		var selector = '#treeview-global>input';
		Options.extend_tab("general", "<label id='treeview-global'><input type='checkbox' /> "+_('Use tree view by default')+"</label>");
		$(selector).on('change', function() {
			if (localStorage.treeview === 'true') {
				localStorage.treeview = 'false';
			} else {
				localStorage.treeview = 'true';
			}
		});
		if (localStorage.treeview === 'true') {
			$(selector).attr('checked', 'checked');
		}
	}
});

if (active_page == 'thread')
$(function() {
	var treeview = function(enable) {
		if (enable === true) {
			$('.post.reply').each(function(){
				var references = [];
				$(this).find('.body a').each(function(){
					if ($(this).html().match('^&gt;&gt;[0-9]+$')) {
						references.push(parseInt($(this).html().replace('&gt;&gt;', '')));
					}
				});
				var maxref = references.reduce(function(a,b) { return a > b ? a : b; }, 0);

				var parent_post = $("#reply_"+maxref);
				if (parent_post.length == 0) return;

				var margin = parseInt(parent_post.css("margin-left"))+32;

				var post = $(this);
				var br = post.next();

				post.detach().css("margin-left", margin).insertAfter(parent_post.next());
				br.detach().insertAfter(post);
			});
		} else {
			$('.post.reply').sort(function(a,b) {
				return parseInt(a.id.replace('reply_', '')) - parseInt(b.id.replace('reply_', ''));
			}).each(function () {
				var post = $(this);
				var br = post.next();
				post.detach().css('margin-left', '').appendTo('.thread');
				br.detach().insertAfter(post);
			});
		}
	}

	$('hr:first').before('<div class="unimportant" style="text-align:right"><label for="treeview"><input type="checkbox" id="treeview"> '+_('Tree view')+'</label></div>');
	$('input#treeview').on('change', function(e) { treeview($(this).is(':checked')); });

	if (localStorage.treeview === 'true') {
		treeview(true);
		$('input#treeview').attr('checked', true);
	}
});
/*
 * expand-too-long.js
 * https://github.com/vichan-devel/vichan/blob/master/js/expand-too-long.js
 *
 * Released under the MIT license
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/expand-too-long.js';
 *      
 */

$(function() {
	var do_expand = function() {
		$(this).find('a').click(function(e) {
			e.preventDefault();

			var url = $(this).attr('href');
			var body = $(this).parents('.body');

			$.ajax({
				url: url,
				context: document.body,
				success: function(data) {
					var content = $(data).find('#'+url.split('#')[1]).parent().parent().find(".body").first().html();

					body.html(content);
				}
			});
		});
	};

        $('.toolong').each(do_expand);
                       
        $(document).on("new_post", function(e, post) {
		$(post).find('.toolong').each(do_expand)
	});
});
/*
* settings.js
* https://github.com/savetheinternet/Tinyboard/blob/master/js/settings.js
*
* Optional settings. Used to customize some scripts without needing to tweak their code.
* Notes:
*   - You must include this script first.
*   - This file is just an example.
*   - You should copy settings.js to something like instance.settings.js to prevent conflicts when upgrading.
*   - This file should always be optional.
*
* Released under the MIT license
* Copyright (c) 2013 Michael Save <savetheinternet@tinyboard.org>
* Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
*
* Usage:
*   $config['additional_javascript'][] = 'js/jquery.min.js';
*   $config['additional_javascript'][] = 'js/instance.settings.js';
*   // $config['additional_javascript'][] = 'js/quick-reply.js';
*
* Usage in scripts:
*   var settings = new script_settings('my-script');
*   var some_value = settings.get('option', 'default value');
*
*/

var tb_settings = {};

// quick-reply.js
tb_settings['quick-reply'] = {
	// Hide form when scrolled to top of page (where original form is visible)
	hide_at_top: true,
	// "Quick reply" button floating at the top right hand corner of the page at all times
	floating_link: false,
	// Show remote in quick reply
	show_remote: false,
	// Show embedding in quick reply
	show_embed: true
};

// ajax.js
tb_settings['ajax'] = {
	// Always act as if "noko" was typed when posting replies with the ajax script
	always_noko_replies: false	
};

// wpaint.js
tb_settings['wpaint'] = {
	// Canvas width
	width: 500,
	// Canvas height
	height: 250
};

// auto-reload.js
tb_settings['auto-reload'] = {
	// Minimum delay before reloading the page when at the bottom
	min_delay_bottom: 5000,
	// Maximum delay before reloading the page
	max_delay: 600000,
	// Delay if there was an error
	error_delay: 30000,
	// Reset the delay to the minimum upon focussing the window.
	reset_focus: true
};
/*
 * hide-images.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/hide-images.js
 *
 * Hide individual images.
 *
 * Released under the MIT license
 * Copyright (c) 2013 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/hide-images.js';
 *
 */

$(document).ready(function(){
	$('<style type="text/css"> img.hidden{ opacity: 0.1; background: grey; border: 1px solid #000; } </style>').appendTo($('head'));
	
	if (!localStorage.hiddenimages)
		localStorage.hiddenimages = '{}';

	// Load data from HTML5 localStorage
	var hidden_data = JSON.parse(localStorage.hiddenimages);

	var store_data = function() {
		localStorage.hiddenimages = JSON.stringify(hidden_data);
	};

	// Delete old hidden images (30+ days old)
	for (var key in hidden_data) {
		for (var id in hidden_data[key]) {
			if (hidden_data[key][id] < Math.round(Date.now() / 1000) - 60 * 60 * 24 * 30) {
				delete hidden_data[key][id];
				store_data();
			}
		}
	}

	var handle_images = function() {
		var index = $(this).parents('.file').index();
		var img = this;
		var fileinfo = $(this).parent().prev();
		var id = $(this).parents('div.post, div[id^="thread_"]').attr('id').split('_')[1];
		var board = $(this).parents('[id^="thread_"]').data("board");

		if (!hidden_data[board]) {
			hidden_data[board] = {}; // id : timestamp
		}
		
		var replacement = $('<span>'+_('File')+' <small>(<a class="hide-image-link" href="javascript:void(0)">'+_('hide')+'</a>)</small>: </span>');
				
		replacement.find('a').click(function() {
			if (hidden_data[board][id]) {
				hidden_data[board][id]['ts'] = Math.round(Date.now() / 1000);
				if (hidden_data[board][id]['index'].indexOf(index) === -1)
					hidden_data[board][id]['index'].push(index);
			} else {
				hidden_data[board][id] = {ts: Math.round(Date.now() / 1000), index: [index]};
			}
			store_data();
			
			var show_link = $('<a class="show-image-link" href="javascript:void(0)">'+_('show')+'</a>').click(function() {
				var i = hidden_data[board][id]['index'].indexOf(index);
				if (i > -1) hidden_data[board][id]['index'].splice(i,1);
				
				if (hidden_data[board][id]['index'].length === 0)
					delete hidden_data[board][id];
				store_data();
				
				$(img)
					.removeClass('hidden')
					.attr('src', $(img).data('orig'));
				$(this).prev().show();
				$(this).remove();
			});
			
			$(this).hide().after(show_link);
			
			if ($(img).parent().data('expanded') == 'true') {
				$(img).parent().click();
			}
		
			$(img)
				.data('orig', img.src)
				.attr('src', 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==')
				.addClass('hidden');
		});
		
		$(this).parent().prev().contents().first().replaceWith(replacement);
		
		if (hidden_data[board][id] && hidden_data[board][id]['index'].indexOf(index) !== -1)
			$(this).parent().prev().find('.hide-image-link').click();
	};

	$('div.post > a > img.post-image, div > a > img.post-image').each(handle_images);

        $(document).on('new_post', function(e, post) {
                $(post).find('a > img.post-image').each(handle_images);
        });
});
/*
 * expand-all-images.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/expand-all-images.js
 *
 * Adds an "Expand all images" button to the top of the page.
 *
 * Released under the MIT license
 * Copyright (c) 2012-2013 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 * Copyright (c) 2014 sinuca <#55ch@rizon.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/inline-expanding.js';
 *   $config['additional_javascript'][] = 'js/expand-all-images.js';
 *
 */

if (active_page == 'ukko' || active_page == 'thread' || active_page == 'index')
onready(function(){
	$('hr:first').before('<div id="expand-all-images" style="text-align:right"><a class="unimportant" href="javascript:void(0)"></a></div>');
	$('div#expand-all-images a')
		.text(_('Expand all images'))
		.click(function() {
			$('a img.post-image').each(function() {
				// Don't expand YouTube embeds
				if ($(this).parent().parent().hasClass('video-container'))
					return;

				// or WEBM
				if (/^\/player\.php\?/.test($(this).parent().attr('href')))
					return;

				if (!$(this).parent().data('expanded'))
					$(this).parent().click();
			});

			if (!$('#shrink-all-images').length) {
				$('hr:first').before('<div id="shrink-all-images" style="text-align:right"><a class="unimportant" href="javascript:void(0)"></a></div>');
			}

			$('div#shrink-all-images a')
				.text(_('Shrink all images'))
				.click(function(){
					$('a img.full-image').each(function() {
						if ($(this).parent().data('expanded'))
							$(this).parent().click();
					});
					$(this).parent().remove();
				});
		});
});
/*
 * local-time.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/local-time.js
 *
 * Released under the MIT license
 * Copyright (c) 2012 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   // $config['additional_javascript'][] = 'js/jquery.min.js';
 *   // $config['additional_javascript'][] = 'js/strftime.min.js';
 *   $config['additional_javascript'][] = 'js/local-time.js';
 *
 */

$(document).ready(function(){
	'use strict';

	var iso8601 = function(s) {
		s = s.replace(/\.\d\d\d+/,""); // remove milliseconds
		s = s.replace(/-/,"/").replace(/-/,"/");
		s = s.replace(/T/," ").replace(/Z/," UTC");
		s = s.replace(/([\+\-]\d\d)\:?(\d\d)/," $1$2"); // -04:00 -> -0400
		return new Date(s);
	};
	var zeropad = function(num, count) {
		return [Math.pow(10, count - num.toString().length), num].join('').substr(1);
	};

	var dateformat = (typeof strftime === 'undefined') ? function(t) {
		return zeropad(t.getMonth() + 1, 2) + "/" + zeropad(t.getDate(), 2) + "/" + t.getFullYear().toString().substring(2) +
				" (" + [_("Sun"), _("Mon"), _("Tue"), _("Wed"), _("Thu"), _("Fri"), _("Sat"), _("Sun")][t.getDay()]  + ") " +
				// time
				zeropad(t.getHours(), 2) + ":" + zeropad(t.getMinutes(), 2) + ":" + zeropad(t.getSeconds(), 2);

	} : function(t) {
		// post_date is defined in templates/main.js
		return strftime(window.post_date, t, datelocale);
	};

	function timeDifference(current, previous) {

		var msPerMinute = 60 * 1000;
		var msPerHour = msPerMinute * 60;
		var msPerDay = msPerHour * 24;
		var msPerMonth = msPerDay * 30;
		var msPerYear = msPerDay * 365;

		var elapsed = current - previous;

		if (elapsed < msPerMinute) {
			return 'Just now';
		} else if (elapsed < msPerHour) {
			return Math.round(elapsed/msPerMinute) + (Math.round(elapsed/msPerMinute)<=1 ? ' minute ago':' minutes ago');
		} else if (elapsed < msPerDay ) {
			return Math.round(elapsed/msPerHour ) + (Math.round(elapsed/msPerHour)<=1 ? ' hour ago':' hours ago');
		} else if (elapsed < msPerMonth) {
			return Math.round(elapsed/msPerDay) + (Math.round(elapsed/msPerDay)<=1 ? ' day ago':' days ago');
		} else if (elapsed < msPerYear) {
			return Math.round(elapsed/msPerMonth) + (Math.round(elapsed/msPerMonth)<=1 ? ' month ago':' months ago');
		} else {
			return Math.round(elapsed/msPerYear ) + (Math.round(elapsed/msPerYear)<=1 ? ' year ago':' years ago');
		}
	}

	var do_localtime = function(elem) {	
		var times = elem.getElementsByTagName('time');
		var currentTime = Date.now();

		for(var i = 0; i < times.length; i++) {
			var t = times[i].getAttribute('datetime');
			var postTime = new Date(t);

			times[i].setAttribute('data-local', 'true');

			if (!localStorage.show_relative_time || localStorage.show_relative_time === 'false') {
				times[i].innerHTML = dateformat(iso8601(t));
				times[i].setAttribute('title', timeDifference(currentTime, postTime.getTime()));
			} else {
				times[i].innerHTML = timeDifference(currentTime, postTime.getTime());
				times[i].setAttribute('title', dateformat(iso8601(t)));
			}
		
		}
	};

	if (window.Options && Options.get_tab('general') && window.jQuery) {
		var interval_id;
		Options.extend_tab('general', '<label id="show-relative-time"><input type="checkbox">' + _('Show relative time') + '</label>');

		$('#show-relative-time>input').on('change', function() {
			if (localStorage.show_relative_time === 'true') {
				localStorage.show_relative_time = 'false';
				clearInterval(interval_id);
			} else {
				localStorage.show_relative_time = 'true';
				interval_id = setInterval(do_localtime, 30000, document);
			}
			// no need to refresh page
			do_localtime(document);
		});

		if (localStorage.show_relative_time === 'true') {
			$('#show-relative-time>input').attr('checked','checked');
			interval_id = setInterval(do_localtime, 30000, document);
		}

		// allow to work with auto-reload.js, etc.
		$(document).on('new_post', function(e, post) {
			do_localtime(post);
		});
	}

	do_localtime(document);
});
/*
 * expand.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/expand.js
 *
 * Released under the MIT license
 * Copyright (c) 2012-2013 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013 Czterooki <czterooki1337@gmail.com>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/expand.js';
 *
 */

$(document).ready(function(){
	if($('span.omitted').length == 0)
		return; // nothing to expand

	var do_expand = function() {
		$(this)
			.html($(this).text().replace(_("Click reply to view."), '<a href="javascript:void(0)">'+_("Click to expand")+'</a>.'))
			.find('a').click(window.expand_fun = function() {
				var thread = $(this).parents('[id^="thread_"]');
				var id = thread.attr('id').replace(/^thread_/, '');
				$.ajax({
					url: thread.find('div.post:not(.hidden) p.intro a.post_no:first').attr('href'),
					context: document.body,
					success: function(data) {
						var last_expanded = false;
						$(data).find('div.post.reply').each(function() {
							thread.find('div.hidden').remove();
							var post_in_doc = thread.find('#' + $(this).attr('id'));
							if(post_in_doc.length == 0) {
								if(last_expanded) {
									$(this).addClass('expanded').insertAfter(last_expanded).before('<br class="expanded">');
								} else {
									$(this).addClass('expanded').insertAfter(thread.find('div.post:first')).after('<br class="expanded">');
								}
								last_expanded = $(this);
								$(document).trigger('new_post', this);
							} else {
								last_expanded = post_in_doc;
							}
						});
						

						thread.find("span.omitted").css('display', 'none');

						$('<span class="omitted hide-expanded"><a href="javascript:void(0)">' + _('Hide expanded replies') + '</a>.</span>')
							.insertAfter(thread.find('.op div.body, .op span.omitted').last())
							.click(function() {
								thread.find('.expanded').remove();
								$(this).parent().find(".omitted:not(.hide-expanded)").css('display', '');
								$(this).parent().find(".hide-expanded").remove();
							});
					}
				});
			});
	}

	$('div.post.op span.omitted').each(do_expand);

	$(document).on("new_post", function(e, post) {
		if (!$(post).hasClass("reply")) {
			$(post).find('div.post.op span.omitted').each(do_expand);
		}
	});
});
/*
 * auto-reload.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/auto-reload.js
 *
 * Brings AJAX to Tinyboard.
 *
 * Released under the MIT license
 * Copyright (c) 2012 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 * Copyright (c) 2013 undido <firekid109@hotmail.com>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   //$config['additional_javascript'][] = 'js/titlebar-notifications.js';
 *   $config['additional_javascript'][] = 'js/auto-reload.js';
 *
 */

// From http://stackoverflow.com/a/14035162
$.fn.scrollStopped = function(callback) {		   
	$(this).scroll(function(){
		var self = this, $this = $(self);
		if ($this.data('scrollTimeout')) {
		  clearTimeout($this.data('scrollTimeout'));
		}
		$this.data('scrollTimeout', setTimeout(callback,250,self));
	});
};

function makeIcon(mode){
	var favicon = $("link[rel='shortcut icon']");

	if (!favicon.length) {
		var favicon = $('<link rel="shortcut icon"></link>').appendTo('head');
	}

	$("link[rel='shortcut icon']").attr("href", configRoot+"static/favicon"+(mode?"-"+mode:"")+".ico");
}


var settings = new script_settings('auto-reload');
var poll_interval_mindelay        = settings.get('min_delay_bottom', 5000);
var poll_interval_maxdelay        = settings.get('max_delay', 600000);
var poll_interval_errordelay      = settings.get('error_delay', 30000);

// number of ms to wait before reloading
var poll_interval_delay = poll_interval_mindelay;
var poll_current_time = poll_interval_delay;
var poll_finish = true;


+function(){
var notify = false;
auto_reload_enabled = true; // for watch.js to interop

$(document).ready(function(){

	// Adds Options panel item
	if (typeof localStorage.auto_thread_update === 'undefined') {
		localStorage.auto_thread_update = 'true'; //default value
	}
	if (window.Options && Options.get_tab('general')) {
		Options.extend_tab("general", "<fieldset id='auto-update-fs'><legend>"+_("Auto update")+"</legend>"
		+ ('<label id="auto-thread-update"><input type="checkbox">' + _('Auto update thread') + '</label>')
		+ ('<label id="auto_thread_desktop_notifications"><input type="checkbox">' + _('Show desktop notifications when users quote me') + '</label>')
		+ ('<label id="auto_thread_desktop_notifications_all"><input type="checkbox">' + _('Show desktop notifications on all replies') + '</label>')
		+ '</fieldset>');

		$('#auto-thread-update>input').on('click', function() {
			if ($('#auto-thread-update>input').is(':checked')) {
				localStorage.auto_thread_update = 'true';
			} else {
				localStorage.auto_thread_update = 'false';
			}
		});

		$('#auto_thread_desktop_notifications>input,#auto_thread_desktop_notifications_all>input').on('click', function() {
			if (!("Notification" in window)) return;
	
			var setting = $(this).parent().attr('id');

			if ($(this).is(':checked')) {
				Notification.requestPermission(function(permission){
					if (permission === "granted") {
						localStorage[setting] = 'true';
					}
				});
				if (Notification.permission === "granted") {
					localStorage[setting] = 'true';
				}
			} else {
				localStorage[setting] = 'false';
			}
		});

		if (localStorage.auto_thread_update === 'true') {
			$('#auto-thread-update>input').prop('checked', true);
		}

		if (localStorage.auto_thread_desktop_notifications === 'true') {
			$('#auto_thread_desktop_notifications>input').prop('checked', true);
			notify = "mention";
		}

		if (localStorage.auto_thread_desktop_notifications_all === 'true') {
			$('#auto_thread_desktop_notifications_all>input').prop('checked', true);
			notify = "all";
		}
	}

	// not thread
	if (active_page != 'thread')
		return;

	var countdown_interval;
        var auto_update_html = "";

        if(!inMod){
                var auto_update_html = "<a href='#' id='update_thread'>["+_("Update")+"]</a> (<input type='checkbox' id='auto_update_status'> "+_("Auto")+") <span id='update_secs'></span>";
        }

        // Add an update link
        $('span#thread-links').append("<span id='updater'>"+auto_update_html+"</span>");

	// Set the updater checkbox according to user setting
	if (localStorage.auto_thread_update === 'true') {
		$('#auto_update_status').prop('checked', true);
	}

	// Grab the settings
	/*var settings = new script_settings('auto-reload');
	var poll_interval_mindelay        = settings.get('min_delay_bottom', 5000);
	var poll_interval_maxdelay        = settings.get('max_delay', 600000);
	var poll_interval_errordelay      = settings.get('error_delay', 30000);

	// number of ms to wait before reloading
	var poll_interval_delay = poll_interval_mindelay;
	var poll_current_time = poll_interval_delay;*/

	var end_of_page = false;

	var new_posts = 0;
	var first_new_post = null;
	
	var title = document.title;

	if (typeof update_title == "undefined") {
		var update_title = function() { 
			if (new_posts) {
				document.title = "("+new_posts+") "+title;
			} else {
				document.title = title;
				makeIcon(false);
			}
		};
	}

	if (typeof add_title_collector != "undefined")
	add_title_collector(function(){
	  return new_posts;
	});

	var window_active = true;
	$(window).focus(function() {
		window_active = true;
		recheck_activated();

		// Reset the delay if needed
		if(settings.get('reset_focus', true)) {
			poll_interval_delay = poll_interval_mindelay;
		}
	});
	$(window).blur(function() {
		window_active = false;
	});
	

	$('#auto_update_status').click(function() {
		if($("#auto_update_status").is(':checked')) {
			auto_update(poll_interval_mindelay);
		} else {
			stop_auto_update();
			$('#update_secs').text("");
		}

	});
	

	var decrement_timer = function() {
		poll_current_time = poll_current_time - 1000;
		$('#update_secs').text(poll_current_time/1000);
		
		if (poll_current_time <= 0) {
			poll(manualUpdate = false);
		}
	}

	var recheck_activated = function(end_of_page) {
		if (typeof end_of_page == "undefined") var end_of_page = false;
		if (end_of_page || (new_posts && window_active &&
			$(window).scrollTop() + $(window).height() >=
			$('div.boardlist.bottom').position().top)) {

			new_posts = 0;
		}
		update_title();
		first_new_post = null;
	};
	
	// automatically updates the thread after a specified delay
	var auto_update = function(delay) {
		clearInterval(countdown_interval);

		poll_current_time = delay;		
		countdown_interval = setInterval(decrement_timer, 1000);
		$('#update_secs').text(poll_current_time/1000);		
	}
	
	var stop_auto_update = function() {
		clearInterval(countdown_interval);
	}
		
	var epoch = (new Date).getTime();
	var epochold = epoch;
		
	var timeDiff = function (delay) {
		if((epoch-epochold) > delay) {
			epochold = epoch = (new Date).getTime();
			return true;
		}else{
			epoch = (new Date).getTime();
			return;
		}
	}
	
	var poll = function(manualUpdate) {
		stop_auto_update();
		$('#update_secs').text(_("Updating..."));

                replies_total_limit = 751; 
                if(typeof $(".fa-refresh").attr("title") === 'undefined' && $('div.post.reply').length >= replies_total_limit){
                        $('#auto_update_status').prop('checked', false);
                }

		$.ajax({
			url: document.location,
			success: function(data) {
				var loaded_posts = 0;	// the number of new posts loaded in this update
				$(data).find('div.post.reply').each(function() {
					var id = $(this).attr('id');
					if($('#' + id).length == 0) {
						if (!new_posts) {
							first_new_post = this;
							makeIcon('reply');
							if (notify === "all" || (notify === "mention" && $(this).find('.own_post').length)) {
								var body = $(this).children('.body').html().replace(/<br\s*[\/]?>/gi, "\n");
								var n = new Notification("New reply to "+$('title').text(), {body: $('<div/>').html(body).text()});
							}
						}
						$(this).insertAfter($('div.post:not(.post-hover):last').next()).after('<br class="clear">');
						new_posts++;
						loaded_posts++;
						$(document).trigger('new_post', this);
						recheck_activated();
					}
				});
				time_loaded = Date.now(); // interop with watch.js
				
				
				if ($('#auto_update_status').is(':checked')) {
					// If there are no new posts, double the delay. Otherwise set it to the min.
					if(loaded_posts == 0) {
						// if the update was manual, don't increase the delay
						if (manualUpdate == false) {
							poll_interval_delay *= 2;
				
							// Don't increase the delay beyond the maximum
							if(poll_interval_delay > poll_interval_maxdelay) {
								poll_interval_delay = poll_interval_maxdelay;
							}
						}
					} else {
						poll_interval_delay = poll_interval_mindelay;
					}
					
					auto_update(poll_interval_delay);
				} else {
					// Decide the message to show if auto update is disabled
					if (loaded_posts > 0)
						$('#update_secs').text(fmt(_("Thread updated with {0} new post(s)"), [loaded_posts]));
					else
						$('#update_secs').text(_("No new posts found"));
				}
			},
			error: function(xhr, status_text, error_text) {
				if (status_text == "error") {
					if (error_text == "Not Found") {
						$('#update_secs').text(_("Thread deleted or pruned"));
						$('#auto_update_status').prop('checked', false);
						$('#auto_update_status').prop('disabled', true); // disable updates if thread is deleted
						return;
					} else {
						$('#update_secs').text("Error: "+error_text);
					}
				} else if (status_text) {
					$('#update_secs').text(_("Error: ")+status_text);
				} else {
					$('#update_secs').text(_("Unknown error"));
				}
				
				// Keep trying to update
				if ($('#auto_update_status').is(':checked')) {
					poll_interval_delay = poll_interval_errordelay;
					auto_update(poll_interval_delay);
				}
			}
		});
		
		return false;
	};
	
	$(window).scrollStopped(function() {
		// if the newest post is not visible
		if($(this).scrollTop() + $(this).height() <
			$('div.post:last').position().top + $('div.post:last').height()) {
			end_of_page = false;
		} else {
			if($("#auto_update_status").is(':checked') && timeDiff(poll_interval_mindelay)) {

				if(tor_browser === false){	
					//Start Vanwatech verification process
					var iframe = document.createElement("iframe");
					iframe.src = "https://8kun.top/vanwanet-verify";
					iframe.setAttribute("height","0");
					iframe.setAttribute("width","0");
					iframe.setAttribute("frameboarder","0");
					iframe.onload = function(){
						var requestStatusVerify = 0;
						while (requestStatusVerify != 502) {
							var request = new XMLHttpRequest();
							request.withCredentials = true;
							request.open('GET', 'https://8kun.top/vanwanet-verify', false);
							request.send(null);
							requestStatusVerify = request.status;
							//console.log(request.status);
						}
						//console.log("Verified - autoupdate true")
						poll(manualUpdate = true);
					};
					document.body.appendChild(iframe);
					//End vanwatech verification
				}else{
					poll(manualUpdate = true);
				}
				

			}
			end_of_page = true;
		}
		recheck_activated(end_of_page);
	});

	$('#update_thread').on('click', function() { 
		if(tor_browser === false){ 	
			//Start Vanwatech verification process
			var iframe = document.createElement("iframe");
			iframe.src = "https://8kun.top/vanwanet-verify";
			iframe.setAttribute("height","0");
			iframe.setAttribute("width","0");
			iframe.setAttribute("frameboarder","0");
			iframe.onload = function(){
				var requestStatusVerify = 0;
				while (requestStatusVerify != 502) {
					var request = new XMLHttpRequest();
					request.withCredentials = true;
					request.open('GET', 'https://8kun.top/vanwanet-verify', false);
					request.send(null); 
					requestStatusVerify = request.status;
				}
				//console.log("Verified - autoupdate true")
				poll(manualUpdate = true);
			};
			document.body.appendChild(iframe);
			//End vanwatech verification
		}else{
			poll(manualUpdate = true);
		}
		return false;
	});

	if($("#auto_update_status").is(':checked')) {
		auto_update(poll_interval_delay);
	}
});
}();
/*
 * options/user-css.js - allow user to enter custom css entries and (march 2015) replaces the old stylesheet system
 *
 * Copyright (c) 2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/options.js';
 *   $config['additional_javascript'][] = 'js/options/user-css.js';
 */

+function(){

var tab = Options.add_tab("user-css", "css3", _("Theme"));

var textarea = $("<textarea></textarea>").css({
  "height"     : "80%",
  "width"      : "100%",
  "font-size"  : "9pt",
  "font-family": "monospace",
}).appendTo(tab.content);
var submit = $("<input type='button' value='"+_("Save custom CSS")+"'>").css({
  "width": "100%",
}).click(function() {
  localStorage.user_css = textarea.val();
  apply_css();
}).appendTo(tab.content);

var main = function(){
  if (typeof styles === "undefined") return;

  var stylechooser = $("<select id='stylechooser'></select>").appendTo(tab.content);
  // Handle empty localStorage
  if (!localStorage.stylesheets_all_boards) localStorage.stylesheets_all_boards = "false";
  if (!localStorage.board_stylesheets) localStorage.board_stylesheets = '{}';

  var fix_choice = function(){
    var chosen = false;
    stylechooser.empty();

    function extend(obj, src) {
      Object.keys(src).forEach(function(key) { obj[key] = src[key]; });
      return obj;
    }

    var styles2 = {'2channel' : '/stylesheets/2channel.css','Cyberpunk' : '/stylesheets/cyberpunk.css','Amber' : '/stylesheets/amber.css','Fringe' : '/stylesheets/fringe.css'};
    styles =extend(styles,styles2);

    $.each(styles, function(k, v) {
      var ps;
      k === "Custom" ? k2 = _("Board-specific CSS") : k2 = k;
      var option = $("<option value='"+k+"' "+(k === "Custom" ? "class='default'" : "")+">"+k2+"</option>").appendTo(stylechooser);
      if (localStorage.stylesheets_all_boards === "false") {
        var bs = JSON.parse(localStorage.board_stylesheets);
        if (bs[board_name]) ps = bs[board_name];
      }
      if ((k === localStorage.stylesheet && localStorage.stylesheets_all_boards === "true") || (localStorage.stylesheets_all_boards === "false" && (ps && k === ps))) { option.prop('selected', 'selected'); chosen = true }
    })
    if (!chosen) stylechooser.find('.default').prop('selected', 'selected');
  };

  fix_choice();

  var allboards = $("<label><input type='checkbox' id='css-all-boards'> "+_("Apply to all boards, not just this one")+" (/"+board_name+"/)</label>").appendTo(tab.content).find('input');

  if (localStorage.stylesheets_all_boards === "true") allboards.prop('checked', 'checked');

  allboards.on('change', function(e) {
    if ($(this).is(':checked')) {
      localStorage.stylesheets_all_boards = "true";
    } else {
      localStorage.stylesheets_all_boards = "false";
    }
    fix_choice();
    apply_css();
  });

  stylechooser.on('change', function(e) {
    var ps = $(this).val();
    if (localStorage && localStorage.stylesheets_all_boards === "false") {
      var bs = JSON.parse(localStorage.board_stylesheets);
      if (!bs) bs = {};
      bs[board_name] = ps;
      localStorage.board_stylesheets = JSON.stringify(bs);
    } else { 
      localStorage.stylesheet = ps;
    }

    apply_css();
  });

  update_textarea();
}

var apply_css = function() {
  var to_apply;

  if (localStorage && localStorage.stylesheets_all_boards === "false") {
    if (localStorage && localStorage.board_stylesheets) {
      var bs = JSON.parse(localStorage.board_stylesheets);
      if (bs && bs[board_name]) {
        to_apply = styles[bs[board_name]];
      }
    } 
  } else if (localStorage && localStorage.stylesheet) {
    to_apply = styles[localStorage.stylesheet];
  }

  $('.user-css').remove();
  var ls = $('link[rel="stylesheet"]:not(#stylesheet)').last();

  ls.after($("<style></style>")
    .addClass("user-css")
    .text(localStorage.user_css)
  );
  
  if (to_apply) {
  $('.user-chosen-stylesheet,#stylesheet').remove();
  ls.after($("<link rel='stylesheet'/>")
    .attr("class", "user-chosen-stylesheet")
    .attr("id", "stylesheet")
    .attr("href", (configRoot !== '/' ? configRoot : '')+to_apply)
  );
  }
  return to_apply;
};

var update_textarea = function() {
  if (!localStorage.user_css) {
    textarea.text("/* "+_("Enter here your own CSS rules...")+" */\n" +
                  "/* "+_("If you want to make a redistributable style, be sure to\nhave a Yotsuba B theme selected.")+" */\n" +
                  "/* "+_("These will be applied on top of whatever theme you choose below.")+" */\n" +
                  "/* "+_("You can include CSS files from remote servers, for example:")+" */\n" +
                  '/* @import "http://example.com/style.css"; */');
  }
  textarea.text(localStorage.user_css);
  apply_css();
};

main();
}();
/*
 * options/user-js.js - allow user enter custom javascripts
 *
 * Copyright (c) 2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/options.js';
 *   $config['additional_javascript'][] = 'js/options/user-js.js';
 */

+function(){

var tab = Options.add_tab("user-js", "code", _("User JS"));

$("<h3 style='margin:0'>"+_("Do not paste code here unless you absolutely trust the source or have read it yourself!")+"</h3><span class='unimportant'>"+_("Untrusted code pasted here could do malicious things such as spam the site under your IP.")+"</span>").appendTo(tab.content);

var textarea = $("<textarea></textarea>").css({
  "height"     : "74%",
  "width"      : "100%",
  "font-size"  : "9pt",
  "font-family": "monospace",
}).appendTo(tab.content);
var submit = $("<input type='button' value='"+_("Save custom Javascript")+"'>").css({
  "width": "100%",
}).click(function() {
  localStorage.user_js = textarea.val();
  document.location.reload();
}).appendTo(tab.content);

var apply_js = function() {
  var proc = function() {
    $('.user-js').remove();
    $('script')
      .last()
      .after($("<script></script>")
        .addClass("user-js")
        .text(localStorage.user_js)
      );
  }

  if (/immediate()/.test(localStorage.user_js)) {
    proc(); // Apply the script immediately
  }
  else {
    $(proc); // Apply the script when the page fully loads
  }
};

var update_textarea = function() {
  if (!localStorage.user_js) {
    textarea.text("/* "+_("Enter your own Javascript code here...")+" */\n" +
                  "/* "+_("You can include JS files from remote servers, for example:")+" */\n" +
                  '/* load_js("http://example.com/script.js"); */');
  }
  else {
    textarea.text(localStorage.user_js);
    apply_js();
  }
};

update_textarea();


// User utility functions
window.load_js = function(url) {
  $('script')
    .last()
    .after($("<script></script>")
      .prop("type", "text/javascript")
      .prop("src", url)
    );
};
window.immediate = function() { // A dummy function.
}

}();
$(document).ready(function(){
//Creating functions
var generateList = function(){
	var favStor = [];
  	for(var i=1; i<favorites.length+1; i++){
  		favStor.push($("#sortable > div:nth-child("+i+")").html());
  	}
	return favStor;
} //This will generate a list of boards based off of the list on the screen
function removeBoard(boardNumber){
	favorites.splice(boardNumber, 1);
	localStorage.favorites = JSON.stringify(favorites);
	$("#sortable > div:nth-child("+(boardNumber+1)+")").remove();
	$("#minusList > div:nth-child("+(favorites.length+1)+")").remove();
	add_favorites();
} //This removes a board from favorites, localStorage.favorites and the page
function addBoard(){
	$("#sortable").append("<div>"+($("#plusBox").val())+"</div>");
	$("#minusList").append( $('<div data-board="'+favorites.length+'" style="cursor: pointer; margin-right: 5px">-</div>').on('click', function(e){removeBoard($(this).data('board'));}) );
	favorites.push($("#plusBox").val());
	localStorage.favorites = JSON.stringify(favorites);
	$("#plusBox").val(""); //Removing text from textbox
	add_favorites();
} //This adds the text inside the textbox to favorites, localStorage.favorites and the page

var favorites = JSON.parse(localStorage.favorites);
Options.add_tab('fav-tab','star',_("Favorites"));

//Pregenerating list of boards 
var favList = $('<div id="sortable" style="cursor: pointer; display: inline-block">');
for(var i=0; i<favorites.length; i++){
    favList.append( $('<div>'+favorites[i]+'</div>') );
} 

//Creating list of minus symbols to remove unwanted boards
var minusList = $('<div id="minusList" style="color: #0000FF; display: inline-block">');
for(var i=0; i<favorites.length; i++){
    minusList.append( $('<div data-board="'+i+'" style="cursor: pointer; margin-right: 5px">-</div>').on('click', function(e){removeBoard($(this).data('board'));}) );
} 

//Help message so people understand how sorting boards works
$("<span>"+_("Drag the boards to sort them.")+"</span><br><br>").appendTo(Options.get_tab('fav-tab').content);

//Adding list of boards and minus symbols to remove boards with
$(minusList).appendTo(Options.get_tab('fav-tab').content); //Adding the list of minus symbols to the tab
$(favList).appendTo(Options.get_tab('fav-tab').content);  //Adding the list of favorite boards to the tab

//Adding spacing and text box to right boards into
var addDiv = $("<div id='favs-add-board'>");

var plusBox = $("<input id=\"plusBox\" type=\"text\">").appendTo(addDiv);
plusBox.keydown(function( event ) {
	if(event.keyCode == 13){
		$("#plus").click();
	}
});

//Adding plus symbol to use to add board
$("<div id=\"plus\">+</div>").css({
	cursor: "pointer",
	color: "#0000FF"
}).on('click', function(e){addBoard()}).appendTo(addDiv);

addDiv.appendTo(Options.get_tab('fav-tab').content); //Adding the plus button

favList.sortable(); //Making boards with sortable id use the sortable jquery function
favList.on('sortstop', function() {
	favorites = generateList();	
	localStorage.favorites = JSON.stringify(favorites);
	add_favorites();
});
});
/*
 * forced-anon.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/forced-anon.js
 *
 * Released under the MIT license
 * Copyright (c) 2012 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   //$config['additional_javascript'][] = 'js/options.js';
 *   //$config['additional_javascript'][] = 'js/style-select.js';
 *   //$config['additional_javascript'][] = 'js/options/general.js';
 *   $config['additional_javascript'][] = 'js/forced-anon.js';
 *
 */

if (active_page == 'ukko' || active_page == 'thread' || active_page == 'index' || (window.Options && Options.get_tab('general')))
$(document).ready(function() {
	var force_anon = function() {
		if ($(this).children('a.capcode').length == 0) {
			var id = $(this).parent().children('a.post_no:eq(1)').text();
			
			if ($(this).children('a.email').length != 0)
				var p = $(this).children('a.email');
			else
				var p = $(this);
			
			old_info[id] = {'name': p.children('span.name').text(), 'trip': p.children('span.trip').text()};
			
			p.children('span.name').text('Anonymous');
			if (p.children('span.trip').length != 0)
				p.children('span.trip').text('');
		}
	};
		
	var enable_fa = function() {
		$('p.intro label').each(force_anon);
	};
	
	var disable_fa = function() {
		$('p.intro label').each(function() {
			if ($(this).children('a.capcode').length == 0) {
				var id = $(this).parent().children('a.post_no:eq(1)').text();
				
				if(old_info[id]) {
					if ($(this).children('a.email').length != 0)
						var p = $(this).children('a.email');
					else
						var p = $(this);
					
					p.children('span.name').text(old_info[id]['name']);
					if (p.children('span.trip').length != 0)
						p.children('span.trip').text(old_info[id]['trip']);
				}
			}
		});
	};
	
	var toggle_id = function() {
		if (localStorage.hideids == 'true'){
			$(this).addClass('hidden');
		} else {
			$(this).removeClass('hidden');
		}
	};
	
	old_info = {};
	forced_anon = localStorage['forcedanon'] ? true : false;

	if (window.Options && Options.get_tab('general')) {
		var s1 = '#hide-ids', s2 = '#forced-anon', e = 'change';
		Options.extend_tab("general", "<label id='hide-ids'><input type='checkbox' /> "+_('Hide IDs')+"</label>");
		Options.extend_tab("general", "<label id='forced-anon'><input type='checkbox' /> "+_('Forced anonymity')+"</label>");
	}
	else {
		var s1 = '#hide-ids', s2 = '#forced-anon', e = 'click';
		$('hr:first').before('<div id="hide-ids" style="text-align:right"><a class="unimportant" href="javascript:void(0)">Hide IDs</a></div>');
		$('hr:first').before('<div id="forced-anon" style="text-align:right"><a class="unimportant" href="javascript:void(0)">-</a></div>');
		$('div#forced-anon a').text(_('Forced anonymity')+' (' + (forced_anon ? _('enabled') : _('disabled')) + ')');
	}
	
	$(s1).on(e, function(e) {
		if (!localStorage.hideids || localStorage.hideids == 'false') {
			localStorage.hideids = 'true';
			if (window.Options && Options.get_tab('general')) e.target.checked = true;
		} else {
			localStorage.hideids = 'false';
			if (window.Options && Options.get_tab('general')) e.target.checked = false;
		}
		$('.poster_id').each(toggle_id);
	});
	
	$(s2).on(e, function() {
		forced_anon = !forced_anon;
		if (forced_anon) {
			$('div#forced-anon a').text(_('Forced anonymity')+' ('+_('enabled')+')');
			localStorage.forcedanon = true;
			enable_fa();
		} else {
			$('div#forced-anon a').text(_('Forced anonymity')+' ('+_('disabled')+')');
			delete localStorage.forcedanon;
			disable_fa();
		}
		return false;
	});
	
	// initial option setup on script load
	if (localStorage.hideids == 'true'){
		if (window.Options && Options.get_tab('general')) $('#hide-ids>input').prop('checked',true);
		$('.poster_id').each(toggle_id);
	}
	
	if (forced_anon) {
		enable_fa();
		if (window.Options && Options.get_tab('general')) {
			$('#forced-anon>input').prop('checked', true);
		}
	}
	
	$(document).on('new_post', function(e, post) {
		if (forced_anon)
			$(post).find('p.intro label').each(force_anon);
		if (localStorage.hideids == 'true') 
			$(post).find('.poster_id').each(toggle_id);
	});
});

/*
 * toggle-locked-threads.js
 *
 * Released under the MIT license
 * Copyright (c) 2012 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net> 
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   //$config['additional_javascript'][] = 'js/options.js';
 *   //$config['additional_javascript'][] = 'js/style-select.js';
 *   //$config['additional_javascript'][] = 'js/options/general.js';
 *   $config['additional_javascript'][] = 'js/toggle-locked-threads.js';
 *
 */

if (active_page == 'ukko' || active_page == 'index' || (window.Options && Options.get_tab('general')))
$(document).ready(function(){
	var hide_locked_threads = localStorage['hidelockedthreads'] ? true : false;

	$('<style type="text/css"> img.hidden{ opacity: 0.1; background: grey; border: 1px solid #000; } </style>').appendTo($('head'));
	
	var hideLockedThread = function($thread) {
		if (active_page == 'ukko' || active_page == 'index')
		$thread
			.hide()
			.addClass('hidden');
	};
	
	var restoreLockedThread = function($thread) {
		$thread
			.show()
			.removeClass('hidden');
	};
	
	var getThreadFromIcon = function($icon) {
		return $icon.parent().parent().parent()
	};

	var selector, event;
        if (window.Options && Options.get_tab('general')) {
                selector = '#toggle-locked-threads>input';
                event = 'change';
                Options.extend_tab("general", "<label id='toggle-locked-threads'><input type='checkbox' /> "+_('Hide locked threads')+"</label>");
        }
        else {
                selector = '#toggle-locked-threads a';
                event = 'click';
		$('hr:first').before('<div id="toggle-locked-threads" style="text-align:right"><a class="unimportant" href="javascript:void(0)">-</a></div>');
        }
	
	$('div#toggle-locked-threads a')
		.text(hide_locked_threads ? _('Show locked threads') : _('Hide locked threads'));

	$(selector)
		.on(event, function() {
			hide_locked_threads = !hide_locked_threads;
			if (hide_locked_threads) {
				$('img.icon[title="Locked"], i.fa-lock.fa').each(function() {
					hideLockedThread(getThreadFromIcon($(this)));
				});
				localStorage.hidelockedthreads = true;
			} else {
				$('img.icon[title="Locked"], i.fa-lock.fa').each(function() {
					restoreLockedThread(getThreadFromIcon($(this)));
				});
				delete localStorage.hidelockedthreads;
			}
			
			$(this).text(hide_locked_threads ? _('Show locked threads') : _('Hide locked threads'))
		});
	
	if (hide_locked_threads) {
		$('img.icon[title="Locked"], i.fa-lock.fa').each(function() {
			hideLockedThread(getThreadFromIcon($(this)));
		});

		if (window.Options && Options.get_tab('general')) {
			$('#toggle-locked-threads>input').prop('checked', true);
		}
	}
        $(document).on('new_post', function(e, post) {
		if (hide_locked_threads) {
			$(post).find('img.icon[title="Locked"], i.fa-lock.fa').each(function() {
	                        hideLockedThread(getThreadFromIcon($(this)));
       		        });
		}
	});
});

/*
 * toggle-images.js
 *
 * Released under the MIT license
 * Copyright (c) 2012 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net> 
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   //$config['additional_javascript'][] = 'js/options.js';
 *   //$config['additional_javascript'][] = 'js/style-select.js';
 *   //$config['additional_javascript'][] = 'js/options/general.js';
 *   $config['additional_javascript'][] = 'js/toggle-images.js';
 *
 */

$(document).ready(function(){
	var hide_images = localStorage['hideimages'] ? true : false;

	if (active_page === 'catalog') {
		filter_hide_images_vt();
	}

	$('<style type="text/css"> img.hidden{ opacity: 0.1; background: grey; border: 1px solid #000; } </style>').appendTo($('head'));

	var hideImage = function() {
		if ($(this).parent().data('expanded') == 'true') {
			$(this).parent().click();
		}

		if (active_page === 'catalog') {
                        $(this)
                                .attr('data-orig', this.src)
                                .addClass('hidden');		
		}else{
			$(this)
				.attr('data-orig', this.src)
				.attr('src', 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==')
				.addClass('hidden');
		}
	};

	var restoreImage = function() {
		$(this)
			.attr('src', $(this).attr('data-orig'))
			.removeClass('hidden');
	};

	// Fix for hide-images.js
	var show_hide_hide_images_buttons = function() {
		if (hide_images) {
			$('a.hide-image-link').each(function() {
				if ($(this).next().hasClass('show-image-link')) {
					$(this).next().hide();
				}
				$(this).hide().after('<span class="toggle-images-placeholder">'+_('hidden')+'</span>');
			});
		} else {
			$('span.toggle-images-placeholder').remove();
			$('a.hide-image-link').each(function() {
				if ($(this).next().hasClass('show-image-link')) {
					$(this).next().show();
				} else {
					$(this).show();
				}
			});
		}
	};

        var selector, event;
        if (window.Options && Options.get_tab('general')) {  
                selector = '#toggle-images>input';
                event = 'change';
                Options.extend_tab("general", "<label id='toggle-images'><input type='checkbox' /> "+_('Hide images')+"</label>");
        }
        else {
                selector = '#toggle-images a';
                event = 'click';
		$('hr:first').before('<div id="toggle-images" style="text-align:right"><a class="unimportant" href="javascript:void(0)">-</a></div>');
		$('div#toggle-images a')
			.text(hide_images ? _('Show images') : _('Hide images'));
        }

	$(selector)
		.on(event, function() {
			hide_images = !hide_images;
			if (hide_images) {
				$('img.post-image, .theme-catalog .thread>a>img').each(hideImage);
				localStorage.hideimages = true;
			} else {
				$('img.post-image, .theme-catalog .thread>a>img').each(restoreImage);
				delete localStorage.hideimages;
			}
			
			show_hide_hide_images_buttons();
			
			$(this).text(hide_images ? _('Show images') : _('Hide images'))
		
			if (active_page === 'catalog') {
				filter_hide_images_vt();
			}
		});

	if (hide_images) {
		$('img.post-image, .theme-catalog .thread>a>img').each(hideImage);
		show_hide_hide_images_buttons();

                if (window.Options && Options.get_tab('general')) {
                        $('#toggle-images>input').prop('checked', true);
                }
	}
	
	$(document).on('new_post', function(e, post) {
		if (hide_images) {
			$(post).find('img.post-image').each(hideImage);
		}
	});
});
/*
 * mobile-style.js - adds some responsiveness to Tinyboard
 * https://github.com/vichan-devel/Tinyboard/blob/master/js/mobile-style.js
 *
 * Released under the MIT license
 * Copyright (c) 2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['api']['enabled'] = true;
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/mobile-style.js';
 */

if(navigator.userAgent.match(/iPhone|iPod|iPad|Android|Opera Mini|Blackberry|PlayBook|Windows Phone|Tablet PC|Windows CE|IEMobile/i)) {
	$('html').addClass("mobile-style");
	device_type = "mobile";
}
else {
	$('html').addClass("desktop-style");
	device_type = "desktop";
}
if (active_page == 'thread' || active_page == 'index') {
	$(document).ready(function(){
		function arrayRemove(a, v) { a.splice(a.indexOf(v) == -1 ? a.length : a.indexOf(v), 1); }

		var idshighlighted = [];

		function getPostsById(id){
			return $(".poster_id").filter(function(i){
				return $(this).text() == id;
			});
		}

		function getMasterPosts(parents){
			if(!parents.hasClass("post")) return;
			
			var toRet = [];
			
			$(parents).each(function(){
				if($(this).hasClass("post"))
					toRet.push($(this));
			});
			
			return toRet;
		}

		var id_highlighter = function(){
			var id = $(this).text();
			
			if($.inArray(id, idshighlighted) !== -1){
				arrayRemove(idshighlighted, id);
				
				$(getMasterPosts(getPostsById(id).parents())).each(function(i){
					$(this).removeClass("highlighted");
				});
			}else{
				idshighlighted.push(id);
				
				$(getMasterPosts(getPostsById(id).parents())).each(function(i){
					$(this).addClass("highlighted");
				});
			}
		}

		$(".poster_id").on('click', id_highlighter);

		$(document).on('new_post', function(e, post) {
			$(post).find('.poster_id').on('click', id_highlighter);
		});
	});
}
if (active_page == 'thread' || active_page == 'index') {
	$(document).ready(function(){
		if (window.Options && Options.get_tab('general')) {
			var selector = '#color-ids>input';
			var e = 'change';
			Options.extend_tab("general", "<label id='color-ids'><input type='checkbox' /> "+_('Color IDs')+"</label>");
		}

		else {
			var selector = '#color-ids';
			var e = 'click';
			$('hr:first').before('<div id="color-ids" style="text-align:right"><a class="unimportant" href="javascript:void(0)">'+_('Color IDs')+'</a></div>')
		}

		$(selector).on(e, function() {
			if (localStorage.color_ids === 'true') {
				localStorage.color_ids = 'false';
			} else {
				localStorage.color_ids = 'true';
			}
		});

		if (!localStorage.color_ids || localStorage.color_ids === 'false') {
			return;
		} else {
			$('#color-ids>input').attr('checked','checked');
		}

		function IDToRGB(id_str){
			var id = id_str.match(/.{1,2}/g);
			var rgb = new Array();

			for (i = 0; i < id.length; i++) {
				rgb[i] = parseInt(id[i], 16);
			}

			return rgb;
		}

		function colorPostId(el) {
			var rgb = IDToRGB($(el).text());
			var ft = "#fff";

			if ((rgb[0]*0.299 + rgb[1]*0.587 + rgb[2]*0.114) > 125)
				ft = "#000";

			$(el).css({
				"background-color": "rgb("+rgb[0]+", "+rgb[1]+", "+rgb[2]+")",
				"padding": "0px 5px",
				"border-radius": "8px",
				"color": ft
			});

			$(el).mouseover(function() {
				$(this).css('color', '#800000'); // how about a CSS :hover rule instead?
			}).mouseout(function() {
				$(this).css('color', ft);
			});
		}

		$(".poster_id").each(function(k, v){
			colorPostId(v);
		});

		$(document).on('new_post', function(e, post) {
			$(post).find('.poster_id').each(function(k, v) {
				colorPostId(v);
			});
		});
	});
}
$(document).ready(function() {
  var App = {
    cache: {},
    get: function(url, cb) {
      var $page = App.cache[url]
      if ($page)
        return cb($page)

      $.get(url, function(data) {
        var $page = $(data)
        App.cache[url] = $page
        cb($page)
      })
    },
    options: {
      add: function(key, description, tab) {
        tab || (tab = 'general')

        var checked = App.options.get(key)
        var $el = $(
          '<div>' +
            '<label>' +
              '<input type="checkbox">' +
              description +
            '</label>' +
          '</div>')

        $el
          .find('input')
          .prop('checked', checked)
          .on('change', App.options.check(key))

        window.Options.extend_tab(tab, $el)
      },
      get: function(key) {
        if (localStorage[key])
          return JSON.parse(localStorage[key])
      },
      check: function(key) {
        return function(e) {
          var val = this.checked
          localStorage[key] = JSON.stringify(val)
        }
      }
    }
  }

  var inline = function(e) {
    e.preventDefault()

    var $root = $(this).closest('.post')
    var targetNum = this.textContent.slice(2)

    var srcOP = $root.closest('[id^=thread]').attr('id').match(/\d+/)[0]

    var node, targetOP
    var isBacklink = !!this.className
    if (isBacklink) {
      node = $root.find('> .intro')
      targetOP = srcOP
    } else {
      node = $(this)

      var to_search = inMod ? this.search : this.pathname;
      targetOP = to_search.match(/(\d+).html/)[1]
    }

    var link = {
      id: 'inline_' + targetNum,
      isBacklink: isBacklink,
      node: node
    }

    var selector = targetNum === targetOP
      ? '#op_' + srcOP
      : '#reply_' + targetNum

    var $clone = $root.find('#inline_' + targetNum)
    if ($clone.length) {
      $clone.remove()
      $(selector)
        .show()
        .next()
        .show()
      return
    }

    if (srcOP === targetOP) {
      if (targetNum === targetOP)
        link.node = link.node.next()// bypass `(OP)`

      var $target = $(selector)
      if ($target.length)
        return add(link, $target)
    }

    var $loading = $('<div class="inline post">loading...</div>')
      .attr('id', link.id)
      .insertAfter(link.node)

    App.get(this.pathname, function($page) {
      $loading.remove()
      var $target = $page.find(selector)
      add(link, $target)
    })
  }

  var add = function(link, $target) {
    var $clone = $target.clone(true)

    if (link.isBacklink && App.options.get('hidePost'))
      $target
        .hide()
        .next()
        .hide()

    $clone.find('.inline').remove()
    $clone.attr({
      "class": 'inline post',
      id: link.id,
      style: null// XXX remove post hover styling
    })
    $clone.insertAfter(link.node)
  }

  App.options.add('useInlining', _('Enable inlining'))
  App.options.add('hidePost', _('Hide inlined backlinked posts'))

  $('head').append(
    '<style>' +
      '.inline {' +
        'border: 1px dashed black;' +
        'white-space: normal;' +
        'overflow: auto;' + // clearfix
      '}' +
    '</style>')

  // don't attach to outbound links

  if (App.options.get('useInlining')) {
    var assign_inline = function() {
        $('.body a[href*="'+location.pathname+'"]').not('[rel]').not('.toolong > a').add('.mentioned a')
          .attr('onclick', null)// XXX disable highlightReply
          .off('click')
          .click(inline)
    }

    assign_inline();

    $(document).on('new_post', function(e, post) {
      assign_inline();
    });
  }
});
/*
 * infinite-scroll.js
 * https://github.com/vichan-devel/vichan/blob/master/js/infinite-scroll.js
 *
 * Released under the MIT license
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/infinite-scroll.js';
 *
 */

$(function() {
if (active_page == 'index') {


var loading = false;

var activate = function() {
  if (document.location.hash != '#all') return false;

  $(window).on("scroll", function() {
	scrolltest();
  });
  scrolltest();

  return true;
};

var scrolltest = function() {
  if ($(window).scrollTop() + $(window).height() + 1000 > $(document).height() && !loading) {
	load_next_page();
  }
};

var load_next_page = function() {
	if (loading) return;
	loading = true;
	
	var this_page = $(".pages a.selected:last");
	var next_page = this_page.next();
	
	var href = next_page.prop("href");
	if (!href) return;
	
	var boardheader = $('<h2>'+_('Page')+' '+next_page.html()+'</h2>');
	var loading_ind = $('<h2>'+_('Loading...')+'</h2>').insertBefore('#post-moderation-fields');
	
	$.get(href, function(data) {
		var doc = $(data);
		
		loading_ind.remove();
		boardheader.insertBefore('#post-moderation-fields');
		
		var i = 0;
		
		doc.find('div[id*="thread_"]').each(function() {
			var checkout = $(this).attr('id').replace('thread_', '');
			var $this = this;
			
			if ($('div#thread_' + checkout).length == 0) {
				// Delay DOM insertion to lessen the lag.
				setTimeout(function() {
					$($this).insertBefore('#post-moderation-fields');
					$(document).trigger('new_post', $this);
					$($this).hide().slideDown();
				}, 500*i);
				
				i++;
			}
		});
		
		setTimeout(function() {
			loading = false;
			scrolltest();
		}, 500*(i+1));
		
		next_page.addClass('selected');
	});
};

var button = $("<a href='#all'>"+_("All")+" </a>").prependTo(".pages");

$(window).on("hashchange", function() {
  return !activate();
});
activate();


}
});
/*
 * download-original.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/download-original.js
 *
 * Makes image filenames clickable, allowing users to download and save files as their original filename.
 * Only works in newer browsers. http://caniuse.com/#feat=download
 *
 * Released under the MIT license
 * Copyright (c) 2012-2013 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/download-original.js';
 *
 */
onready(function(){
        var do_original_filename = function() {
                var filename, truncated;
                if ($(this).attr('title')) {
                        filename = $(this).attr('title');
                } else {
                        filename = $(this).text();
                }

                $(this).replaceWith(
                        $('<a></a>')
                                .attr('download', filename)
                                .append($(this).contents())
                                .attr('href', $(this).parent().parent().find('a').attr('href')+"/"+filename)
                                .attr('title', filename)
                        );
        };

        $('.postfilename').each(do_original_filename);

        $(document).on('new_post', function(e, post) {
                $(post).find('.postfilename').each(do_original_filename);
        });

});
/*Download Hash and Unix filename*/
onready(function(){
        var get_files, do_hash_unix_filename, unixtime_value, file_ctr, unix_file_ctr_str, unix_filename_download, download_unixtime, filename_get_extention;
        do_hash_unix_filename = function() {

          if($(this).find("time").attr("unixtime") !== 'undefined'){
            unixtime_value = $(this).find("time").attr("unixtime");

            if($(this).hasClass('op')){
             get_files = $(this).prev();
            }
            else{
             get_files = $(this);
            }

           file_ctr = 0;
           var files_filenames = function() {

              filenamedownload = $(this).find(".fileinfo").find('a').first().text().split(".");
              filename_get_extention  = filenamedownload[filenamedownload.length - 1];

              unix_file_ctr_str = (file_ctr!=0 ? '-' + file_ctr  : '');

              var unix_filename_download = unixtime_value + unix_file_ctr_str + "." + filename_get_extention;
              var hash_filename_download = $(this).find("a").first().attr('title');

              file_ctr = file_ctr + 1;

	      if($(this).find('a').attr('href') && !$(this).find('.unimportant').find('a').hasClass('hash_unix')){
                var new_href = $(this).find('a').attr('href').replace('//8kun.top', '//media.8kun.top');
		new_href = new_href.replace('/file_store/', '/file_dl/');
                var download_hash = " <a download='"+hash_filename_download+"' class='hash_unix hash_h' title='"+hash_filename_download+"' href='"+ new_href +"'>(h)</a>";
                var download_unixtime = "<a download='"+unix_filename_download+"' class='hash_unix hash_u' title='"+unix_filename_download+"' href='"+ new_href +"/"+unix_filename_download+"'>(u)</a>";
                $(this).find('.unimportant').append( download_hash + " " + download_unixtime );
              }
           };

           get_files.find('.file').each(files_filenames);
          }

        };

        $('.has-file').each(do_hash_unix_filename);

        $(document).on('new_post', function(e, post) {
                $(post).parent().find('.has-file').last().each(do_hash_unix_filename);
        });
});

// https://gitlab.com/aymous/8kun-watchlist

'use strict';
/* jshint globalstrict:true, quotmark:single */
/* jshint browser:true, jquery:true, devel:true, unused:true, undef:true */
/* global active_page:false, board_name:false */
if(!localStorage.watchlist){
	//If the watchlist is undefined in the localStorage,
	//initialize it as an empty array.
	localStorage.watchlist = '[]';
}
var watchlist = {};

/**
 * [render /> Creates a watchlist container and populates it with info
 * about each thread that's currently being watched. If the watchlist container
 * already exists, it empties it out and repopulates it.]
 * @param  {[Bool]} reset [If true and the watchlist is rendered, remove it]
 */
watchlist.render = function(reset) {
	/* jshint eqnull:true */
	if (reset == null) reset = false;
	/* jshint eqnull:false */
	if (reset && $('#watchlist').length) $('#watchlist').remove();
	var threads = [];
	//Read the watchlist and create a new container for each thread.
	JSON.parse(localStorage.watchlist).forEach(function(e, i) {
		//look at line 69, that's what (e) is here.
		threads.push('<div class="watchlist-inner" id="watchlist-'+i+'">' +
		'<span>/'+e[0]+'/ - ' +
		'<a href="'+e[3]+'">'+e[1].replace("thread_", _("Thread #"))+'</a>' +
		' ('+e[2]+') </span>' +
		'<a class="watchlist-remove">X</a>'+
	'</div>');
	});
	if ($('#watchlist').length) {
		//If the watchlist is already there, empty it and append the threads.
		$('#watchlist').children('.watchlist-inner').remove();
		$('#watchlist').append(threads.join(''));
	} else {
		//If the watchlist has not yet been rendered, create it.
		var menuStyle = getComputedStyle($('.boardlist')[0]);
		$('form[name="post"]').before(
			$('<div id="watchlist">'+
					'<div class="watchlist-controls">'+
						'<span><a id="clearList">['+_('Clear List')+']</a></span>&nbsp'+
						'<span><a id="clearGhosts">['+_('Clear Ghosts')+']</a></span>'+
					'</div>'+
					threads.join('')+
				'</div>').css("background-color", menuStyle.backgroundColor).css("border", menuStyle.borderBottomWidth+" "+menuStyle.borderBottomStyle+" "+menuStyle.borderBottomColor));
	}
	return this;
};

/**
 * [add /> adds the given item to the watchlist]
 * @param {[Obj/Str]} sel [An unwrapped jquery selector.]
 */
watchlist.add = function(sel) {
	var threadName, threadInfo;

	if (active_page === 'thread') {
		if ($('.subject').length){
			//If a subject is given, use the first 20 characters as the thread name.
			threadName = $('.subject').text().substring(0,20);
		} else { //Otherwise use the thread id.
			threadName = $('.op').parent().attr('id');
		}
		//board name, thread name as defined above, current amount of posts, thread url
		threadInfo = [board_name, threadName, $('.post').length, location.href];

	} else if (active_page === 'index') {

		var postCount;
		//Figure out the post count.
		if ($(sel).parents('.op').children('.omitted').length) {
			postCount = $(sel).parents('.op').children('.omitted').text().split(' ')[0];
		} else {
			postCount = $(sel).parents('.op').siblings('.post').length+1;
		}
		//Grab the reply link.
		var threadLink = $(sel).siblings('a:contains("['+_('Reply')+']")').attr('href');
		//Figure out the thread name. If anon, use the thread id.
		if ($(sel).parent().find('.subject').length) {
			threadName = $(sel).parent().find('.subject').text().substring(0,20);
		} else {
			threadName = $(sel).parents('div').last().attr('id');
		}

		threadInfo = [board_name, threadName, postCount, threadLink];

	} else {
		alert('Functionality not yet implemented for this type of page.');
		return this;
	}

	//if the thread is already being watched, cancel the function.
	if (localStorage.watchlist.indexOf(JSON.stringify(threadInfo)) !== -1) {
		return this;
	}

	var _watchlist = JSON.parse(localStorage.watchlist); //Read the watchlist
	_watchlist.push(threadInfo); //Add the new watch item.
	localStorage.watchlist = JSON.stringify(_watchlist); //Save the watchlist.
	return this;
};

/**
 * [remove /> removes the given item from the watchlist]
 * @param  {[Int]} n [The index at which to remove.]
 */
watchlist.remove = function(n) {
	var _watchlist = JSON.parse(localStorage.watchlist);
	_watchlist.splice(n, 1);
	localStorage.watchlist = JSON.stringify(_watchlist);
	return this;
};

/**
 * [clear /> resets the watchlist to the initial empty array]
 */
watchlist.clear = function() {
	localStorage.watchlist = '[]';
	return this;
};

/**
 * [exists /> pings every watched thread to check if it exists and removes it if not]
 * @param  {[Obj/Str]} sel [an unwrapped jq selector]
 */
watchlist.exists = function(sel) {
	$.ajax($(sel).children().children('a').attr('href'), {
		type :'HEAD',
		error: function() {
			watchlist.remove(parseInt($(sel).attr('id').split('-')[1])).render();
		},
		success : function(){
			return;
		}
	});
};

$(document).ready(function(){
	if (!(active_page == 'thread' || active_page == 'index')) {
		return;
	}

	//Append the watchlist toggle button.
	$('.boardlist').append('<span>[ <a class="watchlist-toggle" href="#">'+_('watchlist')+'</a> ]</span>');
	//Append a watch thread button after every OP.
	$('.op>.intro').append('<a class="watchThread" href="#">['+_('Watch Thread')+']</a>');

	//Draw the watchlist, hidden.
	watchlist.render();

	//Show or hide the watchlist.
	$('.watchlist-toggle').on('click', function(e) {
		e.preventDefault();
		//if ctrl+click, reset the watchlist.
		if (e.ctrlKey) {
			watchlist.render(true);
		}
		if ($('#watchlist').css('display') !== 'none') {
			$('#watchlist').css('display', 'none');
		} else {
			$('#watchlist').css('display', 'block');
		} //Shit got really weird with hide/show. Went with css manip. Probably faster anyway.
	});

	//Trigger the watchlist add function.
	//The selector is passed as an argument in case the page is not a thread.
	$('.watchThread').on('click', function(e) {
		e.preventDefault();
		watchlist.add(this).render();
	});

	//The index is saved in .watchlist-inner so that it can be passed as the argument here.
	//$('.watchlist-remove').on('click') won't work in case of re-renders and
	//the page will need refreshing. This works around that.
	$(document).on('click', '.watchlist-remove', function() {
		var item = parseInt($(this).parent().attr('id').split('-')[1]);
		watchlist.remove(item).render();
	});

	//Empty the watchlist and redraw it.
	$('#clearList').on('click', function(){
		watchlist.clear().render();
	});

	//Get rid of every watched item that no longer directs to an existing page.
	$('#clearGhosts').on('click', function() {
		$('.watchlist-inner').each(function(){
			watchlist.exists(this);
		});
	});

});

/*
 * ajax.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/ajax.js
 *
 * Released under the MIT license
 * Copyright (c) 2013 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/ajax.js';
 *
 */

if(typeof identityCheck === 'undefined' || typeof identityCheck !== 'function'){
    var identityCheck = function(callback){
    //var location_origin =  location.protocol + '//' + location.hostname.replace('www.','');
    var location_origin =  'http://' + location.hostname.replace('www.','');
      var lurl = location_origin +'/liveposting.php'
      //var lurl = 'http://sys.8kun.top/liveposting.php'
      var ldata = document.querySelector('input[name=board]').value
      $.ajax({
        type: 'POST',
        url: lurl,
        data: {"curb":ldata},
        cache: false,
        success: function(res) {
          switch(res) {
          case '2':
            callback(2);
            break
          case '1':
            callback(1);
            break
          default:
            callback(0);
            break
          }
        },
        error: function (request, status, error) {
          callback(3,request.responseText)
        }
      })

    }
}
+function() {

    function getCookie(name) {
      var v = document.cookie.match('(^|;) ?' + name + '=([^;]*)(;|$)');
      return v ? v[2] : null;
   }

    var settings = new script_settings('ajax');
    var do_not_ajax = false;

    if (window.location.href.indexOf(".onion") > -1) {
      document.cookie = "usingtor=true";
    }

    //var location_origin =  location.protocol + '//sys.' + location.hostname.replace('sys.','');	
    if(location.search){
         var location_origin = location.protocol + '//sys.' + location.search.replace('?http://','');
         var location_split = location_origin.split('/');
         location_origin = location.protocol + '//' + location_split[2];
         location_origin = location_origin.replace('sys.','');

         if(location_split[2] == 'sys.?'){
           location_origin = location.protocol + '//sys.' + location.hostname.replace('sys.','');
         }
     }else{
          var location_origin = location.protocol + '//sys.' + location.hostname.replace('sys.','');
     }

    if(location.href.split('/')[3] == 'index.php?http:'){
      location_origin = location.protocol + location.hostname + '/index.php?'+ location_origin;
    } 
    location_origin = location_origin.replace('www.','');

    var setup_form = function($form) {
        $form.submit(function() {
            if (do_not_ajax)
                return true;
            var form = $(this).find('form')[0];
            var submit_txt = $(this).find('input[type="submit"]').val();
            if (window.FormData === undefined)
                return true;

            var formData = new FormData(form);
	    var tor_cookie = getCookie('tor');
	    var domain_name_post = window.location.hostname;
            formData.append('json_response', '1');
            formData.append('post', submit_txt);
	    formData.append('tor', tor_cookie);
	    formData.append('domain_name_post', domain_name_post);

            $(document).trigger("ajax_before_post", formData);

            var updateProgress = function(e) {
                var percentage;
                if (e.position === undefined) { // Firefox
                    percentage = Math.round(e.loaded * 100 / e.total);
                }
                else { // Chrome?
                    percentage = Math.round(e.position * 100 / e.total);
                }
                if(percentage!==NaN){
                    $(form).find('input[type="submit"]').val(_('Posting... (#%)').replace('#', percentage));
                }else{
                    $(form).find('input[type="submit"]').val(submit_txt);
                    $(form).find('input[type="submit"]').removeAttr('disabled');
                    alert('Posting failed, please try again!')
                }
            };

	    //var location_origin = location_origin.replace('?VanwaNet-DDoS-Verification-Attempt=1','sys.8kun.top');
	    //console.log(location_origin);
            var checkedAjax = true;
            var postAjax = function(){
                $.ajax({
                    url: location_origin +'/post.php',
                    type: 'POST',
                    xhr: function() {
                        var xhr = $.ajaxSettings.xhr();
			//xhr.withCredentials = true;
                        if(xhr.upload) {
                            xhr.upload.addEventListener('progress', updateProgress, false);
                        }
                        return xhr;
                    },
                    beforeSend: function( xhr ) {
                        if(checkedAjax==false){
                            xhr.abort();
                            identityCheck(function(res,msg){
                                switch(res) {
                                  case 3:
                                    alert(msg)
                                    $(form).find('input[type="submit"]').val(submit_txt);
                                    $(form).find('input[type="submit"]').removeAttr('disabled');
                                    break
                                  case 2:
                                    alert('YOU ARE BANNED')
                                    break
                                  case 1:
                                    if($($form).find('.file-thumbs').find('.tmb-container').length>0){
                                        captchabox('',true,
                                            function(){
                                                checkedAjax=true;
                                                postAjax();
                                            },function(){
                                                $(form).find('input[type="submit"]').val(submit_txt);
                                                $(form).find('input[type="submit"]').removeAttr('disabled');
                                            }
                                        );
                                    }else{
                                        checkedAjax=true;
                                        postAjax();
                                    }
                                    break
                                  default:
                                    checkedAjax=true;
                                    postAjax();
                                    break
                                }
                            });


                        }
                    },
                    success: function(post_response, textStatus, xhr) {
			    //alert('success here') ;
                        if (post_response.error) {
                            if (post_response.banned) {
                                // You are banned. Must post the form normally so the user can see the ban message.
                                do_not_ajax = true;
                                $(form).find('input[type="submit"]').each(function() {
                                    var $replacement = $('<input type="hidden">');
                                    $replacement.attr('name', $(this).attr('name'));
                                    $replacement.val(submit_txt);
                                    $(this)
                                        .after($replacement)
                                        .replaceWith($('<input type="button">').val(submit_txt));
                                });
                                $(form).submit();
                            } else {
                                alert(post_response.error);
                                $(form).find('input[type="submit"]').val(submit_txt);
                                $(form).find('input[type="submit"]').removeAttr('disabled');

                                if (post_response.error == 'Sorry. Tor users can\'t upload files.') {
                                    $(form).find('input[name="file_url"],input[type="file"]').val('').change();
                                }
                            }
                        } else if (post_response.redirect && post_response.id) {
                            if (!$(form).find('input[name="thread"]').length
                                || (!settings.get('always_noko_replies', true) && !post_response.noko)) {
                                t_url = location.protocol + '//' +location.hostname +''+ post_response.redirect;
                                document.location = t_url;
                            } else {
                                //                                var unix = new Date().getTime();
                                //var url = document.location + "?_=" + unix;
				setTimeout(function() {

                                $.ajax({
				    headers: { "cache-control": "no-cache" },
                                    url: document.location,
                                    success: function(data) {
                                        $(data).find('div.post.reply').each(function() {
                                            var id = $(this).attr('id');
                                            if($('#' + id).length == 0) {
                                                $(this).insertAfter($('div.post:last').next()).after('<br class="clear">');
                                                $(document).trigger('new_post', this);
                                                // watch.js & auto-reload.js retrigger
                                                setTimeout(function() { $(window).trigger("scroll"); }, 100);
                                            }
                                        });

                                        highlightReply(post_response.id);
                                        window.location.hash = post_response.id;
                                        $(window).scrollTop($('div.post#reply_' + post_response.id).offset().top);

                                        $(form).find('input[type="submit"]').val(submit_txt);
                                        $(form).find('input[type="submit"]').removeAttr('disabled');
                                        $(form).find('input[name="subject"],input[name="file_url"],\
                                            textarea[name="body"],input[type="file"],input[name="embed"]').val('').change();
                                    },
                                    //cache: false,
                                    contentType: false,
                                    processData: false
                                }, 'html');
				}, 3000);
                            }
                            $(form).find('input[type="submit"]').val(_('Posted...'));
                            $(document).trigger("ajax_after_post", post_response);
                        } else {
				console.log("url: "+location_origin);
				console.log(JSON.stringify(xhr));
				if (JSON.parse(JSON.stringify(xhr))['responseText'].split("|")[0]=="{\"captcha\":true"){
					captchabox('');
				}else if (JSON.parse(JSON.stringify(xhr))['responseText'].split("|")[0]=="{\"captcha_thunder\":true"){
					captchabox_thunder('');
				}else{
					alert(_('An unknown error occured when posting!'));
				}
				$(form).find('input[type="submit"]').val(submit_txt);
				$(form).find('input[type="submit"]').removeAttr('disabled');
                        }
                    },
                    error: function(xhr, status, er) {
					
                                            if (JSON.parse(JSON.stringify(xhr))['responseText'] !== undefined && JSON.parse(JSON.stringify(xhr))['responseText'].split("|")[0]=="{\"captcha\":true"){
                                                            captchabox('');
                                            }else if (JSON.parse(JSON.stringify(xhr))['responseText'] !== undefined && JSON.parse(JSON.stringify(xhr))['responseText'].split("|")[0]=="{\"captcha_thunder\":true"){
                                                            captchabox_thunder('');
                                            } else {
                                                    //alert(_('The server took too long to submit your post. Your post was probably still submitted. If it wasn\'t, 8kun might be experiencing issues right now -- please try your post again later. Error information: ') + "<div><textarea>" + JSON.stringify(xhr) + "</textarea></div>");
                                        alert(_('The server took too long to submit your post. Your post was probably still submitted. If it wasn\'t, 8kun might be experiencing issues right now -- please try your post again later. Error information: '));
                                 	    }
					
					  //captchabox('');
					 	console.log(JSON.stringify(xhr));
						console.log("--");
						console.log(location_origin);
                                            $(form).find('input[type="submit"]').val(submit_txt);
                                            $(form).find('input[type="submit"]').removeAttr('disabled');
                    },
                    data: formData,
		    xhrFields: {
			withCredentials: true
		    },
                    cache: false,
                    contentType: false,
                    processData: false
                }, 'json');
            }

	    if(tor_browser === false && get_cookie('usingtor') == null){
	    	//Start Vanwatech verification process
	    	var iframe = document.createElement("iframe");
	    	iframe.src = "https://sys.8kun.top/vanwanet-verify";
	    	iframe.setAttribute("height","0");
	    	iframe.setAttribute("width","0");
	    	iframe.setAttribute("frameboarder","0");
	    	iframe.onload = function(){
			var requestStatusVerify = 0;
	    		while (requestStatusVerify != 502) {
				var request = new XMLHttpRequest();
				request.withCredentials = true;
				request.open('GET', 'https://sys.8kun.top/vanwanet-verify', false);
        			request.send(null);
        			requestStatusVerify = request.status;
        			console.log(request.status);
    	     		}
    	     		console.log("Verified")
	     		//Do Verified Stuff
			postAjax();
	    	};
	    	document.body.appendChild(iframe);
	    	//End vanwatech verification
	   }else{
		console.log("hey");
		postAjax();
	   }


            $(form).find('input[type="submit"]').val(_('Posting...'));
            $(form).find('input[type="submit"]').attr('disabled', true);

            return false;
        });
    };
    $(window).on('quick-reply', function() {
        $('div#quick-reply form').off('submit');
        setup_form($('div#quick-reply'));
    });
    onready(function(){
        // Enable submit button if disabled (cache problem)
        $('input[type="submit"]').removeAttr('disabled');
        setup_form($('div#post-form-outer'));
    });
}();
/*
 * quick-reply.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/quick-reply.js
 *
 * Released under the MIT license
 * Copyright (c) 2013 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/jquery-ui.custom.min.js'; // Optional; if you want the form to be draggable.
 *   $config['additional_javascript'][] = 'js/quick-reply.js';
 *
 */

(function() {
	var settings = new script_settings('quick-reply');
	
	var do_css = function() {
		$('#quick-reply-css').remove();
		
		// Find background of reply posts
		var dummy_reply = $('<div class="post reply"></div>').appendTo($('body'));
		var reply_background = dummy_reply.css('backgroundColor');
		var reply_border_style = dummy_reply.css('borderStyle');
		var reply_border_color = dummy_reply.css('borderColor');
		var reply_border_width = dummy_reply.css('borderWidth');
		dummy_reply.remove();
		
		$('<style type="text/css" id="quick-reply-css">\
		#quick-reply table {\
			border-collapse: collapse;\
			background: ' + reply_background + ';\
			border-style: ' + reply_border_style + ';\
			border-width: ' + reply_border_width + ';\
			border-color: ' + reply_border_color + ';\
			margin: 0;\
			width: 100%;\
		}\
		</style>').appendTo($('head'));
	};
	
	var show_quick_reply = function(){
		if($('div.banner').length == 0)
			return;
		if($('#quick-reply').length != 0)
			return;
		
		do_css();
		
		var $postForm = $('#post-form-outer').clone();
		
		$postForm.clone();
		
		$dummyStuff = $('<div class="nonsense"></div>').appendTo($postForm.find('form'));
		
		$postForm.find('table tr').each(function() {
			var $th = $(this).children('th:first');
			var $td = $(this).children('td:first');		
			if ($th.length && $td.length) {
				$td.attr('colspan', 2);
	
				if ($td.find('input[type="text"]').length) {
					// Replace <th> with input placeholders
					$td.find('input[type="text"]')
						.removeAttr('size')
						.attr('placeholder', $th.clone().children().remove().end().text());
				}

				// Move anti-spam nonsense and remove <th>
				$th.contents().filter(function() {
					return this.nodeType == 3; // Node.TEXT_NODE
				}).remove();
				$th.contents().appendTo($dummyStuff);
				$th.remove();

				if ($td.find('input[name="password"]').length) {
					// Hide password field
					$(this).hide();
				}
	
				// Fix submit button
				if ($td.find('input[type="submit"]').length) {
					$td.removeAttr('colspan');
					$('<td class="submit"></td>').append($td.find('input[type="submit"]')).insertAfter($td);
				}
	
				// reCAPTCHA
				if ($td.find('#recaptcha_widget_div').length) {
					// Just show the image, and have it interact with the real form.
					var $captchaimg = $td.find('#recaptcha_image img');
					
					$captchaimg
						.removeAttr('id')
						.removeAttr('style')
						.addClass('recaptcha_image')
						.click(function() {
							$('#recaptcha_reload').click();
						});
					
					// When we get a new captcha...
					$('#recaptcha_response_field').focus(function() {
						if ($captchaimg.attr('src') != $('#recaptcha_image img').attr('src')) {
							$captchaimg.attr('src', $('#recaptcha_image img').attr('src'));
							$postForm.find('input[name="recaptcha_challenge_field"]').val($('#recaptcha_challenge_field').val());
							$postForm.find('input[name="recaptcha_response_field"]').val('').focus();
						}
					});
					
					$postForm.submit(function() {
						setTimeout(function() {
							$('#recaptcha_reload').click();
						}, 200);
					});
					
					// Make a new row for the response text
					var $newRow = $('<tr><td class="recaptcha-response" colspan="2"></td></tr>');
					$newRow.children().first().append(
						$td.find('input').removeAttr('style')
					);
					$newRow.find('#recaptcha_response_field')
						.removeAttr('id')
						.addClass('recaptcha_response_field')
						.attr('placeholder', $('#recaptcha_response_field').attr('placeholder'));
					
					$('#recaptcha_response_field').addClass('recaptcha_response_field')
					
					$td.replaceWith($('<td class="recaptcha" colspan="2"></td>').append($('<span></span>').append($captchaimg)));
					
					$newRow.insertAfter(this);
				}
	
				// Upload section
				if ($td.find('input[type="file"]').length) {
					if ($td.find('input[name="file_url"]').length) {
						$file_url = $td.find('input[name="file_url"]');
						
						if (settings.get('show_remote', false)) {
							// Make a new row for it
							var $newRow = $('<tr><td colspan="2"></td></tr>');
						
							$file_url.clone().attr('placeholder', _('Upload URL')).appendTo($newRow.find('td'));
						
							$newRow.insertBefore(this);
						}
						$file_url.parent().remove();

						
						$td.find('label').remove();
						$td.contents().filter(function() {
							return this.nodeType == 3; // Node.TEXT_NODE
						}).remove();
						$td.find('input[name="file_url"]').removeAttr('id');
					}
					
					if ($(this).find('input[name="spoiler"]').length) {
						$td.removeAttr('colspan');
					}
				}

				// Disable embedding if configured so
				if (!settings.get('show_embed', false) && $td.find('input[name="embed"]').length) {
					$(this).remove();
				}

				$td.find('small').hide();
			}
		});
		
		$postForm.find('textarea[name="body"]').removeAttr('id').removeAttr('cols').attr('placeholder', _('Comment'))
			.on('keydown', function (e) {
				//close quick reply when esc is prssed
				if (e.which === 27) {
					$('.close-btn').trigger('click');
				}
			});
	
		$postForm.find('textarea:not([name="body"]),input[type="hidden"]:not(.captcha_cookie)').removeAttr('id').appendTo($dummyStuff);
	
		$postForm.find('br,p.board-settings,.unimportant,#oekaki,.required-field-cell').remove();
		$postForm.find('.show-options-cell').attr('colspan', '2');

		$postForm.find('table:first').prepend('<tr><th colspan="2">\
			<span class="handle" id="blp">\
				<a class="close-btn" href="javascript:void(0)">×</a>\
				' + _('Quick Reply') + '\
			</span>\
			</th></tr>');
		
		$postForm.attr('id', 'quick-reply');
		
		$postForm.appendTo($('body')).hide();
		$origPostForm = $('form[name="post"]:first');
		
		// Synchronise body text with original post form
		$origPostForm.find('textarea[name="body"]').on('change input propertychange', function() {
			$postForm.find('textarea[name="body"]').val($(this).val());
		});
		$postForm.find('textarea[name="body"]').on('change input propertychange', function() {
			$origPostForm.find('textarea[name="body"]').val($(this).val());
		});
		$postForm.find('textarea[name="body"]').focus(function() {
			$origPostForm.find('textarea[name="body"]').removeAttr('id');
			$(this).attr('id', 'body');
		});
		$origPostForm.find('textarea[name="body"]').focus(function() {
			$postForm.find('textarea[name="body"]').removeAttr('id');
			$(this).attr('id', 'body');
		});
		// Synchronise other inputs
		$origPostForm.find('input[type="text"],select').on('change input propertychange', function() {
			$postForm.find('[name="' + $(this).attr('name') + '"]').val($(this).val());
		}).change();
		$postForm.find('input[type="text"],select').on('change input propertychange', function() {
			$origPostForm.find('[name="' + $(this).attr('name') + '"]').val($(this).val());
		});

		if (typeof $postForm.draggable != 'undefined') {	
			if (localStorage.quickReplyPosition) {
				var offset = JSON.parse(localStorage.quickReplyPosition);
				if (offset.top < 0)
					offset.top = 0;
				if (offset.right > $(window).width() - $postForm.width())
					offset.right = $(window).width() - $postForm.width();
				if (offset.top > $(window).height() - $postForm.height())
					offset.top = $(window).height() - $postForm.height();
				$postForm.css('right', offset.right).css('top', offset.top);
			}
			$postForm.draggable({
				handle: 'th .handle',
				containment: 'window',
				distance: 10,
				scroll: false,
				stop: function() {
					var offset = {
						top: $(this).offset().top - $(window).scrollTop(),
						right: $(window).width() - $(this).offset().left - $(this).width(),
					};
					localStorage.quickReplyPosition = JSON.stringify(offset);
					
					$postForm.css('right', offset.right).css('top', offset.top).css('left', 'auto');
				}
			});
			$postForm.find('th .handle').css('cursor', 'move');
		}
		
		$postForm.find('th .close-btn').click(function() {
			$origPostForm.find('textarea[name="body"]').attr('id', 'body');
			$postForm.remove();
			floating_link();
		});
		
		// Fix bug when table gets too big for form. Shouldn't exist, but crappy CSS etc.
		$postForm.show();
		$postForm.width($postForm.find('table').width());
		$postForm.hide();
		
		$(window).trigger('quick-reply');
	
		$(window).ready(function() {
			if (settings.get('hide_at_top', true)) {
				$(window).scroll(function() {
					if ($(this).width() <= 600)
						return;
					if ($(this).scrollTop() < $origPostForm.offset().top + $origPostForm.height() - 100)
						$postForm.fadeOut(100);
					else
						$postForm.fadeIn(100);
				}).scroll();
			} else {
				$postForm.show();
			}

			$postForm.find('textarea[name="body"]').focus();
			$(window).on('stylesheet', function() {
				do_css();
				if ($('link#stylesheet').attr('href')) {
					$('link#stylesheet')[0].onload = do_css;
				}
			});
		});
	};
	
	$(window).on('cite', function(e, id, with_link) {
		if ($(this).width() <= 600)
			return;
		show_quick_reply();
		if (with_link) {
			$(document).ready(function() {
				if ($('#' + id).length) {
					highlightReply(id);
					$(document).scrollTop($('#' + id).offset().top);
				}
				
				// Honestly, I'm not sure why we need setTimeout() here, but it seems to work.
				// Same for the "tmp" variable stuff you see inside here:
				setTimeout(function() {
					var tmp = $('#quick-reply textarea[name="body"]').val();
					$('#quick-reply textarea[name="body"]').val('').focus().val(tmp);
				}, 1);
			});
		}
	});
	
	var floating_link = function() {
		if (!settings.get('floating_link', false))
			return;
		$('<a href="javascript:void(0)" class="quick-reply-btn">'+_('Quick Reply')+'</a>')
			.click(function() {
				show_quick_reply();
				$(this).remove();
			}).appendTo($('body'));
		
		$(window).on('quick-reply', function() {
			$('.quick-reply-btn').remove();
		});
	};
	
	if (settings.get('floating_link', false)) {
		$(window).ready(function() {
			if($('div.banner').length == 0)
				return;
			$('<style type="text/css">\
			a.quick-reply-btn {\
				position: fixed;\
				right: 0;\
				bottom: 0;\
				display: block;\
				padding: 5px 13px;\
				text-decoration: none;\
			}\
			</style>').appendTo($('head'));
			
			floating_link();
			
			if (settings.get('hide_at_top', true)) {
				$('.quick-reply-btn').hide();
				
				$(window).scroll(function() {
					if ($(this).width() <= 600)
						return;
					if ($(this).scrollTop() < $('form[name="post"]:first').offset().top + $('form[name="post"]:first').height() - 100)
						$('.quick-reply-btn').fadeOut(100);
					else
						$('.quick-reply-btn').fadeIn(100);
				}).scroll();
			}
		});
	}
})();
/*
 * quick-posts-controls.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/quick-posts-controls.js
 *
 * Released under the MIT license
 * Copyright (c) 2012 Michael Save <savetheinternet@tinyboard.org>
 * Copyright (c) 2013 undido <firekid109@hotmail.com>
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/quick-post-controls.js';
 *
 */

$(document).ready(function(){
	// Bottom of the page quick reply function
	$("#thread-quick-reply").show();
	$("#link-quick-reply").on( 'click', function(event) {
		event.preventDefault();
		$(window).trigger('cite', ['']);
		return false;
	} );
} );
/*
 * show-own-posts.js
 * https://github.com/savetheinternet/Tinyboard/blob/master/js/show-op.js
 *
 * Adds "(You)" to a name field when the post is yours. Update references as well.
 *
 * Released under the MIT license
 * Copyright (c) 2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/ajax.js';
 *   $config['additional_javascript'][] = 'js/show-own-posts.js';
 *
 */


+function(){


var update_own = function() {
  if ($(this).is('.you')) return;

  var thread = $(this).parents('[id^="thread_"]').first();
  if (!thread.length) {
    thread = $(this);
  }

  var board = thread.attr('data-board');
  var posts = JSON.parse(localStorage.own_posts || '{}');

  var id = $(this).attr('id').split('_')[1];

  if (posts[board] && posts[board].indexOf(id) !== -1) { // Own post!
    $(this).addClass('you');
    $(this).find('span.name').first().append(' <span class="own_post">'+_('(You)')+'</span>');
  }

  // Update references
  $(this).find('div.body:first a:not([rel="nofollow"])').each(function() {
    var postID;

    if(postID = $(this).text().match(/^>>(\d+)$/))
      postID = postID[1];
    else
      return;

    if (posts[board] && posts[board].indexOf(postID) !== -1) {
      $(this).after(' <small>'+_('(You)')+'</small>');
    }
  });
};

var update_all = function() {
  $('div[id^="thread_"], div.post.reply').each(update_own);
};

var board = null;

$(function() {
  board = $('input[name="board"]').first().val();

  update_all();
});

$(document).on('ajax_after_post', function(e, r) {
  var posts = JSON.parse(localStorage.own_posts || '{}');
  posts[board] = posts[board] || [];
  posts[board].push(r.id);
  localStorage.own_posts = JSON.stringify(posts);
});

$(document).on('new_post', function(e,post) {
  var $post = $(post);
  if ($post.is('div.post.reply')) { // it's a reply
    $post.each(update_own);
  }
  else {
    $post.each(update_own); // first OP
    $post.find('div.post.reply').each(update_own); // then replies
  }
});



}();
/*
* youtube
* https://github.com/savetheinternet/Tinyboard/blob/master/js/youtube.js
*
* Don't load the YouTube player unless the video image is clicked.
* This increases performance issues when many videos are embedded on the same page.
* Currently only compatiable with YouTube.
*
* Proof of concept.
*
* Released under the MIT license
* Copyright (c) 2013 Michael Save <savetheinternet@tinyboard.org>
* Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net> 
*
* Usage:
*	$config['embedding'] = array();
*	$config['embedding'][0] = array(
*		'/^https?:\/\/(\w+\.)?(?:youtube\.com\/watch\?v=|youtu\.be\/)([a-zA-Z0-9\-_]{10,11})(&.+)?$/i',
*		$config['youtube_js_html']);
*   $config['additional_javascript'][] = 'js/jquery.min.js';
*   $config['additional_javascript'][] = 'js/youtube.js';
*
*/

//YT auto play
$(document).ready(function(){
	if (window.Options && Options.get_tab('general')) {
		Options.extend_tab("general", "<span id='youtube-size'>" + _('YouTube size') + ": <input type='number' id='youtube-width' value='360'>x<input type='number' id='youtube-height' value='270'>");

		if (typeof localStorage.youtube_size === 'undefined') {
			localStorage.youtube_size = '{"width":360,"height":270}';
			var our_yt = JSON.parse(localStorage.youtube_size);
		} else {
			var our_yt = JSON.parse(localStorage.youtube_size);
			$('#youtube-height').val(our_yt.height);
			$('#youtube-width').val(our_yt.width);
		}


		$('#youtube-width, #youtube-height').on('change', function() {
			if ($(this).attr('id') === 'youtube-height') {
				our_yt.height = $(this).val();
			} else {	
				our_yt.width = $(this).val();
			}

			localStorage.youtube_size = JSON.stringify(our_yt);
		});
	}

	var do_embed_yt = function(tag) {
		if (typeof our_yt === "undefined") {
			our_yt = {"width":360,"height":270};
		}
		
		$('div.video-container a', tag).click(function() {
			$(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
				'width="'+our_yt.width+'" height="'+our_yt.height+'" src="//www.youtube.com/embed/' + $(this.parentNode).data('video') +
				'?autoplay=1&html5=1'+ $(this.parentNode).data('params') +'" allowfullscreen frameborder="0"/>');
			$(this).remove();
			return false;
		});
		/*Vidme*/
		$('div.video-container-vidme a', tag).click(function() {
			$(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
				'width="'+our_yt.width+'" height="'+our_yt.height+'" src="//www.vid.me/e/' + $(this.parentNode).data('video') +
				'?stats=1" allowfullscreen frameborder="0"/>');
			$(this).remove();
			return false;
		});

                /*TGW*/
                $('div.video-container-tgw1 a', tag).click(function() {
                        $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
                                'width="'+our_yt.width+'" height="'+our_yt.height+'" src="//video1.thegoldwater.com/api/player.php?id=' + $(this.parentNode).data('video') +
                                '" allowfullscreen frameborder="0"/>');
                        $(this).remove();
                        return false;
                });

                /*TGW*/
                $('div.video-container-tgw2 a', tag).click(function() {
                        $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
                                'width="'+our_yt.width+'" height="'+our_yt.height+'" src="//video2.thegoldwater.com/api/player.php?id=' + $(this.parentNode).data('video') +
                                '" allowfullscreen frameborder="0"/>');
                        $(this).remove();
                        return false;
                });

                /*Xhamster*/
                $('div.video-container-xhamster a', tag).click(function() {
                  $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
                    'width="380" height="280" src="//www.xhamster.com/xembed.php?video=' + $(this.parentNode).data('video') +
                    '" allowfullscreen scrolling="no" frameborder="0"/>');
                  $(this).remove();
                  return false;
                });
                /*Redtube*/
                $('div.video-container-redtube a', tag).click(function() {
                  $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
                    ' src="https://embed.redtube.com/?id=' + $(this.parentNode).data('video') +
                    '&bgcolor=000000" frameborder="0" width="380" height="280" scrolling="no" allowfullscreen/>');
                  $(this).remove();
                  return false;
                });
                /*Pornhub*/
                $('div.video-container-pornhub a', tag).click(function() {
                  $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
                    'width="380" height="280" src="https://www.pornhub.com/embed/' + $(this.parentNode).data('video') +
                    '" allowfullscreen scrolling="no" frameborder="0"/>');
                  $(this).remove();
                  return false;
                });
                /*Vimeo*/
                $('div.video-container-vimeo a', tag).click(function() {
                  $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
                    'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://player.vimeo.com/video/' + $(this.parentNode).data('video') +
                    '?color=ffffff" webkitallowfullscreen mozallowfullscreen allowfullscreen frameborder="0"/>');
                  $(this).remove();
                  return false;
                });
                /*Tube8*/
                $('div.video-container-tube8 a', tag).click(function() {
                  $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
                    'width="608" height="481" src="https://www.tube8.com/embed/' + $(this.parentNode).data('video') +
                    '" scrolling="no" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" name="t8_embed_video" frameborder="0"/>');
                  $(this).remove();
                  return false;
                });
                /*Xvideos*/
                $('div.video-container-xvideos a', tag).click(function() {
                  $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
                    'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://flashservice.xvideos.com/embedframe/' + $(this.parentNode).data('video') +
                    '" scrolling=no allowfullscreen=allowfullscreen frameborder="0"/>');
                  $(this).remove();
                  return false;
                });
                /*Youjizz*/
                $('div.video-container-youjizz a', tag).click(function() {
                  $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
                    'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://www.youjizz.com/videos/embed/' + $(this.parentNode).data('video') +
                    '" allowfullscreen scrolling="no" allowtransparency="true" frameborder="0"/>');
                  $(this).remove();
                  return false;
                });
    		/*Twitch*/
    		$('div.video-container-twitch a', tag).click(function() {
      		 $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
        	  'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://player.twitch.tv/?channel=' + $(this.parentNode).data('video') +
        	  '" allowfullscreen scrolling="no" allowtransparency="true" frameborder="0"/>');
      		 $(this).remove();
      		 return false;
    		});
    		/*Dailymotion*/
    		$('div.video-container-dailymotion a', tag).click(function() {
      		 $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
        	  'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://www.dailymotion.com/embed/video/' + $(this.parentNode).data('video') +
        	  '" allowfullscreen scrolling="no" frameborder="0"/>');
      		 $(this).remove();
      		 return false;
    		});
    		/*vaughnlive*/
    		$('div.video-container-vaughnlive a', tag).click(function() {
      		 $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
        	  'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://vaughnlive.tv/embed/video/' + $(this.parentNode).data('video') +
        	  '" allowfullscreen scrolling="no" frameborder="0"/>');
      		 $(this).remove();
      		 return false;
    		});
    		/*liveleak*/
    		$('div.video-container-liveleak a', tag).click(function() {
      		 $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
        	  'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://www.liveleak.com/ll_embed?i=' + $(this.parentNode).data('video') +
        	  '" allowfullscreen scrolling="no" frameborder="0"/>');
      		 $(this).remove();
      		 return false;
    		});
    		/*nicovideo*/
    		$('div.video-container-nicovideo a', tag).click(function() {
      		 $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
        	  'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://embed.nicovideo.jp/watch/sm' + $(this.parentNode).data('video') +
        	  '?oldScript=1" allowfullscreen scrolling="no" frameborder="0"/>');
      		 $(this).remove();
      		 return false;
    		});
    		/*streamable*/
    		$('div.video-container-streamable a', tag).click(function() {
      		 $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
        	  'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://streamable.com/e/' + $(this.parentNode).data('video') +
        	  '?r=a" allowfullscreen scrolling="no" frameborder="0"/>');
      		 $(this).remove();
      		 return false;
    		});
		/*soundcloud*/
		$('div.video-container-soundcloud a', tag).click(function() {
		  $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
		    'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://w.soundcloud.com/player/?url=' + $(this.parentNode).data('video') +
		    '&amp;auto_play=false&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true" allowfullscreen scrolling="no" frameborder="0"/>');
		  $(this).remove();
		  return false;
		});
		/*xaniatube*/
		$('div.video-container-xaniatube a', tag).click(function() {
		  $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
		    'width="640" height="360" src="https://www.xaniatube.com/embed.php?vid=' + $(this.parentNode).data('video') +
		    '" allowfullscreen seamless scrolling="no" frameborder="0"/>');
		  $(this).remove();
		  return false;
		});
	        /*Vlive*/
	        $('div.video-container-vlive a', tag).click(function() {
	           $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
	            'width="'+our_yt.width+'" height="'+our_yt.height+'" src="//www.vlive.tv/embed/' + $(this.parentNode).data('video') +
	            '#playerBoxArea" allowfullscreen scrolling="no" frameborder="0"/>');
	           $(this).remove();
	           return false;
	        });

	       /*Vocaroo*/
               $('div.video-container-vocaroo a', tag).click(function() {
                   $(this.parentNode).append('<object width="148" height="44">'+
                    '<param name="movie" value="https://vocaroo.com/player.swf?playMediaID=' + $(this.parentNode).data('video') + '&autoplay=0"></param>' +
                    '<param name="wmode" value="transparent"></param>' +
                    '<embed src="https://vocaroo.com/player.swf?playMediaID=' + $(this.parentNode).data('video') + '&autoplay=0" width="148" height="44" wmode="transparent" type="application/x-shockwave-flash"></embed>' +
                    '</object>');
                   $(this).remove();
                   return false;
                });

                /*Hooktube*/
                $('div.video-container-hooktube a', tag).click(function() {
                   $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
                    'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://hooktube.com/embed/' + $(this.parentNode).data('video') +
                    '" allowfullscreen scrolling="no" frameborder="0"/>');
                   $(this).remove();
                   return false;
                });

                /*Smashcast*/
                $('div.video-container-smashcast a', tag).click(function() {
                   $(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
                    'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://www.smashcast.tv/embed/' + $(this.parentNode).data('video') +
                    '" allowfullscreen scrolling="no" frameborder="0"/>');
                   $(this).remove();
                   return false;
                });

		//Twitch YT size
		$('div.video-container.twitch').find('object').each(function(i,v) {
			$(v).attr('width', our_yt.width).attr('height', our_yt.height);
		});

        	/*Invidio*/
        	$('div.video-container-invidio a', tag).click(function() {
           		$(this.parentNode).append('<iframe style="float:left;margin: 10px 20px" type="text/html" '+
            		'width="'+our_yt.width+'" height="'+our_yt.height+'" src="https://invidio.us/embed/' + $(this.parentNode).data('video') +
            		'" allowfullscreen scrolling="no" frameborder="0"/>');
           		$(this).remove();
           		return false;
        	});


	};
	do_embed_yt(document);

        // allow to work with auto-reload.js, etc.
        $(document).on('new_post', function(e, post) {
                do_embed_yt(post);
        });
});

//YT draggable
$(document).on('ready', function() {
	//Options for jQuery-UI draggable
	var ui_draggable_opts = {handle: ".video-handle", containment: 'window', scroll: false, distance: 10, stop: function(){$(this).css('position','fixed');}}
	//Get a suitable background color, based on the current CSS
	var dummy_reply = $('<div class="post reply"></div>').appendTo($('body'));
	var reply_background = dummy_reply.css('backgroundColor');
	dummy_reply.remove();

	//Add pop buttons
	$('.video-container').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
	$('.video-container').css({display:'inline-block',float:'left'});
	$('.thread>.video-container>a>img').css('margin-bottom',0)

	$('.video-pop').on('click', function(e) {
	    e.preventDefault();
	    var vc = $(this).parents('.video-container');

	    if (vc.hasClass('popped')) {
		//vc.remove();
			vc.removeClass('popped');
			vc.draggable('destroy');
			vc.removeClass('ui-draggable');
			vc.css('position','static');
			vc.find('.video-handle').remove();
			$(this).text('[pop]');
		return;
	    } else {
			$(this).text('[return]');
			vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
			vc.addClass('ui-draggable');
			vc.addClass('popped');
			vc.css('background-color', reply_background);
			//No hiding under the nav
			vc.css('z-index', 31);
			//Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
			vc.css('top', vc.offset().top - $(window).scrollTop());
			vc.css('left', vc.offset().left - $(window).scrollLeft());
			vc.css('position','fixed');
			vc.draggable(ui_draggable_opts);    
		}
	});
	/*Vidme*/
  	//Add pop buttons
  	$('.video-container-vidme').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
  	$('.video-container-vidme').css({display:'inline-block',float:'left'});
  	$('.thread>.video-container-vidme>a>img').css('margin-bottom',0)

  	$('.video-pop').on('click', function(e) {
      		e.preventDefault();
      		var vc = $(this).parents('.video-container-vidme');

      		if (vc.hasClass('popped')) {
    		//vc.remove();
      			vc.removeClass('popped');
      			vc.draggable('destroy');
      			vc.removeClass('ui-draggable');
      			vc.css('position','static');
      			vc.find('.video-handle').remove();
      			$(this).text('[pop]');
    			return;
      		} else {
      			$(this).text('[return]');
      			vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
      			vc.addClass('ui-draggable');
      			vc.addClass('popped');
      			vc.css('background-color', reply_background);
      			//No hiding under the nav
      			vc.css('z-index', 31);
      			//Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
      			vc.css('top', vc.offset().top - $(window).scrollTop());
      			vc.css('left', vc.offset().left - $(window).scrollLeft());
      			vc.css('position','fixed');
      			vc.draggable(ui_draggable_opts);
    		}
  	});

        /*TGW*/
        //Add pop buttons
        $('.video-container-tgw1').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-tgw1').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-tgw1>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
                e.preventDefault();
                var vc = $(this).parents('.video-container-tgw1');

                if (vc.hasClass('popped')) {
                //vc.remove();
                        vc.removeClass('popped');
                        vc.draggable('destroy');
                        vc.removeClass('ui-draggable');
                        vc.css('position','static');
                        vc.find('.video-handle').remove();
                        $(this).text('[pop]');
                        return;
                } else {
                        $(this).text('[return]');
                        vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
                        vc.addClass('ui-draggable');
                        vc.addClass('popped');
                        vc.css('background-color', reply_background);
                        //No hiding under the nav
                        vc.css('z-index', 31);
                        //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
                        vc.css('top', vc.offset().top - $(window).scrollTop());
                        vc.css('left', vc.offset().left - $(window).scrollLeft());
                        vc.css('position','fixed');
                        vc.draggable(ui_draggable_opts);
                }
        });

        /*TGW*/
        //Add pop buttons
        $('.video-container-tgw2').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-tgw2').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-tgw2>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
                e.preventDefault();
                var vc = $(this).parents('.video-container-tgw2');

                if (vc.hasClass('popped')) {
                //vc.remove();
                        vc.removeClass('popped');
                        vc.draggable('destroy');
                        vc.removeClass('ui-draggable');
                        vc.css('position','static');
                        vc.find('.video-handle').remove();
                        $(this).text('[pop]');
                        return;
                } else {
                        $(this).text('[return]');
                        vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
                        vc.addClass('ui-draggable');
                        vc.addClass('popped');
                        vc.css('background-color', reply_background);
                        //No hiding under the nav
                        vc.css('z-index', 31);
                        //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
                        vc.css('top', vc.offset().top - $(window).scrollTop());
                        vc.css('left', vc.offset().left - $(window).scrollLeft());
                        vc.css('position','fixed');
                        vc.draggable(ui_draggable_opts);
                }
        });

        /*xhamster*/
        //Add pop buttons
        $('.video-container-xhamster').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-xhamster').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-xhamster>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-xhamster');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

        /*redtube*/
        //Add pop buttons
        $('.video-container-redtube').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-redtube').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-redtube>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-redtube');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

        /*pornhub*/
        //Add pop buttons
        $('.video-container-pornhub').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-pornhub').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-pornhub>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-pornhub');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

        /*tube8*/
        //Add pop buttons
        $('.video-container-tube8').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-tube8').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-tube8>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-tube8');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

        /*xvideos*/
        //Add pop buttons
        $('.video-container-xvideos').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-xvideos').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-xvideos>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-xvideos');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

        /*youjizz*/
        //Add pop buttons
        $('.video-container-youjizz').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-youjizz').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-youjizz>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-youizz');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

        /*twitch*/
        //Add pop buttons
        $('.video-container-twitch').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-twitch').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-twitch>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-twitch');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

        /*Dailymotion*/
        //Add pop buttons
        $('.video-container-dailymotion').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-dailymotion').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-dailymotion>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-dailymotion');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

        /*vaughnlive*/
        //Add pop buttons
        $('.video-container-vaughnlive').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-vaughnlive').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-vaughnlive>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-vaughnlive');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

        /*Liveleak*/
        //Add pop buttons
        $('.video-container-liveleak').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-liveleak').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-liveleak>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-liveleak');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

        /*Nicovideo*/
        //Add pop buttons
        $('.video-container-nicovideo').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-nicovideo').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-nicovideo>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-nicovideo');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

        /*Streamable*/
        //Add pop buttons
        $('.video-container-streamable').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
        $('.video-container-streamable').css({display:'inline-block',float:'left'});
        $('.thread>.video-container-streamable>a>img').css('margin-bottom',0)

        $('.video-pop').on('click', function(e) {
            e.preventDefault();
            var vc = $(this).parents('.video-container-streamable');

            if (vc.hasClass('popped')) {
          //vc.remove();
            vc.removeClass('popped');
            vc.draggable('destroy');
            vc.removeClass('ui-draggable');
            vc.css('position','static');
            vc.find('.video-handle').remove();
            $(this).text('[pop]');
          return;
            } else {
            $(this).text('[return]');
            vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
            vc.addClass('ui-draggable');
            vc.addClass('popped');
            vc.css('background-color', reply_background);
            //No hiding under the nav
            vc.css('z-index', 31);
            //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
            vc.css('top', vc.offset().top - $(window).scrollTop());
            vc.css('left', vc.offset().left - $(window).scrollLeft());
            vc.css('position','fixed');
            vc.draggable(ui_draggable_opts);
          }
        });

	  /*Soundcloud*/
	  //Add pop buttons
	  $('.video-container-soundcloud').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
	  $('.video-container-soundcloud').css({display:'inline-block',float:'left'});
	  $('.thread>.video-container-soundcloud>a>img').css('margin-bottom',0)

	  $('.video-pop').on('click', function(e) {
	      e.preventDefault();
	      var vc = $(this).parents('.video-container-soundcloud');

	      if (vc.hasClass('popped')) {
	    //vc.remove();
	      vc.removeClass('popped');
	      vc.draggable('destroy');
	      vc.removeClass('ui-draggable');
	      vc.css('position','static');
	      vc.find('.video-handle').remove();
	      $(this).text('[pop]');
	    return;
	      } else {
	      $(this).text('[return]');
	      vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
	      vc.addClass('ui-draggable');
	      vc.addClass('popped');
	      vc.css('background-color', reply_background);
	      //No hiding under the nav
	      vc.css('z-index', 31);
	      //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
	      vc.css('top', vc.offset().top - $(window).scrollTop());
	      vc.css('left', vc.offset().left - $(window).scrollLeft());
	      vc.css('position','fixed');
	      vc.draggable(ui_draggable_opts);
	    }
	  });

	  /*Xaniatube*/
	  //Add pop buttons
	  $('.video-container-xaniatube').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
	  $('.video-container-xaniatube').css({display:'inline-block',float:'left'});
	  $('.thread>.video-container-xaniatube>a>img').css('margin-bottom',0)

	  $('.video-pop').on('click', function(e) {
	      e.preventDefault();
	      var vc = $(this).parents('.video-container-xaniatube');

	      if (vc.hasClass('popped')) {
	    //vc.remove();
	      vc.removeClass('popped');
	      vc.draggable('destroy');
	      vc.removeClass('ui-draggable');
	      vc.css('position','static');
	      vc.find('.video-handle').remove();
	      $(this).text('[pop]');
	    return;
	      } else {
	      $(this).text('[return]');
	      vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
	      vc.addClass('ui-draggable');
	      vc.addClass('popped');
	      vc.css('background-color', reply_background);
	      //No hiding under the nav
	      vc.css('z-index', 31);
	      //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
	      vc.css('top', vc.offset().top - $(window).scrollTop());
	      vc.css('left', vc.offset().left - $(window).scrollLeft());
	      vc.css('position','fixed');
	      vc.draggable(ui_draggable_opts);
	    }
	  });

          /*Vlive*/
          //Add pop buttons
          $('.video-container-vlive').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
          $('.video-container-vlive').css({display:'inline-block',float:'left'});
          $('.thread>.video-container-vlive>a>img').css('margin-bottom',0)

          $('.video-pop').on('click', function(e) {
              e.preventDefault();
              var vc = $(this).parents('.video-container-vlive');

              if (vc.hasClass('popped')) {
              vc.removeClass('popped');
              vc.draggable('destroy');
              vc.removeClass('ui-draggable');
              vc.css('position','static');
              vc.find('.video-handle').remove();
              $(this).text('[pop]');
              return;
              } else {
              $(this).text('[return]');
              vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
              vc.addClass('ui-draggable');
              vc.addClass('popped');
              vc.css('background-color', reply_background);
              //No hiding under the nav
              vc.css('z-index', 31);
              //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
              vc.css('top', vc.offset().top - $(window).scrollTop());
              vc.css('left', vc.offset().left - $(window).scrollLeft());
              vc.css('position','fixed');
              vc.draggable(ui_draggable_opts);
            }
          });

            /*Vocaroo*/
            //Add pop buttons
            $('.video-container-vocaroo').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
            $('.video-container-vocaroo').css({display:'inline-block',float:'left'});
            $('.thread>.video-container-vocaroo>a>img').css('margin-bottom',0)

            $('.video-pop').on('click', function(e) {
                e.preventDefault();
                var vc = $(this).parents('.video-container-vocaroo');

                if (vc.hasClass('popped')) {
              //vc.remove();
                vc.removeClass('popped');
                vc.draggable('destroy');
                vc.removeClass('ui-draggable');
                vc.css('position','static');
                vc.find('.video-handle').remove();
                $(this).text('[pop]');
              return;
                } else {
                $(this).text('[return]');
                vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
                vc.addClass('ui-draggable');
                vc.addClass('popped');
                vc.css('background-color', reply_background);
                //No hiding under the nav
                vc.css('z-index', 31);
                //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
                vc.css('top', vc.offset().top - $(window).scrollTop());
                vc.css('left', vc.offset().left - $(window).scrollLeft());
                vc.css('position','fixed');
                vc.draggable(ui_draggable_opts);
              }
            });


            /*Hooktube*/
            //Add pop buttons
            $('.video-container-hooktube').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
            $('.video-container-hooktube').css({display:'inline-block',float:'left'});
            $('.thread>.video-container-hooktube>a>img').css('margin-bottom',0)

            $('.video-pop').on('click', function(e) {
                e.preventDefault();
                var vc = $(this).parents('.video-container-hooktube');

                if (vc.hasClass('popped')) {
              //vc.remove();
                vc.removeClass('popped');
                vc.draggable('destroy');
                vc.removeClass('ui-draggable');
                vc.css('position','static');
                vc.find('.video-handle').remove();
                $(this).text('[pop]');
              return;
                } else {
                $(this).text('[return]');
                vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
                vc.addClass('ui-draggable');
                vc.addClass('popped');
                vc.css('background-color', reply_background);
                //No hiding under the nav
                vc.css('z-index', 31);
                //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
                vc.css('top', vc.offset().top - $(window).scrollTop());
                vc.css('left', vc.offset().left - $(window).scrollLeft());
                vc.css('position','fixed');
                vc.draggable(ui_draggable_opts);
              }
            });

            /*Smashcast*/
            //Add pop buttons
            $('.video-container-smashcast').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
            $('.video-container-smashcast').css({display:'inline-block',float:'left'});
            $('.thread>.video-container-smashcast>a>img').css('margin-bottom',0)

            $('.video-pop').on('click', function(e) {
                e.preventDefault();
                var vc = $(this).parents('.video-container-smashcast');

                if (vc.hasClass('popped')) {
              //vc.remove();
                vc.removeClass('popped');
                vc.draggable('destroy');
                vc.removeClass('ui-draggable');
                vc.css('position','static');
                vc.find('.video-handle').remove();
                $(this).text('[pop]');
              return;
                } else {
                $(this).text('[return]');
                vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
                vc.addClass('ui-draggable');
                vc.addClass('popped');
                vc.css('background-color', reply_background);
                //No hiding under the nav
                vc.css('z-index', 31);
                //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
                vc.css('top', vc.offset().top - $(window).scrollTop());
                vc.css('left', vc.offset().left - $(window).scrollLeft());
                vc.css('position','fixed');
                vc.draggable(ui_draggable_opts);
              }
            });


            /*Invidio*/
            //Add pop buttons
            $('.video-container-invidio').prepend($('<a href="#" class="video-pop" style="font-weight:bold;float:right">[pop]</a>'))
            $('.video-container-invidio').css({display:'inline-block',float:'left'});
            $('.thread>.video-container-invidio>a>img').css('margin-bottom',0)

            $('.video-pop').on('click', function(e) {
                e.preventDefault();
                var vc = $(this).parents('.video-container-invidio');

                if (vc.hasClass('popped')) {
              //vc.remove();
                vc.removeClass('popped');
                vc.draggable('destroy');
                vc.removeClass('ui-draggable');
                vc.css('position','static');
                vc.find('.video-handle').remove();
                $(this).text('[pop]');
              return;
                } else {
                $(this).text('[return]');
                vc.prepend($('<i class="fa fa-arrows video-handle" style="border:1px solid black;padding:2px;cursor:move">'));
                vc.addClass('ui-draggable');
                vc.addClass('popped');
                vc.css('background-color', reply_background);
                //No hiding under the nav
                vc.css('z-index', 31);
                //Correct displacement that would occur when the height of the page changes when a video is first dragged; ui draggable is meant to be used for pos:relative not pos:fixed
                vc.css('top', vc.offset().top - $(window).scrollTop());
                vc.css('left', vc.offset().left - $(window).scrollLeft());
                vc.css('position','fixed');
                vc.draggable(ui_draggable_opts);
              }
            });

});
/*
 * comment-toolbar.js
 *   - Adds a toolbar above the commenting area containing most of 8kun's formatting options
 *   - Press Esc to close quick-reply window when it's in focus
 * 
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/comment-toolbar.js';
 */
if (active_page == 'thread' || active_page == 'index') {
	var formatText = (function($){
		"use strict";
		var self = {};
		self.rules = {
			spoiler: {
				text: _('Spoiler'),
				key: 's',
				multiline: false, 
				exclusiveline: false, 
				prefix:'**',
				suffix:'**'
			},
			italics: {
				text: _('Italics'),
				key: 'i',
				multiline: false, 
				exclusiveline: false, 
				prefix: "''",
				suffix: "''"
			},
			bold: {
				text: _('Bold'),
				key: 'b',
				multiline: false, 
				exclusiveline: false, 
				prefix: "'''",
				suffix: "'''"
			},
			underline: {
				text: _('Underline'),
				key: 'u',
				multiline: false, 
				exclusiveline: false, 
				prefix:'__',
				suffix:'__'
			},
			code: {
				text: _('Code'),
				key: 'f',
				multiline: true, 
				exclusiveline: false, 
				prefix: '[code]',
				suffix: '[/code]'
			},
			strike: {
				text: _('Strike'),
				key: 'd',
				multiline:false, 
				exclusiveline:false, 
				prefix:'~~',
				suffix:'~~'
			},
			heading: {
				text: _('Heading'),
				key: 'r',
				multiline:false, 
				exclusiveline:true, 
				prefix:'==',
				suffix:'=='
			}
		};
		
		self.toolbar_wrap = function(node) {
			var parent = $(node).parents('form[name="post"]');
			self.wrap(parent.find('#body')[0],'textarea[name="body"]', parent.find('.format-text > select')[0].value, false);
		};
	
		self.wrap = function(ref, target, option, expandedwrap) {
			// clean and validate arguments
			if (ref == null) return;
			var settings = {multiline: false, exclusiveline: false, prefix:'', suffix: null};
			$.extend(settings,JSON.parse(localStorage.formatText_rules)[option]);
			
			// resolve targets into array of proper node elements
			// yea, this is overly verbose, oh well.
			var res = [];
			if (target instanceof Array) {
				for (var indexa in target) {
					if (target.hasOwnProperty(indexa)) {
						if (typeof target[indexa] == 'string') {
							var nodes = $(target[indexa]);
							for (var indexb in nodes) {
								if (indexa.hasOwnProperty(indexb)) res.push(nodes[indexb]);
							}
						} else {
							res.push(target[indexa]);
						}
					}
				}
			} else {
				if (typeof target == 'string') {
					var nodes = $(target);
					for (var index in nodes) {
						if (nodes.hasOwnProperty(index)) res.push(nodes[index]);
					}
				} else {
					res.push(target);
				}
			}
			target = res;
			//record scroll top to restore it later.
			var scrollTop = ref.scrollTop;

			//We will restore the selection later, so record the current selection
			var selectionStart = ref.selectionStart;
			var selectionEnd = ref.selectionEnd;

			var text = ref.value;
			var before = text.substring(0, selectionStart);
			var selected = text.substring(selectionStart, selectionEnd);
			var after = text.substring(selectionEnd);
			var whiteSpace = [" ","\t"];
			var breakSpace = ["\r","\n"];
			var cursor;
			
			// handles multiline selections on formatting that doesn't support spanning over multiple lines
			if (!settings.multiline) selected = selected.replace(/(\r|\n|\r\n)/g,settings.suffix +"$1"+ settings.prefix);
			
			// handles formatting that requires it to be on it's own line OR if the user wishes to expand the wrap to the nearest linebreak
			if (settings.exclusiveline || expandedwrap) {
				// buffer the begining of the selection until a linebreak
				cursor = before.length -1;
				while (cursor >= 0 && breakSpace.indexOf(before.charAt(cursor)) == -1) {
					cursor--;
				}
				selected = before.substring(cursor +1) + selected;
				before = before.substring(0, cursor +1);
				
				// buffer the end of the selection until a linebreak
				cursor = 0;
				while (cursor < after.length && breakSpace.indexOf(after.charAt(cursor)) == -1) {
					cursor++;
				}
				selected += after.substring(0, cursor);
				after = after.substring(cursor);
			}
			
			// set values
			var res = before + settings.prefix + selected + settings.suffix + after;
			$(target).val(res);
			
			// restore the selection area and scroll of the reference
			ref.selectionEnd = before.length + settings.prefix.length + selected.length;
			if (selectionStart === selectionEnd) {
				ref.selectionStart = ref.selectionEnd;
			} else {
				ref.selectionStart = before.length + settings.prefix.length;
			}
			ref.scrollTop = scrollTop;
		};
		
		self.build_toolbars = function(){
			if (localStorage.formatText_toolbar == 'true'){
				// remove existing toolbars
				if ($('.format-text').length > 0) $('.format-text').remove();
				
				// Place toolbar above each textarea input
				var name, options = '', rules = JSON.parse(localStorage.formatText_rules);
				for (var index in rules) {
					if (!rules.hasOwnProperty(index)) continue;
					name = rules[index].text;

					//add hint if key exists
					if (rules[index].key) {
						name += ' (CTRL + '+ rules[index].key.toUpperCase() +')';
					}
					options += '<option value="'+ index +'">'+ name +'</option>';
				}
				$('[name="body"]').before('<div class="format-text"><a href="javascript:;" onclick="formatText.toolbar_wrap(this);">Wrap</a><select>'+ options +'</select></div>');
				$('body').append('<style>#quick-reply .format-text>a{width:15%;display:inline-block;text-align:center;}#quick-reply .format-text>select{width:85%;};</style>');
			}
		};
		
		self.add_rule = function(rule, index){
			if (rule === undefined) rule = {
				text: 'New Rule',
				key: '',
				multiline:false, 
				exclusiveline:false, 
				prefix:'',
				suffix:''
			}
			
			// generate an id for the rule
			if (index === undefined) {
				var rules = JSON.parse(localStorage.formatText_rules);
				while (rules[index] || index === undefined) {
					index = ''
					index +='abcdefghijklmnopqrstuvwxyz'.substr(Math.floor(Math.random()*26),1);
					index +='abcdefghijklmnopqrstuvwxyz'.substr(Math.floor(Math.random()*26),1);
					index +='abcdefghijklmnopqrstuvwxyz'.substr(Math.floor(Math.random()*26),1);
				}
			}
			if (window.Options && Options.get_tab('formatting')){
				var html = $('<div class="format_rule" name="'+ index +'"></div>').html('\
				<input type="text" name="text" class="format_option" size="10" value=\"'+ rule.text.replace(/"/g, '&quot;') +'\">\
				<input type="checkbox" name="multiline" class="format_option" '+ (rule.multiline ? 'checked' : '') +'>\
				<input type="checkbox" name="exclusiveline" class="format_option" '+ (rule.exclusiveline ? 'checked' : '') +'>\
				<input type="text" name="prefix" class="format_option" size="8" value=\"'+ (rule.prefix ? rule.prefix.replace(/"/g, '&quot;') : '') +'\">\
				<input type="text" name="suffix" class="format_option" size="8" value=\"'+ (rule.suffix ? rule.suffix.replace(/"/g, '&quot;') : '') +'\">\
				<input type="text" name="key" class="format_option" size="2" maxlength="1" value=\"'+ rule.key +'\">\
				<input type="button" value="X" onclick="if(confirm(\'Do you wish to remove the '+ rule.text +' formatting rule?\'))$(this).parent().remove();">\
				');
				
				if ($('.format_rule').length > 0) {
					$('.format_rule').last().after(html);
				} else {
					Options.extend_tab('formatting', html);
				}
			}
		};
		
		self.save_rules = function(){
			var rule, newrules = {}, rules = $('.format_rule');
			for (var index=0;rules[index];index++) {
				rule = $(rules[index]);
				newrules[rule.attr('name')] = {
					text: rule.find('[name="text"]').val(),
					key: rule.find('[name="key"]').val(),
					prefix: rule.find('[name="prefix"]').val(),
					suffix: rule.find('[name="suffix"]').val(),
					multiline: rule.find('[name="multiline"]').is(':checked'),
					exclusiveline: rule.find('[name="exclusiveline"]').is(':checked')
				};
			}
			localStorage.formatText_rules = JSON.stringify(newrules);
			self.build_toolbars();
		};
		
		self.reset_rules = function(to_default) {
			$('.format_rule').remove();
			var rules;
			if (to_default) rules = self.rules;
			else rules = JSON.parse(localStorage.formatText_rules);
			for (var index in rules){
				if (!rules.hasOwnProperty(index)) continue;
				self.add_rule(rules[index], index);
			}
		};
		
		// setup default rules for customizing
		if (!localStorage.formatText_rules) localStorage.formatText_rules = JSON.stringify(self.rules);
		
		// setup code to be ran when page is ready (work around for main.js compilation).
		$(document).ready(function(){
			// Add settings to Options panel general tab
			if (window.Options && Options.get_tab('general')) {
				var s1 = '#formatText_keybinds>input', s2 = '#formatText_toolbar>input', e = 'change';
				Options.extend_tab('general', '\
					<fieldset>\
						<legend>Formatting Options</legend>\
						<label id="formatText_keybinds"><input type="checkbox">' + _('Enable formatting keybinds') + '</label>\
						<label id="formatText_toolbar"><input type="checkbox">' + _('Show formatting toolbar') + '</label>\
					</fieldset>\
				');
			} else {
				var s1 = '#formatText_keybinds', s2 = '#formatText_toolbar', e = 'click';
				$('hr:first').before('<div id="formatText_keybinds" style="text-align:right"><a class="unimportant" href="javascript:void(0)">'+ _('Enable formatting keybinds') +'</a></div>');
				$('hr:first').before('<div id="formatText_toolbar" style="text-align:right"><a class="unimportant" href="javascript:void(0)">'+ _('Show formatting toolbar') +'</a></div>');
			}
			
			// add the tab for customizing the format settings
			if (window.Options && !Options.get_tab('formatting')) {
				Options.add_tab('formatting', 'angle-right', _('Customize Formatting'));
				Options.extend_tab('formatting', '\
				<style>\
					.format_option{\
						margin-right:5px;\
						overflow:initial;\
						font-size:15px;\
					}\
					.format_option[type="text"]{\
						text-align:center;\
						padding-bottom: 2px;\
						padding-top: 2px;\
					}\
					.format_option:last-child{\
						margin-right:0;\
					}\
					fieldset{\
						margin-top:5px;\
					}\
				</style>\
				');
				
				// Data control row
				Options.extend_tab('formatting', '\
				<button onclick="formatText.add_rule();">'+_('Add Rule')+'</button>\
				<button onclick="formatText.save_rules();">'+_('Save Rules')+'</button>\
				<button onclick="formatText.reset_rules(false);">'+_('Revert')+'</button>\
				<button onclick="formatText.reset_rules(true);">'+_('Reset to Default')+'</button>\
				');
				
				// Descriptor row
				Options.extend_tab('formatting', '\
					<span class="format_option" style="margin-left:25px;">Name</span>\
					<span class="format_option" style="margin-left:45px;" title="Multi-line: Allow formatted area to contain linebreaks.">ML</span>\
					<span class="format_option" style="margin-left:0px;" title="Exclusive-line: Require formatted area to start after and end before a linebreak.">EL</span>\
					<span class="format_option" style="margin-left:25px;" title="Text injected at the start of a format area.">Prefix</span>\
					<span class="format_option" style="margin-left:60px;" title="Text injected at the end of a format area.">Suffix</span>\
					<span class="format_option" style="margin-left:40px;" title="Optional keybind value to allow keyboard shortcut access.">Key</span>\
				');
				
				// Rule rows
				var rules = JSON.parse(localStorage.formatText_rules);
				for (var index in rules){
					if (!rules.hasOwnProperty(index)) continue;
					self.add_rule(rules[index], index);
				}
			}
		
			// setting for enabling formatting keybinds
			$(s1).on(e, function(e) {
				console.log('Keybind');
				if (!localStorage.formatText_keybinds || localStorage.formatText_keybinds == 'false') {
					localStorage.formatText_keybinds = 'true';
					if (window.Options && Options.get_tab('general')) e.target.checked = true;
				} else {
					localStorage.formatText_keybinds = 'false';
					if (window.Options && Options.get_tab('general')) e.target.checked = false;
				}
			});
			
			// setting for toolbar injection
			$(s2).on(e, function(e) {
				console.log('Toolbar');
				if (!localStorage.formatText_toolbar || localStorage.formatText_toolbar == 'false') {
					localStorage.formatText_toolbar = 'true';
					if (window.Options && Options.get_tab('general')) e.target.checked = true;
					formatText.build_toolbars();
				} else {
					localStorage.formatText_toolbar = 'false';
					if (window.Options && Options.get_tab('general')) e.target.checked = false;
					$('.format-text').remove();
				}
			});
			
			// make sure the tab settings are switch properly at loadup
			if (window.Options && Options.get_tab('general')) {
				if (localStorage.formatText_keybinds == 'true') $(s1)[0].checked = true;
				else $(s1)[0].checked = false;
				if (localStorage.formatText_toolbar == 'true') $(s2)[0].checked = true;
				else $(s2)[0].checked = false;
			}
			
			// Initial toolbar injection
			formatText.build_toolbars();
			
			//attach listener to <body> so it also works on quick-reply box
			$('body').on('keydown', '[name="body"]', function(e) {
				if (!localStorage.formatText_keybinds || localStorage.formatText_keybinds == 'false') return;
				var key = String.fromCharCode(e.which).toLowerCase();
				var rules = JSON.parse(localStorage.formatText_rules);
				for (var index in rules) {
					if (!rules.hasOwnProperty(index)) continue;
					if (key === rules[index].key && e.ctrlKey) {
						e.preventDefault();
						if (e.shiftKey) {
							formatText.wrap(e.target, 'textarea[name="body"]', index, true);
						} else {
							formatText.wrap(e.target, 'textarea[name="body"]', index, false);
						}
					}
				}
			});
			
			// Signal that comment-toolbar loading has completed.
			$(document).trigger('formatText');
		});
		
		return self;
    })(jQuery);
}
/*
 * catalog-search.js
 *   - Search and filters threads when on catalog view
 *   - Optional shortcuts 's' and 'esc' to open and close the search.
 * 
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/comment-toolbar.js';
 */
if (active_page == 'catalog') {
	onready(function () {
		'use strict';

		//	'true' = enable shortcuts
		var useKeybinds = true;

		//	trigger the search 400ms after last keystroke
		var delay = 400;
		var timeoutHandle;

		//search and hide none matching threads
		function filter(search_term) {
			$('.replies').each(function () {
				var subject = $(this).children('.intro').text().toLowerCase();
				var comment = $(this).clone().children().remove(':lt(2)').end().text().trim().toLowerCase();
				search_term = search_term.toLowerCase();

				if (subject.indexOf(search_term) == -1 && comment.indexOf(search_term) == -1) {
					$(this).parents('div[id="Grid"]>.mix').css('display', 'none');
				} else {
					$(this).parents('div[id="Grid"]>.mix').css('display', 'inline-block');
				}
			});
		}

		function searchToggle() {
			var button = $('#catalog_search_button');

			if (!button.data('expanded')) {
				button.data('expanded', '1');
				button.text('Close');
				$('.catalog_search').append(' <input id="search_field" style="border: inset 1px;">');
				$('#search_field').focus();
			} else {
				button.removeData('expanded');
				button.text('Search');
				$('.catalog_search').children().last().remove();
				$('div[id="Grid"]>.mix').each(function () { $(this).css('display', 'inline-block'); });
			}
		}

		$('.threads').before('<span class="catalog_search">[<a href="javascript:void(0)" id="catalog_search_button" style="text-decoration:none; cursor:pointer;"></a>]</span>');
		$('#catalog_search_button').text(_('Search'));

		$('#catalog_search_button').on('click', searchToggle);
		$('.catalog_search').on('keyup', 'input#search_field', function (e) {
			window.clearTimeout(timeoutHandle);
			timeoutHandle = window.setTimeout(filter, 400, e.target.value);
		});

		if (useKeybinds) {
			//	's'
			$('body').on('keydown', function (e) {
				if (e.which === 83 && e.target.tagName === 'BODY' && !(e.ctrlKey || e.altKey || e.shiftKey)) {
					e.preventDefault();
					if ($('#search_field').length !== 0) { 
						$('#search_field').focus();
					} else {
						searchToggle();
					}
				}
			});
			//	'esc'
			$('.catalog_search').on('keydown', 'input#search_field', function (e) {
				if (e.which === 27 && !(e.ctrlKey || e.altKey || e.shiftKey)) {
					window.clearTimeout(timeoutHandle);
					searchToggle();
				}
			});
		}
	});
}
/*
 * thread-stats.js
 *   - Adds statistics of the thread below the posts area
 *   - Shows ID post count beside each postID on hover
 * 
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/thread-stats.js';
 */
if (active_page == 'thread') {
$(document).ready(function(){
	//check if page uses unique ID
	var IDsupport = ($('.poster_id').length > 0);
	var thread_id = (document.location.pathname + document.location.search).split('/');
	thread_id = thread_id[thread_id.length -1].split('+')[0].split('.')[0];
	
	//var url_p = 'www.8kun.top';
	//var url_p = document.location.host;
	
        if(location.search){
             var location_origin = location.protocol + '//sys.' + location.search.replace('?http://','');
             var location_split = location_origin.split('/');
             location_origin = location.protocol + '//' + location_split[2];
             location_origin = location_origin.replace('sys.','');

             if(location_split[2] == 'sys.?'){
               location_origin = location.protocol + '//sys.' + location.hostname.replace('sys.','');
             }
         }else{
              var location_origin = location.protocol + '//sys.' + location.hostname.replace('sys.','');
         }
	

        if(location.href.split('/')[3] == 'index.php?http:'){
          location_origin = location.protocol + '//' + location.hostname + '/index.php?'+ location_origin;
        }
        location_origin = location_origin.replace('www.','');
	if(inMod === false){
		location_origin = location_origin.replace('sys.','');
	}
	var url_p = location_origin;	

	$('#thread-links')
		.after('<div id="thread_stats"></div>');
	var el = $('#thread_stats');
	el.prepend('Page <span id="thread_stats_page">?</span>');
	if (IDsupport){
		el.prepend('<span id="thread_stats_uids">0</span> UIDs |&nbsp;');
	}
	el.prepend('<span id="thread_stats_images">0</span> images |&nbsp;');
	el.prepend('<span id="thread_stats_posts">0</span> replies |&nbsp;');
	delete el;
	function update_thread_stats(){
		var op = $('#thread_'+ thread_id +' > div.post.op:not(.post-hover):not(.inline)').first();
		var replies = $('#thread_'+ thread_id +' > div.post.reply:not(.post-hover):not(.inline)');
		// post count
		$('#thread_stats_posts').text(replies.length);
		// image count
		$('#thread_stats_images').text(replies.filter(function(){ 
			return $(this).find('> .files').text().trim() != false; 
		}).length);
		// unique ID count
		if (IDsupport) {
			var opID = op.find('> .intro > .poster_id').text();
			var ids = {};
			replies.each(function(){
				var cur = $(this).find('> .intro > .poster_id');
				var curID = cur.text();
				if (ids[curID] === undefined) {
					ids[curID] = 0;
				}
				ids[curID]++;
			});
			if (ids[opID] === undefined) {
				ids[opID] = 0;
			}
			ids[opID]++;
			var cur = op.find('>.intro >.poster_id');
			if (cur.hasClass('hide_post_counter')){
				show = false;
			}else{
				show = true;
			}

			cur.find('+.posts_by_id').remove();
			if(show) cur.after('<span class="posts_by_id"> ('+ ids[cur.text()] +')</span>');
			replies.each(function(){
				cur = $(this).find('>.intro >.poster_id');
				cur.find('+.posts_by_id').remove();
				if(show) cur.after('<span class="posts_by_id"> ('+ ids[cur.text()] +')</span>');
			});
			var size = function(obj) {
				var size = 0, key;
				for (key in obj) {
					if (obj.hasOwnProperty(key)) size++;
				}
				return size;
			};
			$('#thread_stats_uids').text(size(ids));
		}
		//$.getJSON('//'+ document.location.host +'/'+ board_name +'/threads.json').success(function(data){
		$.getJSON(url_p +'/'+ board_name +'/threads.json').success(function(data){
			var found, page = '???';
			for (var i=0;data[i];i++){
				var threads = data[i].threads;
				for (var j=0; threads[j]; j++){
					if (parseInt(threads[j].no) == parseInt(thread_id)) {
						page = data[i].page +1;
						found = true;
						break;
					}
				}
				if (found) break;
			}
			$('#thread_stats_page').text(page);
			if (!found) $('#thread_stats_page').css('color','red');
			else $('#thread_stats_page').css('color','');
		});
	}
	// load the current page the thread is on.
	// uses ajax call so it gets loaded on a delay (depending on network resources available)
	var thread_stats_page_timer = setInterval(function(){
		//$.getJSON('//'+ document.location.host +'/'+ board_name +'/threads.json').success(function(data){
		$.getJSON(url_p +'/'+ board_name +'/threads.json').success(function(data){
			var found, page = '???';
			for (var i=0;data[i];i++){
				var threads = data[i].threads;
				for (var j=0; threads[j]; j++){
					if (parseInt(threads[j].no) == parseInt(thread_id)) {
						page = data[i].page +1;
						found = true;
						break;
					}
				}
				if (found) break;
			}
			$('#thread_stats_page').text(page);
			if (!found) $('#thread_stats_page').css('color','red');
			else $('#thread_stats_page').css('color','');
		});
	},30000);
		$('body').append('<style>.posts_by_id{display:none;}.poster_id:hover+.posts_by_id{display:initial}</style>');
		update_thread_stats();
		$('#update_thread').click(update_thread_stats);
		$(document).on('new_post',update_thread_stats);
});
}
/*
 * quote-selection.js
 *
 * This is a little buggy.
 * Allows you to quote a post by just selecting some text, then beginning to type.
 *
 * Released under the MIT license
 * Copyright (c) 2012 Michael Save <savetheinternet@tinyboard.org>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/quote-selection.js';
 *
 */

$(document).ready(function(){
	if (!window.getSelection)
		return;
	
	$.fn.selectRange = function(start, end) {
		return this.each(function() {
			if (this.setSelectionRange) {
				this.focus();
				this.setSelectionRange(start, end);
			} else if (this.createTextRange) {
				var range = this.createTextRange();
				range.collapse(true);
				range.moveEnd('character', end);
				range.moveStart('character', start);
				range.select();
			}
		});
	};
	
	var altKey = false;
	var ctrlKey = false;
	var metaKey = false;
	
	$(document).keyup(function(e) {
		if (e.keyCode == 18)
			altKey = false;
		else if (e.keyCode == 17)
			ctrlKey = false;
		else if (e.keyCode == 91)
			metaKey = false;
	});
	
	$(document).keydown(function(e) {
		if (e.altKey)
			altKey = true;
		else if (e.ctrlKey)
			ctrlKey = true;
		else if (e.metaKey)
			metaKey = true;
		
		if (altKey || ctrlKey || metaKey) {
			// console.log('CTRL/ALT/Something used. Ignoring');
			return;
		}
		
		if (e.keyCode < 48 || e.keyCode > 90)
			return;
		
		var selection = window.getSelection();
		var $post = $(selection.anchorNode).parents('.post');
		if ($post.length == 0) {
			// console.log('Start of selection was not post div', $(selection.anchorNode).parent());
			return;
		}
		
		var postID = $post.find('.post_no:eq(1)').text();
		
		if (postID != $(selection.focusNode).parents('.post').find('.post_no:eq(1)').text()) {
			// console.log('Selection left post div', $(selection.focusNode).parent());
			return;
		}
		
		;
		var selectedText = selection.toString();
		// console.log('Selected text: ' + selectedText.replace(/\n/g, '\\n').replace(/\r/g, '\\r'));
		
		if ($('body').hasClass('debug'))
			alert(selectedText);
		
		if (selectedText.length == 0)
			return;
		
		var body = $('textarea#body')[0];
		
		var last_quote = body.value.match(/[\S.]*(^|[\S\s]*)>>(\d+)/);
		if (last_quote)
			last_quote = last_quote[2];
		
		/* to solve some bugs on weird browsers, we need to replace \r\n with \n and then undo that after */
		var quote = (last_quote != postID ? '>>' + postID + '\r\n' : '') + $.trim(selectedText).replace(/\r\n/g, '\n').replace(/^/mg, '>').replace(/\n/g, '\r\n') + '\r\n';
		
		// console.log('Deselecting text');
		selection.removeAllRanges();
		
		if (document.selection) {
			// IE
			body.focus();
			var sel = document.selection.createRange();
			sel.text = quote;
			body.focus();
		} else if (body.selectionStart || body.selectionStart == '0') {
			// Mozilla
			var start = body.selectionStart;
			var end = body.selectionEnd;
			
			if (!body.value.substring(0, start).match(/(^|\n)$/)) {
				quote = '\r\n\r\n' + quote;
			}
			
			body.value = body.value.substring(0, start) + quote + body.value.substring(end, body.value.length);			
			$(body).selectRange(start + quote.length, start + quote.length);
		} else {
			// ???
			body.value += quote;
			body.focus();
		}
	});
});

/*
 * flag-previews.js - Preview board flags
 *
 *
*/

$(document).on('ready', function() {
	var flag_previews = function() {
		if (!$('.flag_preview').length) $('[name=user_flag]').after('<img class="flag_preview">');
		if (!$(this).val()) {
			return $('.flag_preview').remove();
		}

		$('.flag_preview').attr('src', configRoot + "static/custom-flags/" + board_name + "/" + $(this).val() + '.png');
	}

	$('[name=user_flag]').on('change', flag_previews);
	$(window).on('quick-reply', function(){$('[name=user_flag]').on('change', flag_previews)});
});
/*
 * post-menu.js - adds dropdown menu to posts
 *
 * Creates a global Menu object with four public methods:
 *
 *   Menu.onclick(fnc)
 *     registers a function to be executed after button click, before the menu is displayed
 *   Menu.add_item(id, text[, title])
 *     adds an item to the top level of menu
 *   Menu.add_submenu(id, text)
 *     creates and returns a List object through which to manipulate the content of the submenu
 *   Menu.get_submenu(id)
 *     returns the submenu with the specified id from the top level menu
 *
 *   The List object contains all the methods from Menu except onclick()
 *
 *   Example usage:
 *     Menu.add_item('filter-menu-hide', 'Hide post');
 *     Menu.add_item('filter-menu-unhide', 'Unhide post');
 *
 *     submenu = Menu.add_submenu('filter-menu-add', 'Add filter');
 *         submenu.add_item('filter-add-post-plus', 'Post +', 'Hide post and all replies');
 *         submenu.add_item('filter-add-id', 'ID');
 *  
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/post-menu.js';
 */
$(document).ready(function () {

var List = function (menuId, text) {
	this.id = menuId;
	this.text = text;
	this.items = [];

	this.add_item = function (itemId, text, title) {
		this.items.push(new Item(itemId, text, title));
	};
	this.list_items = function () {
		var array = [];
		var i, length, obj, $ele;

		if ($.isEmptyObject(this.items))
			return;

		length = this.items.length;
		for (i = 0; i < length; i++) {
			obj = this.items[i];

			$ele = $('<li>', {id: obj.id}).text(obj.text);
			if ('title' in obj) $ele.attr('title', obj.title);

			if (obj instanceof Item) {
				$ele.addClass('post-item');
			} else {
				$ele.addClass('post-submenu');

				$ele.prepend(obj.list_items());
				$ele.append($('<span>', {class: 'post-menu-arrow'}).text('»'));
			}

			array.push($ele);
		}

		return $('<ul>').append(array);
	};
	this.add_submenu = function (menuId, text) {
		var ele = new List(menuId, text);
		this.items.push(ele);
		return ele;
	};
	this.get_submenu = function (menuId) {
		for (var i = 0; i < this.items.length; i++) {
			if ((this.items[i] instanceof Item) || this.items[i].id != menuId) continue;
			return this.items[i];
		}
	};
};

var Item = function (itemId, text, title) {
	this.id = itemId;
	this.text = text;

	// optional
	if (typeof title != 'undefined') this.title = title;
};

function buildMenu(e) {
	var pos = $(e.target).offset();
	var i, length;

	var $menu = $('<div class="post-menu"></div>').append(mainMenu.list_items());

	//  execute registered click handlers
	length = onclick_callbacks.length;
	for (i = 0; i < length; i++) {
		onclick_callbacks[i](e, $menu);
	}

	//  set menu position and append to page
	 $menu.css({top: pos.top, left: pos.left + 20});
	 $('body').append($menu);
}

function addButton(post) {
	var $ele = $(post);
	$ele.find('input.delete').after(
		$('<a>', {href: '#', class: 'post-btn', title: 'Post menu'}).text('▶')
	);
}


/* * * * * * * * * *
    Public methods
 * * * * * * * * * */
var Menu = {};
var mainMenu = new List();
var onclick_callbacks = [];

Menu.onclick = function (fnc) {
	onclick_callbacks.push(fnc);
};

Menu.add_item = function (itemId, text, title) {
	mainMenu.add_item(itemId, text, title);
};

Menu.add_submenu = function (menuId, text) {
	return mainMenu.add_submenu(menuId, text);
};

Menu.get_submenu = function (id) {
	return mainMenu.get_submenu(id);
};

window.Menu = Menu;


/* * * * * * * *
    Initialize
 * * * * * * * */

/*  Styling
 */
var $ele, cssStyle, cssString;

$ele = $('<div>').addClass('post reply').hide().appendTo('body');
cssStyle = $ele.css(['border-top-color']);
cssStyle.hoverBg = $('body').css('background-color');
$ele.remove();

cssString =
	'\n/*** Generated by post-menu ***/\n' +
	'.post-menu {position: absolute; font-size: 12px; line-height: 1.3em;}\n' +
	'.post-menu ul {\n' +
	'    background-color: '+ cssStyle['border-top-color'] +'; border: 1px solid #666;\n' +
	'    list-style: none; padding: 0; margin: 0; white-space: nowrap;\n}\n' +
	'.post-menu .post-submenu{white-space: normal; width: 90px;}' +
	'.post-menu .post-submenu>ul{white-space: nowrap; width: auto;}' +
	'.post-menu li {cursor: pointer; position: relative; padding: 4px 4px; vertical-align: middle;}\n' +
	'.post-menu li:hover {background-color: '+ cssStyle.hoverBg +';}\n' +
	'.post-menu ul ul {display: none; position: absolute;}\n' +
	'.post-menu li:hover>ul {display: block; left: 100%; margin-top: -3px;}\n' +
	'.post-menu-arrow {float: right; margin-left: 10px;}\n' +
	'.post-menu.hidden, .post-menu .hidden {display: none;}\n' +
	'.post-btn {transition: transform 0.1s; width: 15px; text-align: center; font-size: 10pt; opacity: 0.8; text-decoration: none; margin: -6px 0px 0px -5px !important; display: inline-block;}\n' +
	'.post-btn:hover {opacity: 1;}\n' +
	'.post-btn-open {transform: rotate(90deg);}\n';

if (!$('style.generated-css').length) $('<style class="generated-css">').appendTo('head');
$('style.generated-css').html($('style.generated-css').html() + cssString);

/*  Add buttons
 */
$('.reply:not(.hidden), .thread>.op').each(function () {
	addButton(this);
 });

 /*  event handlers
  */
$('form[name=postcontrols]').on('click', '.post-btn', function (e) {
	e.preventDefault();
	var post = e.target.parentElement.parentElement;
	$('.post-menu').remove();

	if ($(e.target).hasClass('post-btn-open')) {
		$('.post-btn-open').removeClass('post-btn-open');
	} else {
		//  close previous button
		$('.post-btn-open').removeClass('post-btn-open');
		$(post).find('.post-btn').addClass('post-btn-open');

		buildMenu(e);
	}
});

$(document).on('click', function (e){
	if ($(e.target).hasClass('post-btn') || $(e.target).hasClass('post-submenu'))
		return;

	$('.post-menu').remove();
	$('.post-btn-open').removeClass('post-btn-open');
});

// on new posts
$(document).on('new_post', function (e, post) {
	addButton(post);
});

$(document).trigger('menu_ready');
});
if (active_page === 'thread' || active_page === 'index' || active_page === 'catalog') {
	$(document).on('menu_ready', function () {
		'use strict';

                function filterBoardCatalog(opData) {
                    var list = getList();
                    var subject, comment;
                    var i, length, array, rule, pattern;  // temp variables
                    var name = false;
                    var tripcode = false;

                    if(opData.data("name"))
                        name = opData.data("name"); 

                    if(opData.data("trip"));
                      tripcode = opData.data("trip");

                    var hasSub = (opData.find(".subject").length > 0);
                    if (hasSub)
                        subject = opData.find(".subject").text();

                    array = opData.find('.body-line').contents().filter(function () {if ($(this).text() !== '') return true;}).toArray();
                    array = $.map(array, function (ele) {
                        return $(ele).text().trim();
                    });
                    comment = array.join(' ');

                    for (i = 0, length = list.generalFilter.length; i < length; i++) {
                        rule = list.generalFilter[i];
                        if (rule.regex) {
                            pattern = new RegExp(rule.value);
                            switch (rule.type) {
                                case 'name':
                                    if (name && pattern.test(name)) {
                                        opData.remove();
                                    }
                                    break;
                                case 'trip':
                                    if (tripcode && pattern.test(tripcode)) {
                                        opData.remove();
                                    }
                                    break;
                                case 'sub':
                                    if (hasSub && pattern.test(subject)) {
                                        opData.remove();
                                    }
                                    break;
                                case 'com':
                                    if (pattern.test(comment)) {
                                        opData.remove();
                                    }
                                    break;
                            }
                        } else {
                            switch (rule.type) {
                                case 'name':
                                    pattern = new RegExp('\\b'+ rule.value+ '\\b');
                                    if (name && pattern.test(name)) {
                                        opData.remove();
                                    }
                                    break;
                                case 'trip':
                                    pattern = new RegExp(rule.value);
                                    if (tripcode && pattern.test(tripcode)) {
                                        opData.remove();
                                    }
                                    break;
                                case 'sub':
                                    pattern = new RegExp('\\b'+ rule.value+ '\\b');
                                    if (hasSub && pattern.test(subject)) {
                                        opData.remove();
                                    }
                                    break;
                                case 'com':
                                    pattern = new RegExp('\\b'+ rule.value+ '\\b');
                                    if (pattern.test(comment)) {
                                        opData.remove();
                                    }
                                    break;
                            }
                        }
                    }

                }

		
		// returns blacklist object from storage
		function getList() {
			return JSON.parse(localStorage.postFilter);
		}

		// stores blacklist into storage and reruns the filter
		function setList(blacklist) {
			localStorage.postFilter = JSON.stringify(blacklist);
			$(document).trigger('filter_page');
		}

		// unit: seconds
		function timestamp() {
			return Math.floor((new Date()).getTime() / 1000);
		}

		function initList(list, boardId, threadId) {
			if (typeof list.postFilter[boardId] == 'undefined') {
				list.postFilter[boardId] = {};
				list.nextPurge[boardId] = {};
			}
			if (typeof list.postFilter[boardId][threadId] == 'undefined') {
				list.postFilter[boardId][threadId] = [];
			}
			list.nextPurge[boardId][threadId] = {timestamp: timestamp(), interval: 86400};  // 86400 seconds == 1 day
		}

		function addFilter(type, value, useRegex) {
			var list = getList();
			var filter = list.generalFilter;
			var obj = {
				type: type,
				value: value,
				regex: useRegex
			};

			for (var i=0; i<filter.length; i++) {
				if (filter[i].type == type && filter[i].value == value && filter[i].regex == useRegex)
					return;
			}

			filter.push(obj);
			setList(list);
			drawFilterList();
		}

		function removeFilter(type, value, useRegex) {
			var list = getList();
			var filter = list.generalFilter;

			for (var i=0; i<filter.length; i++) {
				if (filter[i].type == type && filter[i].value == value && filter[i].regex == useRegex) {
					filter.splice(i, 1);
					break;
				}
			}

			setList(list);
			drawFilterList();
		}

		function nameSpanToString(el) {
			var s = ''; 

			$.each($(el).contents(), function(k,v) {
				if (v.nodeName === 'IMG')
					s=s+$(v).attr('alt')
				
				if (v.nodeName === '#text')
					s=s+v.nodeValue
			});
			return s.trim();
		}

		var blacklist = {
			add: {
				post: function (boardId, threadId, postId, hideReplies) {
					var list = getList();
					var filter = list.postFilter;

					initList(list, boardId, threadId);

					for (var i in filter[boardId][threadId]) {
						if (filter[boardId][threadId][i].post == postId) return;
					}
					filter[boardId][threadId].push({
						post: postId,
						hideReplies: hideReplies
					});
					setList(list);
				},
				uid: function (boardId, threadId, uniqueId, hideReplies) {
					var list = getList();
					var filter = list.postFilter;

					initList(list, boardId, threadId);

					for (var i in filter[boardId][threadId]) {
						if (filter[boardId][threadId][i].uid == uniqueId) return;
					}
					filter[boardId][threadId].push({
						uid: uniqueId,
						hideReplies: hideReplies
					});
					setList(list);
				}
			},
			remove: {
				post: function (boardId, threadId, postId) {
					var list = getList();
					var filter = list.postFilter;

					// thread already pruned
					if (typeof filter[boardId] == 'undefined' || typeof filter[boardId][threadId] == 'undefined')
						return;

					for (var i=0; i<filter[boardId][threadId].length; i++) {
						if (filter[boardId][threadId][i].post == postId) {
							filter[boardId][threadId].splice(i, 1);
							break;
						}
					}

					if ($.isEmptyObject(filter[boardId][threadId])) {
						delete filter[boardId][threadId];
						delete list.nextPurge[boardId][threadId];

						if ($.isEmptyObject(filter[boardId])) {
							delete filter[boardId];
							delete list.nextPurge[boardId];
						}
					}
					setList(list);
				},
				uid: function (boardId, threadId, uniqueId) {
					var list = getList();
					var filter = list.postFilter;

					// thread already pruned
					if (typeof filter[boardId] == 'undefined' || typeof filter[boardId][threadId] == 'undefined')
						return;

					for (var i=0; i<filter[boardId][threadId].length; i++) {
						if (filter[boardId][threadId][i].uid == uniqueId) {
							filter[boardId][threadId].splice(i, 1);
							break;
						}
					}

					if ($.isEmptyObject(filter[boardId][threadId])) {
						delete filter[boardId][threadId];
						delete list.nextPurge[boardId][threadId];

						if ($.isEmptyObject(filter[boardId])) {
							delete filter[boardId];
							delete list.nextPurge[boardId];
						}
					}
					setList(list);
				}
			}
		};

                /* 
                 *  Unhide thread post/s reply in a thread / jun
                 */
                function showallPostThread(boardId,threadId){
                        var list = getList();
                        var filter = list.postFilter;
                        for(var key in filter[boardId]){
                                if(key==threadId){
                                        for(var keypost in filter[boardId][key]){
                                                var postId = filter[boardId][key][keypost].post;
                                                blacklist.remove.post(boardId, threadId, postId);
                                                $("#reply_"+postId).show();
                                        }
                                }
                        }
                }
		/* 
		 *  hide/show the specified thread/post
		 */
		function hide(ele) {
			var $ele = $(ele);

			if ($(ele).data('hidden'))
				return;

			$(ele).data('hidden', true);
			if ($ele.hasClass('op')) {
				$ele.parent().find('.body, .files, .video-container').not($ele.children('.reply').children()).hide();

				// hide thread replies on index view
				if (active_page == 'index') $ele.parent().find('.omitted, .reply:not(.hidden), post_no, .mentioned, br').hide();
			} else {
				// normal posts
				$ele.children('.body, .files, .video-container').hide();
                                //Hide whole post including Name, Date, Post #id = jun (2lb)
				if (localStorage.stub_hide_post === 'false') {
                                	$ele.hide();
                                	$ele.nextUntil(':not(br)').hide();
				}
			}
		}
		function show(ele) {
			var $ele = $(ele);

			$(ele).data('hidden', false);
			if ($ele.hasClass('op')) {
				$ele.parent().find('.body, .files, .video-container').show();
				if (active_page == 'index') $ele.parent().find('.omitted, .reply:not(.hidden), post_no, .mentioned, br').show();
			} else {
				// normal posts
				$ele.children('.body, .files, .video-container').show();
                                //Show whole post including Name, Date, Post #id = jun (2lb)
				if (localStorage.stub_hide_post === 'false') {
	                                $ele.show();
        	                        $ele.nextUntil(':not(br)').show();
				}
			}
		}

		/* 
		 *  create filter menu when the button is clicked
		 */
		function initPostMenu(pageData) {
			var Menu = window.Menu;
			var submenu;
			Menu.add_item('filter-menu-hide', _('Hide post'));
			Menu.add_item('filter-menu-unhide', _('Unhide post'));

			submenu = Menu.add_submenu('filter-menu-add', _('Add filter'));
				submenu.add_item('filter-add-post-plus', _('Post +'), _('Hide post and all replies'));
				submenu.add_item('filter-add-id', _('ID'));
				submenu.add_item('filter-add-id-plus', _('ID +'), _('Hide ID and all replies'));
				submenu.add_item('filter-add-name', _('Name'));
				submenu.add_item('filter-add-trip', _('Tripcode'));

			submenu = Menu.add_submenu('filter-menu-remove', _('Remove filter'));
				submenu.add_item('filter-remove-id', _('ID'));
				submenu.add_item('filter-remove-name', _('Name'));
				submenu.add_item('filter-remove-trip', _('Tripcode'));

			Menu.onclick(function (e, $buffer) {
				var ele = e.target.parentElement.parentElement;
				var $ele = $(ele);

				var threadId = $ele.parent().attr('id').replace('thread_', '');
				var postId = $ele.find('.post_no').not('[id]').text();
				if (pageData.hasUID) {
					var postUid = $ele.find('.poster_id').text();
				}

				var postName;
				var postTrip = '';
				if (!pageData.forcedAnon) {
					postName = (typeof $ele.find('.name').contents()[0] == 'undefined') ? '' : nameSpanToString($ele.find('.name')[0]);
					postTrip = $ele.find('.trip').text();
				}

				/*  display logic and bind click handlers
				 */

				 // unhide button
				if ($ele.data('hidden')) {
					$buffer.find('#filter-menu-unhide').click(function () {
						//  if hidden due to post id, remove it from blacklist
						//  otherwise just show this post
						blacklist.remove.post(pageData.boardId, threadId, postId);
						show(ele);
                                                //Show whole post including Name / Date / Post #id = jun (2lb)
						if (localStorage.stub_hide_post === 'false') {	
	                                                $ele.show();
        	                                        $ele.nextUntil(':not(br)').hide();
						}
					});
					$buffer.find('#filter-menu-hide').addClass('hidden');
				} else {
					$buffer.find('#filter-menu-unhide').addClass('hidden');
					$buffer.find('#filter-menu-hide').click(function () {
						blacklist.add.post(pageData.boardId, threadId, postId, false);
                                                //Remove whole post including Name / Date / Post #id = jun (4lb)
						if (localStorage.stub_hide_post === 'false') {
	                                                if (!$ele.hasClass('op')) {
        	                                                $ele.hide();
                	                                        $ele.nextUntil(':not(br)').hide();
                        	                        }
						}
					});
				}

				//  post id
				if (!$ele.data('hiddenByPost')) {
					$buffer.find('#filter-add-post-plus').click(function () {
						blacklist.add.post(pageData.boardId, threadId, postId, true);
					});
				} else {
					$buffer.find('#filter-add-post-plus').addClass('hidden');
				}

				// UID
				if (pageData.hasUID && !$ele.data('hiddenByUid')) {
					$buffer.find('#filter-add-id').click(function () {
						blacklist.add.uid(pageData.boardId, threadId, postUid, false);
					});
					$buffer.find('#filter-add-id-plus').click(function () {
						blacklist.add.uid(pageData.boardId, threadId, postUid, true);
					});

					$buffer.find('#filter-remove-id').addClass('hidden');
				} else if (pageData.hasUID) {
					$buffer.find('#filter-remove-id').click(function () {
						blacklist.remove.uid(pageData.boardId, threadId, postUid);
					});

					$buffer.find('#filter-add-id').addClass('hidden');
					$buffer.find('#filter-add-id-plus').addClass('hidden');
				} else {
					// board doesn't use UID
					$buffer.find('#filter-add-id').addClass('hidden');
					$buffer.find('#filter-add-id-plus').addClass('hidden');
					$buffer.find('#filter-remove-id').addClass('hidden');
				}

				//  name
				if (!pageData.forcedAnon && !$ele.data('hiddenByName')) {
					$buffer.find('#filter-add-name').click(function () {
						addFilter('name', postName, false);
					});

					$buffer.find('#filter-remove-name').addClass('hidden');
				} else if (!pageData.forcedAnon) {
					$buffer.find('#filter-remove-name').click(function () {
						removeFilter('name', postName, false);
					});

					$buffer.find('#filter-add-name').addClass('hidden');
				} else {
					// board has forced anon
					$buffer.find('#filter-remove-name').addClass('hidden');
					$buffer.find('#filter-add-name').addClass('hidden');
				}

				//  tripcode
				if (!pageData.forcedAnon && !$ele.data('hiddenByTrip') && postTrip !== '') {
					$buffer.find('#filter-add-trip').click(function () {
						addFilter('trip', postTrip, false);
					});

					$buffer.find('#filter-remove-trip').addClass('hidden');
				} else if (!pageData.forcedAnon && postTrip !== '') {
					$buffer.find('#filter-remove-trip').click(function () {
						removeFilter('trip', postTrip, false);
					});

					$buffer.find('#filter-add-trip').addClass('hidden');
				} else {
					// board has forced anon
					$buffer.find('#filter-remove-trip').addClass('hidden');
					$buffer.find('#filter-add-trip').addClass('hidden');
				}

				/*  hide sub menus if all items are hidden
				 */
				if (!$buffer.find('#filter-menu-remove > ul').children().not('.hidden').length) {
					$buffer.find('#filter-menu-remove').addClass('hidden');
				}
				if (!$buffer.find('#filter-menu-add > ul').children().not('.hidden').length) {
					$buffer.find('#filter-menu-add').addClass('hidden');
				}
			});
		}

		/* 
		 *  hide/unhide thread on index view
		 */
		function quickToggle(ele, threadId, pageData) {
			/*if ($(ele).find('.hide-thread-link').length)
				$('.hide-thread-link').remove();*/

			if ($(ele).hasClass('op') && !$(ele).find('.hide-thread-link').length) {
				$('<a class="hide-thread-link" style="float:left;margin-right:5px" href="javascript:void(0)">[' + ($(ele).data('hidden') ? '+' : '&ndash;') + ']</a>')
					.insertBefore($(ele).find(':not(h2,h2 *):first'))
					.click(function() {
						var postId = $(ele).find('.post_no').not('[id]').text();
						var hidden = $(ele).data('hidden');
					
						if (hidden) {
							blacklist.remove.post(pageData.boardId, threadId, postId, false);
							$(this).html('[&ndash;]');
						} else {
							blacklist.add.post(pageData.boardId, threadId, postId, false);
							$(this).text('[+]');
						}
					});
			}
		}

		/*
		 *  determine whether the reply post should be hidden
		 *   - applies to all posts on page load or filtering rule change
		 *   - apply to new posts on thread updates
		 *   - must explicitly set the state of each attributes because filter will reapply to all posts after filtering rule change
		 */
		function filter(post, threadId, pageData) {
			var $post = $(post);
			var list = getList();
			var postId = $post.find('.post_no').not('[id]').text();
			var name, trip, uid, subject, comment;
			var i, length, array, rule, pattern;  // temp variables

			var boardId     = pageData.boardId;
			var localList   = pageData.localList;
			var noReplyList = pageData.noReplyList;
			var hasUID      = pageData.hasUID;
			var forcedAnon  = pageData.forcedAnon;

			var hasTrip = ($post.find('.trip').length > 0);
			var hasSub = ($post.find('.subject').length > 0);

			$post.data('hidden', false);
			$post.data('hiddenByUid', false);
			$post.data('hiddenByPost', false);
			$post.data('hiddenByName', false);
			$post.data('hiddenByTrip', false);
			$post.data('hiddenBySubject', false);
			$post.data('hiddenByComment', false);

			// add post with matched UID to localList
			if (hasUID &&
				typeof list.postFilter[boardId] != 'undefined' &&
				typeof list.postFilter[boardId][threadId] != 'undefined') {
				uid = $post.find('.poster_id').text();
				array = list.postFilter[boardId][threadId];

				for (i=0; i<array.length; i++) {
					if (array[i].uid == uid) {
						$post.data('hiddenByUid', true);
						localList.push(postId);
						if (array[i].hideReplies) noReplyList.push(postId);
						break;
					}
				}
			}

			// match localList
			if (localList.length) {
				if ($.inArray(postId, localList) != -1) {
					if ($post.data('hiddenByUid') !== true) $post.data('hiddenByPost', true);
					hide(post);
				}
			}

			// matches generalFilter
			if (!forcedAnon)
				name = (typeof $post.find('.name').contents()[0] == 'undefined') ? '' : nameSpanToString($post.find('.name')[0]);
			if (!forcedAnon && hasTrip)
				trip = $post.find('.trip').text();
			if (hasSub)
				subject = $post.find('.subject').text();

			array = $post.find('.body').contents().filter(function () {if ($(this).text() !== '') return true;}).toArray();
			array = $.map(array, function (ele) {
				return $(ele).text().trim();
			});
			comment = array.join(' ');


			for (i = 0, length = list.generalFilter.length; i < length; i++) {
				rule = list.generalFilter[i];

				if (rule.regex) {
					pattern = new RegExp(rule.value);
					switch (rule.type) {
						case 'name':
							if (!forcedAnon && pattern.test(name)) {
								$post.data('hiddenByName', true);
								hide(post);
							}
							break;
						case 'trip':
							if (!forcedAnon && hasTrip && pattern.test(trip)) {
								$post.data('hiddenByTrip', true);
								hide(post);
							}
							break;
						case 'sub':
							if (hasSub && pattern.test(subject)) {
								$post.data('hiddenBySubject', true);
								hide(post);
							}
							break;
						case 'com':
							if (pattern.test(comment)) {
								$post.data('hiddenByComment', true);
								hide(post);
							}
							break;
					}
				} else {
					switch (rule.type) {
						case 'name':
							if (!forcedAnon && rule.value == name) {
								$post.data('hiddenByName', true);
								hide(post);
							}
							break;
						case 'trip':
							if (!forcedAnon && hasTrip && rule.value == trip) {
								$post.data('hiddenByTrip', true);
								hide(post);
							}
							break;
						case 'sub':
							pattern = new RegExp('\\b'+ rule.value+ '\\b');
							if (hasSub && pattern.test(subject)) {
								$post.data('hiddenBySubject', true);
								hide(post);
							}
							break;
						case 'com':
							pattern = new RegExp('\\b'+ rule.value+ '\\b');
							if (pattern.test(comment)) {
								$post.data('hiddenByComment', true);
								hide(post);
							}
							break;
					}
				}
			}

			// check for link to filtered posts
			$post.find('.body a').not('[rel="nofollow"]').each(function () {
				var replyId = $(this).text().match(/^>>(\d+)$/);

				if (!replyId)
					return;

				replyId = replyId[1];
				if ($.inArray(replyId, noReplyList) != -1) {
					hide(post);
				}
			});

			// post didn't match any filters
			if (!$post.data('hidden')) {
				show(post);
			}
		}

		/*  (re)runs the filter on the entire page
		 */
		 function filterPage(pageData) {
			var list = getList();

			if (active_page != 'catalog') {

				// empty the local and no-reply list
				pageData.localList = [];
				pageData.noReplyList = [];

				$('.thread').each(function () {
					var $thread = $(this);
					// disregard the hidden threads constructed by post-hover.js
					if ($thread.css('display') == 'none')
						return;

					var threadId = $thread.attr('id').replace('thread_', '');
					var op = $thread.children('.op')[0];
					var i, array;  // temp variables

					// add posts to localList and noReplyList
					if (typeof list.postFilter[pageData.boardId] != 'undefined' && typeof list.postFilter[pageData.boardId][threadId] != 'undefined') {
						array = list.postFilter[pageData.boardId][threadId];
						for (i=0; i<array.length; i++) {
							if ( typeof array[i].post == 'undefined')
								continue;

							pageData.localList.push(array[i].post);
							if (array[i].hideReplies) pageData.noReplyList.push(array[i].post);
						}
					}
					// run filter on OP
					filter(op, threadId, pageData);
					quickToggle(op, threadId, pageData);

					// iterate filter over each post
					if (!$(op).data('hidden') || active_page == 'thread') {
						$thread.find('.reply').not('.hidden').each(function () {
							filter(this, threadId, pageData);
						});
					}

				});
			} else {
				var postFilter = list.postFilter[pageData.boardId];
				var $collection = $('.mix');

				if ($.isEmptyObject(postFilter))
					return;

				// for each thread that has filtering rules
				// check if filter contains thread OP and remove the thread from catalog
				$.each(postFilter, function (key, thread) {
					var threadId = key;
					$.each(thread, function () {
						if (this.post == threadId) {
							$collection.filter('[data-id='+ threadId +']').remove();
						}
					});
				});
			}
		 }

		function initStyle() {
			var $ele, cssStyle, cssString;

			$ele = $('<div>').addClass('post reply').hide().appendTo('body');
			cssStyle = $ele.css(['background-color', 'border-color']);
			cssStyle.hoverBg = $('body').css('background-color');
			$ele.remove();

			cssString = '\n/*** Generated by post-filter ***/\n' +
				'#filter-control input[type=text] {width: 130px;}' +
				'#filter-control input[type=checkbox] {vertical-align: middle;}' +
				'#filter-control #clear {float: right;}\n' +
				'#filter-container {margin-top: 20px; border: 1px solid; height: 270px; overflow: auto;}\n' +
				'#filter-list {width: 100%; border-collapse: collapse;}\n' +
				'#filter-list th {text-align: center; height: 20px; font-size: 14px; border-bottom: 1px solid;}\n' +
				'#filter-list th:nth-child(1) {text-align: center; width: 70px;}\n' +
				'#filter-list th:nth-child(2) {text-align: left;}\n' +
				'#filter-list th:nth-child(3) {text-align: center; width: 58px;}\n' +
				'#filter-list tr:not(#header) {height: 22px;}\n' +
				'#filter-list tr:nth-child(even) {background-color:rgba(255, 255, 255, 0.5);}\n' +
				'#filter-list td:nth-child(1) {text-align: center; width: 70px;}\n' +
				'#filter-list td:nth-child(3) {text-align: center; width: 58px;}\n' +
				'#confirm {text-align: right; margin-bottom: -18px; padding-top: 2px; font-size: 14px; color: #FF0000;}';

			if (!$('style.generated-css').length) $('<style class="generated-css">').appendTo('head');
			$('style.generated-css').html($('style.generated-css').html() + cssString);
		}

		function drawFilterList() {
			var list = getList().generalFilter;
			var $ele = $('#filter-list');
			var $row, i, length, obj, val;

			var typeName = {
				name: 'name',
				trip: 'tripcode',
				sub: 'subject',
				com: 'comment'
			};

			$ele.empty();

			//$ele.append('<tr id="header"><th>'+_('Type')+'</th><th>'+_('Content')+'</th><th>'+_('Remove')+'</th></tr>');
			$ele.append('<tr id="header"><th>'+_('Type')+'</th><th>'+_('Content')+' <small>('+_('filters are case-sensitive')+')</small></th><th>'+_('Remove')+'</th></tr>');
			for (i = 0, length = list.length; i < length; i++) {
				obj = list[i];

				// display formatting
				val = (obj.regex) ? '/'+ obj.value +'/' : obj.value;

				$row = $('<tr>');
				$row.append(
					'<td>'+ typeName[obj.type] +'</td>',
					'<td>'+ val +'</td>',
					$('<td>').append(
						$('<a>').html('X')
							.addClass('del-btn')
							.attr('href', '#')
							.data('type', obj.type)
							.data('val', obj.value)
							.data('useRegex', obj.regex)
					)
				);
				$ele.append($row);
			}
		}

		function initOptionsPanel() {
			if (window.Options && !Options.get_tab('filter')) {
				Options.add_tab('filter', 'list', _('Filters'));
				Options.extend_tab('filter',
					'<div id="filter-control">' +
						'<select>' +
							'<option value="name">'+_('Name')+'</option>' +
							'<option value="trip">'+_('Tripcode')+'</option>' +
							'<option value="sub">'+_('Subject')+'</option>' +
							'<option value="com">'+_('Comment')+'</option>' +
						'</select>' +
						'<input type="text">' +
						'<input type="checkbox">' +
						'regex ' +
						'<button id="set-filter">'+_('Add')+'</button>' +
						'<button id="clear">'+_('Clear all filters')+'</button>' +
						'<div id="confirm" class="hidden">' +
							_('This will clear all filtering rules including hidden posts.')+' <a id="confirm-y" href="#">'+_('yes')+'</a> | <a id="confirm-n" href="#">'+_('no')+'</a>' +
						'</div>' +
					'</div>' +
					'<div id="filter-container"><table id="filter-list"></table></div>'
				);
				drawFilterList();

				// control buttons
				$('#filter-control').on('click', '#set-filter', function () {
					var type = $('#filter-control select option:selected').val();
					var value = $('#filter-control input[type=text]').val();
					var useRegex = $('#filter-control input[type=checkbox]').prop('checked');

					//clear the input form
					$('#filter-control input[type=text]').val('');

					addFilter(type, value, useRegex);
					drawFilterList();
				});
				$('#filter-control').on('click', '#clear', function () {
					$('#filter-control #clear').addClass('hidden');
					$('#filter-control #confirm').removeClass('hidden');
				});
				$('#filter-control').on('click', '#confirm-y', function (e) {
					e.preventDefault();

					$('#filter-control #clear').removeClass('hidden');
					$('#filter-control #confirm').addClass('hidden');
					setList({
						generalFilter: [],
						postFilter: {},
						nextPurge: {},
						lastPurge: timestamp()
					});
					drawFilterList();
				});
				$('#filter-control').on('click', '#confirm-n', function (e) {
					e.preventDefault();

					$('#filter-control #clear').removeClass('hidden');
					$('#filter-control #confirm').addClass('hidden');
				});


				// remove button
				$('#filter-list').on('click', '.del-btn', function (e) {
					e.preventDefault();

					var $ele = $(e.target);
					var type = $ele.data('type');
					var val = $ele.data('val');
					var useRegex = $ele.data('useRegex');

					removeFilter(type, val, useRegex);
				});
			}
		}

		/* 
		 *  clear out pruned threads
		 */
		function purge() {
			var list = getList();
			var board, thread, boardId, threadId;
			var deferred;
			var requestArray = [];

			var successHandler = function (boardId, threadId) {
				return function () {
					// thread still alive, keep it in the list and increase the time between checks.
					var list = getList();
					var thread = list.nextPurge[boardId][threadId];

					thread.timestamp = timestamp();
					thread.interval = Math.floor(thread.interval * 1.5);
					setList(list);
				};
			};
			var errorHandler = function (boardId, threadId) {
				return function (xhr) {
					if (xhr.status == 404) {
						var list = getList();

						delete list.nextPurge[boardId][threadId];
						delete list.postFilter[boardId][threadId];
						if ($.isEmptyObject(list.nextPurge[boardId])) delete list.nextPurge[boardId];
						if ($.isEmptyObject(list.postFilter[boardId])) delete list.postFilter[boardId];
						setList(list);
					}
				};
			};

			if ((timestamp() - list.lastPurge) < 86400)  // less than 1 day
				return;
			
			for (boardId in list.nextPurge) {
				board = list.nextPurge[boardId];
				for (threadId in board) {
					thread = board[threadId];
					if (timestamp() > (thread.timestamp + thread.interval)) {
						// check if thread is pruned
						deferred = $.ajax({
							cache: false,
							url: '/'+ boardId +'/res/'+ threadId +'.json',
							success: successHandler(boardId, threadId),
							error: errorHandler(boardId, threadId)
						});
						requestArray.push(deferred);
					}
				}
			}

			// when all requests complete
			$.when.apply($, requestArray).always(function () {
				var list = getList();
				list.lastPurge = timestamp();
				setList(list);
			});
		}

		function init() {
			if (typeof localStorage.postFilter === 'undefined') {
				localStorage.postFilter = JSON.stringify({
					generalFilter: [],
					postFilter: {},
					nextPurge: {},
					lastPurge: timestamp()
				});
			}

			var pageData = {
				boardId: board_name,  // get the id from the global variable
				localList: [],  // all the blacklisted post IDs or UIDs that apply to the current page
				noReplyList: [],  // any posts that replies to the contents of this list shall be hidden
				hasUID: (document.getElementsByClassName('poster_id').length > 0),
				forcedAnon: ($('th:contains(Name)').length === 0)  // tests by looking for the Name label on the reply form
			};

			initStyle();
			initOptionsPanel();
			initPostMenu(pageData);
			filterPage(pageData);

                        // Show all post link and event click are available in board index and thread page = jun (7lb)
                        $('.op>.intro').append('<a class="showallThread" href="#">['+_('Show All Posts')+']</a>');
                        $('.showallThread').on('click', function(e) {
                                e.preventDefault();
                                var $thread = $(this);
                                var threadId = $thread.parent().parent().attr("id").replace("op_","");
                                showallPostThread(pageData.boardId,threadId);
                        });

			// on new posts
			$(document).on('new_post', function (e, post) {
				var threadId;

				if ($(post).hasClass('reply')) {
					threadId = $(post).parent().attr('id').replace('thread_', '');
				} else {
					threadId = $(post).attr('id').replace('thread_', '');
				}

				filter(post, threadId, pageData);
				quickToggle(post, threadId, pageData);
			});

			$(document).on('filter_page', function () {
				filterPage(pageData);
			});

			if(active_page == "catalog"){
                            /*Get threads on board and filter it*/
                            $(document).on("filterThreads", function() {
                                $(".mix").each(function() {
                                    /*Filter hide threads on overboard page*/
                                    var pageData = {
                                        boardId: board_name,  // get the id from the global variable
                                        localList: [],  // all the blacklisted post IDs or UIDs that apply to the current page
                                        noReplyList: [],  // any posts that replies to the contents of this list shall be hidden
                                        hasUID: (document.getElementsByClassName('poster_id').length > 0),
                                        forcedAnon: ($('th:contains(Name)').length === 0)  // tests by looking for the Name label on the reply form
                                    };

                                    filterBoardCatalog($(this));

                                });
                            });
                            $(document).trigger('filterThreads');
			}

			// shift+click on catalog to hide thread
			if (active_page == 'catalog') {
				$(document).on('click', '.mix', function(e) {
					if (e.shiftKey) {
						var threadId = $(this).data('id').toString();
						var postId = threadId;
						blacklist.add.post(pageData.boardId, threadId, postId, false);
					}
				});

                                $(document).on('click', '#catalog-hide-thread', function(e) {
                                        var threadId = $(this).data('id').toString();
                                        var postId = threadId;
                                        blacklist.add.post(pageData.boardId, threadId, postId, false);
					$(this).parent().parent().parent().remove();
                                });

                                //Show all hide threads
                                $(document).on('click', '#show-all-hide-thread', function(e) {
                                        $("#show-all-hide-thread").html("Processing...");
                                        localStorage.postFilter = JSON.stringify({
                                                generalFilter: [],
                                                postFilter: {},
                                                nextPurge: {},
                                                lastPurge: timestamp()
                                        });


                                        var body = $(this).parents('#Grid');
                                        var url = window.location.href;
                                        $.ajax({
                                                url: url,
                                                context: document.body,
                                                success: function(data) {
                                                        var content = $(data).find('#Grid').html();
                                                        $("#Grid").html(content);

                                                        //Sort catalog by Bump Order, Creation Date, Reply Count, Random and sort by image sizes
                                                        var v_sort_by = $("#sort_by").val();
                                                        var v_images_size = $("#image_size").val();
                                                        $('#Grid').mixItUp('sort', (v_sort_by == "random" ? v_sort_by : "sticky:desc " + v_sort_by))

                                                        //Change image size
                                                        $(".grid-li").removeClass("grid-size-vsmall");
                                                        $(".grid-li").removeClass("grid-size-small");
                                                        $(".grid-li").removeClass("grid-size-medium");
                                                        $(".grid-li").removeClass("grid-size-large");
                                                        $(".grid-li").addClass("grid-size-"+v_images_size);

                                                        initImageHover();

                                                        //remove hidden thread
                                                        removeHiddenThread();

                                                        $(document).trigger('filterThreads');

                                                        $("#show-all-hide-thread").html("Show All");
							filter_hide_images_vt();
                                                }
                                        });
                                });
			}
			// clear out the old threads
			purge();
		}
		init();
	});
	
	if (typeof window.Menu !== "undefined") {
		$(document).trigger('menu_ready');
	}
}
if (active_page === 'catalog') {

    function filter_hide_images_vt(){

      var hide_images = localStorage['hideimages'] ? true : false;

      if(hide_images){
          $(".goto_thread_catalog").removeClass('hidden');

          var hideImage = function() {
              if ($(this).parent().data('expanded') == 'true') {
                $(this).parent().click();
              }
              $(this)
                .attr('data-orig', this.src)
                .attr('src', 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==')
                .addClass('hidden');
          };


          $('img.post-image, .theme-catalog .thread>a>img').each(hideImage);


      }else{
        $(".goto_thread_catalog").addClass('hidden');

        var restoreImage = function() {
          $(this)
            .attr('src', $(this).attr('data-orig'))
            .removeClass('hidden');
        };

        $('img.post-image, .theme-catalog .thread>a>img').each(restoreImage);


      }

    }

}
/*
 * fix-report-delete-submit.js
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/post-menu.js';
 *   $config['additional_javascript'][] = 'js/fix-report-delete-submit.js';
 *
 */

if (active_page == 'thread' || active_page == 'index') {
$(document).on('menu_ready', function(){
var Menu = window.Menu;
	
if ($('#delete-fields #password').length) {
	Menu.add_item("delete_post_menu", _("Delete post"));
	Menu.add_item("delete_file_menu", _("Delete file"));
	Menu.onclick(function(e, $buf) {
		var ele = e.target.parentElement.parentElement;
		var $ele = $(ele);
		var threadId = $ele.parent().attr('id').replace('thread_', '');
		var postId = $ele.find('.post_no').not('[id]').text();

		var pass = $("input[name=password][type=text]").val();

		$buf.find('#delete_post_menu,#delete_file_menu').click(function(e) {
			e.preventDefault();
			$('#delete_'+postId).prop('checked', 'checked');
		
			if ($(this).attr('id') === 'delete_file_menu') {
				$('#delete_file').prop('checked', 'checked');
			} else {
				$('#delete_file').prop('checked', '');
			}

			console.log("deleted");
			console.log("done");
			$("#password").val(pass);
			$('input[name=delete][type=submit]').click();
                        /*var form = $(this).find('form')[0];
                        var formData = new FormData(form);
			var delete_post_url = "https://sys.8kun.top/post.php";
                        $.ajax({
                                type: 'POST',
                                url: delete_post_url,
                                cache: false,
                                data: formData,
                                xhrFields: {withCredentials: true},
                                success: function(json) {
                                        console.log("success delete");
                                        
                                },
                                error: function (xhr) {
                                  console.log(xhr);
                                }
                        });*/


		});
	});
}

Menu.add_item("report_menu", _("Report"));
Menu.add_item("global_report_menu", _("Global report"));
Menu.onclick(function(e, $buf) {
	var ele = e.target.parentElement.parentElement;
	var $ele = $(ele);
	var threadId = $ele.parent().attr('id').replace('thread_', '');
	var postId = $ele.find('.post_no').not('[id]').text();

	$buf.find('#report_menu,#global_report_menu').click(function(e) {
		if ($(this).attr('id') === "global_report_menu") {
			var global = '&global';
		} else {
			var global = '';
		}
		window.open(configRoot+'report.php?board='+board_name+'&post=delete_'+postId+global, "", (global?"width=600, height=575":"width=500, height=275"));
	});
});

$(document).on('new_post', function(){
	$('input.delete').hide();
});
$('input.delete').hide();
$('#post-moderation-fields').hide();
});

if (typeof window.Menu !== "undefined") {
	$(document).trigger('menu_ready');
}
}
/* image-hover.js 
 * This script is copied almost verbatim from https://github.com/Pashe/8kunX/blob/2-0/8kun-x.user.js
 * All I did was remove the sprintf dependency and integrate it into 8kun's Options as opposed to Pashe's.
 * I also changed initHover() to also bind on new_post.
 * Thanks Pashe for using WTFPL.
 */

if (active_page === "catalog" || active_page === "thread" || active_page === "index") {

	function getSetting(key) {
  		return (localStorage[key] == 'true');
	}

	function isOnCatalog() {
		return window.active_page === "catalog";
	}

	function isOnThread() {
  		return window.active_page === "thread";
	}

	function getFileExtension(filename) { //Pashe, WTFPL
	        if (filename.match(/\.([a-z0-9]+)(&loop.*)?$/i) !== null) {
	                return filename.match(/\.([a-z0-9]+)(&loop.*)?$/i)[1];
	        } else if (filename.match(/https?:\/\/(www\.)?youtube.com/)) {
	                return 'Youtube';
	        } else {
	                return "unknown: " + filename;
	        }
	}

	function isImage(fileExtension) { 
	        return ($.inArray(fileExtension, ["jpg", "jpeg", "gif", "png"]) !== -1);
	}

	function isVideo(fileExtension) { 
	        return ($.inArray(fileExtension, ["webm", "mp4"]) !== -1);
	}

	function imageHoverStart(e) { //Pashe, anonish, WTFPL
	        var hoverImage = $("#chx_hoverImage");

	        if (hoverImage.length) {
	                if (getSetting("imageHoverFollowCursor")) {
	                        var scrollTop = $(window).scrollTop();
	                        var imgY = e.pageY;
	                        var imgTop = imgY;
	                        var windowWidth = $(window).width();
	                        var imgWidth = hoverImage.width() + e.pageX;

	                        if (imgY < scrollTop + 15) {
	                                imgTop = scrollTop;
	                        } else if (imgY > scrollTop + $(window).height() - hoverImage.height() - 15) {
	                                imgTop = scrollTop + $(window).height() - hoverImage.height() - 15;
	                        }

	                        if (imgWidth > windowWidth) {
	                                hoverImage.css({
	                                        'left': (e.pageX + (windowWidth - imgWidth)),
	                                        'top' : imgTop,
	                                });
	                        } else {
	                                hoverImage.css({
	                                        'left': e.pageX,
	                                        'top' : imgTop,
	                                });
	                        }

	                        hoverImage.appendTo($("body"));
	                }

	                return;
	        }

	        var $this = $(this);

	        var fullUrl;
	        var static_img_src_hover = false;
	        if($this.attr("src").match("/static|img.youtube.com/")){
	                static_img_src_hover = true;
	        } else if ($this.parent().attr("href").match("/src|file_store/")) {
	                fullUrl = $this.parent().attr("href");
	        } else if (isOnCatalog()) {
	                fullUrl = $this.attr("data-fullimage");
	                if (!isImage(getFileExtension(fullUrl))) {fullUrl = $this.attr("src");}
	        }

	        if(!static_img_src_hover){
	                if (isVideo(getFileExtension(fullUrl))) {return;}

	                hoverImage = $('<img id="chx_hoverImage" src="'+fullUrl+'" />');

	                if (getSetting("imageHoverFollowCursor")) {
	                        if(active_page=="catalog") var page_element = $this.parents('.thread.grid-li').find('.img_dimension');
	                        else var page_element = $this.parents('.file').find('.unimportant');

	                        var size = page_element.text().match(/\b(\d+)x(\d+)\b/),
	                                maxWidth = $(window).width(),
	                                maxHeight = $(window).height();



	                        var scale = Math.min(1, maxWidth / size[1], maxHeight / size[2]);
	                        hoverImage.css({
	                                "position"      : "absolute",
	                                "z-index"       : 101,
	                                "pointer-events": "none",
	                                "width"         : size[1] + "px",
	                                "height"        : size[2] + "px",
	                                "max-width"     : (size[1] * scale) + "px",
	                                "max-height"    : (size[2] * scale) + "px",
	                                'left'          : e.pageX,
	                                'top'           : imgTop,
	                        });
	                } else {
	                        hoverImage.css({
	                                "position"      : "fixed",
	                                "top"           : 0,
	                                "right"         : 0,
	                                "z-index"       : 101,
	                                "pointer-events": "none",
	                                "max-width"     : "100%",
	                                "max-height"    : "100%",
	                        });
	                }
	                hoverImage.appendTo($("body"));
	                if (isOnThread()) {$this.css("cursor", "none");}
	        }
	}


	function imageHoverEnd() { //Pashe, WTFPL
		$("#chx_hoverImage").remove();
	}

	function initImageHover() { //Pashe, influenced by tux, et al, WTFPL
	        if (!getSetting("imageHover") && !getSetting("catalogImageHover")) {return;}

	        var selectors = [];

	        if (getSetting("imageHover")) {selectors.push("img.post-image", "canvas.post-image");}
	        if (getSetting("catalogImageHover") && isOnCatalog()) {
	                selectors.push(".thread-image");
	                $(".theme-catalog div.thread").css("position", "inherit");
	        }

	        function bindEvents(el) {
	                $(el).find(selectors.join(", ")).each(function () {
	                        if ($(this).parent().data("expanded")) {return;}

	                        var $this = $(this);

	                        $this.on("mousemove", imageHoverStart);
	                        $this.on("mouseout",  imageHoverEnd);
	                        $this.on("click",     imageHoverEnd);
	                });
	        }

	        bindEvents(document.body);
	        $(document).on('new_post', function(e, post) {
	                bindEvents(post);
	        });
	}

    function getList() {
        return JSON.parse(localStorage.postFilter);
    }


    function removeHiddenThread(){
            var list = getList();
            var url = window.location.href;
            var dataurl = url.split("/");
            var boardId = dataurl[dataurl.length - 2]
            var postFilter = list.postFilter[boardId];
            var $collection = $('.mix');

            if ($.isEmptyObject(postFilter))
                    return;

            // for each thread that has filtering rules
            // check if filter contains thread OP and remove the thread from catalog
            $.each(postFilter, function (key, thread) {
                    var threadId = key;
                    $.each(thread, function () {
                            if (this.post == threadId) {
                                    $collection.filter('[data-id='+ threadId +']').remove();
                            }
                    });
            });
    }

$(document).on('ready', function(){

if (window.Options && Options.get_tab('general')) {
	Options.extend_tab("general", 
	"<fieldset><legend>Image hover</legend>"
	+ ("<label class='image-hover' id='imageHover'><input type='checkbox' /> "+_('Image hover')+"</label>")
	+ ("<label class='image-hover' id='catalogImageHover'><input type='checkbox' /> "+_('Image hover on catalog')+"</label>")
	+ ("<label class='image-hover' id='imageHoverFollowCursor'><input type='checkbox' /> "+_('Image hover should follow cursor')+"</label>")
	+ "</fieldset>");
}

$('.image-hover').on('change', function(){
	var setting = $(this).attr('id');

	localStorage[setting] = $(this).children('input').is(':checked');
});

if (!localStorage.imageHover || !localStorage.catalogImageHover || !localStorage.imageHoverFollowCursor) {
	localStorage.imageHover = 'false';
	localStorage.catalogImageHover = 'false';
	localStorage.imageHoverFollowCursor = 'false';
}

if (getSetting('imageHover')) $('#imageHover>input').prop('checked', 'checked');
if (getSetting('catalogImageHover')) $('#catalogImageHover>input').prop('checked', 'checked');
if (getSetting('imageHoverFollowCursor')) $('#imageHoverFollowCursor>input').prop('checked', 'checked');

/*function getFileExtension(filename) { //Pashe, WTFPL
	if (filename.match(/\.([a-z0-9]+)(&loop.*)?$/i) !== null) {
		return filename.match(/\.([a-z0-9]+)(&loop.*)?$/i)[1];
	} else if (filename.match(/https?:\/\/(www\.)?youtube.com/)) {
		return 'Youtube';
	} else {
		return "unknown: " + filename;
	}
}

function isImage(fileExtension) { //Pashe, WTFPL
	return ($.inArray(fileExtension, ["jpg", "jpeg", "gif", "png"]) !== -1);
}

function isVideo(fileExtension) { //Pashe, WTFPL
	return ($.inArray(fileExtension, ["webm", "mp4"]) !== -1);
}

function isOnCatalog() {
	return window.active_page === "catalog";
}

function isOnThread() {
	return window.active_page === "thread";
}

function getSetting(key) {
	return (localStorage[key] == 'true');
}

function initImageHover() { //Pashe, influenced by tux, et al, WTFPL
	if (!getSetting("imageHover") && !getSetting("catalogImageHover")) {return;}
	
	var selectors = [];
	
	if (getSetting("imageHover")) {selectors.push("img.post-image", "canvas.post-image");}
	if (getSetting("catalogImageHover") && isOnCatalog()) {
		selectors.push(".thread-image");
		$(".theme-catalog div.thread").css("position", "inherit");
	}
	
	function bindEvents(el) {
		$(el).find(selectors.join(", ")).each(function () {
			if ($(this).parent().data("expanded")) {return;}
			
			var $this = $(this);
			
			$this.on("mousemove", imageHoverStart);
			$this.on("mouseout",  imageHoverEnd);
			$this.on("click",     imageHoverEnd);
		});
	}

	bindEvents(document.body);
	$(document).on('new_post', function(e, post) {
		bindEvents(post);
	});
}

function imageHoverStart(e) { //Pashe, anonish, WTFPL
	var hoverImage = $("#chx_hoverImage");
	
	if (hoverImage.length) {
		if (getSetting("imageHoverFollowCursor")) {
			var scrollTop = $(window).scrollTop();
			var imgY = e.pageY;
			var imgTop = imgY;
			var windowWidth = $(window).width();
			var imgWidth = hoverImage.width() + e.pageX;
			
			if (imgY < scrollTop + 15) {
				imgTop = scrollTop;
			} else if (imgY > scrollTop + $(window).height() - hoverImage.height() - 15) {
				imgTop = scrollTop + $(window).height() - hoverImage.height() - 15;
			}
			
			if (imgWidth > windowWidth) {
				hoverImage.css({
					'left': (e.pageX + (windowWidth - imgWidth)),
					'top' : imgTop,
				});
			} else {
				hoverImage.css({
					'left': e.pageX,
					'top' : imgTop,
				});
			}
			
			hoverImage.appendTo($("body"));
		}
		
		return;
	}
	
	var $this = $(this);
	
	var fullUrl;
	var static_img_src_hover = false;
	if($this.attr("src").match("/static|img.youtube.com/")){
		static_img_src_hover = true;
	} else if ($this.parent().attr("href").match("/src|file_store/")) {
		fullUrl = $this.parent().attr("href");
	} else if (isOnCatalog()) {
		fullUrl = $this.attr("data-fullimage");
		if (!isImage(getFileExtension(fullUrl))) {fullUrl = $this.attr("src");}
	}
	
	if(!static_img_src_hover){
		if (isVideo(getFileExtension(fullUrl))) {return;}
	
		hoverImage = $('<img id="chx_hoverImage" src="'+fullUrl+'" />');

		if (getSetting("imageHoverFollowCursor")) {
			if(active_page=="catalog") var page_element = $this.parents('.thread.grid-li').find('.img_dimension');
			else var page_element = $this.parents('.file').find('.unimportant'); 

			var size = page_element.text().match(/\b(\d+)x(\d+)\b/),
                        	maxWidth = $(window).width(),
                        	maxHeight = $(window).height();



			var scale = Math.min(1, maxWidth / size[1], maxHeight / size[2]);
			hoverImage.css({
				"position"      : "absolute",
				"z-index"       : 101,
				"pointer-events": "none",
				"width"         : size[1] + "px",
				"height"        : size[2] + "px",
				"max-width"     : (size[1] * scale) + "px",
				"max-height"    : (size[2] * scale) + "px",
				'left'          : e.pageX,
				'top'           : imgTop,
			});
		} else {
			hoverImage.css({
				"position"      : "fixed",
				"top"           : 0,
				"right"         : 0,
				"z-index"       : 101,
				"pointer-events": "none",
				"max-width"     : "100%",
				"max-height"    : "100%",
			});
		}
		hoverImage.appendTo($("body"));
		if (isOnThread()) {$this.css("cursor", "none");}
	}
}

function imageHoverEnd() { //Pashe, WTFPL
	$("#chx_hoverImage").remove();
}
*/

/*Auto update catalog list*/
if (active_page === "catalog") {
function initCatalogUpdater(){
        var countdown_interval_catalog;
        var catalog_interval_mindelay = 60000;
        var catalog_interval_delay = catalog_interval_mindelay;
        var catalog_current_time = catalog_interval_delay;

        var decrement_timer_catalog = function() {
                catalog_current_time = catalog_current_time - 1000;
                $('#update_catalog_secs').text(catalog_current_time/1000);

                if (catalog_current_time <= 0) {
                        updateCatalogContent()
                        catalog_current_time = catalog_interval_delay + 1000;
                }
        }

        var catalog_auto_update = function(delay) {
                clearInterval(countdown_interval_catalog);

                catalog_current_time = delay;
                countdown_interval_catalog = setInterval(decrement_timer_catalog, 1000);
                $('#update_catalog_secs').text(catalog_current_time/1000);
        }

        var catalog_stop_auto_update = function() {
                clearInterval(countdown_interval_catalog);
        }

        // Add an update catalog link
	if(!inMod){
        	$('span.catalog_search').after("&nbsp;<span id='updater_catalog_panel'><a href='#' style='text-decoration:none; cursor:pointer;' id='update_catalog'>[Update]</a><label id='auto_update_catalog_status'><input type='checkbox' id='auto_update_catalog_cb'></label> "+_("Auto")+" (<span id='update_catalog_secs'></span>)</span>");
	}

        // Set the updater checkbox according to user setting
        if (localStorage.auto_catalog_update === 'true') {
                $('#auto_update_catalog_cb').prop('checked', true);
                catalog_auto_update(catalog_interval_mindelay);
        }

        $('#auto_update_catalog_status>input').on('click', function() {
                if ($('#auto_update_catalog_status>input').is(':checked')) {
                        localStorage.auto_catalog_update = 'true';
                        catalog_auto_update(catalog_interval_mindelay);
                } else {
                        localStorage.auto_catalog_update = 'false';
                        catalog_stop_auto_update();
                        $('#update_catalog_secs').text("");
                }
        });

        $('#update_catalog').on('click', function() {
                updateCatalogContent();

                if($("#auto_update_catalog_cb").is(':checked')){
                        catalog_auto_update(catalog_interval_mindelay);
                }

        });


        /*function getList() {
                return JSON.parse(localStorage.postFilter);
        }

        function removeHiddenThread(){
                var list = getList();
                var url = window.location.href;
                var dataurl = url.split("/");
                var boardId = dataurl[dataurl.length - 2]
                var postFilter = list.postFilter[boardId];
                var $collection = $('.mix');

                if ($.isEmptyObject(postFilter))
                        return;

                // for each thread that has filtering rules
                // check if filter contains thread OP and remove the thread from catalog
                $.each(postFilter, function (key, thread) {
                        var threadId = key;
                        $.each(thread, function () {
                                if (this.post == threadId) {
                                        $collection.filter('[data-id='+ threadId +']').remove();
                                }
                        });
                });
        }*/

        function updateCatalogContent(){
                if(active_page == "catalog"){
                        var body = $(this).parents('#Grid');
                        var url = window.location.href;
                        $('#update_catalog_secs').text("Updating...");
                        $.ajax({
                                url: url,
                                context: document.body,
                                success: function(data) {
                                        var content = $(data).find('#Grid').html();
                                        //Update catalog content
                                        $("#Grid").html(content);
                                        //Sort catalog by Bump Order, Creation Date, Reply Count, Random and sort by image sizes
                                        var v_sort_by = $("#sort_by").val();
                                        var v_images_size = $("#image_size").val();
                                        $('#Grid').mixItUp('sort', (v_sort_by == "random" ? v_sort_by : "sticky:desc " + v_sort_by))

                                        //Change image size
                                        $(".grid-li").removeClass("grid-size-vsmall");
                                        $(".grid-li").removeClass("grid-size-small");
                                        $(".grid-li").removeClass("grid-size-medium");
                                        $(".grid-li").removeClass("grid-size-large");
                                        $(".grid-li").addClass("grid-size-"+v_images_size);

                                        initImageHover();
					$('#update_catalog_secs').text("");

					//remove hidden thread
					removeHiddenThread();
					
					//Filter threads on catalog
					$(document).trigger('filterThreads');

					filter_hide_images_vt();
                                }
                        });
                }
        }

}//end initCatalogUpdater()
initCatalogUpdater();
}

initImageHover();
});
}

$('document').ready(function () {
	var autoScroll = localStorage['autoScroll'] ? true : false;
	if (window.Options && Options.get_tab('general')){
		$('#auto-update-fs').append('<label id=\'autoScroll\'><input type=\'checkbox\' />' + _('Scroll to new posts') + '</label>');
		$('#autoScroll').find('input').prop('checked', autoScroll);
	}
	$('#autoScroll').on('change', function() {
		if(autoScroll) {
			delete localStorage.autoScroll;
		} else {
			localStorage.autoScroll = true;
		}
		autoScroll =! autoScroll
		if(active_page == 'thread')
			$('input.auto-scroll').prop('checked', autoScroll);
	});
	if (active_page == 'thread') {
		$('span[id="updater"]').children('a').after(' (<input class="auto-scroll" type="checkbox"></input> '+_('Scroll to new posts')+')');
		$('input.auto-scroll').prop('checked', autoScroll);
		$(document).on('new_post', function (e, post) {
			if ($('input.auto-scroll').prop('checked')) 
			{
				scrollTo(0, $(post).offset().top - window.innerHeight + $(post).outerHeight(true)); 
			}
		});
	}
});
/*
 * file-selector.js - Add support for drag and drop file selection, and paste from clipbboard on supported browsers.
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/file-selector.js';
 */
function init_file_selector(max_images) {

$(document).ready(function () {
	// add options panel item
	if (window.Options && Options.get_tab('general')) {
		Options.extend_tab('general', '<label id="file-drag-drop"><input type="checkbox">' + _('Drag and drop file selection') + '</label>');

		$('#file-drag-drop>input').on('click', function() {
			if ($('#file-drag-drop>input').is(':checked')) {
				localStorage.file_dragdrop = 'true';
			} else {
				localStorage.file_dragdrop = 'false';
			}
		});

		if (typeof localStorage.file_dragdrop === 'undefined') localStorage.file_dragdrop = 'true';
		if (localStorage.file_dragdrop === 'true') $('#file-drag-drop>input').prop('checked', true);
	}
});

// disabled by user, or incompatible browser.
if (localStorage.file_dragdrop == 'false' || !(window.URL.createObjectURL && window.File))
	return;

// multipost not enabled
if (typeof max_images == 'undefined') {
	var max_images = 1;
}

var files = [];
if ( $( "#upload_file" ).length ) {
    $( "#upload_file" ).remove();
}
//$('#upload_file').hide();  // hide the original file selector
$('.dropzone-wrap').css('user-select', 'none').show();  // let jquery add browser specific prefix

function addFile(file) {
	if (files.length == max_images)
		return;

	files.push(file);
	addThumb(file);
}

function removeFile(file) {
	files.splice(files.indexOf(file), 1);
}

function getThumbElement(file) {
	return $('.tmb-container').filter(function(){return($(this).data('file-ref')==file);});
}

function addThumb(file) {

	var fileName = (file.name.length < 24) ? file.name : file.name.substr(0, 22) + '…';
	var fileType = file.type.split('/')[0];
	var fileExt = file.type.split('/')[1];
	var $container = $('<div>')
		.addClass('tmb-container')
		.data('file-ref', file)
		.append(
			$('<div>').addClass('remove-btn').html('✖'),
			$('<div>').addClass('file-tmb'),
			$('<div>').addClass('tmb-filename').html(fileName)
		)
		.appendTo('.file-thumbs');

	var $fileThumb = $container.find('.file-tmb');
	if (fileType == 'image') {
		// if image file, generate thumbnail
		var objURL = window.URL.createObjectURL(file);
		$fileThumb.css('background-image', 'url('+ objURL +')');
	} else {
		$fileThumb.html('<span>' + fileExt.toUpperCase() + '</span>');
	}
}

$(document).on('ajax_before_post', function (e, formData) {
	for (var i=0; i<max_images; i++) {
		var key = 'file';
		if (i > 0) key += i + 1;
		formData.append(key, files[i]);
	}
});

// clear file queue and UI on success
$(document).on('ajax_after_post', function () {
	files = [];
	$('.file-thumbs').empty();

	/*Clear all fields / local storage from form input after posting a thread / comment*/
	if(localStorage.auto_clear_post_fields === 'true'){
		$('form[name="post"]').trigger('reset');
		localStorage.email = "";
		localStorage.name = "";
		sessionStorage.body = "";
	}
});

var dragCounter = 0;
var dropHandlers = {
	dragenter: function (e) {
		e.stopPropagation();
		e.preventDefault();

		if (dragCounter === 0) $(this).addClass('dragover');
		dragCounter++;
	},
	dragover: function (e) {
		// needed for webkit to work
		e.stopPropagation();
		e.preventDefault();
	},
	dragleave: function (e) {
		e.stopPropagation();
		e.preventDefault();

		dragCounter--;
		if (dragCounter === 0) $(this).removeClass('dragover');
	},
	drop: function (e) {
		e.stopPropagation();
		e.preventDefault();

		$(this).removeClass('dragover');
		dragCounter = 0;

		var fileList = e.originalEvent.dataTransfer.files;
		for (var i=0; i<fileList.length; i++) {
			addFile(fileList[i]);
		}
	}
};


// attach handlers
$(document).on(dropHandlers, '.dropzone');

$(document).on('click', '.dropzone .remove-btn', function (e) {
	e.stopPropagation();

	var file = $(e.target).parent().data('file-ref');

	getThumbElement(file).remove();
	removeFile(file);
});

$(document).on('keypress click', '.dropzone', function (e) {
	e.stopPropagation();

	// accept mouse click or Enter
	if ((e.which != 1 || e.target.className != 'file-hint') &&
		 e.which != 13)
		return;

	var $fileSelector = $('<input type="file" multiple>');

	$fileSelector.on('change', function (e) {
		if (this.files.length > 0) {
			for (var i=0; i<this.files.length; i++) {
				addFile(this.files[i]);
			}
		}
		$(this).remove();
	});

	$fileSelector.click();
});

$(document).on('paste', function (e) {
	var clipboard = e.originalEvent.clipboardData;
	if (typeof clipboard.items != 'undefined' && clipboard.items.length != 0) {
		
		//Webkit
		for (var i=0; i<clipboard.items.length; i++) {
			if (clipboard.items[i].kind != 'file')
				continue;

			//convert blob to file
			var file = new File([clipboard.items[i].getAsFile()], 'ClipboardImage.png', {type: 'image/png'});
			addFile(file);
		}
	}
});

}
if (active_page == 'index' || active_page == 'thread')
$(function(){

  var gallery_view = false;

  $('hr:first').before('<div id="gallery-view" style="text-align:right"><a class="unimportant" href="javascript:void(0)">-</a></div>');
  $('#gallery-view a').html(gallery_view ? _("Disable gallery mode") : _("Enable gallery mode")).click(function() {
    gallery_view = !gallery_view;
    $(this).html(gallery_view ? _("Disable gallery mode") : _("Enable gallery mode"));
    toggle_gview(document);
  });

  var toggle_gview = function(elem) {
    if (gallery_view) {
      $(elem).find('img.post-image').parent().each(function() { 
        this.oldonclick = this.onclick;
        this.onclick = handle_click;
        $(this).attr('data-galid', Math.random());
      });
    }
    else {
      $(elem).find('img.post-image').parent().each(function() {
        if (this.onclick == handle_click) this.onclick = this.oldonclick;
      });
    }
  };

  $(document).on('new_post', toggle_gview);

  var gallery_opened = false;

  var handle_click = function(e) {
    e.stopPropagation();
    e.preventDefault();

    if (!gallery_opened) open_gallery();

    gallery_setimage($(this).attr('data-galid'));
  };

  var handler, images, active, toolbar;

  var open_gallery = function() {
    $('body').css('overflow', 'hidden');

    gallery_opened = true;

    handler = $("<div id='alert_handler'></div>").hide().appendTo('body').css('text-align', 'left');

    $("<div id='alert_background'></div>").click(close_gallery).appendTo(handler);

    images = $("<div id='gallery_images'></div>").appendTo(handler);
    toolbar = $("<div id='gallery_toolbar'></div>").appendTo(handler);
    active = $("<div id='gallery_main'></div>").appendTo(handler);

    active.on('click', function() {
      close_gallery();
    });

    $('img.post-image').parent().each(function() {
      var thumb = $(this).find('img').attr('src');

      var i = $('<img>').appendTo(images);
      i.attr('src', thumb);
      i.attr('data-galid-th', $(this).attr('data-galid'));

      i.on('click', function(e) {
        gallery_setimage($(this).attr('data-galid-th'));
      });
    });

    $("<a href='javascript:void(0)'><i class='fa fa-times'></i></div>")
    .click(close_gallery).appendTo(toolbar);

    $('body').on('keydown.gview', function(e) {
      if (e.which == 39 || e.which == 40) { // right or down arrow
        gallery_setimage(+1);
        e.preventDefault();
      }
      else if (e.which == 37 || e.which == 38) { // left or up arrow
        gallery_setimage(-1);
        e.preventDefault();
      }
    });

    handler.fadeIn(400);
  };

  var gallery_setimage = function(a) {
    if (a == +1 || a == -1) {
      var meth = (a == -1) ? 'prev' : 'next';
      a = $('#gallery_images img.active')[meth]().attr('data-galid-th');
      if (!a) return;
    }

    $('#gallery_images img.active').removeClass('active');

    var thumb = $('#gallery_images [data-galid-th="'+a+'"]');
    var elem = $('a[data-galid="'+a+'"]');

    thumb.addClass('active');

    var topscroll = thumb.position().top + images.scrollTop();
    topscroll -= images.height() / 2;
    topscroll += thumb.height() / 2;
    images.animate({'scrollTop': topscroll}, 300);

    var img = elem.attr('href');

    active.find('img, video').fadeOut(200, function() { $(this).remove(); });

    var i;
    if (img.match(/player\.php/)) {
      img = img.replace(/.*player\.php\?v=|&t=.*/g, '');
    }
    if (img.match(/\.webm$|\.mp4$|\.ogv$/i)) { // We are handling video nao
      i = $('<video>');
      i.attr('src', img);
      i.attr('autoplay', true);
      i.attr('controls', true);
      i.appendTo(active);
      i.hide();
    }
    else { // Just a plain image
      i = $('<img>');
      i.attr('src', img);
      i.appendTo(active);
      i.hide();
    }

    // Let's actually preload the next few images
    var nextimg = $('#gallery_images active');
    for (var j = 0; j < 3; j++) { 
      nextimg = nextimg.next();
      var attr;
      if (attr = nextimg.attr('data-gaild-th')) {
        var href = $('a[data-galid="'+attr+'"]').attr('href');
        if (href.match(/\.webm|\.mp4|\.ogv/i)) { j--; continue; }
        if ($('[data-galid-preload="'+attr+'"]').length) continue;
        var img = $('<img>').attr('src', href).attr('data-galid-preload', attr).hide().appendTo('body').on('load', function() { $(this).remove(); });
      }
      else break;
    }

    i.one('load canplay', function() {
      i.css('left', 'calc(50% - '+i.width()+'px / 2)');
      i.css('top', 'calc(50% - '+i.height()+'px / 2)');
      i.fadeIn(200);
    }).on('click', function(e) {
      e.stopPropagation();
      gallery_setimage(+1);
    });
  };

  var close_gallery = function() {
    $('body').css('overflow', 'auto');

    gallery_opened = false;

    $('body').off('keydown.gview');

    handler.fadeOut(400, function() { handler.remove(); });
  };

});
// ============================================================
// Purpose                      : Board directory handling
// Contributors                 : 8n-tech
// ============================================================

;( function( window, $, undefined ) {
	var boardlist = {
		options : {
			$boardlist : false,
			
			// Selectors for finding and binding elements.
			selector   : {
				'boardlist'     : "#boardlist",
				
				'board-head'    : ".board-list-head",
				'board-body'    : ".board-list-tbody",
				'board-loading' : ".board-list-loading",
				'board-omitted' : ".board-list-omitted",
				
				'search'        : "#search-form",
				'search-lang'   : "#search-lang-input",
				'search-sfw'    : "#search-sfw-input",
				'search-tag'    : "#search-tag-input",
				'search-title'  : "#search-title-input",
				'search-submit' : "#search-submit",
				
				'tag-list'      : ".tag-list",
				'tag-link'      : ".tag-link",
				
				'footer-page'   : ".board-page-num",
				'footer-count'  : ".board-page-count",
				'footer-total'  : ".board-page-total",
				'footer-more'   : "#board-list-more"
			},
			
			// HTML Templates for dynamic construction
			template   : {
				// Board row item
				'board-row'          : "<tr></tr>",
				
				// Individual cell definitions
				'board-cell-meta'    : "<td class=\"board-meta\"></td>",
				'board-cell-uri'     : "<td class=\"board-uri\"></td>",
				'board-cell-title'   : "<td class=\"board-title\"></td>",
				'board-cell-pph'     : "<td class=\"board-pph\"></td>",
				'board-cell-posts_total' : "<td class=\"board-max\"></td>",
				'board-cell-active'  : "<td class=\"board-unique\"></td>",
				'board-cell-tags'    : "<td class=\"board-tags\"></td>",
				
				// Content wrapper
				// Used to help constrain contents to their <td>.
				'board-content-wrap' : "<p class=\"board-cell\"></p>",
				
				// Individual items or parts of a single table cell.
				'board-datum-lang'   : "<span class=\"board-lang\"></span>",
				'board-datum-uri'    : "<a class=\"board-link\"></a>",
				'board-datum-sfw'    : "<i class=\"fa fa-briefcase board-sfw\" title=\"SFW\"></i>",
				'board-datum-nsfw'   : "<i class=\"fa fa-briefcase board-nsfw\" title=\"NSFW\"></i>",
				'board-datum-tags'   : "<a class=\"tag-link\" href=\"#\"></a>",
				'board-datum-pph'    : "<p class=\"board-cell board-pph-desc\" title=\"%1 made in the last hour, %2 on average\"></p>",
				
				
				// Tag list.
				'tag-list'           : "<ul class=\"tag-list\"></ul>",
				'tag-item'           : "<li class=\"tag-item\"></li>",
				'tag-link'           : "<a class=\"tag-link\" href=\"#\"></a>"
			}
		},
		
		lastSearch : {},
		
		bind : {
			form : function() {
				var selectors = boardlist.options.selector;
				
				var $search       = $( selectors['search'] ),
				    $searchLang   = $( selectors['search-lang'] ),
				    $searchSfw    = $( selectors['search-sfw'] ),
				    $searchTag    = $( selectors['search-tag'] ),
				    $searchTitle  = $( selectors['search-title'] ),
				    $searchSubmit = $( selectors['search-submit'] );
				
				var searchForms   = {
						'boardlist'    : boardlist.$boardlist,
						'search'       : $search,
						'searchLang'   : $searchLang,
						'searchSfw'    : $searchSfw,
						'searchTag'    : $searchTag,
						'searchTitle'  : $searchTitle,
						'searchSubmit' : $searchSubmit
					};
				
				if ($search.length > 0) {
					// Bind form events.
					boardlist.$boardlist
						// Load more
						.on( 'click', selectors['board-omitted'], searchForms, boardlist.events.loadMore )
						// Tag click
						.on( 'click', selectors['tag-link'], searchForms, boardlist.events.tagClick )
						// Form Submission
						.on( 'submit', selectors['search'], searchForms, boardlist.events.searchSubmit )
						// Submit click
						.on( 'click', selectors['search-submit'], searchForms, boardlist.events.searchSubmit );
					
					$(window)
						.on( 'hashchange', searchForms, boardlist.events.hashChange );
					
					$searchSubmit.prop( 'disabled', false );
				}
			}
		},
		
		build  : {
			boardlist : function(data) {
				boardlist.build.boards(data['boards'], data['order']);
				boardlist.build.lastSearch(data['search']);
				boardlist.build.footer(data);
				boardlist.build.tags(data['tagWeight']);
				
			},
			
			boards : function(boards, order) {
				// Find our head, columns, and body.
				var $head = $( boardlist.options.selector['board-head'], boardlist.$boardlist ),
				    $cols = $("[data-column]", $head ),
				    $body = $( boardlist.options.selector['board-body'], boardlist.$boardlist );
				
				$.each( order, function( index, uri ) {
					var row  = boards[uri];
					    $row = $( boardlist.options.template['board-row'] );
					
					$cols.each( function( index, col ) {
						boardlist.build.board( row, col ).appendTo( $row );
					} );
					
					$row.appendTo( $body );
				} );
				
			},
			board : function(row, col) {
				var $col   = $(col),
				    column = $col.attr('data-column'),
				    value  = row[column]
				    $cell  = $( boardlist.options.template['board-cell-' + column] ),
				    $wrap  = $( boardlist.options.template['board-content-wrap'] );
				
				if (typeof boardlist.build.boardcell[column] === "undefined") {
					if (value instanceof Array) {
						if (typeof boardlist.options.template['board-datum-' + column] !== "undefined") {
							$.each( value, function( index, singleValue ) {
								$( boardlist.options.template['board-datum-' + column] )
									.text( singleValue )
									.appendTo( $wrap );
							} );
						}
						else {
							$wrap.text( value.join(" ") );
						}
					}
					else {
						$wrap.text( value );
					}
				}
				else {
					var $content = boardlist.build.boardcell[column]( row, value );
					
					if ($content instanceof jQuery) {
						if ($content.is("." + $wrap[0].class)) {
							// Our new content has the same classes as the wrapper.
							// Replace the old wrapper.
							$wrap = $content;
						}
						else {
							// We use .append() instead of .appendTo() as we do elsewhere
							// because $content can be multiple elements.
							$wrap.append( $content );
						}
					}
					else if (typeof $content === "string") {
						$wrap.html( $content );
					}
					else {
						console.log("Special cell constructor returned a " + (typeof $content) + " that board-directory.js cannot interpret.");
					}
				}
				
				$wrap.appendTo( $cell );
				return $cell;
			},
			boardcell : {
				'meta' : function(row, value) {
					return $( boardlist.options.template['board-datum-lang'] ).text( row['locale'] );
				},
				'uri'  : function(row, value) {
					var $link = $( boardlist.options.template['board-datum-uri'] ),
						$sfw  = $( boardlist.options.template['board-datum-' + (row['sfw'] == 1 ? "sfw" : "nsfw")] );
					
					$link
						.attr( 'href', "/"+row['uri']+"/" )
						.text( "/"+row['uri']+"/" );
					
					// I decided against NSFW icons because it clutters the index.
					// Blue briefcase = SFW. No briefcase = NSFW. Seems better.
					if (row['sfw'] == 1) {
						return $link[0].outerHTML + $sfw[0].outerHTML;
					}
					else {
						return $link[0].outerHTML;
					}
				},
				'pph' : function(row, value) {
					return $( boardlist.options.template['board-datum-pph'] )
						.attr( 'title', function(index, value) {
							return value.replace("%1", row['pph']).replace("%2", row['pph_average']);
						} )
						.text( row['pph'] );
				},
			},
			
			lastSearch : function(search) {
				return boardlist.lastSearch =  { 
					'lang'  : search.lang === false ? "" : search.lang,
					'page'  : search.page,
					'tags'  : search.tags === false ? "" : search.tags.join(" "),
					'time'  : search.time,
					'title' : search.title === false ? "" : search.title,
					'sfw'   : search.nsfw ? 0 : 1
				};
			},
			
			footer : function(data) {
				var selector = boardlist.options.selector,
				    $page    = $( selector['footer-page'], boardlist.$boardlist ),
				    $count   = $( selector['footer-count'], boardlist.$boardlist ),
				    $total   = $( selector['footer-total'], boardlist.$boardlist ),
				    $more    = $( selector['footer-more'], boardlist.$boardlist ),
				    $omitted = $( selector['board-omitted'], boardlist.$boardlist );
				
				var boards   = Object.keys(data['boards']).length,
				    omitted  = data['omitted'] - data['search']['page'];
				
				if (omitted < 0) {
					omitted = 0;
				}
				
				var total    = boards + omitted + data['search']['page'];
				
				//$page.text( data['search']['page'] );
				$count.text( data['search']['page'] + boards );
				$total.text( total );
				$more.toggleClass( "board-list-hasmore", omitted != 0 );
				$omitted.toggle( boards + omitted > 0 );
			},
			
			tags : function(tags) {
				var selector = boardlist.options.selector,
				    template = boardlist.options.template,
				    $list    = $( selector['tag-list'], boardlist.$boardlist );
				
				if ($list.length) {
					
					$.each( tags, function(tag, weight) {
						var $item = $( template['tag-item'] ),
						    $link = $( template['tag-link'] );
						
						$link
							.css( 'font-size', weight+"%" )
							.text( tag )
							.appendTo( $item );
						
						$item.appendTo( $list );
					} );
				}
			}
		},
		
		events : {
			loadMore : function(event) {
				var parameters = $.extend( {}, boardlist.lastSearch );
				
				parameters.page = $( boardlist.options.selector['board-body'], boardlist.$boardlist ).children().length;
				
				boardlist.submit( parameters );
			},
			
			hashChange : function(event) {
				if (window.location.hash != "") {
					// Turns "#porn,tits" into "porn tits" for easier search results.
					var tags = window.location.hash.substr(1, window.location.hash.length).split(","),
					    hash = tags.join(" ");
				}
				else {
					var tags = [],
					    hash = ""
				}
				
				$( boardlist.options.selector['search-tag'], boardlist.$boardlist ).val( hash );
				$( boardlist.options.selector['tag-list'], boardlist.$boardlist ).html("");
				$( boardlist.options.selector['board-body'], boardlist.$boardlist ).html("");
				
				boardlist.submit( { 'tags' : tags } );
				
				return true;
			},
			
			searchSubmit : function(event) {
				event.preventDefault();
				
				$( boardlist.options.selector['tag-list'], boardlist.$boardlist ).html("");
				$( boardlist.options.selector['board-body'], boardlist.$boardlist ).html("");
				
				boardlist.submit( { 
					'lang'  : event.data.searchLang.val(),
					'tags'  : event.data.searchTag.val(),
					'title' : event.data.searchTitle.val(),
					'sfw'   : event.data.searchSfw.prop('checked') ? 1 : 0
				} );
				
				return false;
			},
			
			tagClick : function(event) {
				event.preventDefault();
				
				var $this  = $(this),
					$input = $( boardlist.options.selector['search-tag'] );
				
				$input
					.val( ( $input.val() + " " + $this.text() ).replace(/\s+/g, " ").trim() )
					.trigger( 'change' )
					.focus();
				
				return false;
			}
		},
		
		submit : function( parameters ) {
			var $boardlist    = boardlist.$boardlist,
			    $boardload    = $( boardlist.options.selector['board-loading'], $boardlist ),
			    $searchSubmit = $( boardlist.options.selector['search-submit'], $boardlist ),
			    $footerMore   = $( boardlist.options.selector['board-omitted'], $boardlist );
			
			$searchSubmit.prop( 'disabled', true );
			$boardload.show();
			$footerMore.hide();
			
			return $.get(
				"https://8kun.top/board-search.php",
				parameters,
				function(data) {
					$searchSubmit.prop( 'disabled', false );
					$boardload.hide();

					boardlist.build.boardlist( $.parseJSON(data) );
				}
			);
		},
		
		init : function( target ) {
			if (typeof target !== "string") {
				target = boardlist.options.selector.boardlist;
			}
			
			// Parse ?GET parameters into lastSearch object.
			if (window.location.search != "" && window.location.search.length > 0) {
				// ?a=1&b=2 -> a=1&b=2 -> { a : 1, b : 2 }
				window.location.search.substr(1).split("&").forEach( function(item) {
					boardlist.lastSearch[item.split("=")[0]] = item.split("=")[1];
				} );
			}
			
			var $boardlist = $(target);
			
			if ($boardlist.length > 0 ) {
				$( boardlist.options.selector['board-loading'], $boardlist ).hide();
				
				boardlist.$boardlist = $boardlist;
				boardlist.bind.form();
				
				if (window.location.hash != "") {
					$(window).trigger( 'hashchange' );
				}
			}
		}
	};
	
	// Tie to the vichan object.
	if (typeof window.vichan === "undefined") {
		window.vichan = {};
	}
	window.vichan.boardlist = boardlist;
	
	// Initialize the boardlist when the document is ready.
	$( document ).on( 'ready', window.vichan.boardlist.init );
	// Run it now if we're already ready.
	if  (document.readyState === 'complete') {
		window.vichan.boardlist.init();
	}
} )( window, jQuery );
$(document).ready(function(){
  
        //*Auto update Velocious and Tempestous
        if (!localStorage.disclaimer_toggle) localStorage.disclaimer_toggle = false;
        Options.extend_tab('general', '<label id="disclaimer_toggle"><input type="checkbox">' + _("  Hide post disclaimer") + '</label>');

        if (localStorage.disclaimer_toggle === 'true') {
                $('#disclaimer_toggle>input').prop('checked', true);
                messageDisclaimer(true);
        } else {
                $('#disclaimer_toggle>input').prop('checked', false);
                messageDisclaimer(false);
        }
        $('#disclaimer_toggle>input').on('click', function() {
                if ($('#disclaimer_toggle>input').is(':checked')) {
                        localStorage.disclaimer_toggle = 'true';
                        messageDisclaimer(true);
                } else {
                        localStorage.disclaimer_toggle = 'false';
                        messageDisclaimer(false);
                }
        });

});

function messageDisclaimer(m){
        if(m===true){
                $(".disclaimer-8kun").hide();
        }else{
                $(".disclaimer-8kun").show();
        }

}
$(document).on('new_post', function(e, post) {

	if (localStorage.disclaimer_toggle === 'true') {
		$(".disclaimer-8kun").remove();
	}
});
/* html2canvas 0.5.0-beta3 <http://html2canvas.hertzen.com> Copyright (c) 2016 Niklas von Hertzen Released under  License */

!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var n;"undefined"!=typeof window?n=window:"undefined"!=typeof global?n=global:"undefined"!=typeof self&&(n=self),n.html2canvas=e()}}(function(){var e;return function n(e,f,o){function d(t,l){if(!f[t]){if(!e[t]){var s="function"==typeof require&&require;if(!l&&s)return s(t,!0);if(i)return i(t,!0);var u=new Error("Cannot find module '"+t+"'");throw u.code="MODULE_NOT_FOUND",u}var a=f[t]={exports:{}};e[t][0].call(a.exports,function(n){var f=e[t][1][n];return d(f?f:n)},a,a.exports,n,e,f,o)}return f[t].exports}for(var i="function"==typeof require&&require,t=0;t<o.length;t++)d(o[t]);return d}({1:[function(n,f,o){(function(n){!function(d){function i(e){throw RangeError(I[e])}function t(e,n){for(var f=e.length;f--;)e[f]=n(e[f]);return e}function l(e,n){return t(e.split(H),n).join(".")}function s(e){for(var n,f,o=[],d=0,i=e.length;i>d;)n=e.charCodeAt(d++),n>=55296&&56319>=n&&i>d?(f=e.charCodeAt(d++),56320==(64512&f)?o.push(((1023&n)<<10)+(1023&f)+65536):(o.push(n),d--)):o.push(n);return o}function u(e){return t(e,function(e){var n="";return e>65535&&(e-=65536,n+=L(e>>>10&1023|55296),e=56320|1023&e),n+=L(e)}).join("")}function a(e){return 10>e-48?e-22:26>e-65?e-65:26>e-97?e-97:k}function p(e,n){return e+22+75*(26>e)-((0!=n)<<5)}function c(e,n,f){var o=0;for(e=f?K(e/B):e>>1,e+=K(e/n);e>J*z>>1;o+=k)e=K(e/J);return K(o+(J+1)*e/(e+A))}function y(e){var n,f,o,d,t,l,s,p,y,m,r=[],v=e.length,w=0,b=D,g=C;for(f=e.lastIndexOf(E),0>f&&(f=0),o=0;f>o;++o)e.charCodeAt(o)>=128&&i("not-basic"),r.push(e.charCodeAt(o));for(d=f>0?f+1:0;v>d;){for(t=w,l=1,s=k;d>=v&&i("invalid-input"),p=a(e.charCodeAt(d++)),(p>=k||p>K((j-w)/l))&&i("overflow"),w+=p*l,y=g>=s?q:s>=g+z?z:s-g,!(y>p);s+=k)m=k-y,l>K(j/m)&&i("overflow"),l*=m;n=r.length+1,g=c(w-t,n,0==t),K(w/n)>j-b&&i("overflow"),b+=K(w/n),w%=n,r.splice(w++,0,b)}return u(r)}function m(e){var n,f,o,d,t,l,u,a,y,m,r,v,w,b,g,h=[];for(e=s(e),v=e.length,n=D,f=0,t=C,l=0;v>l;++l)r=e[l],128>r&&h.push(L(r));for(o=d=h.length,d&&h.push(E);v>o;){for(u=j,l=0;v>l;++l)r=e[l],r>=n&&u>r&&(u=r);for(w=o+1,u-n>K((j-f)/w)&&i("overflow"),f+=(u-n)*w,n=u,l=0;v>l;++l)if(r=e[l],n>r&&++f>j&&i("overflow"),r==n){for(a=f,y=k;m=t>=y?q:y>=t+z?z:y-t,!(m>a);y+=k)g=a-m,b=k-m,h.push(L(p(m+g%b,0))),a=K(g/b);h.push(L(p(a,0))),t=c(f,w,o==d),f=0,++o}++f,++n}return h.join("")}function r(e){return l(e,function(e){return F.test(e)?y(e.slice(4).toLowerCase()):e})}function v(e){return l(e,function(e){return G.test(e)?"xn--"+m(e):e})}var w="object"==typeof o&&o,b="object"==typeof f&&f&&f.exports==w&&f,g="object"==typeof n&&n;(g.global===g||g.window===g)&&(d=g);var h,x,j=2147483647,k=36,q=1,z=26,A=38,B=700,C=72,D=128,E="-",F=/^xn--/,G=/[^ -~]/,H=/\x2E|\u3002|\uFF0E|\uFF61/g,I={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},J=k-q,K=Math.floor,L=String.fromCharCode;if(h={version:"1.2.4",ucs2:{decode:s,encode:u},decode:y,encode:m,toASCII:v,toUnicode:r},"function"==typeof e&&"object"==typeof e.amd&&e.amd)e("punycode",function(){return h});else if(w&&!w.nodeType)if(b)b.exports=h;else for(x in h)h.hasOwnProperty(x)&&(w[x]=h[x]);else d.punycode=h}(this)}).call(this,"undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}],2:[function(e,n){function f(e,n,f){!e.defaultView||n===e.defaultView.pageXOffset&&f===e.defaultView.pageYOffset||e.defaultView.scrollTo(n,f)}function o(e,n){try{n&&(n.width=e.width,n.height=e.height,n.getContext("2d").putImageData(e.getContext("2d").getImageData(0,0,e.width,e.height),0,0))}catch(f){t("Unable to copy canvas content from",e,f)}}function d(e,n){for(var f=3===e.nodeType?document.createTextNode(e.nodeValue):e.cloneNode(!1),i=e.firstChild;i;)(n===!0||1!==i.nodeType||"SCRIPT"!==i.nodeName)&&f.appendChild(d(i,n)),i=i.nextSibling;return 1===e.nodeType&&(f._scrollTop=e.scrollTop,f._scrollLeft=e.scrollLeft,"CANVAS"===e.nodeName?o(e,f):("TEXTAREA"===e.nodeName||"SELECT"===e.nodeName)&&(f.value=e.value)),f}function i(e){if(1===e.nodeType){e.scrollTop=e._scrollTop,e.scrollLeft=e._scrollLeft;for(var n=e.firstChild;n;)i(n),n=n.nextSibling}}var t=e("./log");n.exports=function(e,n,o,t,l,s,u){var a=d(e.documentElement,l.javascriptEnabled),p=n.createElement("iframe");return p.className="html2canvas-container",p.style.visibility="hidden",p.style.position="fixed",p.style.left="-10000px",p.style.top="0px",p.style.border="0",p.width=o,p.height=t,p.scrolling="no",n.body.appendChild(p),new Promise(function(n){var o=p.contentWindow.document;p.contentWindow.onload=p.onload=function(){var e=setInterval(function(){o.body.childNodes.length>0&&(i(o.documentElement),clearInterval(e),"view"===l.type&&(p.contentWindow.scrollTo(s,u),!/(iPad|iPhone|iPod)/g.test(navigator.userAgent)||p.contentWindow.scrollY===u&&p.contentWindow.scrollX===s||(o.documentElement.style.top=-u+"px",o.documentElement.style.left=-s+"px",o.documentElement.style.position="absolute")),n(p))},50)},o.open(),o.write("<!DOCTYPE html><html></html>"),f(e,s,u),o.replaceChild(o.adoptNode(a),o.documentElement),o.close()})}},{"./log":13}],3:[function(e,n){function f(e){this.r=0,this.g=0,this.b=0,this.a=null;this.fromArray(e)||this.namedColor(e)||this.rgb(e)||this.rgba(e)||this.hex6(e)||this.hex3(e)}f.prototype.darken=function(e){var n=1-e;return new f([Math.round(this.r*n),Math.round(this.g*n),Math.round(this.b*n),this.a])},f.prototype.isTransparent=function(){return 0===this.a},f.prototype.isBlack=function(){return 0===this.r&&0===this.g&&0===this.b},f.prototype.fromArray=function(e){return Array.isArray(e)&&(this.r=Math.min(e[0],255),this.g=Math.min(e[1],255),this.b=Math.min(e[2],255),e.length>3&&(this.a=e[3])),Array.isArray(e)};var o=/^#([a-f0-9]{3})$/i;f.prototype.hex3=function(e){var n=null;return null!==(n=e.match(o))&&(this.r=parseInt(n[1][0]+n[1][0],16),this.g=parseInt(n[1][1]+n[1][1],16),this.b=parseInt(n[1][2]+n[1][2],16)),null!==n};var d=/^#([a-f0-9]{6})$/i;f.prototype.hex6=function(e){var n=null;return null!==(n=e.match(d))&&(this.r=parseInt(n[1].substring(0,2),16),this.g=parseInt(n[1].substring(2,4),16),this.b=parseInt(n[1].substring(4,6),16)),null!==n};var i=/^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/;f.prototype.rgb=function(e){var n=null;return null!==(n=e.match(i))&&(this.r=Number(n[1]),this.g=Number(n[2]),this.b=Number(n[3])),null!==n};var t=/^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d?\.?\d+)\s*\)$/;f.prototype.rgba=function(e){var n=null;return null!==(n=e.match(t))&&(this.r=Number(n[1]),this.g=Number(n[2]),this.b=Number(n[3]),this.a=Number(n[4])),null!==n},f.prototype.toString=function(){return null!==this.a&&1!==this.a?"rgba("+[this.r,this.g,this.b,this.a].join(",")+")":"rgb("+[this.r,this.g,this.b].join(",")+")"},f.prototype.namedColor=function(e){e=e.toLowerCase();var n=l[e];if(n)this.r=n[0],this.g=n[1],this.b=n[2];else if("transparent"===e)return this.r=this.g=this.b=this.a=0,!0;return!!n},f.prototype.isColor=!0;var l={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]};n.exports=f},{}],4:[function(n,f){function o(e,n){var f=j++;if(n=n||{},n.logging&&(v.options.logging=!0,v.options.start=Date.now()),n.async="undefined"==typeof n.async?!0:n.async,n.allowTaint="undefined"==typeof n.allowTaint?!1:n.allowTaint,n.removeContainer="undefined"==typeof n.removeContainer?!0:n.removeContainer,n.javascriptEnabled="undefined"==typeof n.javascriptEnabled?!1:n.javascriptEnabled,n.imageTimeout="undefined"==typeof n.imageTimeout?1e4:n.imageTimeout,n.renderer="function"==typeof n.renderer?n.renderer:c,n.strict=!!n.strict,"string"==typeof e){if("string"!=typeof n.proxy)return Promise.reject("Proxy must be used when rendering url");var o=null!=n.width?n.width:window.innerWidth,t=null!=n.height?n.height:window.innerHeight;return g(a(e),n.proxy,document,o,t,n).then(function(e){return i(e.contentWindow.document.documentElement,e,n,o,t)})}var l=(void 0===e?[document.documentElement]:e.length?e:[e])[0];return l.setAttribute(x+f,f),d(l.ownerDocument,n,l.ownerDocument.defaultView.innerWidth,l.ownerDocument.defaultView.innerHeight,f).then(function(e){return"function"==typeof n.onrendered&&(v("options.onrendered is deprecated, html2canvas returns a Promise containing the canvas"),n.onrendered(e)),e})}function d(e,n,f,o,d){return b(e,e,f,o,n,e.defaultView.pageXOffset,e.defaultView.pageYOffset).then(function(t){v("Document cloned");var l=x+d,s="["+l+"='"+d+"']";e.querySelector(s).removeAttribute(l);var u=t.contentWindow,a=u.document.querySelector(s),p=Promise.resolve("function"==typeof n.onclone?n.onclone(u.document):!0);return p.then(function(){return i(a,t,n,f,o)})})}function i(e,n,f,o,d){var i=n.contentWindow,a=new p(i.document),c=new y(f,a),r=h(e),w="view"===f.type?o:s(i.document),b="view"===f.type?d:u(i.document),g=new f.renderer(w,b,c,f,document),x=new m(e,g,a,c,f);return x.ready.then(function(){v("Finished rendering");var o;return o="view"===f.type?l(g.canvas,{width:g.canvas.width,height:g.canvas.height,top:0,left:0,x:0,y:0}):e===i.document.body||e===i.document.documentElement||null!=f.canvas?g.canvas:l(g.canvas,{width:null!=f.width?f.width:r.width,height:null!=f.height?f.height:r.height,top:r.top,left:r.left,x:0,y:0}),t(n,f),o})}function t(e,n){n.removeContainer&&(e.parentNode.removeChild(e),v("Cleaned up container"))}function l(e,n){var f=document.createElement("canvas"),o=Math.min(e.width-1,Math.max(0,n.left)),d=Math.min(e.width,Math.max(1,n.left+n.width)),i=Math.min(e.height-1,Math.max(0,n.top)),t=Math.min(e.height,Math.max(1,n.top+n.height));f.width=n.width,f.height=n.height;var l=d-o,s=t-i;return v("Cropping canvas at:","left:",n.left,"top:",n.top,"width:",l,"height:",s),v("Resulting crop with width",n.width,"and height",n.height,"with x",o,"and y",i),f.getContext("2d").drawImage(e,o,i,l,s,n.x,n.y,l,s),f}function s(e){return Math.max(Math.max(e.body.scrollWidth,e.documentElement.scrollWidth),Math.max(e.body.offsetWidth,e.documentElement.offsetWidth),Math.max(e.body.clientWidth,e.documentElement.clientWidth))}function u(e){return Math.max(Math.max(e.body.scrollHeight,e.documentElement.scrollHeight),Math.max(e.body.offsetHeight,e.documentElement.offsetHeight),Math.max(e.body.clientHeight,e.documentElement.clientHeight))}function a(e){var n=document.createElement("a");return n.href=e,n.href=n.href,n}var p=n("./support"),c=n("./renderers/canvas"),y=n("./imageloader"),m=n("./nodeparser"),r=n("./nodecontainer"),v=n("./log"),w=n("./utils"),b=n("./clone"),g=n("./proxy").loadUrlDocument,h=w.getBounds,x="data-html2canvas-node",j=0;o.CanvasRenderer=c,o.NodeContainer=r,o.log=v,o.utils=w;var k="undefined"==typeof document||"function"!=typeof Object.create||"function"!=typeof document.createElement("canvas").getContext?function(){return Promise.reject("No canvas support")}:o;f.exports=k,"function"==typeof e&&e.amd&&e("html2canvas",[],function(){return k})},{"./clone":2,"./imageloader":11,"./log":13,"./nodecontainer":14,"./nodeparser":15,"./proxy":16,"./renderers/canvas":20,"./support":22,"./utils":26}],5:[function(e,n){function f(e){if(this.src=e,o("DummyImageContainer for",e),!this.promise||!this.image){o("Initiating DummyImageContainer"),f.prototype.image=new Image;var n=this.image;f.prototype.promise=new Promise(function(e,f){n.onload=e,n.onerror=f,n.src=d(),n.complete===!0&&e(n)})}}var o=e("./log"),d=e("./utils").smallImage;n.exports=f},{"./log":13,"./utils":26}],6:[function(e,n){function f(e,n){var f,d,i=document.createElement("div"),t=document.createElement("img"),l=document.createElement("span"),s="Hidden Text";i.style.visibility="hidden",i.style.fontFamily=e,i.style.fontSize=n,i.style.margin=0,i.style.padding=0,document.body.appendChild(i),t.src=o(),t.width=1,t.height=1,t.style.margin=0,t.style.padding=0,t.style.verticalAlign="baseline",l.style.fontFamily=e,l.style.fontSize=n,l.style.margin=0,l.style.padding=0,l.appendChild(document.createTextNode(s)),i.appendChild(l),i.appendChild(t),f=t.offsetTop-l.offsetTop+1,i.removeChild(l),i.appendChild(document.createTextNode(s)),i.style.lineHeight="normal",t.style.verticalAlign="super",d=t.offsetTop-i.offsetTop+1,document.body.removeChild(i),this.baseline=f,this.lineWidth=1,this.middle=d}var o=e("./utils").smallImage;n.exports=f},{"./utils":26}],7:[function(e,n){function f(){this.data={}}var o=e("./font");f.prototype.getMetrics=function(e,n){return void 0===this.data[e+"-"+n]&&(this.data[e+"-"+n]=new o(e,n)),this.data[e+"-"+n]},n.exports=f},{"./font":6}],8:[function(e,n){function f(n,f,o){this.image=null,this.src=n;var i=this,t=d(n);this.promise=(f?new Promise(function(e){"about:blank"===n.contentWindow.document.URL||null==n.contentWindow.document.documentElement?n.contentWindow.onload=n.onload=function(){e(n)}:e(n)}):this.proxyLoad(o.proxy,t,o)).then(function(n){var f=e("./core");return f(n.contentWindow.document.documentElement,{type:"view",width:n.width,height:n.height,proxy:o.proxy,javascriptEnabled:o.javascriptEnabled,removeContainer:o.removeContainer,allowTaint:o.allowTaint,imageTimeout:o.imageTimeout/2})}).then(function(e){return i.image=e})}var o=e("./utils"),d=o.getBounds,i=e("./proxy").loadUrlDocument;f.prototype.proxyLoad=function(e,n,f){var o=this.src;return i(o.src,e,o.ownerDocument,n.width,n.height,f)},n.exports=f},{"./core":4,"./proxy":16,"./utils":26}],9:[function(e,n){function f(e){this.src=e.value,this.colorStops=[],this.type=null,this.x0=.5,this.y0=.5,this.x1=.5,this.y1=.5,this.promise=Promise.resolve(!0)}f.TYPES={LINEAR:1,RADIAL:2},f.REGEXP_COLORSTOP=/^\s*(rgba?\(\s*\d{1,3},\s*\d{1,3},\s*\d{1,3}(?:,\s*[0-9\.]+)?\s*\)|[a-z]{3,20}|#[a-f0-9]{3,6})(?:\s+(\d{1,3}(?:\.\d+)?)(%|px)?)?(?:\s|$)/i,n.exports=f},{}],10:[function(e,n){function f(e,n){this.src=e,this.image=new Image;var f=this;this.tainted=null,this.promise=new Promise(function(o,d){f.image.onload=o,f.image.onerror=d,n&&(f.image.crossOrigin="anonymous"),f.image.src=e,f.image.complete===!0&&o(f.image)})}n.exports=f},{}],11:[function(e,n){function f(e,n){this.link=null,this.options=e,this.support=n,this.origin=this.getOrigin(window.location.href)}var o=e("./log"),d=e("./imagecontainer"),i=e("./dummyimagecontainer"),t=e("./proxyimagecontainer"),l=e("./framecontainer"),s=e("./svgcontainer"),u=e("./svgnodecontainer"),a=e("./lineargradientcontainer"),p=e("./webkitgradientcontainer"),c=e("./utils").bind;f.prototype.findImages=function(e){var n=[];return e.reduce(function(e,n){switch(n.node.nodeName){case"IMG":return e.concat([{args:[n.node.src],method:"url"}]);case"svg":case"IFRAME":return e.concat([{args:[n.node],method:n.node.nodeName}])}return e},[]).forEach(this.addImage(n,this.loadImage),this),n},f.prototype.findBackgroundImage=function(e,n){return n.parseBackgroundImages().filter(this.hasImageBackground).forEach(this.addImage(e,this.loadImage),this),e},f.prototype.addImage=function(e,n){return function(f){f.args.forEach(function(d){this.imageExists(e,d)||(e.splice(0,0,n.call(this,f)),o("Added image #"+e.length,"string"==typeof d?d.substring(0,100):d))},this)}},f.prototype.hasImageBackground=function(e){return"none"!==e.method},f.prototype.loadImage=function(e){if("url"===e.method){var n=e.args[0];return!this.isSVG(n)||this.support.svg||this.options.allowTaint?n.match(/data:image\/.*;base64,/i)?new d(n.replace(/url\(['"]{0,}|['"]{0,}\)$/gi,""),!1):this.isSameOrigin(n)||this.options.allowTaint===!0||this.isSVG(n)?new d(n,!1):this.support.cors&&!this.options.allowTaint&&this.options.useCORS?new d(n,!0):this.options.proxy?new t(n,this.options.proxy):new i(n):new s(n)}return"linear-gradient"===e.method?new a(e):"gradient"===e.method?new p(e):"svg"===e.method?new u(e.args[0],this.support.svg):"IFRAME"===e.method?new l(e.args[0],this.isSameOrigin(e.args[0].src),this.options):new i(e)},f.prototype.isSVG=function(e){return"svg"===e.substring(e.length-3).toLowerCase()||s.prototype.isInline(e)},f.prototype.imageExists=function(e,n){return e.some(function(e){return e.src===n})},f.prototype.isSameOrigin=function(e){return this.getOrigin(e)===this.origin},f.prototype.getOrigin=function(e){var n=this.link||(this.link=document.createElement("a"));return n.href=e,n.href=n.href,n.protocol+n.hostname+n.port},f.prototype.getPromise=function(e){return this.timeout(e,this.options.imageTimeout)["catch"](function(){var n=new i(e.src);return n.promise.then(function(n){e.image=n})})},f.prototype.get=function(e){var n=null;return this.images.some(function(f){return(n=f).src===e})?n:null},f.prototype.fetch=function(e){return this.images=e.reduce(c(this.findBackgroundImage,this),this.findImages(e)),this.images.forEach(function(e,n){e.promise.then(function(){o("Succesfully loaded image #"+(n+1),e)},function(f){o("Failed loading image #"+(n+1),e,f)})}),this.ready=Promise.all(this.images.map(this.getPromise,this)),o("Finished searching images"),this},f.prototype.timeout=function(e,n){var f,d=Promise.race([e.promise,new Promise(function(d,i){f=setTimeout(function(){o("Timed out loading image",e),i(e)},n)})]).then(function(e){return clearTimeout(f),e});return d["catch"](function(){clearTimeout(f)}),d},n.exports=f},{"./dummyimagecontainer":5,"./framecontainer":8,"./imagecontainer":10,"./lineargradientcontainer":12,"./log":13,"./proxyimagecontainer":17,"./svgcontainer":23,"./svgnodecontainer":24,"./utils":26,"./webkitgradientcontainer":27}],12:[function(e,n){function f(e){o.apply(this,arguments),this.type=o.TYPES.LINEAR;var n=f.REGEXP_DIRECTION.test(e.args[0])||!o.REGEXP_COLORSTOP.test(e.args[0]);n?e.args[0].split(/\s+/).reverse().forEach(function(e,n){switch(e){case"left":this.x0=0,this.x1=1;break;case"top":this.y0=0,this.y1=1;break;case"right":this.x0=1,this.x1=0;break;case"bottom":this.y0=1,this.y1=0;break;case"to":var f=this.y0,o=this.x0;this.y0=this.y1,this.x0=this.x1,this.x1=o,this.y1=f;break;case"center":break;default:var d=.01*parseFloat(e,10);if(isNaN(d))break;0===n?(this.y0=d,this.y1=1-this.y0):(this.x0=d,this.x1=1-this.x0)}},this):(this.y0=0,this.y1=1),this.colorStops=e.args.slice(n?1:0).map(function(e){var n=e.match(o.REGEXP_COLORSTOP),f=+n[2],i=0===f?"%":n[3];return{color:new d(n[1]),stop:"%"===i?f/100:null}}),null===this.colorStops[0].stop&&(this.colorStops[0].stop=0),null===this.colorStops[this.colorStops.length-1].stop&&(this.colorStops[this.colorStops.length-1].stop=1),this.colorStops.forEach(function(e,n){null===e.stop&&this.colorStops.slice(n).some(function(f,o){return null!==f.stop?(e.stop=(f.stop-this.colorStops[n-1].stop)/(o+1)+this.colorStops[n-1].stop,!0):!1},this)},this)}var o=e("./gradientcontainer"),d=e("./color");f.prototype=Object.create(o.prototype),f.REGEXP_DIRECTION=/^\s*(?:to|left|right|top|bottom|center|\d{1,3}(?:\.\d+)?%?)(?:\s|$)/i,n.exports=f},{"./color":3,"./gradientcontainer":9}],13:[function(e,n){var f=function(){f.options.logging&&window.console&&window.console.log&&Function.prototype.bind.call(window.console.log,window.console).apply(window.console,[Date.now()-f.options.start+"ms","html2canvas:"].concat([].slice.call(arguments,0)))};f.options={logging:!1},n.exports=f},{}],14:[function(e,n){function f(e,n){this.node=e,this.parent=n,this.stack=null,this.bounds=null,this.borders=null,this.clip=[],this.backgroundClip=[],this.offsetBounds=null,this.visible=null,this.computedStyles=null,this.colors={},this.styles={},this.backgroundImages=null,this.transformData=null,this.transformMatrix=null,this.isPseudoElement=!1,this.opacity=null}function o(e){var n=e.options[e.selectedIndex||0];return n?n.text||"":""}function d(e){if(e&&"matrix"===e[1])return e[2].split(",").map(function(e){return parseFloat(e.trim())});if(e&&"matrix3d"===e[1]){var n=e[2].split(",").map(function(e){return parseFloat(e.trim())});return[n[0],n[1],n[4],n[5],n[12],n[13]]}}function i(e){return-1!==e.toString().indexOf("%")}function t(e){return e.replace("px","")}function l(e){return parseFloat(e)}var s=e("./color"),u=e("./utils"),a=u.getBounds,p=u.parseBackgrounds,c=u.offsetBounds;f.prototype.cloneTo=function(e){e.visible=this.visible,e.borders=this.borders,e.bounds=this.bounds,e.clip=this.clip,e.backgroundClip=this.backgroundClip,e.computedStyles=this.computedStyles,e.styles=this.styles,e.backgroundImages=this.backgroundImages,e.opacity=this.opacity},f.prototype.getOpacity=function(){return null===this.opacity?this.opacity=this.cssFloat("opacity"):this.opacity},f.prototype.assignStack=function(e){this.stack=e,e.children.push(this)},f.prototype.isElementVisible=function(){return this.node.nodeType===Node.TEXT_NODE?this.parent.visible:"none"!==this.css("display")&&"hidden"!==this.css("visibility")&&!this.node.hasAttribute("data-html2canvas-ignore")&&("INPUT"!==this.node.nodeName||"hidden"!==this.node.getAttribute("type"))},f.prototype.css=function(e){return this.computedStyles||(this.computedStyles=this.isPseudoElement?this.parent.computedStyle(this.before?":before":":after"):this.computedStyle(null)),this.styles[e]||(this.styles[e]=this.computedStyles[e])},f.prototype.prefixedCss=function(e){var n=["webkit","moz","ms","o"],f=this.css(e);return void 0===f&&n.some(function(n){return f=this.css(n+e.substr(0,1).toUpperCase()+e.substr(1)),void 0!==f},this),void 0===f?null:f},f.prototype.computedStyle=function(e){return this.node.ownerDocument.defaultView.getComputedStyle(this.node,e)},f.prototype.cssInt=function(e){var n=parseInt(this.css(e),10);return isNaN(n)?0:n},f.prototype.color=function(e){return this.colors[e]||(this.colors[e]=new s(this.css(e)))},f.prototype.cssFloat=function(e){var n=parseFloat(this.css(e));return isNaN(n)?0:n},f.prototype.fontWeight=function(){var e=this.css("fontWeight");switch(parseInt(e,10)){case 401:e="bold";break;case 400:e="normal"}return e},f.prototype.parseClip=function(){var e=this.css("clip").match(this.CLIP);return e?{top:parseInt(e[1],10),right:parseInt(e[2],10),bottom:parseInt(e[3],10),left:parseInt(e[4],10)}:null},f.prototype.parseBackgroundImages=function(){return this.backgroundImages||(this.backgroundImages=p(this.css("backgroundImage")))},f.prototype.cssList=function(e,n){var f=(this.css(e)||"").split(",");return f=f[n||0]||f[0]||"auto",f=f.trim().split(" "),1===f.length&&(f=[f[0],i(f[0])?"auto":f[0]]),f},f.prototype.parseBackgroundSize=function(e,n,f){var o,d,t=this.cssList("backgroundSize",f);if(i(t[0]))o=e.width*parseFloat(t[0])/100;else{if(/contain|cover/.test(t[0])){var l=e.width/e.height,s=n.width/n.height;return s>l^"contain"===t[0]?{width:e.height*s,height:e.height}:{width:e.width,height:e.width/s}}o=parseInt(t[0],10)}return d="auto"===t[0]&&"auto"===t[1]?n.height:"auto"===t[1]?o/n.width*n.height:i(t[1])?e.height*parseFloat(t[1])/100:parseInt(t[1],10),"auto"===t[0]&&(o=d/n.height*n.width),{width:o,height:d}},f.prototype.parseBackgroundPosition=function(e,n,f,o){var d,t,l=this.cssList("backgroundPosition",f);return d=i(l[0])?(e.width-(o||n).width)*(parseFloat(l[0])/100):parseInt(l[0],10),t="auto"===l[1]?d/n.width*n.height:i(l[1])?(e.height-(o||n).height)*parseFloat(l[1])/100:parseInt(l[1],10),"auto"===l[0]&&(d=t/n.height*n.width),{left:d,top:t}},f.prototype.parseBackgroundRepeat=function(e){return this.cssList("backgroundRepeat",e)[0]},f.prototype.parseTextShadows=function(){var e=this.css("textShadow"),n=[];if(e&&"none"!==e)for(var f=e.match(this.TEXT_SHADOW_PROPERTY),o=0;f&&o<f.length;o++){var d=f[o].match(this.TEXT_SHADOW_VALUES);n.push({color:new s(d[0]),offsetX:d[1]?parseFloat(d[1].replace("px","")):0,offsetY:d[2]?parseFloat(d[2].replace("px","")):0,blur:d[3]?d[3].replace("px",""):0})}return n},f.prototype.parseTransform=function(){if(!this.transformData)if(this.hasTransform()){var e=this.parseBounds(),n=this.prefixedCss("transformOrigin").split(" ").map(t).map(l);n[0]+=e.left,n[1]+=e.top,this.transformData={origin:n,matrix:this.parseTransformMatrix()}}else this.transformData={origin:[0,0],matrix:[1,0,0,1,0,0]};return this.transformData},f.prototype.parseTransformMatrix=function(){if(!this.transformMatrix){var e=this.prefixedCss("transform"),n=e?d(e.match(this.MATRIX_PROPERTY)):null;this.transformMatrix=n?n:[1,0,0,1,0,0]}return this.transformMatrix},f.prototype.parseBounds=function(){return this.bounds||(this.bounds=this.hasTransform()?c(this.node):a(this.node))},f.prototype.hasTransform=function(){return"1,0,0,1,0,0"!==this.parseTransformMatrix().join(",")||this.parent&&this.parent.hasTransform()},f.prototype.getValue=function(){var e=this.node.value||"";return"SELECT"===this.node.tagName?e=o(this.node):"password"===this.node.type&&(e=Array(e.length+1).join("Ã¢â‚¬Â¢")),0===e.length?this.node.placeholder||"":e},f.prototype.MATRIX_PROPERTY=/(matrix|matrix3d)\((.+)\)/,f.prototype.TEXT_SHADOW_PROPERTY=/((rgba|rgb)\([^\)]+\)(\s-?\d+px){0,})/g,f.prototype.TEXT_SHADOW_VALUES=/(-?\d+px)|(#.+)|(rgb\(.+\))|(rgba\(.+\))/g,f.prototype.CLIP=/^rect\((\d+)px,? (\d+)px,? (\d+)px,? (\d+)px\)$/,n.exports=f},{"./color":3,"./utils":26}],15:[function(e,n){function f(e,n,f,o,d){N("Starting NodeParser"),this.renderer=n,this.options=d,this.range=null,this.support=f,this.renderQueue=[],this.stack=new U(!0,1,e.ownerDocument,null);var i=new P(e,null);if(d.background&&n.rectangle(0,0,n.width,n.height,new T(d.background)),e===e.ownerDocument.documentElement){var t=new P(i.color("backgroundColor").isTransparent()?e.ownerDocument.body:e.ownerDocument.documentElement,null);n.rectangle(0,0,n.width,n.height,t.color("backgroundColor"))}i.visibile=i.isElementVisible(),this.createPseudoHideStyles(e.ownerDocument),this.disableAnimations(e.ownerDocument),this.nodes=I([i].concat(this.getChildren(i)).filter(function(e){return e.visible=e.isElementVisible()}).map(this.getPseudoElements,this)),this.fontMetrics=new S,N("Fetched nodes, total:",this.nodes.length),N("Calculate overflow clips"),this.calculateOverflowClips(),N("Start fetching images"),this.images=o.fetch(this.nodes.filter(A)),this.ready=this.images.ready.then(W(function(){return N("Images loaded, starting parsing"),N("Creating stacking contexts"),this.createStackingContexts(),N("Sorting stacking contexts"),this.sortStackingContexts(this.stack),this.parse(this.stack),N("Render queue created with "+this.renderQueue.length+" items"),new Promise(W(function(e){d.async?"function"==typeof d.async?d.async.call(this,this.renderQueue,e):this.renderQueue.length>0?(this.renderIndex=0,this.asyncRenderer(this.renderQueue,e)):e():(this.renderQueue.forEach(this.paint,this),e())},this))},this))}function o(e){return e.parent&&e.parent.clip.length}function d(e){return e.replace(/(\-[a-z])/g,function(e){return e.toUpperCase().replace("-","")})}function i(){}function t(e,n,f,o){return e.map(function(d,i){if(d.width>0){var t=n.left,l=n.top,s=n.width,u=n.height-e[2].width;switch(i){case 0:u=e[0].width,d.args=a({c1:[t,l],c2:[t+s,l],c3:[t+s-e[1].width,l+u],c4:[t+e[3].width,l+u]},o[0],o[1],f.topLeftOuter,f.topLeftInner,f.topRightOuter,f.topRightInner);break;case 1:t=n.left+n.width-e[1].width,s=e[1].width,d.args=a({c1:[t+s,l],c2:[t+s,l+u+e[2].width],c3:[t,l+u],c4:[t,l+e[0].width]},o[1],o[2],f.topRightOuter,f.topRightInner,f.bottomRightOuter,f.bottomRightInner);break;case 2:l=l+n.height-e[2].width,u=e[2].width,d.args=a({c1:[t+s,l+u],c2:[t,l+u],c3:[t+e[3].width,l],c4:[t+s-e[3].width,l]},o[2],o[3],f.bottomRightOuter,f.bottomRightInner,f.bottomLeftOuter,f.bottomLeftInner);break;case 3:s=e[3].width,d.args=a({c1:[t,l+u+e[2].width],c2:[t,l],c3:[t+s,l+e[0].width],c4:[t+s,l+u]},o[3],o[0],f.bottomLeftOuter,f.bottomLeftInner,f.topLeftOuter,f.topLeftInner)}}return d})}function l(e,n,f,o){var d=4*((Math.sqrt(2)-1)/3),i=f*d,t=o*d,l=e+f,s=n+o;return{topLeft:u({x:e,y:s},{x:e,y:s-t},{x:l-i,y:n},{x:l,y:n}),topRight:u({x:e,y:n},{x:e+i,y:n},{x:l,y:s-t},{x:l,y:s}),bottomRight:u({x:l,y:n},{x:l,y:n+t},{x:e+i,y:s},{x:e,y:s}),bottomLeft:u({x:l,y:s},{x:l-i,y:s},{x:e,y:n+t},{x:e,y:n})}}function s(e,n,f){var o=e.left,d=e.top,i=e.width,t=e.height,s=n[0][0]<i/2?n[0][0]:i/2,u=n[0][1]<t/2?n[0][1]:t/2,a=n[1][0]<i/2?n[1][0]:i/2,p=n[1][1]<t/2?n[1][1]:t/2,c=n[2][0]<i/2?n[2][0]:i/2,y=n[2][1]<t/2?n[2][1]:t/2,m=n[3][0]<i/2?n[3][0]:i/2,r=n[3][1]<t/2?n[3][1]:t/2,v=i-a,w=t-y,b=i-c,g=t-r;return{topLeftOuter:l(o,d,s,u).topLeft.subdivide(.5),topLeftInner:l(o+f[3].width,d+f[0].width,Math.max(0,s-f[3].width),Math.max(0,u-f[0].width)).topLeft.subdivide(.5),topRightOuter:l(o+v,d,a,p).topRight.subdivide(.5),topRightInner:l(o+Math.min(v,i+f[3].width),d+f[0].width,v>i+f[3].width?0:a-f[3].width,p-f[0].width).topRight.subdivide(.5),bottomRightOuter:l(o+b,d+w,c,y).bottomRight.subdivide(.5),bottomRightInner:l(o+Math.min(b,i-f[3].width),d+Math.min(w,t+f[0].width),Math.max(0,c-f[1].width),y-f[2].width).bottomRight.subdivide(.5),bottomLeftOuter:l(o,d+g,m,r).bottomLeft.subdivide(.5),bottomLeftInner:l(o+f[3].width,d+g,Math.max(0,m-f[3].width),r-f[2].width).bottomLeft.subdivide(.5)}}function u(e,n,f,o){var d=function(e,n,f){return{x:e.x+(n.x-e.x)*f,y:e.y+(n.y-e.y)*f}};return{start:e,startControl:n,endControl:f,end:o,subdivide:function(i){var t=d(e,n,i),l=d(n,f,i),s=d(f,o,i),a=d(t,l,i),p=d(l,s,i),c=d(a,p,i);return[u(e,t,a,c),u(c,p,s,o)]},curveTo:function(e){e.push(["bezierCurve",n.x,n.y,f.x,f.y,o.x,o.y])},curveToReversed:function(o){o.push(["bezierCurve",f.x,f.y,n.x,n.y,e.x,e.y])}}}function a(e,n,f,o,d,i,t){var l=[];return n[0]>0||n[1]>0?(l.push(["line",o[1].start.x,o[1].start.y]),o[1].curveTo(l)):l.push(["line",e.c1[0],e.c1[1]]),f[0]>0||f[1]>0?(l.push(["line",i[0].start.x,i[0].start.y]),i[0].curveTo(l),l.push(["line",t[0].end.x,t[0].end.y]),t[0].curveToReversed(l)):(l.push(["line",e.c2[0],e.c2[1]]),l.push(["line",e.c3[0],e.c3[1]])),n[0]>0||n[1]>0?(l.push(["line",d[1].end.x,d[1].end.y]),d[1].curveToReversed(l)):l.push(["line",e.c4[0],e.c4[1]]),l}function p(e,n,f,o,d,i,t){n[0]>0||n[1]>0?(e.push(["line",o[0].start.x,o[0].start.y]),o[0].curveTo(e),o[1].curveTo(e)):e.push(["line",i,t]),(f[0]>0||f[1]>0)&&e.push(["line",d[0].start.x,d[0].start.y])}function c(e){return e.cssInt("zIndex")<0}function y(e){return e.cssInt("zIndex")>0}function m(e){return 0===e.cssInt("zIndex")}function r(e){return-1!==["inline","inline-block","inline-table"].indexOf(e.css("display"))}function v(e){return e instanceof U}function w(e){return e.node.data.trim().length>0}function b(e){return/^(normal|none|0px)$/.test(e.parent.css("letterSpacing"))}function g(e){return["TopLeft","TopRight","BottomRight","BottomLeft"].map(function(n){var f=e.css("border"+n+"Radius"),o=f.split(" ");return o.length<=1&&(o[1]=o[0]),o.map(F)})}function h(e){return e.nodeType===Node.TEXT_NODE||e.nodeType===Node.ELEMENT_NODE}function x(e){var n=e.css("position"),f=-1!==["absolute","relative","fixed"].indexOf(n)?e.css("zIndex"):"auto";return"auto"!==f}function j(e){return"static"!==e.css("position")}function k(e){return"none"!==e.css("float")}function q(e){return-1!==["inline-block","inline-table"].indexOf(e.css("display"))}function z(e){var n=this;return function(){return!e.apply(n,arguments)}}function A(e){return e.node.nodeType===Node.ELEMENT_NODE}function B(e){return e.isPseudoElement===!0}function C(e){return e.node.nodeType===Node.TEXT_NODE}function D(e){return function(n,f){return n.cssInt("zIndex")+e.indexOf(n)/e.length-(f.cssInt("zIndex")+e.indexOf(f)/e.length)}}function E(e){return e.getOpacity()<1}function F(e){return parseInt(e,10)}function G(e){return e.width}function H(e){return e.node.nodeType!==Node.ELEMENT_NODE||-1===["SCRIPT","HEAD","TITLE","OBJECT","BR","OPTION"].indexOf(e.node.nodeName)}function I(e){return[].concat.apply([],e)}function J(e){var n=e.substr(0,1);return n===e.substr(e.length-1)&&n.match(/'|"/)?e.substr(1,e.length-2):e}function K(e){for(var n,f=[],o=0,d=!1;e.length;)L(e[o])===d?(n=e.splice(0,o),n.length&&f.push(O.ucs2.encode(n)),d=!d,o=0):o++,o>=e.length&&(n=e.splice(0,o),n.length&&f.push(O.ucs2.encode(n)));return f}function L(e){return-1!==[32,13,10,9,45].indexOf(e)}function M(e){return/[^\u0000-\u00ff]/.test(e)}var N=e("./log"),O=e("punycode"),P=e("./nodecontainer"),Q=e("./textcontainer"),R=e("./pseudoelementcontainer"),S=e("./fontmetrics"),T=e("./color"),U=e("./stackingcontext"),V=e("./utils"),W=V.bind,X=V.getBounds,Y=V.parseBackgrounds,Z=V.offsetBounds;f.prototype.calculateOverflowClips=function(){this.nodes.forEach(function(e){if(A(e)){B(e)&&e.appendToDOM(),e.borders=this.parseBorders(e);var n="hidden"===e.css("overflow")?[e.borders.clip]:[],f=e.parseClip();f&&-1!==["absolute","fixed"].indexOf(e.css("position"))&&n.push([["rect",e.bounds.left+f.left,e.bounds.top+f.top,f.right-f.left,f.bottom-f.top]]),e.clip=o(e)?e.parent.clip.concat(n):n,e.backgroundClip="hidden"!==e.css("overflow")?e.clip.concat([e.borders.clip]):e.clip,B(e)&&e.cleanDOM()}else C(e)&&(e.clip=o(e)?e.parent.clip:[]);B(e)||(e.bounds=null)},this)},f.prototype.asyncRenderer=function(e,n,f){f=f||Date.now(),this.paint(e[this.renderIndex++]),e.length===this.renderIndex?n():f+20>Date.now()?this.asyncRenderer(e,n,f):setTimeout(W(function(){this.asyncRenderer(e,n)},this),0)},f.prototype.createPseudoHideStyles=function(e){this.createStyles(e,"."+R.prototype.PSEUDO_HIDE_ELEMENT_CLASS_BEFORE+':before { content: "" !important; display: none !important; }.'+R.prototype.PSEUDO_HIDE_ELEMENT_CLASS_AFTER+':after { content: "" !important; display: none !important; }')},f.prototype.disableAnimations=function(e){this.createStyles(e,"* { -webkit-animation: none !important; -moz-animation: none !important; -o-animation: none !important; animation: none !important; -webkit-transition: none !important; -moz-transition: none !important; -o-transition: none !important; transition: none !important;}")},f.prototype.createStyles=function(e,n){var f=e.createElement("style");f.innerHTML=n,e.body.appendChild(f)},f.prototype.getPseudoElements=function(e){var n=[[e]];if(e.node.nodeType===Node.ELEMENT_NODE){var f=this.getPseudoElement(e,":before"),o=this.getPseudoElement(e,":after");f&&n.push(f),o&&n.push(o)}return I(n)},f.prototype.getPseudoElement=function(e,n){var f=e.computedStyle(n);if(!f||!f.content||"none"===f.content||"-moz-alt-content"===f.content||"none"===f.display)return null;for(var o=J(f.content),i="url"===o.substr(0,3),t=document.createElement(i?"img":"html2canvaspseudoelement"),l=new R(t,e,n),s=f.length-1;s>=0;s--){var u=d(f.item(s));t.style[u]=f[u]}if(t.className=R.prototype.PSEUDO_HIDE_ELEMENT_CLASS_BEFORE+" "+R.prototype.PSEUDO_HIDE_ELEMENT_CLASS_AFTER,i)return t.src=Y(o)[0].args[0],[l];var a=document.createTextNode(o);return t.appendChild(a),[l,new Q(a,l)]},f.prototype.getChildren=function(e){return I([].filter.call(e.node.childNodes,h).map(function(n){var f=[n.nodeType===Node.TEXT_NODE?new Q(n,e):new P(n,e)].filter(H);return n.nodeType===Node.ELEMENT_NODE&&f.length&&"TEXTAREA"!==n.tagName?f[0].isElementVisible()?f.concat(this.getChildren(f[0])):[]:f},this))},f.prototype.newStackingContext=function(e,n){var f=new U(n,e.getOpacity(),e.node,e.parent);e.cloneTo(f);var o=n?f.getParentStack(this):f.parent.stack;o.contexts.push(f),e.stack=f},f.prototype.createStackingContexts=function(){this.nodes.forEach(function(e){A(e)&&(this.isRootElement(e)||E(e)||x(e)||this.isBodyWithTransparentRoot(e)||e.hasTransform())?this.newStackingContext(e,!0):A(e)&&(j(e)&&m(e)||q(e)||k(e))?this.newStackingContext(e,!1):e.assignStack(e.parent.stack)},this)},f.prototype.isBodyWithTransparentRoot=function(e){return"BODY"===e.node.nodeName&&e.parent.color("backgroundColor").isTransparent()},f.prototype.isRootElement=function(e){return null===e.parent},f.prototype.sortStackingContexts=function(e){e.contexts.sort(D(e.contexts.slice(0))),e.contexts.forEach(this.sortStackingContexts,this)},f.prototype.parseTextBounds=function(e){return function(n,f,o){if("none"!==e.parent.css("textDecoration").substr(0,4)||0!==n.trim().length){if(this.support.rangeBounds&&!e.parent.hasTransform()){var d=o.slice(0,f).join("").length;return this.getRangeBounds(e.node,d,n.length)}if(e.node&&"string"==typeof e.node.data){var i=e.node.splitText(n.length),t=this.getWrapperBounds(e.node,e.parent.hasTransform());return e.node=i,t}}else(!this.support.rangeBounds||e.parent.hasTransform())&&(e.node=e.node.splitText(n.length));return{}}},f.prototype.getWrapperBounds=function(e,n){var f=e.ownerDocument.createElement("html2canvaswrapper"),o=e.parentNode,d=e.cloneNode(!0);f.appendChild(e.cloneNode(!0)),o.replaceChild(f,e);var i=n?Z(f):X(f);return o.replaceChild(d,f),i},f.prototype.getRangeBounds=function(e,n,f){var o=this.range||(this.range=e.ownerDocument.createRange());return o.setStart(e,n),o.setEnd(e,n+f),o.getBoundingClientRect()},f.prototype.parse=function(e){var n=e.contexts.filter(c),f=e.children.filter(A),o=f.filter(z(k)),d=o.filter(z(j)).filter(z(r)),t=f.filter(z(j)).filter(k),l=o.filter(z(j)).filter(r),s=e.contexts.concat(o.filter(j)).filter(m),u=e.children.filter(C).filter(w),a=e.contexts.filter(y);n.concat(d).concat(t).concat(l).concat(s).concat(u).concat(a).forEach(function(e){this.renderQueue.push(e),v(e)&&(this.parse(e),this.renderQueue.push(new i))},this)},f.prototype.paint=function(e){try{e instanceof i?this.renderer.ctx.restore():C(e)?(B(e.parent)&&e.parent.appendToDOM(),this.paintText(e),B(e.parent)&&e.parent.cleanDOM()):this.paintNode(e)}catch(n){if(N(n),this.options.strict)throw n}},f.prototype.paintNode=function(e){v(e)&&(this.renderer.setOpacity(e.opacity),this.renderer.ctx.save(),e.hasTransform()&&this.renderer.setTransform(e.parseTransform())),"INPUT"===e.node.nodeName&&"checkbox"===e.node.type?this.paintCheckbox(e):"INPUT"===e.node.nodeName&&"radio"===e.node.type?this.paintRadio(e):this.paintElement(e)},f.prototype.paintElement=function(e){var n=e.parseBounds();this.renderer.clip(e.backgroundClip,function(){this.renderer.renderBackground(e,n,e.borders.borders.map(G))},this),this.renderer.clip(e.clip,function(){this.renderer.renderBorders(e.borders.borders)},this),this.renderer.clip(e.backgroundClip,function(){switch(e.node.nodeName){case"svg":case"IFRAME":var f=this.images.get(e.node);f?this.renderer.renderImage(e,n,e.borders,f):N("Error loading <"+e.node.nodeName+">",e.node);break;case"IMG":var o=this.images.get(e.node.src);o?this.renderer.renderImage(e,n,e.borders,o):N("Error loading <img>",e.node.src);break;case"CANVAS":this.renderer.renderImage(e,n,e.borders,{image:e.node});break;case"SELECT":case"INPUT":case"TEXTAREA":this.paintFormValue(e)}},this)},f.prototype.paintCheckbox=function(e){var n=e.parseBounds(),f=Math.min(n.width,n.height),o={width:f-1,height:f-1,top:n.top,left:n.left},d=[3,3],i=[d,d,d,d],l=[1,1,1,1].map(function(e){return{color:new T("#A5A5A5"),width:e}}),u=s(o,i,l);this.renderer.clip(e.backgroundClip,function(){this.renderer.rectangle(o.left+1,o.top+1,o.width-2,o.height-2,new T("#DEDEDE")),this.renderer.renderBorders(t(l,o,u,i)),e.node.checked&&(this.renderer.font(new T("#424242"),"normal","normal","bold",f-3+"px","arial"),this.renderer.text("Ã¢Å“â€",o.left+f/6,o.top+f-1))},this)},f.prototype.paintRadio=function(e){var n=e.parseBounds(),f=Math.min(n.width,n.height)-2;this.renderer.clip(e.backgroundClip,function(){this.renderer.circleStroke(n.left+1,n.top+1,f,new T("#DEDEDE"),1,new T("#A5A5A5")),e.node.checked&&this.renderer.circle(Math.ceil(n.left+f/4)+1,Math.ceil(n.top+f/4)+1,Math.floor(f/2),new T("#424242"))},this)},f.prototype.paintFormValue=function(e){var n=e.getValue();if(n.length>0){var f=e.node.ownerDocument,o=f.createElement("html2canvaswrapper"),d=["lineHeight","textAlign","fontFamily","fontWeight","fontSize","color","paddingLeft","paddingTop","paddingRight","paddingBottom","width","height","borderLeftStyle","borderTopStyle","borderLeftWidth","borderTopWidth","boxSizing","whiteSpace","wordWrap"];d.forEach(function(n){try{o.style[n]=e.css(n)}catch(f){N("html2canvas: Parse: Exception caught in renderFormValue: "+f.message)}});var i=e.parseBounds();o.style.position="fixed",o.style.left=i.left+"px",o.style.top=i.top+"px",o.textContent=n,f.body.appendChild(o),this.paintText(new Q(o.firstChild,e)),f.body.removeChild(o)}},f.prototype.paintText=function(e){e.applyTextTransform();var n=O.ucs2.decode(e.node.data),f=this.options.letterRendering&&!b(e)||M(e.node.data)?n.map(function(e){return O.ucs2.encode([e])}):K(n),o=e.parent.fontWeight(),d=e.parent.css("fontSize"),i=e.parent.css("fontFamily"),t=e.parent.parseTextShadows();this.renderer.font(e.parent.color("color"),e.parent.css("fontStyle"),e.parent.css("fontVariant"),o,d,i),t.length?this.renderer.fontShadow(t[0].color,t[0].offsetX,t[0].offsetY,t[0].blur):this.renderer.clearShadow(),this.renderer.clip(e.parent.clip,function(){f.map(this.parseTextBounds(e),this).forEach(function(n,o){n&&(this.renderer.text(f[o],n.left,n.bottom),this.renderTextDecoration(e.parent,n,this.fontMetrics.getMetrics(i,d)))},this)},this)},f.prototype.renderTextDecoration=function(e,n,f){switch(e.css("textDecoration").split(" ")[0]){case"underline":this.renderer.rectangle(n.left,Math.round(n.top+f.baseline+f.lineWidth),n.width,1,e.color("color"));break;case"overline":this.renderer.rectangle(n.left,Math.round(n.top),n.width,1,e.color("color"));break;case"line-through":this.renderer.rectangle(n.left,Math.ceil(n.top+f.middle+f.lineWidth),n.width,1,e.color("color"))}};var $={inset:[["darken",.6],["darken",.1],["darken",.1],["darken",.6]]};f.prototype.parseBorders=function(e){var n=e.parseBounds(),f=g(e),o=["Top","Right","Bottom","Left"].map(function(n,f){var o=e.css("border"+n+"Style"),d=e.color("border"+n+"Color");"inset"===o&&d.isBlack()&&(d=new T([255,255,255,d.a]));var i=$[o]?$[o][f]:null;return{width:e.cssInt("border"+n+"Width"),color:i?d[i[0]](i[1]):d,args:null}}),d=s(n,f,o);return{clip:this.parseBackgroundClip(e,d,o,f,n),borders:t(o,n,d,f)}},f.prototype.parseBackgroundClip=function(e,n,f,o,d){var i=e.css("backgroundClip"),t=[];switch(i){case"content-box":case"padding-box":p(t,o[0],o[1],n.topLeftInner,n.topRightInner,d.left+f[3].width,d.top+f[0].width),p(t,o[1],o[2],n.topRightInner,n.bottomRightInner,d.left+d.width-f[1].width,d.top+f[0].width),p(t,o[2],o[3],n.bottomRightInner,n.bottomLeftInner,d.left+d.width-f[1].width,d.top+d.height-f[2].width),p(t,o[3],o[0],n.bottomLeftInner,n.topLeftInner,d.left+f[3].width,d.top+d.height-f[2].width);break;default:p(t,o[0],o[1],n.topLeftOuter,n.topRightOuter,d.left,d.top),p(t,o[1],o[2],n.topRightOuter,n.bottomRightOuter,d.left+d.width,d.top),p(t,o[2],o[3],n.bottomRightOuter,n.bottomLeftOuter,d.left+d.width,d.top+d.height),p(t,o[3],o[0],n.bottomLeftOuter,n.topLeftOuter,d.left,d.top+d.height)}return t},n.exports=f},{"./color":3,"./fontmetrics":7,"./log":13,"./nodecontainer":14,"./pseudoelementcontainer":18,"./stackingcontext":21,"./textcontainer":25,"./utils":26,punycode:1}],16:[function(e,n,f){function o(e,n,f){var o="withCredentials"in new XMLHttpRequest;if(!n)return Promise.reject("No proxy configured");var d=t(o),s=l(n,e,d);return o?a(s):i(f,s,d).then(function(e){return m(e.content)})}function d(e,n,f){var o="crossOrigin"in new Image,d=t(o),s=l(n,e,d);return o?Promise.resolve(s):i(f,s,d).then(function(e){return"data:"+e.type+";base64,"+e.content})}function i(e,n,f){return new Promise(function(o,d){var i=e.createElement("script"),t=function(){delete window.html2canvas.proxy[f],e.body.removeChild(i)};window.html2canvas.proxy[f]=function(e){t(),o(e)},i.src=n,i.onerror=function(e){t(),d(e)},e.body.appendChild(i)})}function t(e){return e?"":"html2canvas_"+Date.now()+"_"+ ++r+"_"+Math.round(1e5*Math.random())}function l(e,n,f){return e+"?url="+encodeURIComponent(n)+(f.length?"&callback=html2canvas.proxy."+f:"")}function s(e){return function(n){var f,o=new DOMParser;try{f=o.parseFromString(n,"text/html")}catch(d){c("DOMParser not supported, falling back to createHTMLDocument"),f=document.implementation.createHTMLDocument("");try{f.open(),f.write(n),f.close()}catch(i){c("createHTMLDocument write not supported, falling back to document.body.innerHTML"),f.body.innerHTML=n}}var t=f.querySelector("base");if(!t||!t.href.host){var l=f.createElement("base");l.href=e,f.head.insertBefore(l,f.head.firstChild)}return f}}function u(e,n,f,d,i,t){return new o(e,n,window.document).then(s(e)).then(function(e){return y(e,f,d,i,t,0,0)})}var a=e("./xhr"),p=e("./utils"),c=e("./log"),y=e("./clone"),m=p.decode64,r=0;f.Proxy=o,f.ProxyURL=d,f.loadUrlDocument=u},{"./clone":2,"./log":13,"./utils":26,"./xhr":28}],17:[function(e,n){function f(e,n){var f=document.createElement("a");f.href=e,e=f.href,this.src=e,this.image=new Image;var d=this;this.promise=new Promise(function(f,i){d.image.crossOrigin="Anonymous",d.image.onload=f,d.image.onerror=i,new o(e,n,document).then(function(e){d.image.src=e})["catch"](i)})}var o=e("./proxy").ProxyURL;n.exports=f},{"./proxy":16}],18:[function(e,n){function f(e,n,f){o.call(this,e,n),this.isPseudoElement=!0,this.before=":before"===f}var o=e("./nodecontainer");f.prototype.cloneTo=function(e){f.prototype.cloneTo.call(this,e),e.isPseudoElement=!0,e.before=this.before},f.prototype=Object.create(o.prototype),f.prototype.appendToDOM=function(){this.before?this.parent.node.insertBefore(this.node,this.parent.node.firstChild):this.parent.node.appendChild(this.node),this.parent.node.className+=" "+this.getHideClass()},f.prototype.cleanDOM=function(){this.node.parentNode.removeChild(this.node),this.parent.node.className=this.parent.node.className.replace(this.getHideClass(),"")},f.prototype.getHideClass=function(){return this["PSEUDO_HIDE_ELEMENT_CLASS_"+(this.before?"BEFORE":"AFTER")]},f.prototype.PSEUDO_HIDE_ELEMENT_CLASS_BEFORE="___html2canvas___pseudoelement_before",f.prototype.PSEUDO_HIDE_ELEMENT_CLASS_AFTER="___html2canvas___pseudoelement_after",n.exports=f},{"./nodecontainer":14}],19:[function(e,n){function f(e,n,f,o,d){this.width=e,this.height=n,this.images=f,this.options=o,this.document=d}var o=e("./log");f.prototype.renderImage=function(e,n,f,o){var d=e.cssInt("paddingLeft"),i=e.cssInt("paddingTop"),t=e.cssInt("paddingRight"),l=e.cssInt("paddingBottom"),s=f.borders,u=n.width-(s[1].width+s[3].width+d+t),a=n.height-(s[0].width+s[2].width+i+l);this.drawImage(o,0,0,o.image.width||u,o.image.height||a,n.left+d+s[3].width,n.top+i+s[0].width,u,a)},f.prototype.renderBackground=function(e,n,f){n.height>0&&n.width>0&&(this.renderBackgroundColor(e,n),this.renderBackgroundImage(e,n,f))},f.prototype.renderBackgroundColor=function(e,n){var f=e.color("backgroundColor");f.isTransparent()||this.rectangle(n.left,n.top,n.width,n.height,f)},f.prototype.renderBorders=function(e){e.forEach(this.renderBorder,this)},f.prototype.renderBorder=function(e){e.color.isTransparent()||null===e.args||this.drawShape(e.args,e.color)},f.prototype.renderBackgroundImage=function(e,n,f){var d=e.parseBackgroundImages();d.reverse().forEach(function(d,i,t){switch(d.method){case"url":var l=this.images.get(d.args[0]);l?this.renderBackgroundRepeating(e,n,l,t.length-(i+1),f):o("Error loading background-image",d.args[0]);break;case"linear-gradient":case"gradient":var s=this.images.get(d.value);s?this.renderBackgroundGradient(s,n,f):o("Error loading background-image",d.args[0]);break;case"none":break;default:o("Unknown background-image type",d.args[0])}},this)},f.prototype.renderBackgroundRepeating=function(e,n,f,o,d){var i=e.parseBackgroundSize(n,f.image,o),t=e.parseBackgroundPosition(n,f.image,o,i),l=e.parseBackgroundRepeat(o);switch(l){case"repeat-x":case"repeat no-repeat":this.backgroundRepeatShape(f,t,i,n,n.left+d[3],n.top+t.top+d[0],99999,i.height,d);break;case"repeat-y":case"no-repeat repeat":this.backgroundRepeatShape(f,t,i,n,n.left+t.left+d[3],n.top+d[0],i.width,99999,d);break;case"no-repeat":this.backgroundRepeatShape(f,t,i,n,n.left+t.left+d[3],n.top+t.top+d[0],i.width,i.height,d);break;default:this.renderBackgroundRepeat(f,t,i,{top:n.top,left:n.left},d[3],d[0])}},n.exports=f},{"./log":13}],20:[function(e,n){function f(e,n){d.apply(this,arguments),this.canvas=this.options.canvas||this.document.createElement("canvas"),this.options.canvas||(this.canvas.width=e,this.canvas.height=n),this.ctx=this.canvas.getContext("2d"),this.taintCtx=this.document.createElement("canvas").getContext("2d"),this.ctx.textBaseline="bottom",this.variables={},t("Initialized CanvasRenderer with size",e,"x",n)}function o(e){return e.length>0}var d=e("../renderer"),i=e("../lineargradientcontainer"),t=e("../log");f.prototype=Object.create(d.prototype),f.prototype.setFillStyle=function(e){return this.ctx.fillStyle="object"==typeof e&&e.isColor?e.toString():e,this.ctx},f.prototype.rectangle=function(e,n,f,o,d){this.setFillStyle(d).fillRect(e,n,f,o)},f.prototype.circle=function(e,n,f,o){this.setFillStyle(o),this.ctx.beginPath(),this.ctx.arc(e+f/2,n+f/2,f/2,0,2*Math.PI,!0),this.ctx.closePath(),this.ctx.fill()},f.prototype.circleStroke=function(e,n,f,o,d,i){this.circle(e,n,f,o),this.ctx.strokeStyle=i.toString(),this.ctx.stroke()},f.prototype.drawShape=function(e,n){this.shape(e),this.setFillStyle(n).fill()},f.prototype.taints=function(e){if(null===e.tainted){this.taintCtx.drawImage(e.image,0,0);try{this.taintCtx.getImageData(0,0,1,1),e.tainted=!1}catch(n){this.taintCtx=document.createElement("canvas").getContext("2d"),e.tainted=!0}}return e.tainted},f.prototype.drawImage=function(e,n,f,o,d,i,t,l,s){(!this.taints(e)||this.options.allowTaint)&&this.ctx.drawImage(e.image,n,f,o,d,i,t,l,s)},f.prototype.clip=function(e,n,f){this.ctx.save(),e.filter(o).forEach(function(e){this.shape(e).clip()},this),n.call(f),this.ctx.restore()},f.prototype.shape=function(e){return this.ctx.beginPath(),e.forEach(function(e,n){"rect"===e[0]?this.ctx.rect.apply(this.ctx,e.slice(1)):this.ctx[0===n?"moveTo":e[0]+"To"].apply(this.ctx,e.slice(1))},this),this.ctx.closePath(),this.ctx},f.prototype.font=function(e,n,f,o,d,i){this.setFillStyle(e).font=[n,f,o,d,i].join(" ").split(",")[0]},f.prototype.fontShadow=function(e,n,f,o){this.setVariable("shadowColor",e.toString()).setVariable("shadowOffsetY",n).setVariable("shadowOffsetX",f).setVariable("shadowBlur",o)},f.prototype.clearShadow=function(){this.setVariable("shadowColor","rgba(0,0,0,0)")},f.prototype.setOpacity=function(e){this.ctx.globalAlpha=e},f.prototype.setTransform=function(e){this.ctx.translate(e.origin[0],e.origin[1]),this.ctx.transform.apply(this.ctx,e.matrix),this.ctx.translate(-e.origin[0],-e.origin[1])},f.prototype.setVariable=function(e,n){return this.variables[e]!==n&&(this.variables[e]=this.ctx[e]=n),this},f.prototype.text=function(e,n,f){this.ctx.fillText(e,n,f)},f.prototype.backgroundRepeatShape=function(e,n,f,o,d,i,t,l,s){var u=[["line",Math.round(d),Math.round(i)],["line",Math.round(d+t),Math.round(i)],["line",Math.round(d+t),Math.round(l+i)],["line",Math.round(d),Math.round(l+i)]];this.clip([u],function(){this.renderBackgroundRepeat(e,n,f,o,s[3],s[0])},this)},f.prototype.renderBackgroundRepeat=function(e,n,f,o,d,i){var t=Math.round(o.left+n.left+d),l=Math.round(o.top+n.top+i);this.setFillStyle(this.ctx.createPattern(this.resizeImage(e,f),"repeat")),this.ctx.translate(t,l),this.ctx.fill(),this.ctx.translate(-t,-l)},f.prototype.renderBackgroundGradient=function(e,n){if(e instanceof i){var f=this.ctx.createLinearGradient(n.left+n.width*e.x0,n.top+n.height*e.y0,n.left+n.width*e.x1,n.top+n.height*e.y1);e.colorStops.forEach(function(e){f.addColorStop(e.stop,e.color.toString())}),this.rectangle(n.left,n.top,n.width,n.height,f)}},f.prototype.resizeImage=function(e,n){var f=e.image;if(f.width===n.width&&f.height===n.height)return f;var o,d=document.createElement("canvas");return d.width=n.width,d.height=n.height,o=d.getContext("2d"),o.drawImage(f,0,0,f.width,f.height,0,0,n.width,n.height),d},n.exports=f},{"../lineargradientcontainer":12,"../log":13,"../renderer":19}],21:[function(e,n){function f(e,n,f,d){o.call(this,f,d),this.ownStacking=e,this.contexts=[],this.children=[],this.opacity=(this.parent?this.parent.stack.opacity:1)*n}var o=e("./nodecontainer");f.prototype=Object.create(o.prototype),f.prototype.getParentStack=function(e){var n=this.parent?this.parent.stack:null;return n?n.ownStacking?n:n.getParentStack(e):e.stack},n.exports=f},{"./nodecontainer":14}],22:[function(e,n){function f(e){this.rangeBounds=this.testRangeBounds(e),this.cors=this.testCORS(),this.svg=this.testSVG()}f.prototype.testRangeBounds=function(e){var n,f,o,d,i=!1;return e.createRange&&(n=e.createRange(),n.getBoundingClientRect&&(f=e.createElement("boundtest"),f.style.height="123px",f.style.display="block",e.body.appendChild(f),n.selectNode(f),o=n.getBoundingClientRect(),d=o.height,123===d&&(i=!0),e.body.removeChild(f))),i},f.prototype.testCORS=function(){return"undefined"!=typeof(new Image).crossOrigin},f.prototype.testSVG=function(){var e=new Image,n=document.createElement("canvas"),f=n.getContext("2d");e.src="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg'></svg>";try{f.drawImage(e,0,0),n.toDataURL()}catch(o){return!1}return!0},n.exports=f},{}],23:[function(e,n){function f(e){this.src=e,this.image=null;var n=this;this.promise=this.hasFabric().then(function(){return n.isInline(e)?Promise.resolve(n.inlineFormatting(e)):o(e)}).then(function(e){return new Promise(function(f){window.html2canvas.svg.fabric.loadSVGFromString(e,n.createCanvas.call(n,f))})})}var o=e("./xhr"),d=e("./utils").decode64;f.prototype.hasFabric=function(){return window.html2canvas.svg&&window.html2canvas.svg.fabric?Promise.resolve():Promise.reject(new Error("html2canvas.svg.js is not loaded, cannot render svg"))},f.prototype.inlineFormatting=function(e){return/^data:image\/svg\+xml;base64,/.test(e)?this.decode64(this.removeContentType(e)):this.removeContentType(e)},f.prototype.removeContentType=function(e){return e.replace(/^data:image\/svg\+xml(;base64)?,/,"")},f.prototype.isInline=function(e){return/^data:image\/svg\+xml/i.test(e)},f.prototype.createCanvas=function(e){var n=this;return function(f,o){var d=new window.html2canvas.svg.fabric.StaticCanvas("c");n.image=d.lowerCanvasEl,d.setWidth(o.width).setHeight(o.height).add(window.html2canvas.svg.fabric.util.groupSVGElements(f,o)).renderAll(),e(d.lowerCanvasEl)}},f.prototype.decode64=function(e){return"function"==typeof window.atob?window.atob(e):d(e)},n.exports=f},{"./utils":26,"./xhr":28}],24:[function(e,n){function f(e,n){this.src=e,this.image=null;var f=this;this.promise=n?new Promise(function(n,o){f.image=new Image,f.image.onload=n,f.image.onerror=o,f.image.src="data:image/svg+xml,"+(new XMLSerializer).serializeToString(e),f.image.complete===!0&&n(f.image)}):this.hasFabric().then(function(){return new Promise(function(n){window.html2canvas.svg.fabric.parseSVGDocument(e,f.createCanvas.call(f,n))})})}var o=e("./svgcontainer");f.prototype=Object.create(o.prototype),n.exports=f},{"./svgcontainer":23}],25:[function(e,n){function f(e,n){d.call(this,e,n)}function o(e,n,f){return e.length>0?n+f.toUpperCase():void 0}var d=e("./nodecontainer");f.prototype=Object.create(d.prototype),f.prototype.applyTextTransform=function(){this.node.data=this.transform(this.parent.css("textTransform"))},f.prototype.transform=function(e){var n=this.node.data;switch(e){case"lowercase":return n.toLowerCase();case"capitalize":return n.replace(/(^|\s|:|-|\(|\))([a-z])/g,o);case"uppercase":return n.toUpperCase();default:return n}},n.exports=f},{"./nodecontainer":14}],26:[function(e,n,f){f.smallImage=function(){return"data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7"},f.bind=function(e,n){return function(){return e.apply(n,arguments)}},f.decode64=function(e){var n,f,o,d,i,t,l,s,u="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",a=e.length,p="";for(n=0;a>n;n+=4)f=u.indexOf(e[n]),o=u.indexOf(e[n+1]),d=u.indexOf(e[n+2]),i=u.indexOf(e[n+3]),t=f<<2|o>>4,l=(15&o)<<4|d>>2,s=(3&d)<<6|i,p+=64===d?String.fromCharCode(t):64===i||-1===i?String.fromCharCode(t,l):String.fromCharCode(t,l,s);return p},f.getBounds=function(e){if(e.getBoundingClientRect){var n=e.getBoundingClientRect(),f=null==e.offsetWidth?n.width:e.offsetWidth;return{top:n.top,bottom:n.bottom||n.top+n.height,right:n.left+f,left:n.left,width:f,height:null==e.offsetHeight?n.height:e.offsetHeight}}return{}},f.offsetBounds=function(e){var n=e.offsetParent?f.offsetBounds(e.offsetParent):{top:0,left:0};return{top:e.offsetTop+n.top,bottom:e.offsetTop+e.offsetHeight+n.top,right:e.offsetLeft+n.left+e.offsetWidth,left:e.offsetLeft+n.left,width:e.offsetWidth,height:e.offsetHeight}},f.parseBackgrounds=function(e){var n,f,o,d,i,t,l,s=" \r\n	",u=[],a=0,p=0,c=function(){n&&('"'===f.substr(0,1)&&(f=f.substr(1,f.length-2)),f&&l.push(f),"-"===n.substr(0,1)&&(d=n.indexOf("-",1)+1)>0&&(o=n.substr(0,d),n=n.substr(d)),u.push({prefix:o,method:n.toLowerCase(),value:i,args:l,image:null})),l=[],n=o=f=i=""};return l=[],n=o=f=i="",e.split("").forEach(function(e){if(!(0===a&&s.indexOf(e)>-1)){switch(e){case'"':t?t===e&&(t=null):t=e;break;case"(":if(t)break;if(0===a)return a=1,void(i+=e);p++;break;case")":if(t)break;if(1===a){if(0===p)return a=0,i+=e,void c();p--}break;case",":if(t)break;if(0===a)return void c();if(1===a&&0===p&&!n.match(/^url$/i))return l.push(f),f="",void(i+=e)}i+=e,0===a?n+=e:f+=e}}),c(),u}},{}],27:[function(e,n){function f(e){o.apply(this,arguments),this.type="linear"===e.args[0]?o.TYPES.LINEAR:o.TYPES.RADIAL}var o=e("./gradientcontainer");f.prototype=Object.create(o.prototype),n.exports=f},{"./gradientcontainer":9}],28:[function(e,n){function f(e){return new Promise(function(n,f){var o=new XMLHttpRequest;o.open("GET",e),o.onload=function(){200===o.status?n(o.responseText):f(new Error(o.statusText))},o.onerror=function(){f(new Error("Network Error"))},o.send()})}n.exports=f},{}]},{},[4])(4)});

/*! @source http://purl.eligrey.com/github/FileSaver.js/blob/master/FileSaver.js */
var saveAs=saveAs||function(r){"use strict";if("undefined"==typeof navigator||!/MSIE [1-9]\./.test(navigator.userAgent)){var e=r.document,o=function(){return r.URL||r.webkitURL||r},t=e.createElementNS("http://www.w3.org/1999/xhtml","a"),f="download"in t,n=function(r){var e=new MouseEvent("click");r.dispatchEvent(e)},i=/Version\/[\d\.]+.*Safari/.test(navigator.userAgent),a=r.webkitRequestFileSystem,d=r.requestFileSystem||a||r.mozRequestFileSystem,C=function(e){(r.setImmediate||r.setTimeout)(function(){throw e},0)},m="application/octet-stream",S=0,h=4e4,g=function(r){var e=function(){"string"==typeof r?o().revokeObjectURL(r):r.remove()};setTimeout(e,h)},c=function(r,e,o){e=[].concat(e);for(var t=e.length;t--;){var f=r["on"+e[t]];if("function"==typeof f)try{f.call(r,o||r)}catch(n){C(n)}}},u=function(r){return/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(r.type)?new Blob([String.fromCharCode(65279),r],{type:r.type}):r},s=function(e,C,h){h||(e=u(e));var s,l,v,p=this,w=e.type,y=!1,x=function(){c(p,"writestart progress write writeend".split(" "))},R=function(){if(l&&i&&"undefined"!=typeof FileReader){var t=new FileReader;return t.onloadend=function(){var r=t.result;l.location.href="data:attachment/file"+r.slice(r.search(/[,;]/)),p.readyState=p.DONE,x()},t.readAsDataURL(e),void(p.readyState=p.INIT)}if((y||!s)&&(s=o().createObjectURL(e)),l)l.location.href=s;else{var f=r.open(s,"_blank");void 0===f&&i&&(r.location.href=s)}p.readyState=p.DONE,x(),g(s)},O=function(r){return function(){return p.readyState!==p.DONE?r.apply(this,arguments):void 0}},b={create:!0,exclusive:!1};return p.readyState=p.INIT,C||(C="download"),f?(s=o().createObjectURL(e),void setTimeout(function(){t.href=s,t.download=C,n(t),x(),g(s),p.readyState=p.DONE})):(r.chrome&&w&&w!==m&&(v=e.slice||e.webkitSlice,e=v.call(e,0,e.size,m),y=!0),a&&"download"!==C&&(C+=".download"),(w===m||a)&&(l=r),d?(S+=e.size,void d(r.TEMPORARY,S,O(function(r){r.root.getDirectory("saved",b,O(function(r){var o=function(){r.getFile(C,b,O(function(r){r.createWriter(O(function(o){o.onwriteend=function(e){l.location.href=r.toURL(),p.readyState=p.DONE,c(p,"writeend",e),g(r)},o.onerror=function(){var r=o.error;r.code!==r.ABORT_ERR&&R()},"writestart progress write abort".split(" ").forEach(function(r){o["on"+r]=p["on"+r]}),o.write(e),p.abort=function(){o.abort(),p.readyState=p.DONE},p.readyState=p.WRITING}),R)}),R)};r.getFile(C,{create:!1},O(function(r){r.remove(),o()}),O(function(r){r.code===r.NOT_FOUND_ERR?o():R()}))}),R)}),R)):void R())},l=s.prototype,v=function(r,e,o){return new s(r,e,o)};return"undefined"!=typeof navigator&&navigator.msSaveOrOpenBlob?function(r,e,o){return o||(r=u(r)),navigator.msSaveOrOpenBlob(r,e||"download")}:(l.abort=function(){var r=this;r.readyState=r.DONE,c(r,"abort")},l.readyState=l.INIT=0,l.WRITING=1,l.DONE=2,l.error=l.onwritestart=l.onprogress=l.onwrite=l.onabort=l.onerror=l.onwriteend=null,v)}}("undefined"!=typeof self&&self||"undefined"!=typeof window&&window||this.content);"undefined"!=typeof module&&module.exports?module.exports.saveAs=saveAs:"undefined"!=typeof define&&null!==define&&null!==define.amd&&define([],function(){return saveAs});

/*! dom-to-image 07-06-2016 */
!function(a){"use strict";function b(a,b){function c(a){return b.bgcolor&&(a.style.backgroundColor=b.bgcolor),b.width&&(a.style.width=b.width+"px"),b.height&&(a.style.height=b.height+"px"),b.style&&Object.keys(b.style).forEach(function(c){a.style[c]=b.style[c]}),a}return b=b||{},Promise.resolve(a).then(function(a){return h(a,b.filter,!0)}).then(i).then(j).then(c).then(function(c){return k(c,b.width||a.scrollWidth,b.height||a.scrollHeight)})}function c(a,b){return g(a,b||{}).then(function(b){return b.getContext("2d").getImageData(0,0,a.scrollWidth,a.scrollHeight).data})}function d(a,b){return g(a,b||{}).then(function(a){return a.toDataURL()})}function e(a,b){return b=b||{},g(a,b).then(function(a){return a.toDataURL("image/jpeg",b.quality||1)})}function f(a,b){return g(a,b||{}).then(p.canvasToBlob)}function g(a,c){function d(a){var b=document.createElement("canvas");return b.width=c.width||a.scrollWidth,b.height=c.height||a.scrollHeight,b}return b(a,c).then(p.makeImage).then(p.delay(100)).then(function(b){var c=d(a);return c.getContext("2d").drawImage(b,0,0),c})}function h(a,b,c){function d(a){return a instanceof HTMLCanvasElement?p.makeImage(a.toDataURL()):a.cloneNode(!1)}function e(a,b,c){function d(a,b,c){var d=Promise.resolve();return b.forEach(function(b){d=d.then(function(){return h(b,c)}).then(function(b){b&&a.appendChild(b)})}),d}var e=a.childNodes;return 0===e.length?Promise.resolve(b):d(b,p.asArray(e),c).then(function(){return b})}function f(a,b){function c(){function c(a,b){function c(a,b){p.asArray(a).forEach(function(c){b.setProperty(c,a.getPropertyValue(c),a.getPropertyPriority(c))})}a.cssText?b.cssText=a.cssText:c(a,b)}c(window.getComputedStyle(a),b.style)}function d(){function c(c){function d(a,b,c){function d(a){var b=a.getPropertyValue("content");return a.cssText+" content: "+b+";"}function e(a){function b(b){return b+": "+a.getPropertyValue(b)+(a.getPropertyPriority(b)?" !important":"")}return p.asArray(a).map(b).join("; ")+";"}var f="."+a+":"+b,g=c.cssText?d(c):e(c);return document.createTextNode(f+"{"+g+"}")}var e=window.getComputedStyle(a,c),f=e.getPropertyValue("content");if(""!==f&&"none"!==f){var g=p.uid();b.className=b.className+" "+g;var h=document.createElement("style");h.appendChild(d(g,c,e)),b.appendChild(h)}}[":before",":after"].forEach(function(a){c(a)})}function e(){a instanceof HTMLTextAreaElement&&(b.innerHTML=a.value),a instanceof HTMLInputElement&&b.setAttribute("value",a.value)}function f(){b instanceof SVGElement&&(b.setAttribute("xmlns","http://www.w3.org/2000/svg"),b instanceof SVGRectElement&&["width","height"].forEach(function(a){var c=b.getAttribute(a);c&&b.style.setProperty(a,c)}))}return b instanceof Element?Promise.resolve().then(c).then(d).then(e).then(f).then(function(){return b}):b}return c||!b||b(a)?Promise.resolve(a).then(d).then(function(c){return e(a,c,b)}).then(function(b){return f(a,b)}):Promise.resolve()}function i(a){return r.resolveAll().then(function(b){var c=document.createElement("style");return a.appendChild(c),c.appendChild(document.createTextNode(b)),a})}function j(a){return s.inlineAll(a).then(function(){return a})}function k(a,b,c){return Promise.resolve(a).then(function(a){return a.setAttribute("xmlns","http://www.w3.org/1999/xhtml"),(new XMLSerializer).serializeToString(a)}).then(p.escapeXhtml).then(function(a){return'<foreignObject x="0" y="0" width="100%" height="100%">'+a+"</foreignObject>"}).then(function(a){return'<svg xmlns="http://www.w3.org/2000/svg" width="'+b+'" height="'+c+'">'+a+"</svg>"}).then(function(a){return"data:image/svg+xml;charset=utf-8,"+a})}function l(){function a(){var a="application/font-woff",b="image/jpeg";return{woff:a,woff2:a,ttf:"application/font-truetype",eot:"application/vnd.ms-fontobject",png:"image/png",jpg:b,jpeg:b,gif:"image/gif",tiff:"image/tiff",svg:"image/svg+xml"}}function b(a){var b=/\.([^\.\/]*?)$/g.exec(a);return b?b[1]:""}function c(c){var d=b(c).toLowerCase();return a()[d]||""}function d(a){return-1!==a.search(/^(data:)/)}function e(a){return new Promise(function(b){for(var c=window.atob(a.toDataURL().split(",")[1]),d=c.length,e=new Uint8Array(d),f=0;d>f;f++)e[f]=c.charCodeAt(f);b(new Blob([e],{type:"image/png"}))})}function f(a){return a.toBlob?new Promise(function(b){a.toBlob(b)}):e(a)}function g(a,b){var c=document.implementation.createHTMLDocument(),d=c.createElement("base");c.head.appendChild(d);var e=c.createElement("a");return c.body.appendChild(e),d.href=b,e.href=a,e.href}function h(){var a=0;return function(){function b(){return("0000"+(Math.random()*Math.pow(36,4)<<0).toString(36)).slice(-4)}return"u"+b()+a++}}function i(a){return new Promise(function(b,c){var d=new Image;d.onload=function(){b(d)},d.onerror=c,d.src=a})}function j(a){var b=3e4;return new Promise(function(c){function d(){if(4===g.readyState){if(200!==g.status)return void f("cannot fetch resource: "+a+", status: "+g.status);var b=new FileReader;b.onloadend=function(){var a=b.result.split(/,/)[1];c(a)},b.readAsDataURL(g.response)}}function e(){f("timeout of "+b+"ms occured while fetching resource: "+a)}function f(a){console.error(a),c("")}var g=new XMLHttpRequest;g.onreadystatechange=d,g.ontimeout=e,g.responseType="blob",g.timeout=b,g.open("GET",a,!0),g.send()})}function k(a,b){return"data:"+b+";base64,"+a}function l(a){return a.replace(/([.*+?^${}()|\[\]\/\\])/g,"\\$1")}function m(a){return function(b){return new Promise(function(c){setTimeout(function(){c(b)},a)})}}function n(a){for(var b=[],c=a.length,d=0;c>d;d++)b.push(a[d]);return b}function o(a){return a.replace(/#/g,"%23").replace(/\n/g,"%0A")}return{escape:l,parseExtension:b,mimeType:c,dataAsUrl:k,isDataUrl:d,canvasToBlob:f,resolveUrl:g,getAndEncode:j,uid:h(),delay:m,asArray:n,escapeXhtml:o,makeImage:i}}function m(){function a(a){return-1!==a.search(e)}function b(a){for(var b,c=[];null!==(b=e.exec(a));)c.push(b[1]);return c.filter(function(a){return!p.isDataUrl(a)})}function c(a,b,c,d){function e(a){return new RegExp("(url\\(['\"]?)("+p.escape(a)+")(['\"]?\\))","g")}return Promise.resolve(b).then(function(a){return c?p.resolveUrl(a,c):a}).then(d||p.getAndEncode).then(function(a){return p.dataAsUrl(a,p.mimeType(b))}).then(function(c){return a.replace(e(b),"$1"+c+"$3")})}function d(d,e,f){function g(){return!a(d)}return g()?Promise.resolve(d):Promise.resolve(d).then(b).then(function(a){var b=Promise.resolve(d);return a.forEach(function(a){b=b.then(function(b){return c(b,a,e,f)})}),b})}var e=/url\(['"]?([^'"]+?)['"]?\)/g;return{inlineAll:d,shouldProcess:a,impl:{readUrls:b,inline:c}}}function n(){function a(){return b(document).then(function(a){return Promise.all(a.map(function(a){return a.resolve()}))}).then(function(a){return a.join("\n")})}function b(){function a(a){return a.filter(function(a){return a.type===CSSRule.FONT_FACE_RULE}).filter(function(a){return q.shouldProcess(a.style.getPropertyValue("src"))})}function b(a){var b=[];return a.forEach(function(a){try{p.asArray(a.cssRules||[]).forEach(b.push.bind(b))}catch(c){console.log("Error while reading CSS rules from "+a.href,c.toString())}}),b}function c(a){return{resolve:function(){var b=(a.parentStyleSheet||{}).href;return q.inlineAll(a.cssText,b)},src:function(){return a.style.getPropertyValue("src")}}}return Promise.resolve(p.asArray(document.styleSheets)).then(b).then(a).then(function(a){return a.map(c)})}return{resolveAll:a,impl:{readAll:b}}}function o(){function a(a){function b(b){return p.isDataUrl(a.src)?Promise.resolve():Promise.resolve(a.src).then(b||p.getAndEncode).then(function(b){return p.dataAsUrl(b,p.mimeType(a.src))}).then(function(b){return new Promise(function(c,d){a.onload=c,a.onerror=d,a.src=b})})}return{inline:b}}function b(c){function d(a){var b=a.style.getPropertyValue("background");return b?q.inlineAll(b).then(function(b){a.style.setProperty("background",b,a.style.getPropertyPriority("background"))}).then(function(){return a}):Promise.resolve(a)}return c instanceof Element?d(c).then(function(){return c instanceof HTMLImageElement?a(c).inline():Promise.all(p.asArray(c.childNodes).map(function(a){return b(a)}))}):Promise.resolve(c)}return{inlineAll:b,impl:{newImage:a}}}var p=l(),q=m(),r=n(),s=o(),t={toSvg:b,toPng:d,toJpeg:e,toBlob:f,toPixelData:c,impl:{fontFaces:r,images:s,util:p,inliner:q}};"undefined"!=typeof module?module.exports=t:a.domtoimage=t}(this);

/*
 * post-grab-selector.js
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/post-capture.js';
 *
 */

if (active_page == 'thread' || active_page == 'index') {
 $(document).on('menu_ready', function(){

  var Menu = window.Menu;
  var scapMainWidth = 0;
  var scapProxyUri  = '/proxy.php?url=';
  var scapMobile = navigator.userAgent.match(/iPhone|iPod|Android|Opera Mini|Blackberry|PlayBook|Windows Phone|Tablet PC|Windows CE|IEMobile/i);

  /*Convert youtube image to base64 :)*/
  
  function getBase64() {

	$('#final').find('img').each(function() {

    		var tmp_id = Math.floor((Math.random() * 10000) + 1);
    		var src = $(this).attr('src');

    		if (src.indexOf('/static/') >= 0){
     			src = 'http://8kun.top' + src;
    		}

		//if(src.indexOf('img.youtube.com') >= 0) {
    		if(src.indexOf('media.8kun.top') >= 0 || src.indexOf('media2.8kun.top') >= 0 || src.indexOf('img.youtube.com') >= 0 || src.indexOf('8kun.top') >= 0) {
			console.log("srv");
     			$(this).attr('id', tmp_id);
     			if (src.indexOf('img.youtube.com') >= 0)
      				src = src.replace('//', 'http://');

			$.ajax({
           			url: encodeURI(scapProxyUri + src + '&id=' + tmp_id),
           			success: function(result) {
					$('#'+result['id']).attr('src', result['src']);
           			}
     			});
    		}
   	});
  }
  
  function setDivWidth(){
        /*find and change largest width in each element in #final*/
        var width_posts = [];
        var scapMainWidth = 0;
        $("#final").find("div.post_capture").each(function(){
                id = $(this).attr("id");
                post_width = $("#"+id+"").width();
                width_posts.push(post_width);
        });
        if (width_posts.length > 0){
                //Ge highest value of width
                scapMainWidth = Math.max.apply(Math, width_posts);
        }

        /*Set largest width in each elements*/
        $('#final').css({display:'none', width:scapMainWidth+'px'});
  }

  /*Re-arrange post by reply_ID for screen capture*/
  function setReplyByID(){
        $('#final').find('br').remove();
        $("#final div.post_capture").sort(function (a, b) {
                return parseInt(a.id.replace( /^\D+/g, '')) > parseInt(b.id.replace( /^\D+/g, ''));
        }).each(function () {
                $($(this)).appendTo("#final");
                $($(this)).after("<br>");
        });
  }

  /* Screen Capture dropdown*/
  if ($('div#thread-interactions').length && !scapMobile) {
	Menu.add_item("screen_capture_menu", _("Select post"));

	Menu.onclick(function(e, $buf) {
		var ele = e.target.parentElement.parentElement;
		var $ele = $(ele);
		var threadId = $ele.parent().attr('id').replace('thread_', '');
   		var postId = $ele.find('.post_no').not('[id]').text();

    		//Dynamic text condition
    		if ($ele.hasClass('screen-menu-clicked')) {
     			$buf.find("#screen_capture_menu").text(_("Select post") + " ?~\~S");	
    		}else{
     			$buf.find("#screen_capture_menu").text(_("Select post"));
    		}

		//when user click the Select post menu
		$buf.find('#screen_capture_menu').click(function(e) {
     			var tmp = $ele.clone().wrap('<p/>').parent().html();

	     		$buf.find("#screen_capture_menu").text("");

     			if ($ele.hasClass('screen-menu-clicked')) {
				$ele.removeClass('screen-menu-clicked');

				if($('#final').find('#'+$ele.attr('id')).prev().hasClass('files') || $('#final').find('#'+$ele.attr('id')).prev().hasClass('video-container'))
					$('#final').find('#'+$ele.attr('id')).prev().remove();

	       			$('#final').find('#'+$ele.attr('id')).next().remove();
       				$('#final').find('#'+$ele.attr('id')).remove();
       				$ele.find(".intro").find("#glyphicon-capture").remove();
	
	     		} else {
      				$ele.removeClass('screen-menu-clicked');
				$ele.addClass('screen-menu-clicked');
		
				if($ele.width() > scapMainWidth)
					scapMainWidth = $ele.width();

                                /*html2canvas($('#'+$ele.attr('id')),
                                {
                                        useCORS: true,
                                        allowTaint:true,
                                        onrendered: function (canvas) {
                                                $("#final").append(canvas);
						$("#final").append("<br>");
                                        }
                                });*/

				$ele.find(".intro").append('<span id="glyphicon-capture" class="fa fa-camera"></span>');


       				if($ele.prev().hasClass('files')) {
					tmp = '<div class="files">' + $ele.prev().html() + '</div>' + tmp;
				}else if($ele.prev().hasClass('video-container')) {
        				tmp = '<div class="video-container">' + $ele.prev().html() + '</div>' + tmp;
				}

				$('#final').append(tmp);			
				$('#final').find('.own_post').remove();
				getBase64();

				//replace class name to not allow new post on the screen capture canvas
                                $("#final").find('#'+$ele.attr('id')).toggleClass('post post_capture');
				
			}

			setDivWidth()

                        /*re-arrange post by reply_ID*/
                        setReplyByID();
		});
        });
  }
 /*End screen capture*/
 });
}

/*Screen capture*/
$('document').ready(function () {
    var captured_all = false;
    var scapProxyUri  = '/proxy.php?url=';
    var scapLogo = configRoot+"static/8ch_logo.svg.png";
    var scapMobile = navigator.userAgent.match(/iPhone|iPod|Android|Opera Mini|Blackberry|PlayBook|Windows Phone|Tablet PC|Windows CE|IEMobile/i);
    var scapSafari          = !!navigator.userAgent.match(/Version\/[\d\.]+.*Safari/);
    var scapMainWidth = 0;
    var timeoutdelay = 1000;
    var youtubeUriCount = 0;

    if ($('div#thread-interactions').length && !scapMobile) {
	    $('body').append('<div style="position:relative;overflow:hidden;display:none;background-color:'+$('body').css('background-color')+'" id="final"></div>');

	    if(scapSafari){
	    	$('body').append('<div id="scap-modal"><div id="scap-modal-content"><span id="scap-close">x</span><center>Safari users: Please right click and click "Save image as..."<br><img id="scap-safari-src" src="null"></center></div></div>');
	    }

	    $('#scap-modal').css({'display':'none', 'position':'fixed', 'z-index':'1', 'left':'0', 'top':'0', 'width':'100%', 'height':'100%', 'overflow':'auto', 'background-color':'rgb(0,0,0)', 'background-color':'rgba(0,0,0,0.4)'});
	    $('#scap-modal-content').css({'background-color':'#fefefe', 'margin':'5% auto', 'padding':'20px', 'border':'1px solid #888', 'width':'80%'});
	    $('#scap-safari-src').css({'max-width':'100%', 'height':'auto'});
	    $('#scap-close').css({'color':'#aaa', 'float':'right', 'font-size':'28px', 'font-weight':'bold'});
	    $('#scap-close').hover(function(){$(this).css({'color':'black', 'text-decoration':'none', 'cursor':'pointer'})});
	    $('#scap-close').focus(function(){$(this).css({'color':'black', 'text-decoration':'none', 'cursor':'pointer'})});
	    $('#scap-close').click(function(){ $('#scap-modal').css('display','none');$('#scap-safari-src').attr('src', 'null');});
            $('<a id="grab" href="javascript:void(0)" xmlns="http://www.w3.org/1999/xhtml">[' + _("Screencap") + ']</a>').insertAfter('#thread-catalog');
    }
   
    /*Convert youtube image to base64 :)*/
    function getBase64() {

	$('#final').find('img').each(function() {
    		var tmp_id = Math.floor((Math.random() * 10000) + 1);
	    	var src = $(this).attr('src');
	        var img_w = $(this).css("width");
        	var img_h = $(this).css("height");

    		if (src.indexOf('/static/') >= 0){
     			src = 'https://8kun.top' + src;
    		}

 	   	//if(src.indexOf('img.youtube.com') >= 0) {
    		if(src.indexOf('media.8kun.top') >= 0 || src.indexOf('media2.8kun.top') >= 0 || src.indexOf('img.youtube.com') >= 0 || src.indexOf('8kun.top') >= 0) {
			youtubeUriCount++;
     			$(this).attr('id', tmp_id);

 	    		if (src.indexOf('img.youtube.com') >= 0)
      				src = src.replace('//', 'http://');

     			$.ajax({
           			url: encodeURI(scapProxyUri + src + '&id=' + tmp_id),
	           		success: function(result) {
        	                         $('#'+result['id']).attr('src', result['src']);
           			}
	     		});
			
                         /*function loadImage(url) {
                           return new Promise(resolve => { let i = new Image(); i.onload = ()=>{resolve(i)}; i.src=url; });
                         }

                         let img = loadImage(src);
                         var canvas = document.createElement('canvas');
                         canvas.setAttribute('height', img_h);
                         canvas.setAttribute('width', img_w);
                         canvas.setAttribute('id', tmp_id);
                         ctx = canvas.getContext('2d');
                         //img.then(function(i){ctx.drawImage(i,0,0);$('#'+tmp_id).replaceWith(canvas)})
			 img.then(function(i){
				ctx.drawImage(i,0,0);
				$('#'+tmp_id).replaceWith(canvas);
			 })*/
			
    		}
   	});

	if(youtubeUriCount > 0) timeoutdelay = timeoutdelay * youtubeUriCount;

	return timeoutdelay;
    }


    function setDivWidth(typePost){
        /*find and change largest width in each element in #final*/
        var width_posts = [];
        var scapMainWidth = 0;
        if(typePost=="all"){
                divClassname = "post";
        }
        else{
                divClassname = "post_capture";
        }
        $("#final").find("div."+divClassname).each(function(){
                id = $(this).attr("id");
                post_width = $("#"+id+"").width();
                width_posts.push(post_width);
        });
        if (width_posts.length > 0){
                //Get highest value of width
                scapMainWidth = Math.max.apply(Math, width_posts);
        }

        return scapMainWidth;
    }

    function generatingCanvasDownload(scapSafari,typePost){
	console.log("generatingCanvasDownload");
	var canvasdiv = setDivWidth(typePost) + 22;
	html2canvas($('#final'), {
		useCORS: true,
		width: canvasdiv,
		onrendered: function(canvas) {

			console.log(canvas);
			if (scapSafari) {
				console.log("generatingCanvasDownload - scapSafari");
				var scap = canvas.toDataURL();
				$('#scap-safari-src').attr('src',scap);
				$('#scap-modal').css('display','block');
				$('#tmp_capture').remove();
				$('#final').html('');
				$('#final').css({display:'none'});
			}else{
				console.log("generatingCanvasDownload - not scapSafari");
				var link = document.createElement('a');
				document.body.appendChild(link);
				link.setAttribute("type", "hidden");
				link.setAttribute("id", "tmpClick");
				link.download = Date.now() + '.png';
				link.href = canvas.toDataURL();
				link.click();
				$('#tmpClick').remove();
				$('#final').html('');
				$('#final').css({display:'none'});
			}

		}
	});

	// reset things 
	$('.thread').find(".post").removeClass('screen-menu-clicked');
	$('.thread').find(".intro").find("#glyphicon-capture").remove();
	$('#grab').text("["+_("Screencap")+"]");
	timeoutdelay = 1000;
	youtubeUriCount = 0;
    }
 

    $('#grab').click(function() {

		console.log("grab image");
		if($('#grab').text() == '[Capturing...]' || $('#grab').text() == '[Capturing all...]'){
			return;
		}
		//check if screen capture was clicked then proceed to 
		if($('#final').width()>0){
			 console.log("grab image - if");
			$('#grab').text("[Capturing...]");
			typePost= "perpost";
		}
		else{
			console.log("grab image - else");
			$('#grab').text("[Capturing all...]");
	                var thread_tmp = $('.thread').html();
        	        $('#final').html('');
			$('#final').append(thread_tmp);
			captured_all = true;
			timeoutdelay = getBase64();
			$('#final').find('.own_post').remove();
			typePost = "all";
		}
		var dmn = window.location.href.split('//');
		dmn = dmn[1].split('/')[0] + '/' + dmn[1].split('/')[1];
		var maxWithdiv = setDivWidth(typePost) + 15;
		var location = '<div style="clear: both;"></div><div style="width:'+maxWithdiv+'px;float:left;margin-right:15px;margin-bottom:4px;font-size:18px;color:'+$('body').css('color')+';background-color:'+$('body').css('backgroundColor')+';"><div style="float:right"><center><img src="' + scapLogo + '" style="width:73px;height:48px;"><br>' + dmn + '</center></div></div>';
		$('#final').append(location);

		$('#final').css({'display':'block'});
		if(scapSafari){
			console.log("grab image safari");
			$('body').append("<div id='tmp_capture'>"+$('#final').html()+"</div>");//this line is working only in safari
		}

		/*
		- FOR SCREEN CAPTURE ALL
		- count how many youtube url images
			example youtube images (integer): 5 images 
			computation:
				settimeout = 5 * 1000
				settimeout = 5000

		- if youtube images greater than  zero
			then: proceed to setTimeOut process
			else: set 1000 default setTiimeout process
				 
		*/
		console.log("grab image finished");
		setTimeout(function() {

			generatingCanvasDownload(scapSafari,typePost);

		}, timeoutdelay);

    });
    /*$(window).on('keyup', function(e) { if (e.keyCode == 44) $('#grab').trigger('click') });*/
});
/*show rotating boards as an option, but keep as default. Show and Hide feature of trending boards on the top panel and option menu*/
$(document).ready(function(){
        if (!localStorage.show_recommendedboards) localStorage.show_recommendedboards = 'true';
        $('#show_top_boards').parent().after('<div><label id="show_recommended_boards"><input type="checkbox">' + _("  Show trending boards") + '</label></div>');
        if (localStorage.show_recommendedboards === 'true') {
		$('#show_recommended_boards>input').prop('checked', true);
		$('.sub[data-description="1"]').show();
	} else {
		$('#show_recommended_boards>input').prop('checked', false);
                $('.sub[data-description="1"]').hide();
	}
	$('#show_recommended_boards>input').on('click', function() {
                if ($('#show_recommended_boards>input').is(':checked')) {
                        localStorage.show_recommendedboards = 'true';
                        $('.sub[data-description="1"]').show();
                } else {
                        localStorage.show_recommendedboards = 'false';
                        $('.sub[data-description="1"]').hide();
                }
        });
});
/*fold create new thread in catalog*/
$('document').ready(function () {
  createThreadShowing = false;
  $('.show-create-thread-catalog').on("click",function() {
    if (!createThreadShowing) {
      $('.show-create-thread-catalog').html('['+_('Create a thread')+']');
      $('#create-thread-catalog').css('display', 'table');
      createThreadShowing = true;
    } else {
      $('.show-create-thread-catalog').html('['+_('Create a thread')+']');
      $('#create-thread-catalog').css('display', 'none');
      createThreadShowing = false;
    }
    return false;
  });
});
/*Pepe Colored Quotes*/
$(document).ready(function(){
        if (!localStorage.pepe_coloredquotes) localStorage.pepe_coloredquotes = 'false';

        $('#youtube-size').parent().before('<div><label id="pepe_colored_quotes"><input type="checkbox">' + _("  Pepe colored quotes") + '</label></div>');

        if (localStorage.pepe_coloredquotes === 'true') {
                $('#pepe_colored_quotes>input').prop('checked', true);
		$("body").find('.quote').toggleClass('quote quote_checked');
        } else {
                $('#pepe_colored_quotes>input').prop('checked', false);
		$("body").find('.quote_checked').toggleClass('quote_checked quote');
        }
        $('#pepe_colored_quotes>input').on('click', function() {
                if ($('#pepe_colored_quotes>input').is(':checked')) {
                        localStorage.pepe_coloredquotes = 'true';
			$("body").find('.quote').toggleClass('quote quote_checked');
                } else {
                        localStorage.pepe_coloredquotes = 'false';
			$("body").find('.quote_checked').toggleClass('quote_checked quote');
                }
        });

});
// ==UserScript==
// @name          Save As Filename Fix
// @namespace     http://www.grauw.nl/projects/pc/greasemonkey/
// @description   Fixes 'Save as original filename' function
// @include     https*//8kun.top/*
// @include     http*//8kun.top/*
// ==/UserScript==
$(function() {
  $("a[download]").each(function() { var url = $(this).attr('href'); $(this).attr('href', url.replace('media.', '').replace('media2.','')); });

  $("a[download]").each(function() {
          var url = $(this).attr('href');
          var filenamedownload = $(this).text();
          $(this).attr('href', url.replace('//8kun.top', '//media.8kun.top'));
  });


  $("a[download]").each(function() {
          var url = $(this).attr('href');
	  url = url.replace('/file_store/', '/file_dl/');
	  url = url.replace('/src/', '/file_dl/');
	  url = url.replace(/\s/g, '_');
          $(this).attr('href', url);
  });

});
$('document').ready(function () {

        $(document).on('click', '#captcha_pop_submit', function(e) {
		var tos_agree = $('input[name="tos_agree"]:checked').length > 0;
		
		if(tos_agree === true){	
                	var captcha_text = $('#captcha_main_box').find('.captcha_text').val();
                	var captcha_cookie = $('#captcha_main_box').find('.captcha_cookie').val();
			var url_captcha_submit = "";
                	if (window.document.location.protocol == 'https:') {
                        	url_captcha_submit = "//sys.8kun.top/dnsbls_bypass_popup.php";
                	}
                	else{
                        	url_captcha_submit = "//sys.8kun.top/dnsbls_bypass_popup.php";
                	}
                	$.ajax({
				type: 'POST',
                        	url: url_captcha_submit,
				xhrFields: {withCredentials: true},
                        	context: document.body,
				data: {captcha_text : captcha_text, captcha_cookie : captcha_cookie},
				crossDomain : true,
                        	success: function(data) {
					var jsonResp = JSON.parse(data);
					if(jsonResp['status'] == 1){
						$('#captcha_main_box').html(jsonResp['message']);
						$('#alert_close').click();
					}
					else{
						$('#captcha_message_box').html(jsonResp['message']);
						$('#captcha_objects').html(jsonResp['new_captcha']);
					}

                        	}
                	});
		}
	
        });

	$(document).on('keyup', '.captcha_text', function(e) {
                if(e.which === 13) {
                        $('#captcha_pop_submit').trigger('click');
                }
        });

});
function timeSince(date) {
    var seconds = Math.floor((new Date).getTime()/1000) - date;
    var interval = Math.floor(seconds / 31536000);

  if (interval > 1) {
    return interval + " year/s ago";
  }
  //interval = Math.floor(seconds / 2592000);
  interval = (seconds / 2592000);
  if (interval > 1) {
    return Math.floor(interval) + " month/s ago";
  }
  //interval = Math.floor(seconds / 86400);
  interval = (seconds / 86400);
  if (interval > 1) {
    return Math.floor(interval) + " day/s ago";
  }
  //interval = Math.floor(seconds / 3600);
  interval = (seconds / 3600);
  if (interval > 1) {
    return Math.floor(interval) + " hour/s ago";
  }
  //interval = Math.floor(seconds / 60);
  interval = (seconds / 60);
  if (interval > 1) {
    return Math.floor(interval) + " minute/s ago";
  }
  return Math.floor(seconds) + " seconds ago";
}

$(document).ready(function() {
  if (active_page == 'page_123') {
    $('.vello-time').each(function() {
      var curr = $(this).text();
      $(this).text(timeSince(curr));
    });

    window.setInterval(function() {
      $.ajax({
        url: '/templates/nrecent.html',
        success: function(data) {
          var content = $(data).find('ul').html();
          $("div#recent_main").find("section").find("ul").html(content);
          $('.vello-time').each(function() {
            var curr = $(this).text();
            $(this).text(timeSince(curr));
          });
        }
      });
    }, 15000);
  }
});
/*Announcement preview*/
$('document').ready(function () {
  $('#preview-announcement').on("click",function() {
    var blotter = $("input[name=blotter]").val();
    localStorage.preview_blotter = blotter;
//    $(location).attr('href', '/mod.php?/preview/newest');
  });

  $(".blotterpreview").html(localStorage.preview_blotter);
});
$(document).ready(function(){

        //*Auto clear post fields
        if (!localStorage.auto_clear_post_fields) localStorage.auto_clear_post_fields = 'false';
        $('#auto-update-fs').append('<label id="auto_clear_post_fields"><input type="checkbox">' + _("  Auto clear fields") + '</label>');
        if (localStorage.auto_clear_post_fields === 'true') {
                $('#auto_clear_post_fields>input').prop('checked', true);
        } else {
                $('#auto_clear_post_fields>input').prop('checked', false);
        }
        $('#auto_clear_post_fields>input').on('click', function() {
                if ($('#auto_clear_post_fields>input').is(':checked')) {
                        localStorage.auto_clear_post_fields = 'true';
                } else {
                        localStorage.auto_clear_post_fields = 'false';
                }
        });

});

if (active_page == 'thread' || active_page == 'index') {
  $(document).ready(function(){

    function thumb_embed_generator(embed_site,embed_id,embed_params,api_uri){

      $.ajax({
        url: api_uri+embed_params,
        data: "",
        type: 'GET',
        crossDomain: true,
        dataType: 'json',
        success: function(data) {
          $("#"+embed_id).attr("src",data.thumbnail_url);
          $("#"+embed_id).css({"width":"200px"});
        },
        error: function() { console.log("cant load "+embed_site+" api") },
      });

    }

    $(".vimeo_thumb").each(function() {
      var api_vimeo_uri = 'https://vimeo.com/api/oembed.json?url=https://vimeo.com/';
      var embed_vimeo_id = $(this).attr('id');
      var embed_vimeo_params = $(this).data('params');
      if(embed_vimeo_id!=null){
        thumb_embed_generator("vimeo",embed_vimeo_id,embed_vimeo_params,api_vimeo_uri);
      }
    });


    $(".dailymotion_thumb").each(function() {
      var proxy_url = '/proxy_embed.php?url=';
      var embed_dailymotion_id = $(this).attr('id');
      var embed_dailymotion_params = $(this).data('params');
      if(embed_dailymotion_id!=null){
        thumb_embed_generator("dailymotion",embed_dailymotion_id,embed_dailymotion_params,proxy_url);
      }
    });

/*
    $(".dailymotion_thumb").each(function() {
      var api_dailymotion_uri = 'https://www.dailymotion.com/services/oembed?url=';
      var embed_dailymotion_id = $(this).attr('id');
      var embed_dailymotion_params = $(this).data('params');
      if(embed_dailymotion_id!=null){
        thumb_embed_generator("dailymotion",embed_dailymotion_id,embed_dailymotion_params,api_dailymotion_uri);
      }
    });
*/

    $(".streamable_thumb").each(function() {
      var api_streamable_uri = 'https://api.streamable.com/oembed.json?url=';
      var embed_streamable_id = $(this).attr('id');
      var embed_streamable_params = $(this).data('params');
      if(embed_streamable_id!=null){
        thumb_embed_generator("streamable",embed_streamable_id,embed_streamable_params,api_streamable_uri);
      }
    });


  });
}
$(document).ready(function(){
        //Stub hide/show options
        if (!localStorage.stub_hide_post) localStorage.stub_hide_post = 'false';
        $('#youtube-size').parent().before('<div><label id="stub_hide_post_label"><input type="checkbox">' + _("  Unhide stub when hiding post") + '</label></div>');
        if (localStorage.stub_hide_post === 'true') {
                $('#stub_hide_post_label>input').prop('checked', true);
        } else {
                $('#stub_hide_post_label>input').prop('checked', false);
        }
        $('#stub_hide_post_label>input').on('click', function() {
            console.log("test");
               if ($('#stub_hide_post_label>input').is(':checked')) {
                        localStorage.stub_hide_post = 'true';
                } else {
                        localStorage.stub_hide_post = 'false';
                }
        });
});
window.rgbHex = (function() {
    function isNumeric(arg) {
        return !isNaN(parseFloat(arg)) && isFinite(arg);
    }

    function trim(arg) {
        return arg.replace(/^\s+|\s+$/g, "");
    }

    function isRgb(arg) {
        arg = trim(arg);
        return isNumeric(arg) && arg >= 0 && arg <= 255;
    }
    
    function isHex(arg) {
        return (/^[0-9a-f]{3}$|^[0-9a-f]{6}$/i).test(trim(arg));
    }

    function rgbToHex(arg) {
        arg = parseInt(arg, 10).toString(16);
        return arg.length === 1 ? '0' + arg : arg; 
    }

    function hexToRgb(arg) {
        return parseInt(arg, 16).toString();
    }

    function processRgb(arg) {
        arg = arg.split(',');

        if ( (arg.length === 3 || arg.length === 4) && isRgb(arg[0]) && isRgb(arg[1]) && isRgb(arg[2]) ) {
            if (arg.length === 4 && !isNumeric(arg[3])) { return null; }
            return '#' + rgbToHex(arg[0]).toUpperCase() + rgbToHex(arg[1]).toUpperCase() + rgbToHex(arg[2]).toUpperCase();
        }
        else {
            return null;
        }
    }

    function processHex(arg) {
        if (isHex(arg)) {
            if (arg.length === 3) { arg = arg.charAt(0) + arg.charAt(0) + arg.charAt(1) + arg.charAt(1) + arg.charAt(2) + arg.charAt(2); }

            return 'rgb(' + hexToRgb(arg.substr(0,2)) + ',' + hexToRgb(arg.substr(2,2)) + ',' + hexToRgb(arg.substr(4,2)) + ')';
        }
    }

    function removeWhitespace(arg) {
        return arg.replace(/\s/g, '');
    }

    return function(arg) {        
        if(!arg) { return null; }

        var code = null,
            rgbRegex = /^rgba?\((.*)\);?$/,
            hexRegex = /^#/;
            
        arg = trim(arg.toString());
        
        if (arg === 'transparent' || removeWhitespace(arg) === 'rgba(0,0,0,0)') {
            return 'transparent';
        }
        else if (rgbRegex.test(arg)) {
            return processRgb(arg.match(rgbRegex)[1]);
        }
        else if (hexRegex.test(arg)) {
            return processHex(arg.split('#').reverse()[0]);
        }
        //try to parse the string without rgb or #
        else {
            code = arg.split(',');

            if (code.length === 1) { return processHex(arg); }
            else if (code.length === 3 || code.length === 4) { return processRgb(arg); }
        }
    };
})();

if(jQuery) {
    jQuery.extend({
        rgbHex: function(arg) { return window.rgbHex(arg); }
    });
}
//     keymaster.js
//     (c) 2011-2013 Thomas Fuchs
//     keymaster.js may be freely distributed under the MIT license.

;(function(global){
  var k,
    _handlers = {},
    _mods = { 16: false, 18: false, 17: false, 91: false },
    _scope = 'all',
    // modifier keys
    _MODIFIERS = {
      '⇧': 16, shift: 16,
      '⌥': 18, alt: 18, option: 18,
      '⌃': 17, ctrl: 17, control: 17,
      '⌘': 91, command: 91
    },
    // special keys
    _MAP = {
      backspace: 8, tab: 9, clear: 12,
      enter: 13, 'return': 13,
      esc: 27, escape: 27, space: 32,
      left: 37, up: 38,
      right: 39, down: 40,
      del: 46, 'delete': 46,
      home: 36, end: 35,
      pageup: 33, pagedown: 34,
      ',': 188, '.': 190, '/': 191,
      '`': 192, '-': 189, '=': 187,
      ';': 186, '\'': 222,
      '[': 219, ']': 221, '\\': 220
    },
    code = function(x){
      return _MAP[x] || x.toUpperCase().charCodeAt(0);
    },
    _downKeys = [];

  for(k=1;k<20;k++) _MAP['f'+k] = 111+k;

  // IE doesn't support Array#indexOf, so have a simple replacement
  function index(array, item){
    var i = array.length;
    while(i--) if(array[i]===item) return i;
    return -1;
  }

  // for comparing mods before unassignment
  function compareArray(a1, a2) {
    if (a1.length != a2.length) return false;
    for (var i = 0; i < a1.length; i++) {
        if (a1[i] !== a2[i]) return false;
    }
    return true;
  }

  var modifierMap = {
      16:'shiftKey',
      18:'altKey',
      17:'ctrlKey',
      91:'metaKey'
  };
  function updateModifierKey(event) {
      for(k in _mods) _mods[k] = event[modifierMap[k]];
  };

  // handle keydown event
  function dispatch(event) {
    var key, handler, k, i, modifiersMatch, scope;
    key = event.keyCode;

    if (index(_downKeys, key) == -1) {
        _downKeys.push(key);
    }

    // if a modifier key, set the key.<modifierkeyname> property to true and return
    if(key == 93 || key == 224) key = 91; // right command on webkit, command on Gecko
    if(key in _mods) {
      _mods[key] = true;
      // 'assignKey' from inside this closure is exported to window.key
      for(k in _MODIFIERS) if(_MODIFIERS[k] == key) assignKey[k] = true;
      return;
    }
    updateModifierKey(event);

    // see if we need to ignore the keypress (filter() can can be overridden)
    // by default ignore key presses if a select, textarea, or input is focused
    if(!assignKey.filter.call(this, event)) return;

    // abort if no potentially matching shortcuts found
    if (!(key in _handlers)) return;

    scope = getScope();

    // for each potential shortcut
    for (i = 0; i < _handlers[key].length; i++) {
      handler = _handlers[key][i];

      // see if it's in the current scope
      if(handler.scope == scope || handler.scope == 'all'){
        // check if modifiers match if any
        modifiersMatch = handler.mods.length > 0;
        for(k in _mods)
          if((!_mods[k] && index(handler.mods, +k) > -1) ||
            (_mods[k] && index(handler.mods, +k) == -1)) modifiersMatch = false;
        // call the handler and stop the event if neccessary
        if((handler.mods.length == 0 && !_mods[16] && !_mods[18] && !_mods[17] && !_mods[91]) || modifiersMatch){
          if(handler.method(event, handler)===false){
            if(event.preventDefault) event.preventDefault();
              else event.returnValue = false;
            if(event.stopPropagation) event.stopPropagation();
            if(event.cancelBubble) event.cancelBubble = true;
          }
        }
      }
    }
  };

  // unset modifier keys on keyup
  function clearModifier(event){
    var key = event.keyCode, k,
        i = index(_downKeys, key);

    // remove key from _downKeys
    if (i >= 0) {
        _downKeys.splice(i, 1);
    }

    if(key == 93 || key == 224) key = 91;
    if(key in _mods) {
      _mods[key] = false;
      for(k in _MODIFIERS) if(_MODIFIERS[k] == key) assignKey[k] = false;
    }
  };

  function resetModifiers() {
    for(k in _mods) _mods[k] = false;
    for(k in _MODIFIERS) assignKey[k] = false;
  };

  // parse and assign shortcut
  function assignKey(key, scope, method){
    var keys, mods;
    keys = getKeys(key);
    if (method === undefined) {
      method = scope;
      scope = 'all';
    }

    // for each shortcut
    for (var i = 0; i < keys.length; i++) {
      // set modifier keys if any
      mods = [];
      key = keys[i].split('+');
      if (key.length > 1){
        mods = getMods(key);
        key = [key[key.length-1]];
      }
      // convert to keycode and...
      key = key[0]
      key = code(key);
      // ...store handler
      if (!(key in _handlers)) _handlers[key] = [];
      _handlers[key].push({ shortcut: keys[i], scope: scope, method: method, key: keys[i], mods: mods });
    }
  };

  // unbind all handlers for given key in current scope
  function unbindKey(key, scope) {
    var multipleKeys, keys,
      mods = [],
      i, j, obj;

    multipleKeys = getKeys(key);

    for (j = 0; j < multipleKeys.length; j++) {
      keys = multipleKeys[j].split('+');

      if (keys.length > 1) {
        mods = getMods(keys);
      }

      key = keys[keys.length - 1];
      key = code(key);

      if (scope === undefined) {
        scope = getScope();
      }
      if (!_handlers[key]) {
        return;
      }
      for (i = 0; i < _handlers[key].length; i++) {
        obj = _handlers[key][i];
        // only clear handlers if correct scope and mods match
        if (obj.scope === scope && compareArray(obj.mods, mods)) {
          _handlers[key][i] = {};
        }
      }
    }
  };

  // Returns true if the key with code 'keyCode' is currently down
  // Converts strings into key codes.
  function isPressed(keyCode) {
      if (typeof(keyCode)=='string') {
        keyCode = code(keyCode);
      }
      return index(_downKeys, keyCode) != -1;
  }

  function getPressedKeyCodes() {
      return _downKeys.slice(0);
  }

  function filter(event){
    var tagName = (event.target || event.srcElement).tagName;
    // ignore keypressed in any elements that support keyboard data input
    return !(tagName == 'INPUT' || tagName == 'SELECT' || tagName == 'TEXTAREA');
  }

  // initialize key.<modifier> to false
  for(k in _MODIFIERS) assignKey[k] = false;

  // set current scope (default 'all')
  function setScope(scope){ _scope = scope || 'all' };
  function getScope(){ return _scope || 'all' };

  // delete all handlers for a given scope
  function deleteScope(scope){
    var key, handlers, i;

    for (key in _handlers) {
      handlers = _handlers[key];
      for (i = 0; i < handlers.length; ) {
        if (handlers[i].scope === scope) handlers.splice(i, 1);
        else i++;
      }
    }
  };

  // abstract key logic for assign and unassign
  function getKeys(key) {
    var keys;
    key = key.replace(/\s/g, '');
    keys = key.split(',');
    if ((keys[keys.length - 1]) == '') {
      keys[keys.length - 2] += ',';
    }
    return keys;
  }

  // abstract mods logic for assign and unassign
  function getMods(key) {
    var mods = key.slice(0, key.length - 1);
    for (var mi = 0; mi < mods.length; mi++)
    mods[mi] = _MODIFIERS[mods[mi]];
    return mods;
  }

  // cross-browser events
  function addEvent(object, event, method) {
    if (object.addEventListener)
      object.addEventListener(event, method, false);
    else if(object.attachEvent)
      object.attachEvent('on'+event, function(){ method(window.event) });
  };

  // set the handlers globally on document
  addEvent(document, 'keydown', function(event) { dispatch(event) }); // Passing _scope to a callback to ensure it remains the same by execution. Fixes #48
  addEvent(document, 'keyup', clearModifier);

  // reset modifiers to false whenever the window is (re)focused.
  addEvent(window, 'focus', resetModifiers);

  // store previously defined key
  var previousKey = global.key;

  // restore previously defined key and return reference to our key object
  function noConflict() {
    var k = global.key;
    global.key = previousKey;
    return k;
  }

  // set window.key and window.key.set/get/deleteScope, and the default filter
  global.key = assignKey;
  global.key.setScope = setScope;
  global.key.getScope = getScope;
  global.key.deleteScope = deleteScope;
  global.key.filter = filter;
  global.key.isPressed = isPressed;
  global.key.getPressedKeyCodes = getPressedKeyCodes;
  global.key.noConflict = noConflict;
  global.key.unbind = unbindKey;

  if(typeof module !== 'undefined') module.exports = assignKey;

})(this);

(function($) {
	function ColorPicker(el, options) {
		this.$el = $(el);
		this.options = options;
		this.init = false;

		this.generate();
	}
		
	ColorPicker.prototype = {
		generate: function() {
			var _this = this;
			var colorchooser, gradientchooser, contexts, id, common, resizing = false, ci = 0;

			if (!this.$colorPicker) {
				// input and target holders
				this.$colorTarget = $('<div class="wColorPicker-color-target"></div>');
				this.$customInput = $('<input type="text" class="wColorPicker-custom-input"/>').keyup($.proxy(this._customInputKeyup, this));

				this.$colorChooser = $('<canvas id="colorchooser" height="142" width="339" style="border:1px solid black"></canvas>');
				this.$gradientChooser = $('<canvas id="gradientchooser" height="142" width="20" style="border:1px solid black"></canvas>');
				this.$commonHistory = $('<table id="commonhistory">'+
						'<tr id="common"><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td rowspan="3" class="ignore" id="curcolor"></td></tr>'+
						'<tr id="commonbw"><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr>'+
						'<tr id="history"><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td></tr>'+
						'</table>');
				this.$colorChosen =	$('<table id="colorchosen">'+
						'<tr class="rgb"><td>'+_('R')+' <span class="r">255</span></td><td>'+_('G')+' <span class="g">255</span></td><td>'+_('B')+' <span class="b">255</span></td><td rowspan="2" class="colorpicker-buttons"><button value="white">HSV</button><button value="black">HVS</button><button value="both">'+_('Both')+'</button><button value="flip">'+_('Flip')+'</button></td></tr>'+
						'<tr class="hsv"><td>H <span class="h"></span></td><td>S <span class="s"></span></td><td>V <span class="v"></span></td></tr>'+
						'</table>');
				this.$containerDiv = $('<div class="wColorPicker" title=""></div>')
				.append(this.$colorChooser)
				.append(this.$gradientChooser)
				.append(this.$commonHistory)
				.append(this.$colorChosen);

				if (this.options.dropperButton) { this.$dropperButton = this._createDropperButton(); }

				// the Palettes holder is to enforce size of color picker for effects so no weird bunching up happens when we change sizes
				this.$colorPickerPalettesHolder = $('<div class="wColorPicker-palettes-holder"></div>')
				.append(this.$containerDiv)
				.append(this.$dropperButton);

				// the holder is what we will use on some effects, rather than the pallettes holder which need to remain the same size
				this.$colorPickerHolder = $('<div class="wColorPicker-holder"></div>').append(this.$colorPickerPalettesHolder);
				
				// store our bg independantly this is due to a bug with opacities showing up oddly 
				this.$colorPickerBg = $('<div class="wColorPicker-bg"></div>');

				// put everything into the color picker
				// make sure title="" here otherwise title from button will appear
				this.$colorPicker = $('<div class="wColorPicker" title=""></div>')
				.append(this.$colorPickerBg).append(this.$colorPickerHolder);

				// set some properties
				this.setColor(this.options.color);
				this.setTheme(this.options.theme);

				// get proper width/height and keep it for reference (needed for effects)
				$('body').append(this.$colorPicker);
				this.width = this.$colorPickerPalettesHolder.width();
				this.height = this.$colorPickerPalettesHolder.height();

				// append the color picker properly
				this.$el.append(this.$colorPicker);

				// set mode after to get proper dimensions
				// if hidden will not get proper dimensions
				this.setMode(this.options.mode);

				// call after we have our proper dimensions set
				// setPosition will call setEffect
				this.setPosition(this.options.position);

				colorchooser = this.$colorChooser[0];
				gradientchooser = this.$gradientChooser[0];
				this.contexts = new Object;
				this.curmode = '';
				this.leftButtonDown = false;
				this.contexts.colorchooser = {element: colorchooser, context: colorchooser.getContext("2d")};
				this.contexts.gradientchooser = {element: gradientchooser, context: gradientchooser.getContext("2d")};
				id = this._buildImageData(this.contexts.colorchooser, "both");
				this.contexts.colorchooser.context.putImageData(id, 0, 0);

				common = this.$commonHistory.find('#common td:not(.ignore)');
				$.each(common, function(k, v) {
					var rgb = _this._HSVtoRGB((ci/(common.length-1)), 1, 1);
					$(this).css('background-color', 'rgb('+rgb.r+','+rgb.b+','+rgb.g+')');
					var bw = ((ci/(common.length-1))*255).toFixed();
					_this.$commonHistory.find('#commonbw td:eq('+ci+')').css('background-color', 'rgb('+bw+','+bw+','+bw+')');
					ci++;
				});

				this.$colorPicker.mousedown(function(e){
					if (e.which === 1) _this.leftButtonDown = true;
				});

				this.$colorPicker.mouseup(function(e){
					if (e.which === 1) _this.leftButtonDown = false;
				});

				this.$colorPicker.mouseout(function(e){
					_this.leftButtonDown = false;
				});

				var handleColorChange = function(e){
					if (resizing) return;
					var x = e.offsetX, y = e.offsetY;
					var cure = $(this).attr('id');
					if (!_this.leftButtonDown && e.type !== 'click') return;

					if (!x) {
						x = (e.clientX - this.getBoundingClientRect().left).toFixed();
						y = (e.clientY - this.getBoundingClientRect().top).toFixed();
					}
				
					var color = _this.contexts[cure].context.getImageData(x,y,1,1).data;

					if (e.type === 'click') {
						$(_this.$colorPicker).trigger('colornew', color);
					}

					if (_this.curmode === 'flip' && cure == 'gradientchooser') {
						var id = _this._buildImageData(_this.contexts.colorchooser, 'flipc', _this._RGBtoHSV.apply(null, color).h);
						_this.contexts.colorchooser.context.putImageData(id, 0, 0);
					} else if (_this.curmode != 'flip' && cure != 'gradientchooser') {
						_this._updateGradientCanvas(color);
					}

					$(_this.$colorPicker).trigger('colorchange', color);
				};

				this.$colorChooser.on('click mouseup mousemove', handleColorChange);
				this.$gradientChooser.on('click mouseup mousemove', handleColorChange);

				this.$colorChosen.find('.colorpicker-buttons>button').on('click', function(e) {
					e.preventDefault();
					var val = $(this).val()
					_this.curmode = val;
					_this._updateCanvas();
				});

				this.$commonHistory.find('tr').on('click', 'td', function(e) {
					var rgb, color;
					rgb = $(this).css('background-color').match(/rgb\((\d+), ?(\d+), ?(\d+)\)/);
					if (!rgb) return;
					color = rgb.map(function(v) {return parseInt(v)}).filter(function(v){return !isNaN(v)});
					$(_this.$colorPicker).trigger('colorchange', color);
					$(_this.$colorPicker).trigger('colornew', color);
				});

				this.$colorPicker.on('colorchange', function(e, r, g, b, a) {
					var hsv = _this._RGBtoHSV(r,g,b);
					var cc = _this.$colorChosen;					

					cc.find('.r').text(r);
					cc.find('.g').text(g);
					cc.find('.b').text(b);
					cc.find('.h').text(Math.round(hsv.h*360));
					cc.find('.s').text(hsv.s.toFixed(2));
					cc.find('.v').text(hsv.v.toFixed(2));
				});

				this.$colorPicker.on('colornew', function(e, r, g, b, a) {
					var newtd = $('<td></td>');
					var history = _this.$commonHistory.find('#history');
					newtd.css('background-color', 'rgb('+r+', '+g+', '+b+')');
					history.prepend(newtd);
					history.find('td:last').remove();
				});

				this.$colorPicker.on('colorchange', function(e, r, g, b, a) {
					_this.$commonHistory.find('#curcolor').css('background-color', 'rgb('+r+', '+g+', '+b+')');
				});

				this.$colorPicker.on('colorchange', function(e, r, g, b, a) {
					_this.setColor(window.rgbHex([r, g, b]));
				});
			}

			this.init = true;

			return this;
		},

		/************************************
		 * Setters
		 ************************************/

		setTheme: function(theme) {
			this.$colorPicker.attr('class', this.$colorPicker.attr('class').replace(/wColorPicker-theme-.+\s|wColorPicker-theme-.+$/, ''));
			this.$colorPicker.addClass('wColorPicker-theme-' + theme);
		},

		setOpacity: function(opacity) {
			this.$colorPickerBg.css('opacity', opacity);
		},

		setColor: function(color) {
			if (!window.rgbHex(color)) { return true; }

			this.options.color = color;
			this.$colorTarget.css('backgroundColor', color);
			this.$customInput.val(color);

			if (this.init && this.options.onSelect) { this.options.onSelect.apply(this, [color]); }
		},

		setMode: function(mode) {
			var _this = this,
					showFunc = function(){ _this._toggleEffect('show'); },
					hideFunc = function(){ _this._toggleEffect('hide'); };

			if (mode === 'flat') { this.$colorPicker.removeClass('wColorPicker-zindex').css({position:'relative', display:''}); }
			else { this.$colorPicker.addClass('wColorPicker-zindex').css({position:'absolute'}).hide(); }

			// incase button needs to be reset
			this.$el.find('wColorPicker-button').remove();
			this.$el.unbind('mouseenter', showFunc).unbind('mouseleave', hideFunc);
			$(document).unbind('click', hideFunc);

			// regenerate button
			if (mode !== 'flat') {
				var $button = null,
						$buttonColor = null,
						func = function(e) {
							e.stopPropagation();
							if(_this.options.generateButton) { $buttonColor.css('backgroundColor', _this.options.color); }
							_this._toggleEffect();
						};

				if(this.options.generateButton) {
					$button = $('<div class="wColorPicker-button"></div>');
					$buttonColor = $('<div class="wColorPicker-button-color"></div>').css('backgroundColor', this.options.color);

					this.$el.append($button);
					$button.append($buttonColor.height(this.$el.height() - $button.outerHeight(true)));
				}

				// toggle effect if palette is clicked
				/*this.$noneColorPalette.bind('click', func);
				this.$simpleColorPalette.bind('click', func);
				this.$mixedColorPalette.bind('click', func);*/
			}

			// regenerate events
			if (mode === 'click') {
				this.$el.click(function(e){
					_this._toggleEffect();
					e.stopPropagation(); // so doc event doesn't run
				});

				this.$colorPicker.click(function(e){ e.stopPropagation(); });
				$(document).bind('click', hideFunc);
			}
			else if (mode === 'hover') {
				this.$el.bind('mouseenter', showFunc).bind('mouseleave', hideFunc);
			}
		},

		setEffect: function(effect) {
			if (this.options.mode === 'flat') { return true; }

			// reset
			this.$colorPicker.css('opacity', 1);
			this.$colorPickerHolder.width(this.width).height(this.height);

			if (effect === 'fade') {
				this.$colorPicker.css('opacity', 0);
			}
			else if (effect === 'slide') {
				this.$colorPickerHolder
				.width(this.positionAxis === 'x' ? 0 : this.width)
				.height(this.positionAxis === 'y' ? 0 : this.height);
			}
		},

		setPosition: function(position) {
			if (this.options.mode === 'flat') { return true; }

			var elWidth = this.$el.outerWidth(),
					elHeight = this.$el.outerHeight(),
					center = (this.$el.outerWidth()/2) - (this.$colorPicker.outerWidth()/2),
					middle = (this.$el.outerHeight()/2) - (this.$colorPicker.outerHeight()/2),
					css = {left:'', right:'', top:'', bottom:''},
					firstChar = this.options.position.charAt(0);

			// so we know which way to do our slide effects
			if (firstChar === 't' || firstChar === 'b') { this.positionAxis = 'y'; }
			else if(firstChar === 'l' || firstChar === 'r') { this.positionAxis = 'x'; }

			switch (position) {
				case 'tl': css.left=0;        css.bottom=elHeight; break;
				case 'tc': css.left=center;   css.bottom=elHeight; break;
				case 'tr': css.right=0;       css.bottom=elHeight; break;
				case 'rt': css.left=elWidth;  css.top=0;           break;
				case 'rm': css.left=elWidth;  css.top=middle;      break;
				case 'rb': css.left=elWidth;  css.bottom=0;        break;
				case 'br': css.right=0;       css.top=elHeight;    break;
				case 'bc': css.left=center;   css.top=elHeight;    break;
				case 'bl': css.left=0;        css.top=elHeight;    break;
				case 'lb': css.right=elWidth; css.bottom=0;        break;
				case 'lm': css.right=elWidth; css.top=middle;      break;
				case 'lt': css.right=elWidth; css.top=0;           break;
			}

			this.$colorPicker.css(css);
			this.setEffect(this.options.effect);
		},

		/************************************
		 * Components
		 ************************************/

		// From http://axonflux.com/handy-rgb-to-hsl-and-rgb-to-hsv-color-model-c
		_HSVtoRGB: function(h, s, v) {
			var r, g, b, i, f, p, q, t;
			if (h && s === undefined && v === undefined) {
				s = h.s, v = h.v, h = h.h;
			}
			i = Math.floor(h * 6);
			f = h * 6 - i;
			p = v * (1 - s);
			q = v * (1 - f * s);
			t = v * (1 - (1 - f) * s);
			switch (i % 6) {
				case 0: r = v, g = t, b = p; break;
				case 1: r = q, g = v, b = p; break;
				case 2: r = p, g = v, b = t; break;
				case 3: r = p, g = q, b = v; break;
				case 4: r = t, g = p, b = v; break;
				case 5: r = v, g = p, b = q; break;
			}
			return {
				r: Math.floor(r * 255),
				g: Math.floor(g * 255),
				b: Math.floor(b * 255)
			};
		},
		_RGBtoHSV: function(r, g, b){
			r = r/255, g = g/255, b = b/255;
			var max = Math.max(r, g, b), min = Math.min(r, g, b);
			var h, s, v = max;

			var d = max - min;
			s = max == 0 ? 0 : d / max;

			if (max == min) {
				h = 0; // achromatic
			} else {
				switch (max) {
					case r: h = (g - b) / d + (g < b ? 6 : 0); break;
					case g: h = (b - r) / d + 2; break;
					case b: h = (r - g) / d + 4; break;
				}
				h /= 6;
			}

			return {
				h: h, 
				s: s, 
				v: v
			};
		},

		_buildImageData: function(c, mode, static) {
			var pi = 0, rgb, hh, id, d

			var w = c.element.width;
			var h = c.element.height;
			var id = c.context.createImageData(w,h);
			var d = id.data;

			var setImageData = function(rgb, pi) {
				id.data[4*pi] = rgb.r
				id.data[4*pi+1] = rgb.g
				id.data[4*pi+2] = rgb.b
				id.data[4*pi+3] = 255
			}

			for (ii = 0; ii < h; ii++) {
				for (i = 0; i < w; i++) {
					if (mode === "white") {
						rgb = this._HSVtoRGB(i/w, ii/h, 1);
					} else if (mode === "black") {
						rgb = this._HSVtoRGB(i/w, 1, 1-(ii/h));
					} else if (mode === "flip") {
						rgb = this._HSVtoRGB(ii/h, 1, 1);
					} else if (mode === "flipc") {
						if (i < w/2) {
							rgb = this._HSVtoRGB(static, i/(w/2), 1);
						} else {
							rgb = this._HSVtoRGB(static, 1, 2-(i/(w/2)));
						}
					} else { // both
						if (ii < h/2) {
							rgb = this._HSVtoRGB(i/w, ii/(h/2), 1);
						} else {
							rgb = this._HSVtoRGB(i/w, 1, 2-(ii/(h/2)));
						}
					}
					setImageData(rgb, pi);
					pi++
				}
			}

			return id;
		},

		_updateGradientCanvas: function(color) {
			var gradient = this.contexts.gradientchooser.context.createLinearGradient(0,0,0,this.contexts.gradientchooser.element.height);
			gradient.addColorStop(0, "white");
			gradient.addColorStop(0.5, "rgb("+color[0]+","+color[1]+","+color[2]+")");
			gradient.addColorStop(1, "black");
			this.contexts.gradientchooser.context.fillStyle=gradient;
			this.contexts.gradientchooser.context.fillRect(0,0,this.contexts.gradientchooser.element.width, this.contexts.gradientchooser.element.height);
		},

		_updateCanvas: function() {
			var targetcontext = this.curmode === 'flip' ? this.contexts.gradientchooser : this.contexts.colorchooser;
			var id = this._buildImageData(targetcontext, this.curmode);
			targetcontext.context.putImageData(id, 0, 0);
		},

		_createDropperButton: function() {
			return $('<div class="wColorPicker-dropper"></div>').click($.proxy(this.options.onDropper, this));
		},

		/************************************
		 * Effects
		 ************************************/

		_toggleEffect: function(toggle) {
			var visible = this.$colorPicker.hasClass('wColorPicker-visible');

			// to make sure some effects only occur on a certain state (to avoid an effect running twice and retoggling)
			if(
				!toggle ||
				(toggle === 'show' && visible === false) ||
				(toggle === 'hide' && visible === true)
			) {
				if(!visible) { this.setPosition(this.options.position); }
				this['_' + this.options.effect + 'Effect' + (visible ? 'Hide' : 'Show')]();
				this.$colorPicker.toggleClass('wColorPicker-visible');
			}
		},

		/* none */
		_noneEffectShow: function() {
			this.$colorPicker.css('display', 'inline-block');
		},

		_noneEffectHide: function() {
			this.$colorPicker.hide();
		},

		/* fade */
		_fadeEffectShow: function() {
			this.$colorPicker.stop(true, false).css({display:'inline-block'}).animate({opacity:1}, this.options.showSpeed);
		},

		_fadeEffectHide: function() {
			this.$colorPicker.stop(true, false).animate({opacity:0}, this.options.hideSpeed, $.proxy(function(){ this.$colorPicker.hide(); }, this));
		},

		/* slide */
		_slideEffectShow: function() {
			var animate = this.positionAxis === 'y' ? {height:this.height} : {width:this.width};

			this.$colorPicker.css('display', 'inline-block');
			this.$colorPickerHolder.stop(true, false).animate(animate, this.options.showSpeed);
		},

		_slideEffectHide: function() {
			var animate = this.positionAxis === 'y' ? {height:0} : {width:0};
			this.$colorPickerHolder.stop(true, false).animate(animate, this.options.hideSpeed, $.proxy(function(){ this.$colorPicker.hide(); }, this));
		}
	};

	$.fn.wColorPicker = function(options, value) {
		if (typeof options === 'string') {
			var values = [], wColorPicker = null, elements = null, func = null;
				
			elements = this.each(function() {
				wColorPicker = $(this).data('wColorPicker');

				if (wColorPicker) {
					func = (value ? 'set' : 'get') + options.charAt(0).toUpperCase() + options.substring(1).toLowerCase();

					if (wColorPicker[options]) {
						values.push(wColorPicker[options].apply(wColorPicker, [value]));
					}
					else if (value) {
						if (wColorPicker[func]) { wColorPicker[func].apply(wColorPicker, [value]); }
						if (wColorPicker.options[options]) { wColorPicker.options[options] = value; }
					}
					else {
						if(wColorPicker[func]) { values.push(wColorPicker[func].apply(wColorPicker, [value])); }
						else if (wColorPicker.options[options]) { values.push(wColorPicker.options[options]); }
						else { values.push(null); }
					}
				}
			});

			if (values.length === 1) { return values[0]; }
			else if (values.length > 0) { return values; }
			else { return elements; }
		}

		function get(el) {
			var _options,
					wColorPicker = $.data(el, 'wColorPicker');
			
			if (!wColorPicker) {
				_options = $.extend({}, $.fn.wColorPicker.defaults, options);
				_options.color = window.rgbHex(_options.color) ? _options.color : 'transparent';

				wColorPicker = new ColorPicker(el, _options);
				$.data(el, 'wColorPicker', wColorPicker);
			}

			return wColorPicker;
		}

		return this.each(function(){ get(this); });
	};
	
	$.fn.wColorPicker.defaults = {
		theme           : 'classic',  // set theme
		opacity         : 0.9,        // opacity level
		color           : '#FF0000',  // set init color
		mode            : 'flat',     // mode for palette (flat, hover, click)
		position        : 'bl',       // position of palette, (tl, tc, tr, rt, rm, rb, br, bc, bl, lb, lm, lt)
		generateButton  : true,       // if mode not flat generate button or not
		dropperButton   : false,      // optional dropper button to use in other apps
		effect          : 'slide',    // only used when not in flat mode (none, slide, fade)
		showSpeed       : 500,        // show speed for effects
		hideSpeed       : 500,        // hide speed for effects
		onMouseover     : null,       // callback for color mouseover
		onMouseout      : null,       // callback for color mouseout
		onSelect        : null,       // callback for color when selected
		onDropper       : null        // callback when dropper is clicked
	};

})(jQuery);

(function () {
  if (!String.prototype.capitalize) {
    String.prototype.capitalize = function () {
      return this.slice(0, 1).toUpperCase() + this.slice(1);
    };
  }
})();

(function ($) {
  $.fn.realWidth = function (type, margin, $el) {
    var width = null, $div = null, method = null;

    type = type === 'inner' || type === 'outer' ? type : '';
    method = type === '' ? 'width' : type + 'Width';
    margin = margin === true ? true : false;
    $div = $(this).clone().css({position: 'absolute', left: -10000}).appendTo($el || 'body');
    width = margin ? $div[method](margin) : $div[method]();

    $div.remove();

    return width;
  };

  $.fn.realHeight = function (type, margin, $el) {
    var height = null, $div = null, method = null;

    type = type === 'inner' || type === 'outer' ? type : '';
    method = type === '' ? 'height' : type + 'Height';
    margin = margin === true ? true : false;
    $div = $(this).clone().css({position: 'absolute', left: -10000}).appendTo($el || 'body');
    height = margin ? $div[method](margin) : $div[method]();

    $div.remove();

    return height;
  };

  $.fn.bindMobileEvents = function () {
    $(this).on('touchstart touchmove touchend touchcancel', function () {
      var touches = (event.changedTouches || event.originalEvent.targetTouches),
          first = touches[0],
          type = '';

      switch (event.type) {
      case 'touchstart':
        type = 'mousedown';
        break;
      case 'touchmove':
        type = 'mousemove';
        event.preventDefault();
        break;
      case 'touchend':
        type = 'mouseup';
        break;
      default:
        return;
      }

      var simulatedEvent = document.createEvent('MouseEvent'); 

      simulatedEvent.initMouseEvent(
        type, true, true, window, 1, 
        first.screenX, first.screenY, first.clientX, first.clientY, 
        false, false, false, false, 0/*left*/, null
      );

      first.target.dispatchEvent(simulatedEvent);
    });
  };
})(jQuery);

(function ($) {
	'use strict';

	/************************************************************************
	 * Paint class
	 ************************************************************************/
	function Paint(el, options) {
		this.$el = $(el);
		this.options = options;
		this.init = false;

		this.menus = {primary: null, active: null, all: {}};
		this.previousMode = null;
		this.width = this.$el.width();
		this.height = this.$el.height();

		this.ctxBgResize = false;
		this.ctxResize = false;

		this.generate();
		this._init();
	}
	
	Paint.prototype = {
		generate: function () {
			if (this.init) { return this; }

			var _this = this;

			// automatically appends each canvas
			// also returns the jQuery object so we can chain events right off the function call.
			// for the tempCanvas we will be setting some extra attributes but don't won't matter
			// as they will be reset on mousedown anyway.
			function createCanvas(name) {
				var newName = (name ? name.capitalize() : ''),
						canvasName = 'canvas' + newName,
						ctxName = 'ctx' + newName;

				_this[canvasName] = document.createElement('canvas');
				_this[ctxName] = _this[canvasName].getContext('2d');
				_this['$' + canvasName] = $(_this[canvasName]);
				
				_this['$' + canvasName]
				.attr('class', 'wPaint-canvas' + (name ? '-' + name : ''))
				.attr('width', _this.width + 'px')
				.attr('height', _this.height + 'px')
				.css({position: 'absolute', left: 0, top: 0});

				_this.$el.append(_this['$' + canvasName]);

				return _this['$' + canvasName];
			}

			// event functions
			function canvasMousedown(e) {
				e.preventDefault();
				e.stopPropagation();
				_this.draw = true;
				e.canvasEvent = 'down';
				_this._closeSelectBoxes();
				_this._callShapeFunc.apply(_this, [e]);
			}

			function documentMousemove(e) {
				if (_this.draw) {
					e.canvasEvent = 'move';
					_this._callShapeFunc.apply(_this, [e]);
				}
			}

			function documentMouseup(e) {

				//make sure we are in draw mode otherwise this will fire on any mouse up.
				if (_this.draw) {
					_this.draw = false;
					e.canvasEvent = 'up';
					_this._callShapeFunc.apply(_this, [e]);
				}
			}

			// create bg canvases
			createCanvas('bg');
			
			// create drawing canvas
			createCanvas('')
			.on('mousedown', canvasMousedown)
			.bindMobileEvents();
			
			// create temp canvas for drawing shapes temporarily
			// before transfering to main canvas
			createCanvas('temp').hide();
			
			// event handlers for drawing
			$(document)
			.on('mousemove', documentMousemove)
			.on('mousedown', $.proxy(this._closeSelectBoxes, this))
			.on('mouseup', documentMouseup);

			// we will need to preset theme to get proper dimensions
			// when creating menus which will be appended after this
			this.setTheme(this.options.theme);
		},

		_init: function () {
			var index = null,
					setFuncName = null;

			this.init = true;

			// run any set functions if they exist
			for (index in this.options) {
				setFuncName = 'set' + index.capitalize();
				if (this[setFuncName]) { this[setFuncName](this.options[index]); }
			}

			// fix menus
			this._fixMenus();

			// initialize active menu button
			this.menus.primary._getIcon(this.options.mode).trigger('click');      
		},

		resize: function () {
			var bg = this.getBg(),
					image = this.getImage();

			this.width = this.$el.width();
			this.height = this.$el.height();

			this.canvasBg.width = this.width;
			this.canvasBg.height = this.height;
			this.canvas.width = this.width;
			this.canvas.height = this.height;

			if (this.ctxBgResize === false) {
				this.ctxBgResize = true;
				this.setBg(bg, true);
			}

			if (this.ctxResize === false) {
				this.ctxResize = true;
				this.setImage(image, '', true, true);
			}
		},

		/************************************
		 * setters
		 ************************************/
		setTheme: function (theme) {
			var i, ii;

			theme = theme.split(' ');

			// remove anything beginning with "wPaint-theme-" first
			this.$el.attr('class', (this.$el.attr('class') || '').replace(/wPaint-theme-.+\s|wPaint-theme-.+$/, ''));
			
			// add each theme
			for (i = 0, ii = theme.length; i < ii; i++) {
				this.$el.addClass('wPaint-theme-' + theme[i]);
			}
		},

		setMode: function (mode) {
			this.setCursor(mode);
			this.previousMode = this.options.mode;
			this.options.mode = mode;
		},

		setImage: function (img, ctxType, resize, notUndo) {
			if (!img) { return true; }

			var _this = this,
					myImage = null,
					ctx = '';

			function loadImage() {
				var ratio = 1, xR = 0, yR = 0, x = 0, y = 0, w = myImage.width, h = myImage.height;

				if (!resize) {
					// get width/height
					if (myImage.width > _this.width || myImage.height > _this.height || _this.options.imageStretch) {
						xR = _this.width / myImage.width;
						yR = _this.height / myImage.height;

						ratio = xR < yR ? xR : yR;

						w = myImage.width * ratio;
						h = myImage.height * ratio;
					}

					// get left/top (centering)
					x = (_this.width - w) / 2;
					y = (_this.height - h) / 2;
				}

				ctx.clearRect(0, 0, _this.width, _this.height);
				ctx.drawImage(myImage, x, y, w, h);

				_this[ctxType + 'Resize'] = false;

				// Default is to run the undo.
				// If it's not to be run set it the flag to true.
				if (!notUndo) {
					_this._addUndo();
				}
			}
			
			ctxType = 'ctx' + (ctxType || '').capitalize();
			ctx = this[ctxType];
			
			if (window.rgbHex(img)) {
				ctx.clearRect(0, 0, this.width, this.height);
				ctx.fillStyle = img;
				ctx.rect(0, 0, this.width, this.height);
				ctx.fill();
			}
			else {
	if (notUndo) ctx.clearRect(0, 0, this.width, this.height);
				myImage = new Image();
				$(myImage).on('load', loadImage);
	if (typeof img.slice !== "undefined" && img.slice(0, 4) !== "data") myImage.setAttribute('crossOrigin','anonymous');
				myImage.src = img;
			}
		},

		setBg: function (img, resize) {
			if (!img) { return true; }
			
			this.setImage(img, 'bg', resize, true);
		},

		setCursor: function (cursor) {
			cursor = $.fn.wPaint.cursors[cursor] || $.fn.wPaint.cursors['default'];

			this.$el.css('cursor', 'url("' + this.options.path + cursor.path + '") ' + cursor.left + ' ' + cursor.top + ', default');
		},

		setMenuOrientation: function (orientation) {
			$.each(this.menus.all, function (i, menu) {
				menu.options.aligment = orientation;
				menu.setAlignment(orientation);
			});
		},

		getImage: function (withBg) {
			var canvasSave = document.createElement('canvas'),
					ctxSave = canvasSave.getContext('2d');

			withBg = withBg === false ? false : true;

			$(canvasSave)
			.css({display: 'none', position: 'absolute', left: 0, top: 0})
			.attr('width', this.width)
			.attr('height', this.height);

			if (withBg) { ctxSave.drawImage(this.canvasBg, 0, 0); }
			ctxSave.drawImage(this.canvas, 0, 0);

			return canvasSave.toDataURL();
		},

		getBg: function () {
			return this.canvasBg.toDataURL();
		},

		/************************************
		 * prompts
		 ************************************/
		_displayStatus: function (msg) {
			var _this = this;

			if (!this.$status) {
				this.$status = $('<div class="wPaint-status"></div>');
				this.$el.append(this.$status);
			}

			this.$status.html(msg);
			clearTimeout(this.displayStatusTimer);

			this.$status.fadeIn(500, function () {
				_this.displayStatusTimer = setTimeout(function () { _this.$status.fadeOut(500); }, 1500);
			});
		},

		_showModal: function ($content) {
			var _this = this,
					$bg = this.$el.children('.wPaint-modal-bg'),
					$modal = this.$el.children('.wPaint-modal');

			function modalFadeOut() {
					$bg.remove();
					$modal.remove();
					_this._createModal($content);
				}

			if ($bg.length) {
				$modal.fadeOut(500, modalFadeOut);
			}
			else {
				this._createModal($content);
			}
		},

		_createModal: function ($content) {
			$content = $('<div class="wPaint-modal-content"></div>').append($content.children());

			var $bg = $('<div class="wPaint-modal-bg"></div>'),
					$modal = $('<div class="wPaint-modal"></div>'),
					$holder = $('<div class="wPaint-modal-holder"></div>'),
					$close = $('<div class="wPaint-modal-close">X</div>');

			function modalClick() {
				$modal.fadeOut(500, modalFadeOut);
			}

			function modalFadeOut() {
				$bg.remove();
				$modal.remove();
			}

			$close.on('click', modalClick);
			$modal.append($holder.append($content)).append($close);
			this.$el.append($bg).append($modal);

			$modal.css({
				left: (this.$el.outerWidth() / 2) - ($modal.outerWidth(true) / 2),
				top: (this.$el.outerHeight() / 2) - ($modal.outerHeight(true) / 2)
			});

			$modal.fadeIn(500);
		},

		/************************************
		 * menu helpers
		 ************************************/
		_createMenu: function (name, options) {
			options = options || {};
			options.alignment = this.options.menuOrientation;
			options.handle = this.options.menuHandle;
			
			return new Menu(this, name, options);
		},

		_fixMenus: function () {
			var _this = this,
					$selectHolder = null;

			function selectEach(i, el) {
				var $el = $(el),
						$select = $el.clone();

				$select.appendTo(_this.$el);

				if ($select.outerHeight() === $select.get(0).scrollHeight) {
					$el.css({overflowY: 'auto'});
				}

				$select.remove();
			}

			// TODO: would be nice to do this better way
			// for some reason when setting overflowY:auto with dynamic content makes the width act up
			for (var key in this.menus.all) {
				$selectHolder = _this.menus.all[key].$menu.find('.wPaint-menu-select-holder');
				if ($selectHolder.length) { $selectHolder.children().each(selectEach); }
			}
		},

		_closeSelectBoxes: function (item) {
			var key, $selectBoxes;

			for (key in this.menus.all) {
				$selectBoxes = this.menus.all[key].$menuHolder.children('.wPaint-menu-icon-select');

				// hide any open select menus excluding the current menu
				// this is to avoid the double toggle since there are some
				// other events running here
				if (item) { $selectBoxes = $selectBoxes.not('.wPaint-menu-icon-name-' + item.name); }

				$selectBoxes.children('.wPaint-menu-select-holder').hide();
			}
		},

		/************************************
		 * events
		 ************************************/
		//_imageOnload: function () {
		//  /* a blank helper function for post image load calls on canvas - can be extended by other plugins using the setImage called */
		//},

		_callShapeFunc: function (e) {

			// TODO: this is where issues with mobile offsets are probably off
			var canvasOffset = this.$canvas.offset(),
					canvasEvent = e.canvasEvent.capitalize(),
					func = '_draw' + this.options.mode.capitalize() + canvasEvent;

			// update offsets here since we are detecting mouseup on $(document) not on the canvas
			e.pageX = Math.floor(e.pageX - canvasOffset.left);
			e.pageY = Math.floor(e.pageY - canvasOffset.top);

			// call drawing func
			if (this[func]) { this[func].apply(this, [e]); }

			// run callback if set
			if (this.options['draw' + canvasEvent]) { this.options['_draw' + canvasEvent].apply(this, [e]); }

			// run options (user) callback if set
			if (canvasEvent === 'Down' && this.options.onShapeDown) { this.options.onShapeDown.apply(this, [e]); }
			else if (canvasEvent === 'Move' && this.options.onShapeMove) { this.options.onShapeMove.apply(this, [e]); }
			else if (canvasEvent === 'Up' && this.options.onShapeUp) { this.options.onShapeUp.apply(this, [e]); }
		},

		_stopPropagation: function (e) {
			e.stopPropagation();
		},

		/************************************
		 * shape helpers
		 ************************************/
		_drawShapeDown: function (e) {
			this.$canvasTemp
			.css({left: e.PageX, top: e.PageY})
			.attr('width', 0)
			.attr('height', 0)
			.show();

			this.canvasTempLeftOriginal = e.pageX;
			this.canvasTempTopOriginal = e.pageY;
		},
		
		_drawShapeMove: function (e, factor) {
			var xo = this.canvasTempLeftOriginal,
					yo = this.canvasTempTopOriginal;

			// we may need these in other funcs, so we'll just pass them along with the event
			factor = factor || 2;
			e.left = (e.pageX < xo ? e.pageX : xo);
			e.top = (e.pageY < yo ? e.pageY : yo);
			e.width = Math.abs(e.pageX - xo);
			e.height = Math.abs(e.pageY - yo);
			e.x = this.options.lineWidth / 2 * factor;
			e.y = this.options.lineWidth / 2 * factor;
			e.w = e.width - this.options.lineWidth * factor;
			e.h = e.height - this.options.lineWidth * factor;

			$(this.canvasTemp)
			.css({left: e.left, top: e.top})
			.attr('width', e.width)
			.attr('height', e.height);
			
			// store these for later to use in our "up" call
			this.canvasTempLeftNew = e.left;
			this.canvasTempTopNew = e.top;

			factor = factor || 2;

			// TODO: set this globally in _drawShapeDown (for some reason colors are being reset due to canvas resize - is there way to permanently set it)
			this.ctxTemp.fillStyle = this.options.fillStyle;
			this.ctxTemp.strokeStyle = this.options.strokeStyle;
			this.ctxTemp.lineWidth = this.options.lineWidth * factor;
		},
		
		_drawShapeUp: function () {
			this.ctx.drawImage(this.canvasTemp, this.canvasTempLeftNew, this.canvasTempTopNew);
			this.$canvasTemp.hide();
		},

		/****************************************
		 * dropper
		 ****************************************/
		_drawDropperDown: function (e) {
			var pos = {x: e.pageX, y: e.pageY},
					pixel = this._getPixel(this.ctx, pos),
					color = null;

			// if we get no color try getting from the background
			//if(pixel.r === 0 && pixel.g === 0 && pixel.b === 0 && pixel.a === 0) {
			//  imageData = this.ctxBg.getImageData(0, 0, this.width, this.height)
			//  pixel = this._getPixel(imageData, pos);
			//}

			color = 'rgba(' + [ pixel.r, pixel.g, pixel.b, pixel.a ].join(',') + ')';

			// set color from dropper here
			this.options[this.dropper] = color;
			this.menus.active._getIcon(this.dropper).wColorPicker('color', color);
		},

		_drawDropperUp: function () {
			this.setMode(this.previousMode);
		},

		// get pixel data represented as RGBa color from pixel array.
		_getPixel: function (ctx, pos) {
			var imageData = ctx.getImageData(0, 0, this.width, this.height),
					pixelArray = imageData.data,
					base = ((pos.y * imageData.width) + pos.x) * 4;
			
			return {
				r: pixelArray[base],
				g: pixelArray[base + 1],
				b: pixelArray[base + 2],
				a: pixelArray[base + 3]
			};
		}
	};

	/************************************************************************
	 * Menu class
	 ************************************************************************/
	function Menu(wPaint, name, options) {
		this.wPaint = wPaint;
		this.options = options;
		this.name = name;
		this.type = !wPaint.menus.primary ? 'primary' : 'secondary';
		this.docked = true;
		this.dockOffset = {left: 0, top: 0};

		this.generate();
	}
	
	Menu.prototype = {
		generate: function () {
			this.$menu = $('<div class="wPaint-menu"></div>');
			this.$menuHolder = $('<div class="wPaint-menu-holder wPaint-menu-name-' + this.name + '"></div>');
			
			if (this.options.handle) { this.$menuHandle = this._createHandle(); }
			else { this.$menu.addClass('wPaint-menu-nohandle'); }
			
			if (this.type === 'primary') {

				// store the primary menu in primary object - we will need this reference later
				this.wPaint.menus.primary = this;

				this.setOffsetLeft(this.options.offsetLeft);
				this.setOffsetTop(this.options.offsetTop);
			}
			else if (this.type === 'secondary') {
				this.$menu.hide();
			}

			// append menu items
			this.$menu.append(this.$menuHolder.append(this.$menuHandle));
			this.reset();
			
			// append menu
			this.wPaint.$el.append(this.$menu);

			this.setAlignment(this.options.alignment);
		},

		// create / reset menu - will add new entries in the array
		reset: function () {
			var _this = this,
					menu = $.fn.wPaint.menus[this.name],
					key;

			// self invoking function
			function itemAppend(item) { _this._appendItem(item); }

			for (key in menu.items) {

				// only add unique (new) items (icons)
				if (!this.$menuHolder.children('.wPaint-menu-icon-name-' + key).length) {
					
					// add the item name, we will need this internally
					menu.items[key].name = key;

					// check whether the paths are already set
					if (menu.items[key].pathSet === undefined) {
						menu.items[key].pathSet = true;

						// use default img if img not set
						menu.items[key].img = _this.wPaint.options.path + (menu.items[key].img || menu.img);
					}

					// make self invoking to avoid overwrites
					(itemAppend)(menu.items[key]);
				}
			}
		},

		_appendItem: function (item) {
			var $item = this['_createIcon' + item.icon.capitalize()](item);

			if (item.after) {
				this.$menuHolder.children('.wPaint-menu-icon-name-' + item.after).after($item);
			}
			else {
				this.$menuHolder.append($item);
			}
		},

		/************************************
		 * setters
		 ************************************/
		setOffsetLeft: function (left) {
			this.$menu.css({left: left});
		},

		setOffsetTop: function (top) {
			this.$menu.css({top: top});
		},

		setAlignment: function (alignment) {
			var tempLeft = this.$menu.css('left');

			this.$menu.attr('class', this.$menu.attr('class').replace(/wPaint-menu-alignment-.+\s|wPaint-menu-alignment-.+$/, ''));
			this.$menu.addClass('wPaint-menu-alignment-' + alignment);

			this.$menu.width('auto').css('left', -10000);
			this.$menu.width(this.$menu.width()).css('left', tempLeft);

			// set proper offsets based on alignment
			if (this.type === 'secondary') {
				if (this.options.alignment === 'horizontal') {
					this.dockOffset.top = this.wPaint.menus.primary.$menu.outerHeight(true);
				}
				else {
					this.dockOffset.left = this.wPaint.menus.primary.$menu.outerWidth(true);
				}
			}   
		},

		/************************************
		 * handle
		 ************************************/
		_createHandle: function () {
			var _this = this,
			$handle = $('<div class="wPaint-menu-handle"></div>');

			// draggable functions
			function draggableStart() {
				_this.docked = false;
				_this._setDrag();
			}

			function draggableStop() {
				$.each(_this.$menu.data('ui-draggable').snapElements, function (i, el) {
					var offset = _this.$menu.offset(),
					offsetPrimary = _this.wPaint.menus.primary.$menu.offset();

					_this.dockOffset.left = offset.left - offsetPrimary.left;
					_this.dockOffset.top = offset.top - offsetPrimary.top;
					_this.docked = el.snapping;
				});

				_this._setDrag();
			}

			function draggableDrag() {
				_this._setIndex();
			}

			// the drag/snap events for menus are tricky
			// init handle for ALL menus, primary menu will drag a secondary menu with it, but that is un/binded in the toggle function
			this.$menu.draggable({handle: $handle});

			// if it's a secondary menu we want to check for snapping
			// on drag we set docked to false, on snap we set it back to true
			if (this.type === 'secondary') {
				this.$menu.draggable('option', 'snap', this.wPaint.menus.primary.$menu);
				this.$menu.draggable('option', 'start', draggableStart);
				this.$menu.draggable('option', 'stop', draggableStop);
				this.$menu.draggable('option', 'drag', draggableDrag);
			}

			$handle.bindMobileEvents();

			return $handle;
		},

		/************************************
		 * generic icon
		 ************************************/
		_createIconBase: function (item) {
			var _this = this,
			$icon = $('<div class="wPaint-menu-icon wPaint-menu-icon-name-' + item.name + '"></div>'),
			$iconImg = $('<div class="wPaint-menu-icon-img"></div>'),
			width = $iconImg.realWidth(null, null, this.wPaint.$el);

			function mouseenter(e) {
				var $el = $(e.currentTarget);

				$el.siblings('.hover').removeClass('hover');
				if (!$el.hasClass('disabled')) { $el.addClass('hover'); }
			}

			function mouseleave(e) {
				$(e.currentTarget).removeClass('hover');
			}

			function click() {
				_this.wPaint.menus.active = _this;
			}

			var hasKeybind = (typeof item.keybind !== "undefined");
			var formattedTitle = (hasKeybind ? (item.title + " (" + item.keybind + ")") : item.title);
			var activatedFunction = $.proxy(this.wPaint._closeSelectBoxes, this.wPaint, item);

			$icon
			.attr('title', formattedTitle)
			.on('mousedown', activatedFunction)
			.on('mouseenter', mouseenter)
			.on('mouseleave', mouseleave)
			.on('click', click);

			if (hasKeybind) { 
				key(item.keybind, function(e) {
					$.proxy(item.callback, _this.wPaint)();
					_this._iconClick($icon);
					click();
					activatedFunction();
				});
			}

			// can have index:0 so be careful here
			if ($.isNumeric(item.index)) {
				$iconImg
				.css({
					backgroundImage: 'url(' + item.img + ')',
					backgroundPosition: (-width * item.index) + 'px 0px'
				});
			}

			return $icon.append($iconImg);
		},

		/************************************
		 * icon group
		 ************************************/
		_createIconGroup: function (item) {
			var _this = this,
					css = {backgroundImage: 'url(' + item.img + ')'},
					$icon = this.$menuHolder.children('.wPaint-menu-icon-group-' + item.group),
					iconExists = $icon.length,
					$selectHolder = null,
					$option = null,
					$item = null,
					width = 0;

			// local functions
			function setIconClick() {

				// only trigger if menu is not visible otherwise it will fire twice
				// from the mousedown to open the menu which we want just to display the menu
				// not fire the button callback
				if (!$icon.children('.wPaint-menu-select-holder').is(':visible')) {
					item.callback.apply(_this.wPaint, []);
				}
			}

			function selectHolderClick() {
				$icon.addClass('active').siblings('.active').removeClass('active');
			}

			function optionClick() {

				// rebind the main icon when we select an option
				$icon
				.attr('title', item.title)
				.off('click.setIcon')
				.on('click.setIcon', setIconClick);
				
				// run the callback right away when we select an option
				$icon.children('.wPaint-menu-icon-img').css(css);
				item.callback.apply(_this.wPaint, []);
			}

			// crate icon if it doesn't exist yet
			if (!iconExists) {
				$icon = this._createIconBase(item)
				.addClass('wPaint-menu-icon-group wPaint-menu-icon-group-' + item.group)
				.on('click.setIcon', setIconClick)
				.on('mousedown', $.proxy(this._iconClick, this));
			}

			// get the proper width here now that we have the icon
			// this is for the select box group not the main icon
			width = $icon.children('.wPaint-menu-icon-img').realWidth(null, null, this.wPaint.$el);
			css.backgroundPosition = (-width * item.index) + 'px center';

			// create selectHolder if it doesn't exist
			$selectHolder = $icon.children('.wPaint-menu-select-holder');
			if (!$selectHolder.length) {
				$selectHolder = this._createSelectBox($icon);
				$selectHolder.children().on('click', selectHolderClick);
			}

			$item = $('<div class="wPaint-menu-icon-select-img"></div>')
			.attr('title', item.title)
			.css(css);

			$option = this._createSelectOption($selectHolder, $item)
			.addClass('wPaint-menu-icon-name-' + item.name)
			.on('click', optionClick);

			// move select option into place if after is set
			if (item.after) {
				$selectHolder.children('.wPaint-menu-select').children('.wPaint-menu-icon-name-' + item.after).after($option);
			}

			// we only want to return an icon to append on the first run of a group
			if (!iconExists) { return $icon; }
		},

		/************************************
		 * icon generic
		 ************************************/
		_createIconGeneric: function (item) {

			// just a go between for the iconGeneric type
			return this._createIconActivate(item);
		},

		/************************************
		 * icon
		 ************************************/
		_createIconActivate: function (item) {

			// since we are piggy backing icon with the item.group
			// we'll just do a redirect and keep the code separate for group icons
			if (item.group) { return this._createIconGroup(item); }

			var _this = this,
					$icon = this._createIconBase(item);

			function iconClick(e) {
				if (item.icon !== 'generic') { _this._iconClick(e); }
				item.callback.apply(_this.wPaint, [e]);
			}

			$icon.on('click', iconClick);

			return $icon;
		},

		_isIconDisabled: function (name) {
			return this.$menuHolder.children('.wPaint-menu-icon-name-' + name).hasClass('disabled');
		},

		_setIconDisabled: function (name, disabled) {
			var $icon = this.$menuHolder.children('.wPaint-menu-icon-name-' + name);

			if (disabled) {
				$icon.addClass('disabled').removeClass('hover');
			}
			else {
				$icon.removeClass('disabled');
			}
		},

		_getIcon: function (name) {
			return this.$menuHolder.children('.wPaint-menu-icon-name-' + name);
		},

		_iconClick: function (e) {
			if (typeof e.currentTarget !== "undefined") {
				var $el = $(e.currentTarget);
			} else {
				var $el = $(e);
			}

			var menus = this.wPaint.menus.all;

			// make sure to loop using parent object - don't use .wPaint-menu-secondary otherwise we would hide menu for all canvases
			for (var menu in menus) {
				if (menus[menu] && menus[menu].type === 'secondary') { menus[menu].$menu.hide(); }  
			}

			$el.siblings('.active').removeClass('active');
			if (!$el.hasClass('disabled')) { $el.addClass('active'); }
		},

		/************************************
		 * iconToggle
		 ************************************/
		_createIconToggle: function (item) {
			var _this = this,
					$icon = this._createIconBase(item);

			function iconClick() {
				$icon.toggleClass('active');
				item.callback.apply(_this.wPaint, [$icon.hasClass('active')]);
			}

			$icon.on('click', iconClick);

			return $icon;
		},

		/************************************
		 * select
		 ************************************/
		_createIconSelect: function (item) {
			var _this = this,
					$icon = this._createIconBase(item),
					$selectHolder = this._createSelectBox($icon),
					i, ii, $option;

			function optionClick(e) {
				$icon.children('.wPaint-menu-icon-img').html($(e.currentTarget).html());
				item.callback.apply(_this.wPaint, [$(e.currentTarget).html()]);
			}

			// add values for select
			for (i = 0, ii = item.range.length; i < ii; i++) {
				$option = this._createSelectOption($selectHolder, item.range[i]);
				$option.on('click', optionClick);
				if (item.useRange) { $option.css(item.name, item.range[i]); }
			}

			return $icon;
		},

		_createSelectBox: function ($icon) {
			var $selectHolder = $('<div class="wPaint-menu-select-holder"></div>'),
					$select = $('<div class="wPaint-menu-select"></div>'),
					timer = null;

			function clickSelectHolder(e) {
				e.stopPropagation();
				$selectHolder.hide();
			}

			function iconMousedown() {
				timer = setTimeout(function () { $selectHolder.toggle(); }, 200);
			}

			function iconMouseup() {
				clearTimeout(timer);
			}

			function iconClick() {
				$selectHolder.toggle();
			}

			$selectHolder
			.on('mousedown mouseup', this.wPaint._stopPropagation)
			.on('click', clickSelectHolder)
			.hide();

			// of hozizontal we'll pop below the icon
			if (this.options.alignment === 'horizontal') {
				$selectHolder.css({left: 0, top: $icon.children('.wPaint-menu-icon-img').realHeight('outer', true, this.wPaint.$el)});
			}
			// vertical we'll pop to the right
			else {
				$selectHolder.css({left: $icon.children('.wPaint-menu-icon-img').realWidth('outer', true, this.wPaint.$el), top: 0});
			}

			$icon
			.addClass('wPaint-menu-icon-select')
			.append('<div class="wPaint-menu-icon-group-arrow"></div>')
			.append($selectHolder.append($select));

			// for groups we want to add a delay before the selectBox pops up
			if ($icon.hasClass('wPaint-menu-icon-group')) {
				$icon
				.on('mousedown', iconMousedown)
				.on('mouseup', iconMouseup);
			}
			else { $icon.on('click', iconClick); }

			return $selectHolder;
		},

		_createSelectOption: function ($selectHolder, value) {
			var $select = $selectHolder.children('.wPaint-menu-select'),
					$option = $('<div class="wPaint-menu-select-option"></div>').append(value);

			// set class for first item to remove any undesired styles like borders
			if (!$select.children().length) { $option.addClass('first'); }

			$select.append($option);

			return $option;
		},

		_setSelectValue: function (icon, value) {
			this._getIcon(icon).children('.wPaint-menu-icon-img').html(value);
		},

		/************************************
		 * color picker
		 ************************************/
		_createIconColorPicker: function (item) {
			var _this = this,
					$icon = this._createIconBase(item);

			function iconClick() {

				// if we happen to click on this while in dropper mode just revert to previous
				if (_this.wPaint.options.mode === 'dropper') { _this.wPaint.setMode(_this.wPaint.previousMode); }
			}

			function iconOnSelect(color) {
				item.callback.apply(_this.wPaint, [color]);
			}

			function iconOnDropper() {
				$icon.trigger('click');
				_this.wPaint.dropper = item.name;
				_this.wPaint.setMode('dropper');
			}

			$icon
			.on('click', iconClick)
			.addClass('wPaint-menu-colorpicker')
			.wColorPicker({
				mode: 'click',
				generateButton: false,
				dropperButton: true,
				onSelect: iconOnSelect,
				onDropper: iconOnDropper
			});

			return $icon;
		},

		_setColorPickerValue: function (icon, value) {
			this._getIcon(icon).children('.wPaint-menu-icon-img').css('backgroundColor', value);
		},

		/************************************
		 * menu toggle
		 ************************************/
		_createIconMenu: function (item) {
			var _this = this,
					$icon = this._createIconActivate(item);

			function iconClick() {
				_this.wPaint.setCursor(item.name);

				// the items name here will be the menu name
				var menu = _this.wPaint.menus.all[item.name];
				menu.$menu.toggle();
				if (_this.handle) {
					menu._setDrag();
				} else {
					menu._setPosition();
				}
			}

			$icon.on('click', iconClick);

			return $icon;
		},

		// here we specify which menu will be dragged
		_setDrag: function () {
			var $menu = this.$menu,
					drag = null, stop = null;

			if ($menu.is(':visible')) {
				if (this.docked) {

					// make sure we are setting proper menu object here
					drag = stop = $.proxy(this._setPosition, this);
					this._setPosition();
				}

				// register drag/stop events
				this.wPaint.menus.primary.$menu.draggable('option', 'drag', drag);
				this.wPaint.menus.primary.$menu.draggable('option', 'stop', stop);
			}
		},

		_setPosition: function () {
			var offset = this.wPaint.menus.primary.$menu.position();

			this.$menu.css({
				left: offset.left + this.dockOffset.left,
				top: offset.top + this.dockOffset.top
			});
		},

		_setIndex: function () {
			var primaryOffset = this.wPaint.menus.primary.$menu.offset(),
					secondaryOffset = this.$menu.offset();

			if (
				secondaryOffset.top < primaryOffset.top ||
				secondaryOffset.left < primaryOffset.left
			) {
				this.$menu.addClass('wPaint-menu-behind');
			}
			else {
				this.$menu.removeClass('wPaint-menu-behind');
			}
		}
	};

	/************************************************************************
	 * wPaint
	 ************************************************************************/
	$.support.canvas = (document.createElement('canvas')).getContext;

	$.fn.wPaint = function (options, value) {

		function create() {
			if (!$.support.canvas) {
				$(this).html('Browser does not support HTML5 canvas, please upgrade to a more modern browser.');
				return false;
			}

			return $.proxy(get, this)();
		}

		function get() {
			var wPaint = $.data(this, 'wPaint');

			if (!wPaint) {
				wPaint = new Paint(this, $.extend(true, {}, options));
				$.data(this, 'wPaint', wPaint);
			}

			return wPaint;
		}

		function runOpts() {
			var wPaint = $.data(this, 'wPaint');

			if (wPaint) {
				if (wPaint[options]) { wPaint[options].apply(wPaint, [value]); }
				else if (value !== undefined) {
					if (wPaint[func]) { wPaint[func].apply(wPaint, [value]); }
					if (wPaint.options[options]) { wPaint.options[options] = value; }
				}
				else {
					if (wPaint[func]) { values.push(wPaint[func].apply(wPaint, [value])); }
					else if (wPaint.options[options]) { values.push(wPaint.options[options]); }
					else { values.push(undefined); }
				}
			}
		}

		if (typeof options === 'string') {
			var values = [],
					func = (value ? 'set' : 'get') + options.charAt(0).toUpperCase() + options.substring(1);

			this.each(runOpts);

			if (values.length) { return values.length === 1 ? values[0] : values; }
			
			return this;
		}

		options = $.extend({}, $.fn.wPaint.defaults, options);
		options.lineWidth = parseInt(options.lineWidth, 10);
		options.fontSize = parseInt(options.fontSize, 10);

		return this.each(create);
	};

	/************************************************************************
	 * extend
	 ************************************************************************/
	$.fn.wPaint.extend = function (funcs, protoType) {
		var key;
		
		function elEach(func) {
			if (protoType[func]) {
				var tmpFunc = Paint.prototype[func],
						newFunc = funcs[func];
				
				protoType[func] = function () {
					tmpFunc.apply(this, arguments);
					newFunc.apply(this, arguments);
				};
			}
			else {
				protoType[func] = funcs[func];
			}
		}

		protoType = protoType === 'menu' ? Menu.prototype : Paint.prototype;

		for (key in funcs) { (elEach)(key); }
	};

	/************************************************************************
	 * Init holders
	 ************************************************************************/
	$.fn.wPaint.menus = {};

	$.fn.wPaint.cursors = {};

	$.fn.wPaint.defaults = {
		path:            '/',                // set absolute path for images and cursors
		theme:           'standard classic', // set theme
		autoScaleImage:  true,               // auto scale images to size of canvas (fg and bg)
		autoCenterImage: true,               // auto center images (fg and bg, default is left/top corner)
		menuHandle:      true,               // setting to false will means menus cannot be dragged around
		menuOrientation: 'horizontal',       // menu alignment (horizontal,vertical)
		menuOffsetLeft:  5,                  // left offset of primary menu
		menuOffsetTop:   5,                  // top offset of primary menu
		bg:              null,               // set bg on init
		image:           null,               // set image on init
		imageStretch:    false,              // stretch smaller images to full canvans dimensions
		onShapeDown:     null,               // callback for draw down event
		onShapeMove:     null,               // callback for draw move event
		onShapeUp:       null                // callback for draw up event
	};
})(jQuery);

(function ($) {

  // setup menu
  $.fn.wPaint.menus.main = {
    img: 'plugins/main/img/icons-menu-main.png',
    items: {
      undo: {
        icon: 'generic',
        title: _('Undo'),
        keybind: 'alt+z',
        index: 0,
        callback: function () { this.undo(); }
      },
      redo: {
        icon: 'generic',
        title: _('Redo'),
        keybind: 'alt+shift+z,alt+r',
        index: 1,
        callback: function () { this.redo(); }
      },
      clear: {
        icon: 'generic',
        title: _('Clear'),
        keybind: 'alt+x',
        index: 2,
        callback: function () { this.clear(); }
      },
      rectangle: {
        icon: 'activate',
        title: _('Rectangle'),
        index: 3,
        callback: function () { this.setMode('rectangle'); }
      },
      ellipse: {
        icon: 'activate',
        title: _('Ellipse'),
        index: 4,
        callback: function () { this.setMode('ellipse'); }
      },
      line: {
        icon: 'activate',
        title: _('Line'),
        keybind: 'alt+l',
        index: 5,
        callback: function () { this.setMode('line'); }
      },
      pencil: {
        icon: 'activate',
        title: _('Pencil'),
        keybind: 'alt+p',
        index: 6,
        callback: function () { this.setMode('pencil'); }
      },
      eraser: {
        icon: 'activate',
        title: _('Eraser'),
        keybind: 'alt+e',
        index: 8,
        callback: function () { this.setMode('eraser'); }
      },
      bucket: {
        icon: 'activate',
        title: _('Bucket'),
        keybind: 'alt+b',
        index: 9,
        callback: function () { this.setMode('bucket'); }
      },
      fillStyle: {
        title: _('Fill Color'),
        icon: 'colorPicker',
        callback: function (color) { this.setFillStyle(color); }
      },
      lineWidth: {
        icon: 'select',
        title: _('Stroke Width'),
        range: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10],
        value: 2,
        callback: function (width) { this.setLineWidth(width); }
      },
      strokeStyle: {
        icon: 'colorPicker',
        title: _('Stroke Color'),
        callback: function (color) { this.setStrokeStyle(color); }
      }      
    }
  };

  // extend cursors
  $.extend($.fn.wPaint.cursors, {
    'default': {path: 'plugins/main/img/cursor-crosshair.png', left: 7, top: 7},
    dropper:   {path: 'plugins/main/img/cursor-dropper.png', left: 0, top: 12},
    pencil:    {path: 'plugins/main/img/cursor-pencil.png', left: 0, top: 11.99},
    bucket:    {path: 'plugins/main/img/cursor-bucket.png', left: 0, top: 10},
    eraser1:   {path: 'plugins/main/img/cursor-eraser1.png', left: 1, top: 1},
    eraser2:   {path: 'plugins/main/img/cursor-eraser2.png', left: 2, top: 2},
    eraser3:   {path: 'plugins/main/img/cursor-eraser3.png', left: 2, top: 2},
    eraser4:   {path: 'plugins/main/img/cursor-eraser4.png', left: 3, top: 3},
    eraser5:   {path: 'plugins/main/img/cursor-eraser5.png', left: 3, top: 3},
    eraser6:   {path: 'plugins/main/img/cursor-eraser6.png', left: 4, top: 4},
    eraser7:   {path: 'plugins/main/img/cursor-eraser7.png', left: 4, top: 4},
    eraser8:   {path: 'plugins/main/img/cursor-eraser8.png', left: 5, top: 5 },
    eraser9:   {path: 'plugins/main/img/cursor-eraser9.png', left: 5, top: 5},
    eraser10:  {path: 'plugins/main/img/cursor-eraser10.png', left: 6, top: 6}
  });

  // extend defaults
  $.extend($.fn.wPaint.defaults, {
    mode:        'pencil',  // set mode
    lineWidth:   '3',       // starting line width
    fillStyle:   '#FFFFFF', // starting fill style
    strokeStyle: '#FFFF00'  // start stroke style
  });

  // extend functions
  $.fn.wPaint.extend({
    undoCurrent: -1,
    undoArray: [],
    setUndoFlag: true,

    generate: function () {
      this.menus.all.main = this._createMenu('main', {
        offsetLeft: this.options.menuOffsetLeft,
        offsetTop: this.options.menuOffsetTop
      });
    },

    _init: function () {
      // must add undo on init to set the first undo as the initial drawing (bg or blank)
      this._addUndo();
      this.menus.all.main._setIconDisabled('clear', true);
    },

    setStrokeStyle: function (color) {
      this.options.strokeStyle = color;
      this.menus.all.main._setColorPickerValue('strokeStyle', color);
    },

    setLineWidth: function (width) {
      this.options.lineWidth = width;
      this.menus.all.main._setSelectValue('lineWidth', width);

      // reset cursor here based on mode in case we need to update cursor (for instance when changing cursor for eraser sizes)
      this.setCursor(this.options.mode);
    },

    setFillStyle: function (color) {
      this.options.fillStyle = color;
      this.menus.all.main._setColorPickerValue('fillStyle', color);
    },

    setCursor: function (cursor) {
      if (cursor === 'eraser') {
        this.setCursor('eraser' + this.options.lineWidth);
      }
    },

    /****************************************
     * undo / redo
     ****************************************/
    undo: function () {
      if (this.undoArray[this.undoCurrent - 1]) {
        this._setUndo(--this.undoCurrent);
      }

      this._undoToggleIcons();
    },

    redo: function () {
      if (this.undoArray[this.undoCurrent + 1]) {
        this._setUndo(++this.undoCurrent);
      }

      this._undoToggleIcons();
    },

    _addUndo: function () {

      //if it's not at the end of the array we need to repalce the current array position
      if (this.undoCurrent < this.undoArray.length - 1) {
        this.undoArray[++this.undoCurrent] = this.getImage(false);
      }
      else { // owtherwise we push normally here
        this.undoArray.push(this.getImage(false));

        //if we're at the end of the array we need to slice off the front - in increment required
        if (this.undoArray.length > this.undoMax) {
          this.undoArray = this.undoArray.slice(1, this.undoArray.length);
        }
        //if we're NOT at the end of the array, we just increment
        else { this.undoCurrent++; }
      }

      //for undo's then a new draw we want to remove everything afterwards - in most cases nothing will happen here
      while (this.undoCurrent !== this.undoArray.length - 1) { this.undoArray.pop(); }

      this._undoToggleIcons();
      this.menus.all.main._setIconDisabled('clear', false);
    },

    _undoToggleIcons: function () {
      var undoIndex = (this.undoCurrent > 0 && this.undoArray.length > 1) ? 0 : 1,
          redoIndex = (this.undoCurrent < this.undoArray.length - 1) ? 2 : 3;

      this.menus.all.main._setIconDisabled('undo', undoIndex === 1 ? true : false);
      this.menus.all.main._setIconDisabled('redo', redoIndex === 3 ? true : false);
    },

    _setUndo: function (undoCurrent) {
      this.setImage(this.undoArray[undoCurrent], null, null, true);
    },

    /****************************************
     * clear
     ****************************************/
    clear: function () {

      // only run if not disabled (make sure we only run one clear at a time)
      if (!this.menus.all.main._isIconDisabled('clear')) {
        this.ctx.clearRect(0, 0, this.width, this.height);
        this._addUndo();
        this.menus.all.main._setIconDisabled('clear', true);
      }
    },

    /****************************************
     * rectangle
     ****************************************/
    _drawRectangleDown: function (e) { this._drawShapeDown(e); },

    _drawRectangleMove: function (e) {
      this._drawShapeMove(e);

      this.ctxTemp.rect(e.x, e.y, e.w, e.h);
      this.ctxTemp.stroke();
      this.ctxTemp.fill();
    },

    _drawRectangleUp: function (e) {
      this._drawShapeUp(e);
      this._addUndo();
    },

    /****************************************
     * ellipse
     ****************************************/
    _drawEllipseDown: function (e) { this._drawShapeDown(e); },

    _drawEllipseMove: function (e) {
      this._drawShapeMove(e);

      this.ctxTemp.ellipse(e.x, e.y, e.w, e.h);
      this.ctxTemp.stroke();
      this.ctxTemp.fill();
    },

    _drawEllipseUp: function (e) {
      this._drawShapeUp(e);
      this._addUndo();
    },

    /****************************************
     * line
     ****************************************/
    _drawLineDown: function (e) { this._drawShapeDown(e); },

    _drawLineMove: function (e) {
      this._drawShapeMove(e, 1);

      var xo = this.canvasTempLeftOriginal;
      var yo = this.canvasTempTopOriginal;
      
      if (e.pageX < xo) { e.x = e.x + e.w; e.w = e.w * - 1; }
      if (e.pageY < yo) { e.y = e.y + e.h; e.h = e.h * - 1; }
      
      this.ctxTemp.lineJoin = 'round';
      this.ctxTemp.beginPath();
      this.ctxTemp.moveTo(e.x, e.y);
      this.ctxTemp.lineTo(e.x + e.w, e.y + e.h);
      this.ctxTemp.closePath();
      this.ctxTemp.stroke();
    },

    _drawLineUp: function (e) {
      this._drawShapeUp(e);
      this._addUndo();
    },

    /****************************************
     * pencil
     ****************************************/
    _drawPencilDown: function (e) {
      this.ctx.lineJoin = 'round';
      this.ctx.lineCap = 'round';
      this.ctx.strokeStyle = this.options.strokeStyle;
      this.ctx.fillStyle = this.options.strokeStyle;
      this.ctx.lineWidth = this.options.lineWidth;
      
      //draw single dot in case of a click without a move
      this.ctx.beginPath();
      this.ctx.arc(e.pageX, e.pageY, this.options.lineWidth / 2, 0, Math.PI * 2, true);
      this.ctx.closePath();
      this.ctx.fill();
      
      //start the path for a drag
      this.ctx.beginPath();
      this.ctx.moveTo(e.pageX, e.pageY);
    },
    
    _drawPencilMove: function (e) {
      this.ctx.lineTo(e.pageX, e.pageY);
      this.ctx.stroke();
    },
    
    _drawPencilUp: function () {
      this.ctx.closePath();
      this._addUndo();
    },

    /****************************************
     * eraser
     ****************************************/
    _drawEraserDown: function (e) {
      this.ctx.save();
      this.ctx.globalCompositeOperation = 'destination-out';
      this._drawPencilDown(e);
    },
    
    _drawEraserMove: function (e) {
      this._drawPencilMove(e);
    },
    
    _drawEraserUp: function (e) {
      this._drawPencilUp(e);
      this.ctx.restore();
    },

    /****************************************
     * bucket
     ****************************************/
    _drawBucketDown: function (e) {
      this.ctx.fillArea(e.pageX, e.pageY, this.options.fillStyle);
      this._addUndo();
    }
  });
})(jQuery);

!function(){window.CanvasRenderingContext2D&&(CanvasRenderingContext2D.prototype.fillArea=function(a,b,c){function d(a){return{r:p[a],g:p[a+1],b:p[a+2],a:p[a+3]}}function e(a){p[a]=c.r,p[a+1]=c.g,p[a+2]=c.b,p[a+3]=c.a}function f(a){return g.r===a.r&&g.g===a.g&&g.b===a.b&&g.a===a.a}if(!a||!b||!c)return!0;var g,h,i,j,k,l,m=this.canvas.width,n=this.canvas.height,o=this.getImageData(0,0,m,n),p=o.data,q=[[a,b]];if(g=d(4*(b*m+a)),l=this.canvas.style.color,this.canvas.style.color=c,c=this.canvas.style.color.match(/^rgba?\((.*)\);?$/)[1].split(","),this.canvas.style.color=l,c={r:parseInt(c[0],10),g:parseInt(c[1],10),b:parseInt(c[2],10),a:parseInt(c[3]||255,10)},f(c))return!0;for(;q.length;){for(h=q.pop(),i=4*(h[1]*m+h[0]);h[1]-->=0&&f(d(i));)i-=4*m;for(i+=4*m,++h[1],j=!1,k=!1;h[1]++<n-1&&f(d(i));)e(i),h[0]>0&&(f(d(i-4))?j||(q.push([h[0]-1,h[1]]),j=!0):j&&(j=!1)),h[0]<m-1&&(f(d(i+4))?k||(q.push([h[0]+1,h[1]]),k=!0):k&&(k=!1)),i+=4*m}this.putImageData(o,0,0)})}();
(function ($) {

  // setup menu
  $.fn.wPaint.menus.text = {
    img: 'plugins/text/img/icons-menu-text.png',
    items: {
      bold: {
        icon: 'toggle',
        title: _('Bold'),
        index: 0,
        callback: function (toggle) { this.setFontBold(toggle); }
      },
      italic: {
        icon: 'toggle',
        title: _('Italic'),
        index: 1,
        callback: function (toggle) { this.setFontItalic(toggle); }
      },
      /*underline: {
        icon: 'toggle',
        title: 'Undelrine',
        index: 2,
        callback: function (toggle) { this.setFontUnderline(toggle); }
      },*/
      fontSize: {
        title: _('Font Size'),
        icon: 'select',
        range: [8, 9, 10, 12, 14, 16, 20, 24, 30],
        value: 12,
        callback: function (size) { this.setFontSize(size); }
      },
      fontFamily: {
        icon: 'select',
        title: _('Font Family'),
        range: ['Arial', 'Courier', 'Times', 'Verdana'],
        useRange: true,
        value: 'Arial',
        callback: function (family) { this.setFontFamily(family); }
      }
    }
  };

  // add icon to main menu
  $.fn.wPaint.menus.main.items.text = {
    icon: 'menu',
    after: 'pencil',
    title: 'Text',
    index: 7,
    callback: function () { this.setMode('text'); }
  };

  // extend defaults
  $.extend($.fn.wPaint.defaults, {
    fontSize       : '12',    // current font size for text input
    fontFamily     : 'Arial', // active font family for text input
    fontBold       : false,   // text input bold enable/disable
    fontItalic     : false,   // text input italic enable/disable
    fontUnderline  : false    // text input italic enable/disable
  });

  // extend functions
  $.fn.wPaint.extend({
    generate: function () {
      this.$textCalc = $('<div></div>').hide();

      // make sure clicking on the text-tnput doesn't trigger another textInput
      this.$textInput = $('<textarea class="wPaint-text-input" spellcheck="false"></textarea>')
      .on('mousedown', this._stopPropagation) 
      .css({position: 'absolute'})
      .hide();
      
      $('body').append(this.$textCalc);
      this.$el.append(this.$textInput);

      this.menus.all.text = this._createMenu('text');
    },

    _init: function () {
      var _this = this;

      function inputClick() {
        _this._drawTextIfNotEmpty();
        _this.$textInput.hide();
        _this.$canvasTemp.hide();
      }

      // in case we click on another element while typing - just auto set the text
      for (var i in this.menus.all) {
        this.menus.all[i].$menu
        .on('click', inputClick)
        .on('mousedown', this._stopPropagation);
      }

      // same idea here for clicking outside of the canvas area
      $(document).on('mousedown', inputClick);
    },

    /****************************************
     * setters
     ****************************************/
    setFillStyle: function (fillStyle) {
      this.$textInput.css('color', fillStyle);
    },

    setFontSize: function (size) {
      this.options.fontSize = parseInt(size, 10);
      this._setFont({fontSize: size + 'px', lineHeight: size + 'px'});
      this.menus.all.text._setSelectValue('fontSize', size);
    },

    setFontFamily: function (family) {
      this.options.fontFamily = family;
      this._setFont({fontFamily: family});
      this.menus.all.text._setSelectValue('fontFamily', family);
    },

    setFontBold: function (bold) {
      this.options.fontBold = bold;
      this._setFont({fontWeight: (bold ? 'bold' : '')});
    },

    setFontItalic: function (italic) {
      this.options.fontItalic = italic;
      this._setFont({fontStyle: (italic ? 'italic' : '')});
    },

    setFontUnderline: function (underline) {
      this.options.fontUnderline = underline;
      this._setFont({fontWeight: (underline ? 'underline' : '')});
    },

    _setFont: function (css) {
      this.$textInput.css(css);
      this.$textCalc.css(css);
    },

    /****************************************
     * Text
     ****************************************/
    _drawTextDown: function (e) {
      this._drawTextIfNotEmpty();
      this._drawShapeDown(e, 1);

      this.$textInput
      .css({left: e.pageX - 1, top: e.pageY - 1, width: 0, height: 0})
      .show().focus();
    },
    
    _drawTextMove: function (e) {
      this._drawShapeMove(e, 1);

      this.$textInput.css({left: e.left - 1, top: e.top - 1, width: e.width, height: e.height});
    },

    _drawTextIfNotEmpty: function () {
      if (this.$textInput.val() !== '') { this._drawText(); }
    },

    // just draw text - don't want to trigger up here since we are just copying text from input box here
    _drawText: function () {
      var fontString = '',
          lines = this.$textInput.val().split('\n'),
          linesNew = [],
          textInputWidth = this.$textInput.width() - 2,
          width = 0,
          lastj = 0,
          offset = this.$textInput.position(),
          left = offset.left + 1,
          top = offset.top + 1,
          //underlineOffset = 0,
          i, ii, j, jj;

      if (this.options.fontItalic) { fontString += 'italic '; }
      //if(this.settings.fontUnderline) { fontString += 'underline '; }
      if (this.options.fontBold) { fontString += 'bold '; }
      
      fontString += this.options.fontSize + 'px ' + this.options.fontFamily;
      
      for (i = 0, ii = lines.length; i < ii; i++) {
        this.$textCalc.html('');
        lastj = 0;
        
        for (j = 0, jj = lines[0].length; j < jj; j++) {
          width = this.$textCalc.append(lines[i][j]).width();
          
          if (width > textInputWidth) {
            linesNew.push(lines[i].substring(lastj, j));
            lastj = j;
            this.$textCalc.html(lines[i][j]);
          }
        }
        
        if (lastj !== j) { linesNew.push(lines[i].substring(lastj, j)); }
      }
      
      lines = this.$textInput.val(linesNew.join('\n')).val().split('\n');

      for (i = 0, ii = lines.length; i < ii; i++) {
        this.ctx.fillStyle = this.options.fillStyle;
        this.ctx.textBaseline = 'top';
        this.ctx.font = fontString;
        this.ctx.fillText(lines[i], left, top);
        
        top += this.options.fontSize;
        
        /*if(lines[i] !== '' && this.options.fontTypeUnderline) {
          width = this.$textCalc.html(lines[i]).width();
          
          //manually set pixels for underline since to avoid antialiasing 1px issue, and lack of support for underline in canvas
          var imgData = this.ctx.getImageData(0, top+underlineOffset, width, 1);
          
          for (j=0; j<imgData.width*imgData.height*4; j+=4) {
            imgData.data[j] = parseInt(this.options.fillStyle.substring(1,3), 16);
            imgData.data[j+1] = parseInt(this.options.fillStyle.substring(3,5), 16);
            imgData.data[j+2] = parseInt(this.options.fillStyle.substring(5,7), 16);
            imgData.data[j+3] = 255;
          }
          
          this.ctx.putImageData(imgData, left, top+underlineOffset);
        }*/
      }

      this.$textInput.val('');
      this._addUndo();
    }
  });
})(jQuery);

(function ($) {
  var img = 'plugins/shapes/img/icons-menu-main-shapes.png';

  // extend menu
  $.extend(true, $.fn.wPaint.menus.main.items, {
    rectangle: {
      group: 'shapes'
    },
    roundedRect: {
      icon: 'activate',
      group: 'shapes',
      title: _('Rounded Rectangle'),
      img: img,
      index: 0,
      callback: function () { this.setMode('roundedRect'); }
    },
    square: {
      icon: 'activate',
      group: 'shapes',
      title: _('Square'),
      img: img,
      index: 1,
      callback: function () { this.setMode('square'); }
    },
    roundedSquare: {
      icon: 'activate',
      group: 'shapes',
      title: _('Rounded Square'),
      img: img,
      index: 2,
      callback: function () { this.setMode('roundedSquare'); }
    },
    diamond: {
      icon: 'activate',
      group: 'shapes',
      title: _('Diamond'),
      img: img,
      index: 4,
      callback: function () { this.setMode('diamond'); }
    },

    ellipse: {
      group: 'shapes2'
    },
    circle: {
      icon: 'activate',
      group: 'shapes2',
      title: _('Circle'),
      img: img,
      index: 3,
      callback: function () { this.setMode('circle'); }
    },
    pentagon: {
      icon: 'activate',
      group: 'shapes2',
      title: _('Pentagon'),
      img: img,
      index: 5,
      callback: function () { this.setMode('pentagon'); }
    },
    hexagon: {
      icon: 'activate',
      group: 'shapes2',
      title: _('Hexagon'),
      img: img,
      index: 6,
      callback: function () { this.setMode('hexagon'); }
    }
  });

  // extend functions
  $.fn.wPaint.extend({
    /****************************************
     * roundedRect
     ****************************************/
    _drawRoundedRectDown: function (e) { this._drawShapeDown(e); },

    _drawRoundedRectMove: function (e) {
      this._drawShapeMove(e);

      var radius = e.w > e.h ? e.h / e.w : e.w / e.h;

      this.ctxTemp.roundedRect(e.x, e.y, e.w, e.h, Math.ceil(radius * (e.w * e.h * 0.001)));
      this.ctxTemp.stroke();
      this.ctxTemp.fill();
    },

    _drawRoundedRectUp: function (e) {
      this._drawShapeUp(e);
      this._addUndo();
    },

    /****************************************
     * square
     ****************************************/
    _drawSquareDown: function (e) { this._drawShapeDown(e); },

    _drawSquareMove: function (e) {
      this._drawShapeMove(e);

      var l = e.w > e.h ? e.h : e.w;

      this.ctxTemp.rect(e.x, e.y, l, l);
      this.ctxTemp.stroke();
      this.ctxTemp.fill();
    },

    _drawSquareUp: function (e) {
      this._drawShapeUp(e);
      this._addUndo();
    },

    /****************************************
     * roundedSquare
     ****************************************/
    _drawRoundedSquareDown: function (e) { this._drawShapeDown(e); },

    _drawRoundedSquareMove: function (e) {
      this._drawShapeMove(e);

      var l = e.w > e.h ? e.h : e.w;

      this.ctxTemp.roundedRect(e.x, e.y, l, l, Math.ceil(l * l * 0.001));
      this.ctxTemp.stroke();
      this.ctxTemp.fill();
    },

    _drawRoundedSquareUp: function (e) {
      this._drawShapeUp(e);
      this._addUndo();
    },

    /****************************************
     * diamond
     ****************************************/
    _drawDiamondDown: function (e) { this._drawShapeDown(e); },

    _drawDiamondMove: function (e) {
      this._drawShapeMove(e);

      this.ctxTemp.diamond(e.x, e.y, e.w, e.h);
      this.ctxTemp.stroke();
      this.ctxTemp.fill();
    },

    _drawDiamondUp: function (e) {
      this._drawShapeUp(e);
      this._addUndo();
    },

    /****************************************
     * circle
     ****************************************/
    _drawCircleDown: function (e) { this._drawShapeDown(e); },

    _drawCircleMove: function (e) {
      this._drawShapeMove(e);

      var l = e.w > e.h ? e.h : e.w;

      this.ctxTemp.ellipse(e.x, e.y, l, l);
      this.ctxTemp.stroke();
      this.ctxTemp.fill();
    },

    _drawCircleUp: function (e) {
      this._drawShapeUp(e);
      this._addUndo();
    },

    /****************************************
     * pentagon
     ****************************************/
    _drawPentagonDown: function (e) { this._drawShapeDown(e); },

    _drawPentagonMove: function (e) {
      this._drawShapeMove(e);

      this.ctxTemp.pentagon(e.x, e.y, e.w, e.h);
      this.ctxTemp.stroke();
      this.ctxTemp.fill();
    },

    _drawPentagonUp: function (e) {
      this._drawShapeUp(e);
      this._addUndo();
    },

    /****************************************
     * hexagon
     ****************************************/
    _drawHexagonDown: function (e) { this._drawShapeDown(e); },

    _drawHexagonMove: function (e) {
      this._drawShapeMove(e);

      this.ctxTemp.hexagon(e.x, e.y, e.w, e.h);
      this.ctxTemp.stroke();
      this.ctxTemp.fill();
    },

    _drawHexagonUp: function (e) {
      this._drawShapeUp(e);
      this._addUndo();
    }
  });
})(jQuery);

!function(){window.CanvasRenderingContext2D&&(CanvasRenderingContext2D.prototype.diamond=function(a,b,c,d){return a&&b&&c&&d?(this.beginPath(),this.moveTo(a+.5*c,b),this.lineTo(a,b+.5*d),this.lineTo(a+.5*c,b+d),this.lineTo(a+c,b+.5*d),this.lineTo(a+.5*c,b),this.closePath(),void 0):!0}),window.CanvasRenderingContext2D&&(CanvasRenderingContext2D.prototype.ellipse=function(a,b,c,d){if(!(a&&b&&c&&d))return!0;var e=.5522848,f=c/2*e,g=d/2*e,h=a+c,i=b+d,j=a+c/2,k=b+d/2;this.beginPath(),this.moveTo(a,k),this.bezierCurveTo(a,k-g,j-f,b,j,b),this.bezierCurveTo(j+f,b,h,k-g,h,k),this.bezierCurveTo(h,k+g,j+f,i,j,i),this.bezierCurveTo(j-f,i,a,k+g,a,k),this.closePath()}),window.CanvasRenderingContext2D&&(CanvasRenderingContext2D.prototype.hexagon=function(a,b,c,d){if(!(a&&b&&c&&d))return!0;var e=.225,f=1-e;this.beginPath(),this.moveTo(a+.5*c,b),this.lineTo(a,b+d*e),this.lineTo(a,b+d*f),this.lineTo(a+.5*c,b+d),this.lineTo(a+c,b+d*f),this.lineTo(a+c,b+d*e),this.lineTo(a+.5*c,b),this.closePath()}),window.CanvasRenderingContext2D&&(CanvasRenderingContext2D.prototype.pentagon=function(a,b,c,d){return a&&b&&c&&d?(this.beginPath(),this.moveTo(a+c/2,b),this.lineTo(a,b+.4*d),this.lineTo(a+.2*c,b+d),this.lineTo(a+.8*c,b+d),this.lineTo(a+c,b+.4*d),this.lineTo(a+c/2,b),this.closePath(),void 0):!0}),window.CanvasRenderingContext2D&&(CanvasRenderingContext2D.prototype.roundedRect=function(a,b,c,d,e){return a&&b&&c&&d?(e||(e=5),this.beginPath(),this.moveTo(a+e,b),this.lineTo(a+c-e,b),this.quadraticCurveTo(a+c,b,a+c,b+e),this.lineTo(a+c,b+d-e),this.quadraticCurveTo(a+c,b+d,a+c-e,b+d),this.lineTo(a+e,b+d),this.quadraticCurveTo(a,b+d,a,b+d-e),this.lineTo(a,b+e),this.quadraticCurveTo(a,b,a+e,b),this.closePath(),void 0):!0})}();/*
 * wpaint.js - wPaint integration javascript
 * https://github.com/vichan-devel/Tinyboard/blob/master/js/wpaint.js
 *
 * Released under the MIT license
 * Copyright (c) 2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Contains parts of old oekaki code:
 * Copyright (c) 2013-2014 Marcin Łabanowski <marcin@6irc.net>
 *
 * Usage:
 *   $config['additional_javascript'][] = 'js/jquery.min.js';
 *   $config['additional_javascript'][] = 'js/jquery-ui.custom.min.js';
 *   $config['additional_javascript'][] = 'js/ajax.js';
 *   $config['additional_javascript'][] = 'js/wPaint/lib/wColorPicker.min.js';
 *   $config['additional_javascript'][] = 'js/wPaint/wPaint.min.js';
 *   $config['additional_javascript'][] = 'js/wPaint/plugins/main/wPaint.menu.main.min.js';
 *   $config['additional_javascript'][] = 'js/wPaint/plugins/text/wPaint.menu.text.min.js';
 *   $config['additional_javascript'][] = 'js/wPaint/plugins/shapes/wPaint.menu.main.shapes.min.js';
 *   $config['additional_javascript'][] = 'js/wPaint/plugins/file/wPaint.menu.main.file.min.js';
 *   $config['additional_javascript'][] = 'js/wpaint.js';
 *   $config['additional_javascript'][] = 'js/upload-selection.js';
 *
 */

window.oekaki = (function(){
"use strict";

var oekaki = {};

oekaki.settings = new script_settings('wpaint');
oekaki.height = oekaki.settings.get("height", 250);
oekaki.width = oekaki.settings.get("width", 500);

function dataURItoBlob(dataURI) {
    var binary = atob(dataURI.split(',')[1]);
    var array = new Array(binary.length);
    for(var i = 0; i < binary.length; i++) {
        array[i] = binary.charCodeAt(i);
    }
    return new Blob([new Uint8Array(array)], {type: 'image/jpeg'});
}

oekaki.do_css = function() {
}

oekaki.init = function() {
  var oekaki_form = '<div id="wpaintctr"><div id="wpaintdiv"></div></div>';

  // Add oekaki after the file input
  $('.oekaki-applet').html(oekaki_form);

  $('<link class="wpaintcss" rel="stylesheet" href="'+configRoot+'js/wPaint/wPaint.min.css" />').appendTo($("head"));
  $('<link class="wpaintcss" rel="stylesheet" href="'+configRoot+'js/wPaint/lib/wColorPicker.min.css" />').appendTo($("head"));
  $('<link class="wpaintcss" rel="stylesheet" href="'+configRoot+'stylesheets/jquery-ui/core.css" />').appendTo($("head"));
  $('<link class="wpaintcss" rel="stylesheet" href="'+configRoot+'stylesheets/jquery-ui/resizable.css" />').appendTo($("head"));
  $('<link class="wpaintcss" rel="stylesheet" href="'+configRoot+'stylesheets/jquery-ui/theme.css" />').appendTo($("head"));

  var initcount = 0;
  $('.wpaintcss').one('load', function() {
    initcount++;

    if (initcount == 5) {
      $.extend($.fn.wPaint.defaults, {
        mode:        'pencil',  // set mode
        lineWidth:   '1',       // starting line width
        fillStyle:   '#FFFFFF', // starting fill style
        strokeStyle: '#000000',  // start stroke style
      });

      delete $.fn.wPaint.menus.main.items.save;

      $('#wpaintdiv').wPaint({
        path: configRoot+'js/wPaint/',
	menuOffsetTop: -46,
	bg: "#ffffff",
	loadImgFg:   oekaki.load_img,
	loadImgBg:   oekaki.load_img
      });

      $("#wpaintctr").resizable({
        stop: function(event,ui) {
          $("#wpaintdiv").wPaint("resize");
        },
        alsoResize: "#wpaintdiv",
      });

      $('#wpaintctr .ui-resizable-se').css({'height':'12px', 'width':'12px'});
    }
  });

  $("#wpaintdiv").width(oekaki.width).height(oekaki.height).css("position", "relative");
  $("#wpaintctr").width(oekaki.width+5).height(oekaki.height+5).css("padding-top", 48).css("position", "relative");

  $(document).on("ajax_before_post.wpaint", function(e, postData) {
    var blob = $('#wpaintdiv').wPaint("image");
    blob = dataURItoBlob(blob);
    postData.append("file", blob, "Oekaki.png");
  });

  $(window).on('stylesheet', function() {
    oekaki.do_css();
    if ($('link#stylesheet').attr('href')) {
      $('link#stylesheet')[0].onload = oekaki.do_css;
    }
  });

  oekaki.initialized = true;
};

oekaki.load_img = function() {
  alert(_("Click on any image on this site to load it into oekaki applet"));
  $('img').one('click.loadimg', function(e) {
    $('img').off('click.loadimg');
    e.stopImmediatePropagation();
    e.preventDefault();
    var url = $(this).prop('src');
    $('#wpaintdiv').wPaint('setBg', url);
    return false;
  });
};

oekaki.deinit = function() {
  $('.oekaki-applet').empty();
  $('.wpaintcss').remove();

  $(document).off("ajax_before_post.wpaint");

  oekaki.initialized = false;
};

oekaki.initialized = false;
return oekaki;
})();
!function(){var r=null;
(function(){function X(e){function j(){try{J.doScroll("left")}catch(e){P(j,50);return}w("poll")}function w(j){if(!(j.type=="readystatechange"&&x.readyState!="complete")&&((j.type=="load"?n:x)[z](i+j.type,w,!1),!m&&(m=!0)))e.call(n,j.type||j)}var Y=x.addEventListener,m=!1,C=!0,t=Y?"addEventListener":"attachEvent",z=Y?"removeEventListener":"detachEvent",i=Y?"":"on";if(x.readyState=="complete")e.call(n,"lazy");else{if(x.createEventObject&&J.doScroll){try{C=!n.frameElement}catch(A){}C&&j()}x[t](i+"DOMContentLoaded",
w,!1);x[t](i+"readystatechange",w,!1);n[t](i+"load",w,!1)}}function Q(){S&&X(function(){var e=K.length;$(e?function(){for(var j=0;j<e;++j)(function(e){P(function(){n.exports[K[e]].apply(n,arguments)},0)})(j)}:void 0)})}for(var n=window,P=n.setTimeout,x=document,J=x.documentElement,L=x.head||x.getElementsByTagName("head")[0]||J,z="",A=x.scripts,m=A.length;--m>=0;){var M=A[m],T=M.src.match(/^[^#?]*\/run_prettify\.js(\?[^#]*)?(?:#.*)?$/);if(T){z=T[1]||"";M.parentNode.removeChild(M);break}}var S=!0,D=
[],N=[],K=[];z.replace(/[&?]([^&=]+)=([^&]+)/g,function(e,j,w){w=decodeURIComponent(w);j=decodeURIComponent(j);j=="autorun"?S=!/^[0fn]/i.test(w):j=="lang"?D.push(w):j=="skin"?N.push(w):j=="callback"&&K.push(w)});m=0;for(z=D.length;m<z;++m)(function(){var e=x.createElement("script");e.onload=e.onerror=e.onreadystatechange=function(){if(e&&(!e.readyState||/loaded|complete/.test(e.readyState)))e.onerror=e.onload=e.onreadystatechange=r,--R,R||P(Q,0),e.parentNode&&e.parentNode.removeChild(e),e=r};e.type=
"text/javascript";e.src="/js/code_tags/lang-"+encodeURIComponent(D[m])+".js";L.insertBefore(e,L.firstChild)})(D[m]);for(var R=D.length,A=[],m=0,z=N.length;m<z;++m)A.push("/js/code_tags/skins/"+encodeURIComponent(N[m])+".css");(function(e){function j(m){if(m!==w){var n=x.createElement("link");n.rel="stylesheet";n.type="text/css";if(m+1<w)n.error=
n.onerror=function(){j(m+1)};n.href=e[m];L.appendChild(n)}}var w=e.length;j(0)})(A);var $=function(){window.PR_SHOULD_USE_CONTINUATION=!0;var e;(function(){function j(a){function d(f){var b=f.charCodeAt(0);if(b!==92)return b;var a=f.charAt(1);return(b=i[a])?b:"0"<=a&&a<="7"?parseInt(f.substring(1),8):a==="u"||a==="x"?parseInt(f.substring(2),16):f.charCodeAt(1)}function h(f){if(f<32)return(f<16?"\\x0":"\\x")+f.toString(16);f=String.fromCharCode(f);return f==="\\"||f==="-"||f==="]"||f==="^"?"\\"+f:
f}function b(f){var b=f.substring(1,f.length-1).match(/\\u[\dA-Fa-f]{4}|\\x[\dA-Fa-f]{2}|\\[0-3][0-7]{0,2}|\\[0-7]{1,2}|\\[\S\s]|[^\\]/g),f=[],a=b[0]==="^",c=["["];a&&c.push("^");for(var a=a?1:0,g=b.length;a<g;++a){var k=b[a];if(/\\[bdsw]/i.test(k))c.push(k);else{var k=d(k),o;a+2<g&&"-"===b[a+1]?(o=d(b[a+2]),a+=2):o=k;f.push([k,o]);o<65||k>122||(o<65||k>90||f.push([Math.max(65,k)|32,Math.min(o,90)|32]),o<97||k>122||f.push([Math.max(97,k)&-33,Math.min(o,122)&-33]))}}f.sort(function(f,a){return f[0]-
a[0]||a[1]-f[1]});b=[];g=[];for(a=0;a<f.length;++a)k=f[a],k[0]<=g[1]+1?g[1]=Math.max(g[1],k[1]):b.push(g=k);for(a=0;a<b.length;++a)k=b[a],c.push(h(k[0])),k[1]>k[0]&&(k[1]+1>k[0]&&c.push("-"),c.push(h(k[1])));c.push("]");return c.join("")}function e(f){for(var a=f.source.match(/\[(?:[^\\\]]|\\[\S\s])*]|\\u[\dA-Fa-f]{4}|\\x[\dA-Fa-f]{2}|\\\d+|\\[^\dux]|\(\?[!:=]|[()^]|[^()[\\^]+/g),c=a.length,d=[],g=0,k=0;g<c;++g){var o=a[g];o==="("?++k:"\\"===o.charAt(0)&&(o=+o.substring(1))&&(o<=k?d[o]=-1:a[g]=h(o))}for(g=
1;g<d.length;++g)-1===d[g]&&(d[g]=++j);for(k=g=0;g<c;++g)o=a[g],o==="("?(++k,d[k]||(a[g]="(?:")):"\\"===o.charAt(0)&&(o=+o.substring(1))&&o<=k&&(a[g]="\\"+d[o]);for(g=0;g<c;++g)"^"===a[g]&&"^"!==a[g+1]&&(a[g]="");if(f.ignoreCase&&F)for(g=0;g<c;++g)o=a[g],f=o.charAt(0),o.length>=2&&f==="["?a[g]=b(o):f!=="\\"&&(a[g]=o.replace(/[A-Za-z]/g,function(a){a=a.charCodeAt(0);return"["+String.fromCharCode(a&-33,a|32)+"]"}));return a.join("")}for(var j=0,F=!1,l=!1,I=0,c=a.length;I<c;++I){var p=a[I];if(p.ignoreCase)l=
!0;else if(/[a-z]/i.test(p.source.replace(/\\u[\da-f]{4}|\\x[\da-f]{2}|\\[^UXux]/gi,""))){F=!0;l=!1;break}}for(var i={b:8,t:9,n:10,v:11,f:12,r:13},q=[],I=0,c=a.length;I<c;++I){p=a[I];if(p.global||p.multiline)throw Error(""+p);q.push("(?:"+e(p)+")")}return RegExp(q.join("|"),l?"gi":"g")}function m(a,d){function h(a){var c=a.nodeType;if(c==1){if(!b.test(a.className)){for(c=a.firstChild;c;c=c.nextSibling)h(c);c=a.nodeName.toLowerCase();if("br"===c||"li"===c)e[l]="\n",F[l<<1]=j++,F[l++<<1|1]=a}}else if(c==
3||c==4)c=a.nodeValue,c.length&&(c=d?c.replace(/\r\n?/g,"\n"):c.replace(/[\t\n\r ]+/g," "),e[l]=c,F[l<<1]=j,j+=c.length,F[l++<<1|1]=a)}var b=/(?:^|\s)nocode(?:\s|$)/,e=[],j=0,F=[],l=0;h(a);return{a:e.join("").replace(/\n$/,""),d:F}}function n(a,d,h,b){d&&(a={a:d,e:a},h(a),b.push.apply(b,a.g))}function x(a){for(var d=void 0,h=a.firstChild;h;h=h.nextSibling)var b=h.nodeType,d=b===1?d?a:h:b===3?S.test(h.nodeValue)?a:d:d;return d===a?void 0:d}function C(a,d){function h(a){for(var l=a.e,j=[l,"pln"],c=
0,p=a.a.match(e)||[],m={},q=0,f=p.length;q<f;++q){var B=p[q],y=m[B],u=void 0,g;if(typeof y==="string")g=!1;else{var k=b[B.charAt(0)];if(k)u=B.match(k[1]),y=k[0];else{for(g=0;g<i;++g)if(k=d[g],u=B.match(k[1])){y=k[0];break}u||(y="pln")}if((g=y.length>=5&&"lang-"===y.substring(0,5))&&!(u&&typeof u[1]==="string"))g=!1,y="src";g||(m[B]=y)}k=c;c+=B.length;if(g){g=u[1];var o=B.indexOf(g),H=o+g.length;u[2]&&(H=B.length-u[2].length,o=H-g.length);y=y.substring(5);n(l+k,B.substring(0,o),h,j);n(l+k+o,g,A(y,
g),j);n(l+k+H,B.substring(H),h,j)}else j.push(l+k,y)}a.g=j}var b={},e;(function(){for(var h=a.concat(d),l=[],i={},c=0,p=h.length;c<p;++c){var m=h[c],q=m[3];if(q)for(var f=q.length;--f>=0;)b[q.charAt(f)]=m;m=m[1];q=""+m;i.hasOwnProperty(q)||(l.push(m),i[q]=r)}l.push(/[\S\s]/);e=j(l)})();var i=d.length;return h}function t(a){var d=[],h=[];a.tripleQuotedStrings?d.push(["str",/^(?:'''(?:[^'\\]|\\[\S\s]|''?(?=[^']))*(?:'''|$)|"""(?:[^"\\]|\\[\S\s]|""?(?=[^"]))*(?:"""|$)|'(?:[^'\\]|\\[\S\s])*(?:'|$)|"(?:[^"\\]|\\[\S\s])*(?:"|$))/,
r,"'\""]):a.multiLineStrings?d.push(["str",/^(?:'(?:[^'\\]|\\[\S\s])*(?:'|$)|"(?:[^"\\]|\\[\S\s])*(?:"|$)|`(?:[^\\`]|\\[\S\s])*(?:`|$))/,r,"'\"`"]):d.push(["str",/^(?:'(?:[^\n\r'\\]|\\.)*(?:'|$)|"(?:[^\n\r"\\]|\\.)*(?:"|$))/,r,"\"'"]);a.verbatimStrings&&h.push(["str",/^@"(?:[^"]|"")*(?:"|$)/,r]);var b=a.hashComments;b&&(a.cStyleComments?(b>1?d.push(["com",/^#(?:##(?:[^#]|#(?!##))*(?:###|$)|.*)/,r,"#"]):d.push(["com",/^#(?:(?:define|e(?:l|nd)if|else|error|ifn?def|include|line|pragma|undef|warning)\b|[^\n\r]*)/,
r,"#"]),h.push(["str",/^<(?:(?:(?:\.\.\/)*|\/?)(?:[\w-]+(?:\/[\w-]+)+)?[\w-]+\.h(?:h|pp|\+\+)?|[a-z]\w*)>/,r])):d.push(["com",/^#[^\n\r]*/,r,"#"]));a.cStyleComments&&(h.push(["com",/^\/\/[^\n\r]*/,r]),h.push(["com",/^\/\*[\S\s]*?(?:\*\/|$)/,r]));if(b=a.regexLiterals){var e=(b=b>1?"":"\n\r")?".":"[\\S\\s]";h.push(["lang-regex",RegExp("^(?:^^\\.?|[+-]|[!=]=?=?|\\#|%=?|&&?=?|\\(|\\*=?|[+\\-]=|->|\\/=?|::?|<<?=?|>>?>?=?|,|;|\\?|@|\\[|~|{|\\^\\^?=?|\\|\\|?=?|break|case|continue|delete|do|else|finally|instanceof|return|throw|try|typeof)\\s*("+
("/(?=[^/*"+b+"])(?:[^/\\x5B\\x5C"+b+"]|\\x5C"+e+"|\\x5B(?:[^\\x5C\\x5D"+b+"]|\\x5C"+e+")*(?:\\x5D|$))+/")+")")])}(b=a.types)&&h.push(["typ",b]);b=(""+a.keywords).replace(/^ | $/g,"");b.length&&h.push(["kwd",RegExp("^(?:"+b.replace(/[\s,]+/g,"|")+")\\b"),r]);d.push(["pln",/^\s+/,r," \r\n\t\u00a0"]);b="^.[^\\s\\w.$@'\"`/\\\\]*";a.regexLiterals&&(b+="(?!s*/)");h.push(["lit",/^@[$_a-z][\w$@]*/i,r],["typ",/^(?:[@_]?[A-Z]+[a-z][\w$@]*|\w+_t\b)/,r],["pln",/^[$_a-z][\w$@]*/i,r],["lit",/^(?:0x[\da-f]+|(?:\d(?:_\d+)*\d*(?:\.\d*)?|\.\d\+)(?:e[+-]?\d+)?)[a-z]*/i,
r,"0123456789"],["pln",/^\\[\S\s]?/,r],["pun",RegExp(b),r]);return C(d,h)}function z(a,d,h){function b(a){var c=a.nodeType;if(c==1&&!j.test(a.className))if("br"===a.nodeName)e(a),a.parentNode&&a.parentNode.removeChild(a);else for(a=a.firstChild;a;a=a.nextSibling)b(a);else if((c==3||c==4)&&h){var d=a.nodeValue,i=d.match(m);if(i)c=d.substring(0,i.index),a.nodeValue=c,(d=d.substring(i.index+i[0].length))&&a.parentNode.insertBefore(l.createTextNode(d),a.nextSibling),e(a),c||a.parentNode.removeChild(a)}}
function e(a){function b(a,c){var d=c?a.cloneNode(!1):a,f=a.parentNode;if(f){var f=b(f,1),h=a.nextSibling;f.appendChild(d);for(var e=h;e;e=h)h=e.nextSibling,f.appendChild(e)}return d}for(;!a.nextSibling;)if(a=a.parentNode,!a)return;for(var a=b(a.nextSibling,0),d;(d=a.parentNode)&&d.nodeType===1;)a=d;c.push(a)}for(var j=/(?:^|\s)nocode(?:\s|$)/,m=/\r\n?|\n/,l=a.ownerDocument,i=l.createElement("li");a.firstChild;)i.appendChild(a.firstChild);for(var c=[i],p=0;p<c.length;++p)b(c[p]);d===(d|0)&&c[0].setAttribute("value",
d);var n=l.createElement("ol");n.className="linenums";for(var d=Math.max(0,d-1|0)||0,p=0,q=c.length;p<q;++p)i=c[p],i.className="L"+(p+d)%10,i.firstChild||i.appendChild(l.createTextNode("\u00a0")),n.appendChild(i);a.appendChild(n)}function i(a,d){for(var h=d.length;--h>=0;){var b=d[h];U.hasOwnProperty(b)?V.console&&console.warn("cannot override language handler %s",b):U[b]=a}}function A(a,d){if(!a||!U.hasOwnProperty(a))a=/^\s*</.test(d)?"default-markup":"default-code";return U[a]}function D(a){var d=
a.h;try{var h=m(a.c,a.i),b=h.a;a.a=b;a.d=h.d;a.e=0;A(d,b)(a);var e=/\bMSIE\s(\d+)/.exec(navigator.userAgent),e=e&&+e[1]<=8,d=/\n/g,i=a.a,j=i.length,h=0,l=a.d,n=l.length,b=0,c=a.g,p=c.length,t=0;c[p]=j;var q,f;for(f=q=0;f<p;)c[f]!==c[f+2]?(c[q++]=c[f++],c[q++]=c[f++]):f+=2;p=q;for(f=q=0;f<p;){for(var x=c[f],y=c[f+1],u=f+2;u+2<=p&&c[u+1]===y;)u+=2;c[q++]=x;c[q++]=y;f=u}c.length=q;var g=a.c,k;if(g)k=g.style.display,g.style.display="none";try{for(;b<n;){var o=l[b+2]||j,H=c[t+2]||j,u=Math.min(o,H),E=l[b+
1],W;if(E.nodeType!==1&&(W=i.substring(h,u))){e&&(W=W.replace(d,"\r"));E.nodeValue=W;var Z=E.ownerDocument,s=Z.createElement("span");s.className=c[t+1];var z=E.parentNode;z.replaceChild(s,E);s.appendChild(E);h<o&&(l[b+1]=E=Z.createTextNode(i.substring(u,o)),z.insertBefore(E,s.nextSibling))}h=u;h>=o&&(b+=2);h>=H&&(t+=2)}}finally{if(g)g.style.display=k}}catch(v){V.console&&console.log(v&&v.stack||v)}}var V=window,G=["break,continue,do,else,for,if,return,while"],O=[[G,"auto,case,char,const,default,double,enum,extern,float,goto,inline,int,long,register,short,signed,sizeof,static,struct,switch,typedef,union,unsigned,void,volatile"],
"catch,class,delete,false,import,new,operator,private,protected,public,this,throw,true,try,typeof"],J=[O,"alignof,align_union,asm,axiom,bool,concept,concept_map,const_cast,constexpr,decltype,delegate,dynamic_cast,explicit,export,friend,generic,late_check,mutable,namespace,nullptr,property,reinterpret_cast,static_assert,static_cast,template,typeid,typename,using,virtual,where"],K=[O,"abstract,assert,boolean,byte,extends,final,finally,implements,import,instanceof,interface,null,native,package,strictfp,super,synchronized,throws,transient"],
L=[K,"as,base,by,checked,decimal,delegate,descending,dynamic,event,fixed,foreach,from,group,implicit,in,internal,into,is,let,lock,object,out,override,orderby,params,partial,readonly,ref,sbyte,sealed,stackalloc,string,select,uint,ulong,unchecked,unsafe,ushort,var,virtual,where"],O=[O,"debugger,eval,export,function,get,null,set,undefined,var,with,Infinity,NaN"],M=[G,"and,as,assert,class,def,del,elif,except,exec,finally,from,global,import,in,is,lambda,nonlocal,not,or,pass,print,raise,try,with,yield,False,True,None"],
N=[G,"alias,and,begin,case,class,def,defined,elsif,end,ensure,false,in,module,next,nil,not,or,redo,rescue,retry,self,super,then,true,undef,unless,until,when,yield,BEGIN,END"],R=[G,"as,assert,const,copy,drop,enum,extern,fail,false,fn,impl,let,log,loop,match,mod,move,mut,priv,pub,pure,ref,self,static,struct,true,trait,type,unsafe,use"],G=[G,"case,done,elif,esac,eval,fi,function,in,local,set,then,until"],Q=/^(DIR|FILE|vector|(de|priority_)?queue|list|stack|(const_)?iterator|(multi)?(set|map)|bitset|u?(int|float)\d*)\b/,
S=/\S/,T=t({keywords:[J,L,O,"caller,delete,die,do,dump,elsif,eval,exit,foreach,for,goto,if,import,last,local,my,next,no,our,print,package,redo,require,sub,undef,unless,until,use,wantarray,while,BEGIN,END",M,N,G],hashComments:!0,cStyleComments:!0,multiLineStrings:!0,regexLiterals:!0}),U={};i(T,["default-code"]);i(C([],[["pln",/^[^<?]+/],["dec",/^<!\w[^>]*(?:>|$)/],["com",/^<\!--[\S\s]*?(?:--\>|$)/],["lang-",/^<\?([\S\s]+?)(?:\?>|$)/],["lang-",/^<%([\S\s]+?)(?:%>|$)/],["pun",/^(?:<[%?]|[%?]>)/],["lang-",
/^<xmp\b[^>]*>([\S\s]+?)<\/xmp\b[^>]*>/i],["lang-js",/^<script\b[^>]*>([\S\s]*?)(<\/script\b[^>]*>)/i],["lang-css",/^<style\b[^>]*>([\S\s]*?)(<\/style\b[^>]*>)/i],["lang-in.tag",/^(<\/?[a-z][^<>]*>)/i]]),["default-markup","htm","html","mxml","xhtml","xml","xsl"]);i(C([["pln",/^\s+/,r," \t\r\n"],["atv",/^(?:"[^"]*"?|'[^']*'?)/,r,"\"'"]],[["tag",/^^<\/?[a-z](?:[\w-.:]*\w)?|\/?>$/i],["atn",/^(?!style[\s=]|on)[a-z](?:[\w:-]*\w)?/i],["lang-uq.val",/^=\s*([^\s"'>]*(?:[^\s"'/>]|\/(?=\s)))/],["pun",/^[/<->]+/],
["lang-js",/^on\w+\s*=\s*"([^"]+)"/i],["lang-js",/^on\w+\s*=\s*'([^']+)'/i],["lang-js",/^on\w+\s*=\s*([^\s"'>]+)/i],["lang-css",/^style\s*=\s*"([^"]+)"/i],["lang-css",/^style\s*=\s*'([^']+)'/i],["lang-css",/^style\s*=\s*([^\s"'>]+)/i]]),["in.tag"]);i(C([],[["atv",/^[\S\s]+/]]),["uq.val"]);i(t({keywords:J,hashComments:!0,cStyleComments:!0,types:Q}),["c","cc","cpp","cxx","cyc","m"]);i(t({keywords:"null,true,false"}),["json"]);i(t({keywords:L,hashComments:!0,cStyleComments:!0,verbatimStrings:!0,types:Q}),
["cs"]);i(t({keywords:K,cStyleComments:!0}),["java"]);i(t({keywords:G,hashComments:!0,multiLineStrings:!0}),["bash","bsh","csh","sh"]);i(t({keywords:M,hashComments:!0,multiLineStrings:!0,tripleQuotedStrings:!0}),["cv","py","python"]);i(t({keywords:"caller,delete,die,do,dump,elsif,eval,exit,foreach,for,goto,if,import,last,local,my,next,no,our,print,package,redo,require,sub,undef,unless,until,use,wantarray,while,BEGIN,END",hashComments:!0,multiLineStrings:!0,regexLiterals:2}),["perl","pl","pm"]);i(t({keywords:N,
hashComments:!0,multiLineStrings:!0,regexLiterals:!0}),["rb","ruby"]);i(t({keywords:O,cStyleComments:!0,regexLiterals:!0}),["javascript","js"]);i(t({keywords:"all,and,by,catch,class,else,extends,false,finally,for,if,in,is,isnt,loop,new,no,not,null,of,off,on,or,return,super,then,throw,true,try,unless,until,when,while,yes",hashComments:3,cStyleComments:!0,multilineStrings:!0,tripleQuotedStrings:!0,regexLiterals:!0}),["coffee"]);i(t({keywords:R,cStyleComments:!0,multilineStrings:!0}),["rc","rs","rust"]);
i(C([],[["str",/^[\S\s]+/]]),["regex"]);var X=V.PR={createSimpleLexer:C,registerLangHandler:i,sourceDecorator:t,PR_ATTRIB_NAME:"atn",PR_ATTRIB_VALUE:"atv",PR_COMMENT:"com",PR_DECLARATION:"dec",PR_KEYWORD:"kwd",PR_LITERAL:"lit",PR_NOCODE:"nocode",PR_PLAIN:"pln",PR_PUNCTUATION:"pun",PR_SOURCE:"src",PR_STRING:"str",PR_TAG:"tag",PR_TYPE:"typ",prettyPrintOne:function(a,d,e){var b=document.createElement("div");b.innerHTML="<pre>"+a+"</pre>";b=b.firstChild;e&&z(b,e,!0);D({h:d,j:e,c:b,i:1});return b.innerHTML},
prettyPrint:e=e=function(a,d){function e(){for(var b=V.PR_SHOULD_USE_CONTINUATION?c.now()+250:Infinity;p<j.length&&c.now()<b;p++){for(var d=j[p],m=k,l=d;l=l.previousSibling;){var n=l.nodeType,s=(n===7||n===8)&&l.nodeValue;if(s?!/^\??prettify\b/.test(s):n!==3||/\S/.test(l.nodeValue))break;if(s){m={};s.replace(/\b(\w+)=([\w%+\-.:]+)/g,function(a,b,c){m[b]=c});break}}l=d.className;if((m!==k||f.test(l))&&!w.test(l)){n=!1;for(s=d.parentNode;s;s=s.parentNode)if(g.test(s.tagName)&&s.className&&f.test(s.className)){n=
!0;break}if(!n){d.className+=" prettyprinted";n=m.lang;if(!n){var n=l.match(q),A;if(!n&&(A=x(d))&&u.test(A.tagName))n=A.className.match(q);n&&(n=n[1])}if(y.test(d.tagName))s=1;else var s=d.currentStyle,v=i.defaultView,s=(s=s?s.whiteSpace:v&&v.getComputedStyle?v.getComputedStyle(d,r).getPropertyValue("white-space"):0)&&"pre"===s.substring(0,3);v=m.linenums;if(!(v=v==="true"||+v))v=(v=l.match(/\blinenums\b(?::(\d+))?/))?v[1]&&v[1].length?+v[1]:!0:!1;v&&z(d,v,s);t={h:n,c:d,j:v,i:s};D(t)}}}p<j.length?
P(e,250):"function"===typeof a&&a()}for(var b=d||document.body,i=b.ownerDocument||document,b=[b.getElementsByTagName("pre"),b.getElementsByTagName("code"),b.getElementsByTagName("xmp")],j=[],m=0;m<b.length;++m)for(var l=0,n=b[m].length;l<n;++l)j.push(b[m][l]);var b=r,c=Date;c.now||(c={now:function(){return+new Date}});var p=0,t,q=/\blang(?:uage)?-([\w.]+)(?!\S)/,f=/\bprettyprint\b/,w=/\bprettyprinted\b/,y=/pre|xmp/i,u=/^code$/i,g=/^(?:pre|code|xmp)$/i,k={};e()}};typeof define==="function"&&define.amd&&
define("google-code-prettify",[],function(){return X})})();return e}();R||P(Q,0)})();}();

function SHA1(msg) {
	function rotate_left(n, s) {
		var t4 = (n << s) | (n >>> (32 - s));
		return t4;
	};

	function lsb_hex(val) {
		var str = "";
		var i;
		var vh;
		var vl;
		for (i = 0; i <= 6; i += 2) {
			vh = (val >>> (i * 4 + 4)) & 0x0f;
			vl = (val >>> (i * 4)) & 0x0f;
			str += vh.toString(16) + vl.toString(16);
		}
		return str;
	};

	function cvt_hex(val) {
		var str = "";
		var i;
		var v;
		for (i = 7; i >= 0; i--) {
			v = (val >>> (i * 4)) & 0x0f;
			str += v.toString(16);
		}
		return str;
	};

	function Utf8Encode(string) {
		string = string.replace(/\r\n/g, "\n");
		var utftext = "";
		for (var n = 0; n < string.length; n++) {
			var c = string.charCodeAt(n);
			if (c < 128) {
				utftext += String.fromCharCode(c);
			} else if ((c > 127) && (c < 2048)) {
				utftext += String.fromCharCode((c >> 6) | 192);
				utftext += String.fromCharCode((c & 63) | 128);
			} else {
				utftext += String.fromCharCode((c >> 12) | 224);
				utftext += String.fromCharCode(((c >> 6) & 63) | 128);
				utftext += String.fromCharCode((c & 63) | 128);
			}
		}
		return utftext;
	};
	var blockstart;
	var i, j;
	var W = new Array(80);
	var H0 = 0x67452301;
	var H1 = 0xEFCDAB89;
	var H2 = 0x98BADCFE;
	var H3 = 0x10325476;
	var H4 = 0xC3D2E1F0;
	var A, B, C, D, E;
	var temp;
	msg = Utf8Encode(msg);
	var msg_len = msg.length;
	var word_array = new Array();
	for (i = 0; i < msg_len - 3; i += 4) {
		j = msg.charCodeAt(i) << 24 | msg.charCodeAt(i + 1) << 16 |
			msg.charCodeAt(i + 2) << 8 | msg.charCodeAt(i + 3);
		word_array.push(j);
	}
	switch (msg_len % 4) {
		case 0:
			i = 0x080000000;
			break;
		case 1:
			i = msg.charCodeAt(msg_len - 1) << 24 | 0x0800000;
			break;
		case 2:
			i = msg.charCodeAt(msg_len - 2) << 24 | msg.charCodeAt(msg_len - 1) << 16 | 0x08000;
			break;
		case 3:
			i = msg.charCodeAt(msg_len - 3) << 24 | msg.charCodeAt(msg_len - 2) << 16 | msg.charCodeAt(msg_len - 1) << 8 | 0x80;
			break;
	}
	word_array.push(i);
	while ((word_array.length % 16) != 14) word_array.push(0);
	word_array.push(msg_len >>> 29);
	word_array.push((msg_len << 3) & 0x0ffffffff);
	for (blockstart = 0; blockstart < word_array.length; blockstart += 16) {
		for (i = 0; i < 16; i++) W[i] = word_array[blockstart + i];
		for (i = 16; i <= 79; i++) W[i] = rotate_left(W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16], 1);
		A = H0;
		B = H1;
		C = H2;
		D = H3;
		E = H4;
		for (i = 0; i <= 19; i++) {
			temp = (rotate_left(A, 5) + ((B & C) | (~B & D)) + E + W[i] + 0x5A827999) & 0x0ffffffff;
			E = D;
			D = C;
			C = rotate_left(B, 30);
			B = A;
			A = temp;
		}
		for (i = 20; i <= 39; i++) {
			temp = (rotate_left(A, 5) + (B ^ C ^ D) + E + W[i] + 0x6ED9EBA1) & 0x0ffffffff;
			E = D;
			D = C;
			C = rotate_left(B, 30);
			B = A;
			A = temp;
		}
		for (i = 40; i <= 59; i++) {
			temp = (rotate_left(A, 5) + ((B & C) | (B & D) | (C & D)) + E + W[i] + 0x8F1BBCDC) & 0x0ffffffff;
			E = D;
			D = C;
			C = rotate_left(B, 30);
			B = A;
			A = temp;
		}
		for (i = 60; i <= 79; i++) {
			temp = (rotate_left(A, 5) + (B ^ C ^ D) + E + W[i] + 0xCA62C1D6) & 0x0ffffffff;
			E = D;
			D = C;
			C = rotate_left(B, 30);
			B = A;
			A = temp;
		}
		H0 = (H0 + A) & 0x0ffffffff;
		H1 = (H1 + B) & 0x0ffffffff;
		H2 = (H2 + C) & 0x0ffffffff;
		H3 = (H3 + D) & 0x0ffffffff;
		H4 = (H4 + E) & 0x0ffffffff;
	}
	var temp = cvt_hex(H0) + cvt_hex(H1) + cvt_hex(H2) + cvt_hex(H3) + cvt_hex(H4);
	return temp.toLowerCase();
}
if (active_page == 'thread' || active_page == 'index' || active_page == 'catalog') {

	$(document).on('menu_ready', function(){

		function createCookie(name, value, days) {
    			var date, expires;
   	 		if (days) {
        			date = new Date();
        			date.setTime(date.getTime()+(days*24*60*60*1000));
        			expires = "; expires="+date.toGMTString();
    			} else {
        			expires = "";
    			}
    			document.cookie = name+"="+value+expires+"; path=/";
		}

  		function getCookie(name){
    			var re = new RegExp(name + "=([^;]+)");
    			var value = re.exec(document.cookie);
    			return (value != null) ? unescape(value[1]) : null;
 		}
		
		//check if cookie pass is null, then create
		if(getCookie("uid")==null){
				
			//generate 
			uid = generatePassword();
			createCookie("uid", uid, 1);
		}

    		$(document).on('ajax_after_post', function(e, post) {

      			if(post.post_type){
        			localStorage.new_thread = 1;
				localStorage.new_thread_pass = localStorage.password;
      			}

    		});

		function get_thread_id(path_str){
      			var pnt_arr = path_str.split("/");
      			var newest_thread_id = pnt_arr[pnt_arr.length-1].replace(".html","");
			return newest_thread_id;
		}

		var genhs = function(guid,rnd){

			if(rnd==1){
				var random_string = generatePassword();
				var str_id = random_string + getCookie("uid") + guid;
				var new_pass = SHA1 (str_id).slice(-16);
			}else{
				var new_pass = SHA1 (getCookie("uid") + guid).slice(-16);
			}

      			document.forms.post.password.value = new_pass;
      			localStorage.password = new_pass;

		}

		if(localStorage.new_thread == 1){
				localStorage.new_thread_id = get_thread_id(window.location.pathname);
	
		}

		var url_path = window.location.pathname;

		//check if new_thread_id in localstorage is not equal to viewed page
		var get_viewed_thread_id = get_thread_id( url_path );

    		var nav = window.navigator;
    		var guid = nav.userAgent.replace(/[^a-zA-Z0-9]/g, '');
    		guid += url_path.replace(/[^a-zA-Z0-9]/g, '');

		if(get_viewed_thread_id == localStorage.new_thread_id){
			document.forms.post.password.value = localStorage.new_thread_pass;
			localStorage.password = localStorage.new_thread_pass;	
		}else{

			if(active_page == 'index' || active_page == 'catalog'){
				genhs(guid,1);
			}else{
				genhs(guid,0);
			}
		}

		//reset
		localStorage.new_thread = 0;

	});
}
$(function() {
	$('.fileboard td').find("a[target='_blank']").each(function() {
	    var url = $(this).attr('href');
	    var url_p = document.location.host;
	    //$(this).attr('href', url.replace("media.8kun.top/"+board_name+"/src/","media.8kun.top/file_store/"));
	    //$(this).attr('href', url.replace("media.8kun.top/"+board_name+"/src/","media.8kun.top/file_store/")); 
	    $(this).attr('href', url.replace(url_p + "/"+board_name+"/src/",url_p + "/file_store/")); 
	});
});
$(document).ready(function(){
	$('a[rel="nofollow"]').each(function() {
		$(this).removeAttr( "rel" );
	});
});
